/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.particles.options;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class ColorParticleOptions
implements ParticleOptions {
    public static final Codec<ColorParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(options -> Float.valueOf(options.r)), (App)Codec.FLOAT.fieldOf("g").forGetter(options -> Float.valueOf(options.g)), (App)Codec.FLOAT.fieldOf("b").forGetter(options -> Float.valueOf(options.b)), (App)Codec.FLOAT.fieldOf("scale").forGetter(options -> Float.valueOf(options.scale)), (App)Codec.INT.fieldOf("ownerId").forGetter(options -> options.ownerId)).apply((Applicative)instance, ColorParticleOptions::new));
    public static final ParticleOptions.Deserializer<ColorParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<ColorParticleOptions>(){

        public ColorParticleOptions fromCommand(ParticleType<ColorParticleOptions> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            int ownerId = reader.readInt();
            return new ColorParticleOptions(particleType, r, g, b, scale, ownerId);
        }

        public ColorParticleOptions fromNetwork(ParticleType<ColorParticleOptions> particleType, FriendlyByteBuf buffer) {
            return new ColorParticleOptions(particleType, buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt());
        }
    };
    private final ParticleType<ColorParticleOptions> type;
    private final float r;
    private final float g;
    private final float b;
    private final float scale;
    private final int ownerId;

    public ColorParticleOptions(ParticleType<ColorParticleOptions> type, float r, float g, float b, float scale, int ownerId) {
        this.type = type;
        this.r = r;
        this.g = g;
        this.b = b;
        this.scale = scale;
        this.ownerId = ownerId;
    }

    public ColorParticleOptions(float r, float g, float b, float scale, int ownerId) {
        this(null, r, g, b, scale, ownerId);
    }

    public ParticleType<?> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.r);
        buffer.writeFloat(this.g);
        buffer.writeFloat(this.b);
        buffer.writeFloat(this.scale);
        buffer.writeInt(this.ownerId);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.scale), this.ownerId);
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public float getScale() {
        return this.scale;
    }

    public int getOwnerId() {
        return this.ownerId;
    }
}

