/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.saksolm.monsterexpansion.client.RoarShakeHandler;

public class ScreenShakePacket {
    public final int duration;
    public final int intensity;

    public ScreenShakePacket(int duration, int intensity) {
        this.duration = duration;
        this.intensity = intensity;
    }

    public static void encode(ScreenShakePacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.duration);
        buf.writeInt(pkt.intensity);
    }

    public static ScreenShakePacket decode(FriendlyByteBuf buf) {
        int duration = buf.readInt();
        int intensity = buf.readInt();
        return new ScreenShakePacket(duration, intensity);
    }

    public static void handle(ScreenShakePacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && mc.f_91073_ != null) {
                RoarShakeHandler.startShake(pkt.duration, pkt.intensity);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

