/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;

public class ParticleImpactPacket {
    private final Vec3 impactPos;
    private final int ownerId;

    public ParticleImpactPacket(Vec3 impactPos, int ownerId) {
        this.impactPos = impactPos;
        this.ownerId = ownerId;
    }

    public ParticleImpactPacket(FriendlyByteBuf buf) {
        this.impactPos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.ownerId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.impactPos.m_7096_());
        buf.writeDouble(this.impactPos.m_7098_());
        buf.writeDouble(this.impactPos.m_7094_());
        buf.writeInt(this.ownerId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            Entity owner = level.m_6815_(this.ownerId);
            if (owner instanceof AbstractLargeMonster) {
                AbstractLargeMonster monster = (AbstractLargeMonster)owner;
                monster.handleParticleImpact(this.impactPos);
            }
        });
        return true;
    }
}

