/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.network;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.saksolm.monsterexpansion.network.AttackPartPacket;
import net.saksolm.monsterexpansion.network.FlashbangSequencePacket;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ParticleImpactPacket;
import net.saksolm.monsterexpansion.network.RiderInputPacket;
import net.saksolm.monsterexpansion.network.ScreenShakePacket;
import net.saksolm.monsterexpansion.network.ShockwaveEffectPacket;
import net.saksolm.monsterexpansion.network.SoundPacket;

public class ModNetwork {
    private static final String PROTOCOL_VERSION = "1.0";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("monsterexpansion", "main"), () -> "1.0", "1.0"::equals, "1.0"::equals);
    private static int id = 0;

    public static <MSG> void sendToClientsTracking(MSG message, Entity entity) {
        CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToServer(MSG message) {
        CHANNEL.sendToServer(message);
    }

    public static void register() {
        CHANNEL.registerMessage(id++, ScreenShakePacket.class, ScreenShakePacket::encode, ScreenShakePacket::decode, ScreenShakePacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, ShockwaveEffectPacket.class, ShockwaveEffectPacket::encode, ShockwaveEffectPacket::decode, ShockwaveEffectPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, GenericParticlePacket.class, GenericParticlePacket::encode, GenericParticlePacket::decode, GenericParticlePacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, RiderInputPacket.class, RiderInputPacket::encode, RiderInputPacket::decode, RiderInputPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, AttackPartPacket.class, AttackPartPacket::encode, AttackPartPacket::decode, AttackPartPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, SoundPacket.class, SoundPacket::encode, SoundPacket::decode, SoundPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, FlashbangSequencePacket.class, FlashbangSequencePacket::encode, FlashbangSequencePacket::decode, FlashbangSequencePacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, ParticleImpactPacket.class, ParticleImpactPacket::toBytes, ParticleImpactPacket::new, ParticleImpactPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }
}

