/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.IdMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.saksolm.monsterexpansion.particles.CustomParticles;

public class GenericParticlePacket {
    private final ParticleOptions particle;
    private final Vec3 pos;
    private final Vec3 velocity;
    private final boolean force;

    public GenericParticlePacket(ParticleOptions particle, Vec3 pos, Vec3 velocity, boolean force) {
        this.particle = particle;
        this.pos = pos;
        this.velocity = velocity;
        this.force = force;
    }

    public static void encode(GenericParticlePacket message, FriendlyByteBuf buffer) {
        buffer.m_236818_((IdMap)BuiltInRegistries.f_257034_, (Object)message.particle.m_6012_());
        message.particle.m_7711_(buffer);
        buffer.writeDouble(message.pos.f_82479_);
        buffer.writeDouble(message.pos.f_82480_);
        buffer.writeDouble(message.pos.f_82481_);
        buffer.writeDouble(message.velocity.f_82479_);
        buffer.writeDouble(message.velocity.f_82480_);
        buffer.writeDouble(message.velocity.f_82481_);
        buffer.writeBoolean(message.force);
    }

    public static GenericParticlePacket decode(FriendlyByteBuf buffer) {
        ParticleOptions particleOptions = GenericParticlePacket.readParticle(buffer);
        Vec3 pos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        Vec3 velocity = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        boolean force = buffer.readBoolean();
        return new GenericParticlePacket(particleOptions, pos, velocity, force);
    }

    private static ParticleOptions readParticle(FriendlyByteBuf buffer) {
        ParticleType particleType = (ParticleType)buffer.m_236816_((IdMap)BuiltInRegistries.f_257034_);
        return GenericParticlePacket.readParticle(buffer, particleType);
    }

    private static <T extends ParticleOptions> T readParticle(FriendlyByteBuf buffer, ParticleType<T> type) {
        return (T)type.m_123743_().m_6507_(type, buffer);
    }

    public static void handle(GenericParticlePacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleParticle(message)));
        context.setPacketHandled(true);
    }

    public static class ClientPacketHandler {
        public static void handleParticle(GenericParticlePacket message) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                CustomParticles.addParticle((Level)level, message.particle, message.force, message.pos.f_82479_, message.pos.f_82480_, message.pos.f_82481_, message.velocity.f_82479_, message.velocity.f_82480_, message.velocity.f_82481_);
            }
        }
    }
}

