/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.LargeMonsterPartEntity;

public class AttackPartPacket {
    private final int parentId;
    private final int partId;

    public AttackPartPacket(int parentId, int partId) {
        this.parentId = parentId;
        this.partId = partId;
    }

    public static void encode(AttackPartPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.parentId);
        buffer.writeInt(message.partId);
    }

    public static AttackPartPacket decode(FriendlyByteBuf buffer) {
        return new AttackPartPacket(buffer.readInt(), buffer.readInt());
    }

    public static void handle(AttackPartPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Entity parent = player.m_9236_().m_6815_(message.parentId);
            Entity part = player.m_9236_().m_6815_(message.partId);
            if (parent instanceof AbstractLargeMonster && part instanceof LargeMonsterPartEntity) {
                LargeMonsterPartEntity monsterPart = (LargeMonsterPartEntity)part;
                player.m_5706_((Entity)monsterPart);
            }
        });
        context.setPacketHandled(true);
    }
}

