/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.effect.ModEffects;
import net.saksolm.monsterexpansion.entity.custom.projectile.IceSpikeMarkerEntity;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.particles.ModParticles;
import net.saksolm.monsterexpansion.particles.options.ColorParticleOptions;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class RimescourgeItem
extends TieredItem {
    private static final int NUM_RINGS = 3;
    private static final int SPIKES_PER_RING = 8;
    private static final double INITIAL_RADIUS = 1.5;
    private static final double RADIUS_STEP = 1.5;
    private static final int COOLDOWN_TICKS = 200;
    private static final int FROSTVEIN_DURATION = 200;
    private static final int FROSTVEIN_MAX_AMP = 2;
    private final float attackDamage;
    private final float attackSpeedModifier;

    public RimescourgeItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pProperties);
        this.attackDamage = (float)pAttackDamageModifier + pTier.m_6631_();
        this.attackSpeedModifier = pAttackSpeedModifier;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        if (!pAttacker.m_9236_().m_5776_() && pAttacker.m_217043_().m_188503_(3) == 0) {
            int currentAmplifier = -1;
            MobEffectInstance existingEffect = pTarget.m_21124_((MobEffect)ModEffects.FROSTVEIN.get());
            if (existingEffect != null) {
                currentAmplifier = existingEffect.m_19564_();
            }
            int newAmplifier = Math.min(currentAmplifier + 1, 2);
            pTarget.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROSTVEIN.get(), 200, newAmplifier, false, true, true));
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!pLevel.m_5776_()) {
            this.spawnShockwave(pLevel, pPlayer, pPlayer.m_20182_());
            pPlayer.m_20256_(new Vec3(0.0, 1.0, 0.0));
            pPlayer.f_19864_ = true;
            pPlayer.f_19789_ = 0.0f;
            pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
            pPlayer.m_36335_().m_41524_((Item)this, 200);
            itemstack.m_41622_(1, (LivingEntity)pPlayer, player -> player.m_21190_(pHand));
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    private void spawnShockwave(Level level, Player owner, Vec3 impactLocation) {
        if (level.f_46443_ || !(owner instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)owner;
        for (int i = 0; i < 3; ++i) {
            this.spawnSpikeRing(level, serverPlayer, impactLocation, i);
            this.spawnShardParticles(level, serverPlayer, impactLocation, i);
        }
        this.spawnSmallImpactParticles(level, serverPlayer, impactLocation);
    }

    private void spawnSpikeRing(Level level, ServerPlayer player, Vec3 impactLocation, int ringIndex) {
        if (level.f_46443_) {
            return;
        }
        double currentRadius = 1.5 + (double)ringIndex * 1.5;
        int spikesInThisRing = 8 + ringIndex * 4;
        double angleOffset = ringIndex % 2 == 0 ? 0.0 : Math.PI / (double)spikesInThisRing;
        for (int i = 0; i < spikesInThisRing; ++i) {
            double angle = Math.PI * 2 / (double)spikesInThisRing * (double)i + angleOffset;
            double xOffset = Math.cos(angle) * currentRadius;
            double zOffset = Math.sin(angle) * currentRadius;
            double spawnX = impactLocation.m_7096_() + xOffset;
            double spawnZ = impactLocation.m_7094_() + zOffset;
            int blockX = Mth.m_14107_((double)spawnX);
            int blockZ = Mth.m_14107_((double)spawnZ);
            int groundY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockX, blockZ);
            double playerY = impactLocation.m_7098_();
            if (playerY - (double)groundY > 5.0) continue;
            Vec3 spawnPos = new Vec3(spawnX, (double)groundY, spawnZ);
            float yaw = (float)(Mth.m_14136_((double)xOffset, (double)zOffset) * 57.29577951308232);
            IceSpikeMarkerEntity marker = new IceSpikeMarkerEntity(level, spawnPos, yaw, (LivingEntity)player);
            level.m_7967_((Entity)marker);
        }
    }

    private void spawnShardParticles(Level level, ServerPlayer player, Vec3 impactLocation, int ringIndex) {
        if (impactLocation == null) {
            return;
        }
        int particleCount = 15 + ringIndex * 10;
        RandomSource random = level.f_46441_;
        for (int j = 0; j < particleCount; ++j) {
            double randomAngle = random.m_188500_() * Math.PI * 2.0;
            Vec3 direction = new Vec3(Math.cos(randomAngle), 0.0, Math.sin(randomAngle));
            double upSpeed = 0.1 + random.m_188500_() * 0.3;
            double speed = 0.3 + random.m_188500_() * 0.5;
            Vec3 velocity = direction.m_82490_(speed).m_82520_(0.0, upSpeed, 0.0);
            ColorParticleOptions options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.ICE_SHARD.get()), 1.0f, 1.0f, 1.0f, 0.3f, -1);
            ModNetwork.sendToClientsTracking(new GenericParticlePacket(options, impactLocation, velocity, true), (Entity)player);
            ModNetwork.sendToPlayer(new GenericParticlePacket(options, impactLocation, velocity, true), player);
        }
    }

    private void spawnSmallImpactParticles(Level level, ServerPlayer player, Vec3 impactLocation) {
        if (impactLocation == null) {
            return;
        }
        int particleCount = 15;
        RandomSource random = level.f_46441_;
        for (int j = 0; j < particleCount; ++j) {
            double randomAngle = random.m_188500_() * Math.PI * 2.0;
            Vec3 direction = new Vec3(Math.cos(randomAngle), 0.0, Math.sin(randomAngle));
            double speed = 0.5 + random.m_188500_() * 1.0;
            Vec3 velocity = direction.m_82490_(speed).m_82520_(0.0, 0.1, 0.0);
            ColorParticleOptions options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.CORE_MIST.get()), 1.0f, 1.0f, 1.0f, 0.3f, -1);
            ModNetwork.sendToClientsTracking(new GenericParticlePacket(options, impactLocation, velocity, true), (Entity)player);
            ModNetwork.sendToPlayer(new GenericParticlePacket(options, impactLocation, velocity, true), player);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.getAttributeModifiers(slot, stack));
        if (slot == EquipmentSlot.MAINHAND) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeedModifier, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return !pPlayer.m_7500_();
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237113_((String)"A mace that pounds with glacial wrath.").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x7A7A7A)).m_131155_(Boolean.valueOf(true))));
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237113_((String)"\u00bb On hit: ").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)12086828))).m_7220_((Component)Component.m_237113_((String)"Applies Frostvein, layering chill that slows and numbs foes.").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xE0E0E0)))));
        pTooltipComponents.add((Component)Component.m_237113_((String)"\u00bb Use: ").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)12086828))).m_7220_((Component)Component.m_237113_((String)"Unleash a freezing shockwave of ice spikes.").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xE0E0E0)))));
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237113_((String)"You feel the air get colder around you...").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x7A7A7A)).m_131155_(Boolean.valueOf(true))));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public Component m_7626_(ItemStack pStack) {
        Style nameStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)7918055)).m_131136_(Boolean.valueOf(false));
        return super.m_7626_(pStack).m_6881_().m_6270_(nameStyle);
    }

    public int m_6473_() {
        return this.m_43314_().m_6601_();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.f_44672_ == EnchantmentCategory.WEAPON) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

