/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.item;

import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.saksolm.monsterexpansion.entity.custom.KobekoEntity;

public class KobekoLocatorItem
extends Item {
    public KobekoLocatorItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!pLevel.f_46443_) {
            KobekoEntity kobeko;
            ServerLevel playerLevel = (ServerLevel)pLevel;
            CompoundTag playerData = pPlayer.getPersistentData();
            if (!playerData.m_128403_("TamedKobekoUUID")) {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"You don't have a tamed Kobeko.").m_130940_(ChatFormatting.RED));
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (pPlayer.m_36335_().m_41519_((Item)this)) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            UUID kobekoUUID = playerData.m_128342_("TamedKobekoUUID");
            if (!playerData.m_128441_("KobekoLastDim") || !playerData.m_128441_("KobekoLastPos")) {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"Your Kobeko's location is unknown. Try again later.").m_130940_(ChatFormatting.RED));
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            String dimString = playerData.m_128461_("KobekoLastDim");
            long posLong = playerData.m_128454_("KobekoLastPos");
            ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimString));
            ServerLevel targetLevel = pLevel.m_7654_().m_129880_(dimKey);
            if (targetLevel == null) {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"Error: Could not find your Kobeko's dimension.").m_130940_(ChatFormatting.RED));
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            BlockPos kobekoPos = BlockPos.m_122022_((long)posLong);
            Entity entity = targetLevel.m_8791_(kobekoUUID);
            if (entity == null) {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"Locating your Kobeko...").m_130940_(ChatFormatting.GRAY));
                targetLevel.m_6522_(kobekoPos.m_123341_() >> 4, kobekoPos.m_123343_() >> 4, ChunkStatus.f_62326_, true);
                entity = targetLevel.m_8791_(kobekoUUID);
            }
            if (entity instanceof KobekoEntity && (kobeko = (KobekoEntity)entity).m_6084_()) {
                BlockPos safePos = this.findSafeTeleportSpot((Level)playerLevel, pPlayer.m_20183_(), pLevel.f_46441_);
                if (safePos != null) {
                    kobeko.m_264318_(playerLevel, (double)safePos.m_123341_() + 0.5, safePos.m_123342_(), (double)safePos.m_123343_() + 0.5, Set.of(), pPlayer.m_146908_(), pPlayer.m_146909_());
                    kobeko.m_21573_().m_26573_();
                    pLevel.m_6263_(null, kobeko.m_20185_(), kobeko.m_20186_(), kobeko.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    pPlayer.m_146850_(GameEvent.f_238175_);
                    pPlayer.m_36335_().m_41524_((Item)this, 1200);
                    return InteractionResultHolder.m_19090_((Object)itemstack);
                }
                pPlayer.m_213846_((Component)Component.m_237113_((String)"No safe spot to teleport your Kobeko!").m_130940_(ChatFormatting.RED));
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            playerData.m_128473_("TamedKobekoUUID");
            playerData.m_128473_("KobekoLastDim");
            playerData.m_128473_("KobekoLastPos");
            pPlayer.m_213846_((Component)Component.m_237113_((String)"Your Kobeko seems to be permanently gone. You can now tame a new one.").m_130940_(ChatFormatting.RED));
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
    }

    @Nullable
    private BlockPos findSafeTeleportSpot(Level level, BlockPos targetPos, RandomSource pRandom) {
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = pRandom.m_188503_(7) - 3;
            BlockPos potentialPos = targetPos.m_7918_(x, y = pRandom.m_188503_(3) - 1, z = pRandom.m_188503_(7) - 3);
            BlockPos floorPos = potentialPos.m_7495_();
            if (!level.m_8055_(floorPos).m_280296_() || level.m_8055_(potentialPos).m_280296_() || level.m_8055_(potentialPos.m_6630_(1)).m_280296_() || level.m_8055_(potentialPos.m_6630_(2)).m_280296_()) continue;
            return potentialPos;
        }
        return null;
    }
}

