/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.custom.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.ModEntities;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.LargeMonsterPartEntity;
import net.saksolm.monsterexpansion.entity.custom.projectile.IceSpikeMarkerEntity;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.ScreenShakePacket;
import net.saksolm.monsterexpansion.particles.ModParticles;
import net.saksolm.monsterexpansion.particles.options.ColorParticleOptions;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class SupercooledOrbEntity
extends ThrowableProjectile {
    private boolean isExploding = false;
    private int explosionTick = 0;
    private Vec3 impactLocation;
    private static final int NUM_RINGS = 10;
    private static final int SPIKES_PER_RING = 8;
    private static final double INITIAL_RADIUS = 2.5;
    private static final double RADIUS_STEP = 5.0;
    private static final int TICKS_BETWEEN_RINGS = 3;
    private static final int FREEZE_RADIUS = 8;
    public final AnimationState spinAnimation = new AnimationState();

    public SupercooledOrbEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
    }

    public SupercooledOrbEntity(Level pLevel, LivingEntity pShooter) {
        super((EntityType)ModEntities.SUPERCOOLED_ORB.get(), pShooter, pLevel);
        this.m_20242_(true);
    }

    protected void m_8097_() {
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.spinAnimation.m_216977_(this.f_19797_);
    }

    public void m_8119_() {
        if (this.isExploding) {
            ++this.explosionTick;
            if (this.explosionTick % 3 == 0) {
                int ringIndex = this.explosionTick / 3;
                if (ringIndex <= 10) {
                    this.spawnSpikeRing(ringIndex);
                    this.spawnShardParticles(ringIndex);
                    this.spawnSmallImpactParticles();
                } else {
                    this.m_146870_();
                }
            }
            return;
        }
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.f_19796_.m_188503_(2) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123747_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ > 500) {
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult pResult) {
        if (!this.m_9236_().f_46443_ && !this.isExploding) {
            this.isExploding = true;
            this.impactLocation = pResult.m_82450_();
            this.m_20256_(Vec3.f_82478_);
            this.spawnImpactParticles();
            this.freezeGround();
            ModNetwork.sendToClientsTracking(new ScreenShakePacket(240, 5), (Entity)this);
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            Entity entity = this.m_19749_();
            if (entity instanceof AbstractLargeMonster) {
                AbstractLargeMonster largeMonster = (AbstractLargeMonster)entity;
                largeMonster.dealDamageInOrientedBox(this.m_20182_(), Vec3.f_82478_, 50.0, 50.0, 50.0, 5.0f, AbstractLargeMonster.KnockbackType.NONE, 1.0, true, true, 0);
            }
        }
    }

    private void spawnImpactParticles() {
        if (this.impactLocation == null) {
            return;
        }
        int particleCount = 100;
        for (int j = 0; j < particleCount; ++j) {
            double randomAngle = this.f_19796_.m_188500_() * Math.PI * 2.0;
            Vec3 direction = new Vec3(Math.cos(randomAngle), 0.0, Math.sin(randomAngle));
            double speed = 5.0 + this.f_19796_.m_188500_() * 1.5;
            Vec3 velocity = direction.m_82490_(speed).m_82520_(0.0, 0.2, 0.0);
            ColorParticleOptions options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.CORE_MIST.get()), 1.0f, 1.0f, 1.0f, 0.5f, -1);
            ModNetwork.sendToClientsTracking(new GenericParticlePacket(options, this.impactLocation, velocity, true), (Entity)this);
        }
    }

    private void spawnSmallImpactParticles() {
        if (this.impactLocation == null) {
            return;
        }
        int particleCount = 5;
        for (int j = 0; j < particleCount; ++j) {
            double randomAngle = this.f_19796_.m_188500_() * Math.PI * 2.0;
            Vec3 direction = new Vec3(Math.cos(randomAngle), 0.0, Math.sin(randomAngle));
            double speed = 2.5 + this.f_19796_.m_188500_() * 1.5;
            Vec3 velocity = direction.m_82490_(speed).m_82520_(0.0, 0.2, 0.0);
            ColorParticleOptions options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.CORE_MIST.get()), 1.0f, 1.0f, 1.0f, 0.3f, -1);
            ModNetwork.sendToClientsTracking(new GenericParticlePacket(options, this.impactLocation, velocity, true), (Entity)this);
        }
    }

    private void spawnShardParticles(int ringIndex) {
        if (this.impactLocation == null) {
            return;
        }
        int particleCount = 30 + ringIndex * 15;
        for (int j = 0; j < particleCount; ++j) {
            double randomAngle = this.f_19796_.m_188500_() * Math.PI * 2.0;
            Vec3 direction = new Vec3(Math.cos(randomAngle), 0.0, Math.sin(randomAngle));
            double upSpeed = 0.1 + this.f_19796_.m_188500_() * 0.5;
            double speed = 1.3 + this.f_19796_.m_188500_() * 0.8;
            Vec3 velocity = direction.m_82490_(speed).m_82520_(0.0, upSpeed, 0.0);
            ColorParticleOptions options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.ICE_SHARD.get()), 1.0f, 1.0f, 1.0f, 0.3f, -1);
            ModNetwork.sendToClientsTracking(new GenericParticlePacket(options, this.impactLocation, velocity, true), (Entity)this);
        }
    }

    private void spawnSpikeRing(int ringIndex) {
        if (this.m_9236_().f_46443_ || this.impactLocation == null) {
            return;
        }
        LivingEntity owner = (LivingEntity)this.m_19749_();
        double currentRadius = 2.5 + (double)ringIndex * 5.0;
        int spikesInThisRing = 8 + ringIndex * 6;
        double angleOffset = ringIndex % 2 == 0 ? 0.0 : Math.PI / (double)spikesInThisRing;
        for (int i = 0; i < spikesInThisRing; ++i) {
            double angle = Math.PI * 2 / (double)spikesInThisRing * (double)i + angleOffset;
            double xOffset = Math.cos(angle) * currentRadius;
            double zOffset = Math.sin(angle) * currentRadius;
            Vec3 spawnPos = new Vec3(this.impactLocation.m_7096_() + xOffset, this.impactLocation.m_7098_(), this.impactLocation.m_7094_() + zOffset);
            float yaw = (float)(Mth.m_14136_((double)xOffset, (double)zOffset) * 57.29577951308232);
            IceSpikeMarkerEntity marker = new IceSpikeMarkerEntity(this.m_9236_(), spawnPos, yaw, owner);
            this.m_9236_().m_7967_((Entity)marker);
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 3) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_EXPLOSION.get(), this.m_5720_(), 10.0f, 1.0f, false);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123747_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_7337_(Entity pEntity) {
        if (this.isExploding) {
            return false;
        }
        if (pEntity == this.m_19749_()) {
            return false;
        }
        if (pEntity instanceof LargeMonsterPartEntity) {
            LargeMonsterPartEntity part = (LargeMonsterPartEntity)pEntity;
            if (part.parent == this.m_19749_()) {
                return false;
            }
        }
        return super.m_7337_(pEntity);
    }

    private void freezeGround() {
        if (this.impactLocation == null || this.m_9236_().m_5776_()) {
            return;
        }
        BlockPos centerPos = BlockPos.m_274446_((Position)this.impactLocation);
        Level world = this.m_9236_();
        for (int x = -8; x <= 8; ++x) {
            for (int z = -8; z <= 8; ++z) {
                if (x * x + z * z > 64) continue;
                for (int yOffset = -1; yOffset <= 0; ++yOffset) {
                    BlockPos currentPos = centerPos.m_7918_(x, yOffset, z);
                    BlockState currentState = world.m_8055_(currentPos);
                    if (currentState.m_60713_(Blocks.f_50126_) || currentState.m_60713_(Blocks.f_50354_) || currentState.m_60713_(Blocks.f_50449_) || currentState.m_60800_((BlockGetter)world, currentPos) < 0.0f) continue;
                    if (currentState.m_60819_().m_205070_(FluidTags.f_13131_) && currentState.m_60819_().m_76170_()) {
                        world.m_46597_(currentPos, Blocks.f_50449_.m_49966_());
                        continue;
                    }
                    if (currentState.m_60795_() || !currentState.m_60804_((BlockGetter)world, currentPos) || !currentState.m_60819_().m_76178_()) continue;
                    world.m_46597_(currentPos, Blocks.f_50354_.m_49966_());
                }
            }
        }
    }
}

