/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.custom.projectile;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.effect.ModEffects;
import net.saksolm.monsterexpansion.entity.ModEntities;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.KobekoEntity;
import net.saksolm.monsterexpansion.event.RhyzaSetBonusEvents;
import net.saksolm.monsterexpansion.item.ModItems;
import net.saksolm.monsterexpansion.network.FlashbangSequencePacket;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.SoundPacket;
import net.saksolm.monsterexpansion.particles.ModParticles;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import org.jetbrains.annotations.NotNull;

public class FlashArrowEntity
extends AbstractArrow {
    private static final int MAX_LIFETIME_IN_AIR = 50;
    private boolean effectTriggered = false;
    private int effectTicks = 0;

    public FlashArrowEntity(EntityType<? extends FlashArrowEntity> entityType, Level level) {
        super(entityType, level);
    }

    public FlashArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType)ModEntities.FLASH_ARROW.get(), shooter, level);
    }

    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ModItems.FLASH_ARROW.get());
    }

    public void m_8119_() {
        boolean inAir;
        super.m_8119_();
        if (this.effectTriggered) {
            ++this.effectTicks;
            if (this.effectTicks == 1) {
                this.flashParticles();
            } else if (this.effectTicks >= 3) {
                this.flashEffects();
                this.m_146870_();
            }
            return;
        }
        boolean bl = inAir = !this.m_20096_() && this.f_36704_ <= 0;
        if (inAir && this.f_19797_ >= 50) {
            this.startEffectSequence();
        }
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        super.m_8060_(result);
        this.startEffectSequence();
    }

    private void startEffectSequence() {
        if (!this.effectTriggered && !this.m_9236_().m_5776_()) {
            this.effectTriggered = true;
            this.m_20242_(true);
            this.m_20256_(Vec3.f_82478_);
        }
    }

    private void flashParticles() {
        if (!this.m_9236_().m_5776_()) {
            Vec3 pos = this.m_20182_();
            SimpleParticleType flashParticle = ParticleTypes.f_123747_;
            ParticleOptions flash = (ParticleOptions)ModParticles.FLASH.get();
            GenericParticlePacket particlePacket = new GenericParticlePacket((ParticleOptions)flashParticle, pos, Vec3.f_82478_, true);
            GenericParticlePacket flashParticlePacket = new GenericParticlePacket(flash, pos, Vec3.f_82478_, true);
            ModNetwork.sendToClientsTracking(particlePacket, (Entity)this);
            ModNetwork.sendToClientsTracking(flashParticlePacket, (Entity)this);
        }
    }

    private void flashEffects() {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.RHYZA_FLASHBANG.get(), this.m_5720_(), 5.0f, 1.0f);
            AABB area = this.m_20191_().m_82400_(50.0);
            List entities = this.m_9236_().m_45976_(LivingEntity.class, area);
            for (LivingEntity entity : entities) {
                KobekoEntity kobeko;
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof KobekoEntity && entity == (kobeko = (KobekoEntity)entity2).m_269323_()) continue;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    this.handlePlayerFlash(player);
                    continue;
                }
                if (entity instanceof KobekoEntity) {
                    KobekoEntity kobeko2 = (KobekoEntity)entity;
                    if (this.m_19749_() == kobeko2) continue;
                }
                if (entity instanceof AbstractLargeMonster) {
                    AbstractLargeMonster largeMonster = (AbstractLargeMonster)entity;
                    largeMonster.flash();
                    continue;
                }
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                mob.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BLINDED.get(), 400, 0));
            }
        }
    }

    private void handlePlayerFlash(ServerPlayer player) {
        double GUARANTEED_FLASH_RANGE = 20.0;
        double distanceSq = this.m_20280_((Entity)player);
        if (distanceSq <= 400.0) {
            this.flashPlayer(player);
            return;
        }
        boolean hasLineOfSight = player.m_142582_((Entity)this);
        Vec3 playerLookVec = player.m_20252_(1.0f);
        Vec3 directionToBoss = this.m_20182_().m_82546_(player.m_146892_()).m_82541_();
        double dotProduct = playerLookVec.m_82526_(directionToBoss);
        if (hasLineOfSight && dotProduct > 0.5) {
            this.flashPlayer(player);
        }
    }

    private void flashPlayer(ServerPlayer player) {
        if (!(player.m_5833_() || player.m_7500_() || RhyzaSetBonusEvents.isFullSetWorn((Player)player))) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 400, 0));
            ModNetwork.sendToPlayer(new FlashbangSequencePacket(), player);
            ModNetwork.sendToPlayer(new SoundPacket(((SoundEvent)ModSounds.RHYZA_FLASHBANG_RING.get()).m_11660_(), true), player);
        }
    }

    protected boolean m_142470_(Player pPlayer) {
        return false;
    }
}

