/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.custom;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.config.ModConfig;
import net.saksolm.monsterexpansion.entity.ai.behavior.BehaviorStatus;
import net.saksolm.monsterexpansion.entity.ai.behavior.custom.SkrytheAerialBehaviorTree;
import net.saksolm.monsterexpansion.entity.ai.behavior.custom.SkrytheGroundBehaviorTree;
import net.saksolm.monsterexpansion.entity.ai.control.BigMobFlyController;
import net.saksolm.monsterexpansion.entity.ai.control.BigMobMoveControl;
import net.saksolm.monsterexpansion.entity.ai.control.BigMobPathNavigate;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheAerialAssaultGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheAirBiteGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheAirClawGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheAirDashGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheAirKickGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheAirOrbGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheAirRoarGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheAirTailSlamGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheAirTailSwipeGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheChargeGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheEnrageGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheEscapeWaterGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheFlyGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheFollowOwnerGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheFrontBiteGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheGroundOrbGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheHaltGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheLandGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheLegStompGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheOrbFlyGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheRoarGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheRushGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheSeismicRoarGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheStaggerGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheStompGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheTailCutGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheTailSlamGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheTailSwipeGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheToppleGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheTurnGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheWingBreakGoal;
import net.saksolm.monsterexpansion.entity.ai.skrythe.SkrytheWingSlapGoal;
import net.saksolm.monsterexpansion.entity.animations.SkrytheAnimationState;
import net.saksolm.monsterexpansion.entity.animations.skrythe.SkrytheServerAnimations;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.IFlyingMonster;
import net.saksolm.monsterexpansion.entity.custom.IMonsterAbilities;
import net.saksolm.monsterexpansion.entity.custom.IMonsterStaggers;
import net.saksolm.monsterexpansion.entity.custom.LargeMonsterPartEntity;
import net.saksolm.monsterexpansion.entity.custom.SkrythePartEntity;
import net.saksolm.monsterexpansion.entity.custom.SkrytheTailEntity;
import net.saksolm.monsterexpansion.entity.custom.projectile.DistortionOrbProjectile;
import net.saksolm.monsterexpansion.entity.custom.projectile.SoundSphereProjectile;
import net.saksolm.monsterexpansion.entity.util.DamageTypes;
import net.saksolm.monsterexpansion.item.ModItems;
import org.jetbrains.annotations.Nullable;

public class SkrytheEntity
extends AbstractLargeMonster<Ability, StaggerState>
implements IFlyingMonster {
    private final SkrytheAnimationState animationState;
    public static final double BASE_MAX_HEALTH = 750.0;
    public static final double BASE_ATTACK_DAMAGE = 12.0;
    private float serverLimbSwingAmount;
    private float serverLimbSwing;
    private static final Map<String, String> SKRYTHE_HIERARCHY = ImmutableMap.builder().put((Object)"torso", (Object)"Skrythe").put((Object)"right_wing", (Object)"torso").put((Object)"right_wing1", (Object)"right_wing").put((Object)"right_wing2", (Object)"right_wing1").put((Object)"right_wing_part4", (Object)"right_wing2").put((Object)"right_wing_part1", (Object)"right_wing2").put((Object)"right_wing_part2", (Object)"right_wing2").put((Object)"right_wing_part3", (Object)"right_wing2").put((Object)"right_wing_anchor", (Object)"right_wing").put((Object)"left_wing", (Object)"torso").put((Object)"left_wing1", (Object)"left_wing").put((Object)"left_wing2", (Object)"left_wing1").put((Object)"left_wing_part4", (Object)"left_wing2").put((Object)"left_wing_part1", (Object)"left_wing2").put((Object)"left_wing_part2", (Object)"left_wing2").put((Object)"left_wing_part3", (Object)"left_wing2").put((Object)"left_wing_anchor", (Object)"left_wing").put((Object)"left_leg", (Object)"torso").put((Object)"left_knee", (Object)"left_leg").put((Object)"left_foot", (Object)"left_knee").put((Object)"left_toes", (Object)"left_foot").put((Object)"right_leg", (Object)"torso").put((Object)"right_knee", (Object)"right_leg").put((Object)"right_foot", (Object)"right_knee").put((Object)"right_toes", (Object)"right_foot").put((Object)"tail", (Object)"torso").put((Object)"tail1", (Object)"tail").put((Object)"tail2", (Object)"tail1").put((Object)"tail3", (Object)"tail2").put((Object)"tail4", (Object)"tail3").put((Object)"tail5", (Object)"tail4").put((Object)"tail6", (Object)"tail5").put((Object)"tail7", (Object)"tail6").put((Object)"neck", (Object)"torso").put((Object)"neck1", (Object)"neck").put((Object)"head", (Object)"neck1").put((Object)"jaw", (Object)"head").put((Object)"right_headthings", (Object)"head").put((Object)"right_headthing", (Object)"right_headthings").put((Object)"right_headthing2", (Object)"right_headthings").put((Object)"left_headthings", (Object)"head").put((Object)"left_headthing", (Object)"left_headthings").put((Object)"left_headthing2", (Object)"left_headthings").build();
    private static final Map<String, Vec3> SKRYTHE_DEFAULT_OFFSETS = ImmutableMap.builder().put((Object)"torso", (Object)new Vec3(0.0, 3.625, -0.3125)).put((Object)"right_wing", (Object)new Vec3(0.68695625, 0.194775, -1.26838125)).put((Object)"right_wing1", (Object)new Vec3(1.535675, 1.11143125, 1.77388125)).put((Object)"right_wing2", (Object)new Vec3(4.0625, 0.5625, -3.8125)).put((Object)"right_wing_part4", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_wing_part1", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_wing_part2", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_wing_part3", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_wing_anchor", (Object)new Vec3(5.00996875, 0.14570625, 0.33083125)).put((Object)"left_wing", (Object)new Vec3(-0.68695625, 0.194775, -1.26838125)).put((Object)"left_wing1", (Object)new Vec3(-1.535675, 1.11143125, 1.77388125)).put((Object)"left_wing2", (Object)new Vec3(-4.0625, 0.5625, -3.8125)).put((Object)"left_wing_part4", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_wing_part1", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_wing_part2", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_wing_part3", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_wing_anchor", (Object)new Vec3(-5.00996875, 0.14570625, 0.33083125)).put((Object)"left_leg", (Object)new Vec3(-0.6875, -0.315025, 0.81380625)).put((Object)"left_knee", (Object)new Vec3(-0.1875, -1.5625, -0.9375)).put((Object)"left_foot", (Object)new Vec3(0.0, -1.5625, 1.875)).put((Object)"left_toes", (Object)new Vec3(0.0, -0.25, -1.25)).put((Object)"right_leg", (Object)new Vec3(0.6875, -0.315025, 0.81380625)).put((Object)"right_knee", (Object)new Vec3(0.1875, -1.5625, -0.9375)).put((Object)"right_foot", (Object)new Vec3(0.0, -1.5625, 1.875)).put((Object)"right_toes", (Object)new Vec3(0.0, -0.25, -1.25)).put((Object)"tail", (Object)new Vec3(0.0, 0.372475, 1.50130625)).put((Object)"tail1", (Object)new Vec3(0.0, -0.125, 0.9375)).put((Object)"tail2", (Object)new Vec3(0.0, 0.0, 1.6875)).put((Object)"tail3", (Object)new Vec3(0.0, -0.0625, 1.8125)).put((Object)"tail4", (Object)new Vec3(0.0, 0.0, 1.0)).put((Object)"tail5", (Object)new Vec3(0.0, -0.0625, 0.875)).put((Object)"tail6", (Object)new Vec3(0.0, -0.0625, 1.5625)).put((Object)"tail7", (Object)new Vec3(0.0, -0.0625, 1.6875)).put((Object)"neck", (Object)new Vec3(0.0, 0.247475, -1.37369375)).put((Object)"neck1", (Object)new Vec3(0.0, -0.25, -0.6875)).put((Object)"head", (Object)new Vec3(0.0, 0.9375, -1.75)).put((Object)"jaw", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_headthings", (Object)new Vec3(0.4375, 0.5, 0.1875)).put((Object)"right_headthing", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_headthing2", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_headthings", (Object)new Vec3(-0.4375, 0.5, 0.1875)).put((Object)"left_headthing", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_headthing2", (Object)new Vec3(0.0, 0.0, 0.0)).build();
    private static final Map<String, Vec3> SKRYTHE_DEFAULT_ROTATIONS = ImmutableMap.builder().put((Object)"torso", (Object)new Vec3((double)0.0436f, 0.0, 0.0)).put((Object)"right_wing", (Object)new Vec3((double)0.0715f, (double)0.05f, (double)-0.6091f)).put((Object)"right_wing1", (Object)new Vec3((double)0.4309f, (double)-0.2909f, (double)0.0658f)).put((Object)"right_wing2", (Object)new Vec3((double)-0.4088f, (double)-0.3235f, (double)0.062f)).put((Object)"right_wing_part4", (Object)new Vec3((double)-0.4835f, (double)0.9335f, (double)0.0324f)).put((Object)"right_wing_part1", (Object)new Vec3((double)-0.4156f, (double)-0.2397f, (double)-0.6876f)).put((Object)"right_wing_part2", (Object)new Vec3((double)-0.1845f, (double)-0.0608f, (double)-0.2849f)).put((Object)"right_wing_part3", (Object)new Vec3((double)-0.215f, (double)0.3669f, (double)0.0687f)).put((Object)"right_wing_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_wing", (Object)new Vec3((double)0.0715f, (double)-0.05f, (double)0.6091f)).put((Object)"left_wing1", (Object)new Vec3((double)0.4309f, (double)0.2909f, (double)-0.0658f)).put((Object)"left_wing2", (Object)new Vec3((double)-0.4088f, (double)0.3235f, (double)-0.062f)).put((Object)"left_wing_part4", (Object)new Vec3((double)-0.4835f, (double)-0.9335f, (double)-0.0324f)).put((Object)"left_wing_part1", (Object)new Vec3((double)-0.3462f, (double)0.17f, (double)0.5568f)).put((Object)"left_wing_part2", (Object)new Vec3((double)-0.1845f, (double)0.0608f, (double)0.2849f)).put((Object)"left_wing_part3", (Object)new Vec3((double)-0.215f, (double)-0.3669f, (double)-0.0687f)).put((Object)"left_wing_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_leg", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_knee", (Object)new Vec3((double)-0.2664f, (double)-0.2595f, (double)0.035f)).put((Object)"left_foot", (Object)new Vec3((double)0.2618f, 0.0, 0.0)).put((Object)"left_toes", (Object)new Vec3((double)-0.4363f, 0.0, 0.0)).put((Object)"right_leg", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_knee", (Object)new Vec3((double)-0.2664f, (double)0.2595f, (double)-0.035f)).put((Object)"right_foot", (Object)new Vec3((double)0.2618f, 0.0, 0.0)).put((Object)"right_toes", (Object)new Vec3((double)-0.4363f, 0.0, 0.0)).put((Object)"tail", (Object)new Vec3((double)-0.3491f, 0.0, 0.0)).put((Object)"tail1", (Object)new Vec3((double)-0.0436f, 0.0, 0.0)).put((Object)"tail2", (Object)new Vec3((double)-0.0436f, 0.0, 0.0)).put((Object)"tail3", (Object)new Vec3((double)-0.0436f, 0.0, 0.0)).put((Object)"tail4", (Object)new Vec3((double)-0.0436f, 0.0, 0.0)).put((Object)"tail5", (Object)new Vec3((double)-0.0436f, 0.0, 0.0)).put((Object)"tail6", (Object)new Vec3((double)-0.0436f, 0.0, 0.0)).put((Object)"tail7", (Object)new Vec3((double)-0.0436f, 0.0, 0.0)).put((Object)"neck", (Object)new Vec3((double)0.48f, 0.0, 0.0)).put((Object)"neck1", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"head", (Object)new Vec3((double)-0.2618f, 0.0, 0.0)).put((Object)"jaw", (Object)new Vec3((double)0.0873f, 0.0, 0.0)).put((Object)"right_headthings", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_headthing", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_headthing2", (Object)new Vec3((double)-0.7586f, (double)0.3658f, (double)-2.828f)).put((Object)"left_headthings", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_headthing", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_headthing2", (Object)new Vec3((double)-0.7586f, (double)-0.3658f, (double)2.828f)).build();
    private final SkrytheGroundBehaviorTree groundBehaviorTree;
    private final SkrytheAerialBehaviorTree aerialBehaviorTree;
    private final SkrythePartEntity head;
    private final SkrythePartEntity right_wing1;
    private final SkrythePartEntity right_wing2;
    private final SkrythePartEntity left_wing1;
    private final SkrythePartEntity left_wing2;
    private final SkrythePartEntity tail;
    private final SkrythePartEntity tail1;
    private final SkrythePartEntity tail2;
    private final SkrythePartEntity tail3;
    private final SkrythePartEntity tail4;
    private final SkrythePartEntity tail5;
    private final SkrythePartEntity tail6;
    private final SkrythePartEntity tail7;
    private final SkrythePartEntity[] parts;
    public boolean rightWingBroken = false;
    public boolean leftWingBroken = false;
    private static final EntityDataAccessor<Boolean> TAIL_CUT = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int ticksStuckClose = 0;
    private int ticksSpentFlying = 0;
    private int pathUpdateCooldown = 0;
    private int flightCooldown = 0;
    private int landingCooldown = 0;
    private int takeoffStartTick = -1;
    private boolean hasLaunched = false;
    private int timeTargetOutOfRange = 0;
    private int timeInRange = 0;
    private int lastOrbFly = -1000;
    private int lastTurn = -1000;
    private int lastGlance = -1000;
    private int lastSeismicRoar = -1000;
    private int lastAerialAssault = -1000;
    private int lastAirOrb = -1000;
    private int lastGroundOrb = -1000;
    private int lastAirKick = -1000;
    private int lastRush = -1000;
    private int lastAirBite = -1000;
    private int lastAirTailSwipe = -1000;
    private int lastLegStomp = -1000;
    private int lastStomp = -1000;
    private int lastCharge = -1000;
    private int lastFrontBite = -1000;
    private int lastTailSlam = -1000;
    private int lastWingSlap = -1000;
    private int lastTailSwipe = -1000;
    private int lastAirRoar = -1000;
    private int lastRoar = -1000;
    private int lastAirDash = -1000;
    private int lastAirClaw = -1000;
    private int lastHalt = -1000;
    private int lastAirTailSlam = -1000;
    public LivingEntity turnTarget;
    private final int GLANCE_COOLDOWN = 200;
    private final int AIR_CLAW_COOLDOWN = 200;
    private final int ORB_FLY_COOLDOWN = 1000;
    private final int TURN_COOLDOWN = 50;
    private final int ROAR_COOLDOWN = 750;
    private final int AIR_ROAR_COOLDOWN = 750;
    private final int TAILSWIPE_COOLDOWN = 250;
    private final int WING_SLAP_COOLDOWN = 100;
    private final int TAIL_SLAM_COOLDOWN = 200;
    private final int FRONT_BITE_COOLDOWN = 100;
    private final int CHARGE_COOLDOWN = 500;
    private final int STOMP_COOLDOWN = 500;
    private final int LEG_STOMP_COOLDOWN = 200;
    private final int AIR_TAILSWIPE_COOLDOWN = 200;
    private final int AIR_BITE_COOLDOWN = 100;
    private final int RUSH_COOLDOWN = 300;
    private final int AIR_KICK_COOLDOWN = 50;
    private final int AIR_ORB_COOLDOWN = 150;
    private final int GROUND_ORB_COOLDOWN = 70;
    private final int AERIAL_ASSAULT_COOLDOWN = 1500;
    private final int SEISMIC_ROAR_COOLDOWN = 2000;
    private final int AIR_DASH_COOLDOWN = 100;
    private final int HALT_COOLDOWN = 250;
    private final int AIR_TAIL_SLAM_COOLDOWN = 250;
    private boolean wasFlyingLastTick = false;
    private boolean wasHoveringLastTick = false;
    private static final EntityDataAccessor<Boolean> HEADSHAKE = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HOVER_TRANSITION = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLY_TRANSITION = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> AERIAL = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLY = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HOVER = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLAPPING = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TURN_STATE = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AIR_DASH_STATE = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CHARGE_STATE = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STOMP_STATE = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LAND_STATE = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FLY_STATE = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ENRAGED_RUSH_STATE = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ENRAGED_FRONT_BITE_STATE = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AERIAL_ASSAULT_STATE = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AIR_TOPPLE_STATE = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AIR_TAIL_CUT_STATE = SynchedEntityData.m_135353_(SkrytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState startFlyFailAnimation = new AnimationState();
    public final AnimationState airTailSlamAnimation = new AnimationState();
    public final AnimationState airClawAnimation = new AnimationState();
    public final AnimationState airHaltAnimation = new AnimationState();
    public final AnimationState groundHaltAnimation = new AnimationState();
    public final AnimationState orbFlyAnimation = new AnimationState();
    public final AnimationState airDashTurnRightAnimation = new AnimationState();
    public final AnimationState airDashTurnLeftAnimation = new AnimationState();
    public final AnimationState airDashStopLeftAnimation = new AnimationState();
    public final AnimationState airDashStopRightAnimation = new AnimationState();
    public final AnimationState airDashMoveAnimation = new AnimationState();
    public final AnimationState groundRightWingBreakAnimation = new AnimationState();
    public final AnimationState groundLeftWingBreakAnimation = new AnimationState();
    public final AnimationState airRightWingBreakAnimation = new AnimationState();
    public final AnimationState airLeftWingBreakAnimation = new AnimationState();
    public final AnimationState airTailCutCrashAnimation = new AnimationState();
    public final AnimationState airTailCutFallAnimation = new AnimationState();
    public final AnimationState airTailCutStartAnimation = new AnimationState();
    public final AnimationState groundTailCutAnimation = new AnimationState();
    public final AnimationState deathAnimation = new AnimationState();
    public final AnimationState turnRightAnimation = new AnimationState();
    public final AnimationState turnLeftAnimation = new AnimationState();
    public final AnimationState groundOrbAnimation = new AnimationState();
    public final AnimationState airStaggerAnimation = new AnimationState();
    public final AnimationState groundStaggerAnimation = new AnimationState();
    public final AnimationState groundToppleAnimation = new AnimationState();
    public final AnimationState airToppleStartAnimation = new AnimationState();
    public final AnimationState airToppleFallAnimation = new AnimationState();
    public final AnimationState airToppleCrashAnimation = new AnimationState();
    public final AnimationState seismicRoarAnimation = new AnimationState();
    public final AnimationState aerialAssaultRiseAnimation = new AnimationState();
    public final AnimationState aerialAssaultTransitionAnimation = new AnimationState();
    public final AnimationState aerialAssaultDiveAnimation = new AnimationState();
    public final AnimationState aerialAssaultCrashAnimation = new AnimationState();
    public final AnimationState enragedAirOrbAnimation = new AnimationState();
    public final AnimationState enragedRushBaseAnimation = new AnimationState();
    public final AnimationState enragedRushSlideAnimation = new AnimationState();
    public final AnimationState enragedRushTurnAnimation = new AnimationState();
    public final AnimationState enragedRushReRushAnimation = new AnimationState();
    public final AnimationState enragedRushEndAnimation = new AnimationState();
    public final AnimationState enragedFrontBiteSuccessAnimation = new AnimationState();
    public final AnimationState enragedFrontBiteFailAnimation = new AnimationState();
    public final AnimationState enragedFrontBiteBaseAnimation = new AnimationState();
    public final AnimationState airOrbAnimation = new AnimationState();
    public final AnimationState airKickAnimation = new AnimationState();
    public final AnimationState rushAnimation = new AnimationState();
    public final AnimationState airEnrageAnimation = new AnimationState();
    public final AnimationState groundEnrageAnimation = new AnimationState();
    public final AnimationState airBiteAnimation = new AnimationState();
    public final AnimationState airTailswipeAnimation = new AnimationState();
    public final AnimationState legStompAnimation = new AnimationState();
    public final AnimationState stompAnimation = new AnimationState();
    public final AnimationState stompEndAnimation = new AnimationState();
    public final AnimationState stompStartAnimation = new AnimationState();
    public final AnimationState chargeAnimation = new AnimationState();
    public final AnimationState chargeEndAnimation = new AnimationState();
    public final AnimationState chargeStartAnimation = new AnimationState();
    public final AnimationState wingSlapAnimation = new AnimationState();
    public final AnimationState frontBiteAnimation = new AnimationState();
    public final AnimationState tailSlamAnimation = new AnimationState();
    public final AnimationState airRoarAnimation = new AnimationState();
    public final AnimationState tailswipeAnimation = new AnimationState();
    public final AnimationState roarAnimation = new AnimationState();
    public final AnimationState hoverToFlyingAnimation = new AnimationState();
    public final AnimationState flyingToHoverAnimation = new AnimationState();
    public final AnimationState hoverAnimation = new AnimationState();
    public final AnimationState flyAnimation = new AnimationState();
    public final AnimationState startFlyingAnimation = new AnimationState();
    public final AnimationState stopFlyingAnimation = new AnimationState();
    public final AnimationState idleAnimation = new AnimationState();
    public final AnimationState flappingAnimation = new AnimationState();
    public final AnimationState sitAnimation = new AnimationState();
    public final AnimationState sitStartAnimation = new AnimationState();
    public final AnimationState sitEndAnimation = new AnimationState();

    public SkrytheEntity(EntityType<? extends AbstractLargeMonster<Ability, StaggerState>> pEntityType, Level pLevel) {
        super(pEntityType, pLevel, Ability.class, StaggerState.class);
        this.animationState = new SkrytheAnimationState();
        this.head = new SkrythePartEntity(this, 1.5f, 1.5f);
        this.right_wing1 = new SkrythePartEntity(this, 5.0f, 2.5f);
        this.right_wing2 = new SkrythePartEntity(this, 3.0f, 2.5f);
        this.left_wing1 = new SkrythePartEntity(this, 5.0f, 2.5f);
        this.left_wing2 = new SkrythePartEntity(this, 3.0f, 2.5f);
        this.tail = new SkrythePartEntity(this, 1.0f, 1.0f);
        this.tail1 = new SkrythePartEntity(this, 2.0f, 2.0f);
        this.tail2 = new SkrythePartEntity(this, 2.0f, 2.0f);
        this.tail3 = new SkrythePartEntity(this, 2.0f, 2.0f);
        this.tail4 = new SkrythePartEntity(this, 2.0f, 2.0f);
        this.tail5 = new SkrythePartEntity(this, 2.0f, 2.0f);
        this.tail6 = new SkrythePartEntity(this, 2.0f, 2.0f);
        this.tail7 = new SkrythePartEntity(this, 2.0f, 2.0f);
        for (SkrythePartEntity part : this.parts = new SkrythePartEntity[]{this.head, this.right_wing1, this.right_wing2, this.left_wing1, this.left_wing2, this.tail1, this.tail2, this.tail3, this.tail4, this.tail5, this.tail6, this.tail7}) {
            this.additivePartOffsets.put(part, Vec3.f_82478_);
        }
        this.groundBehaviorTree = new SkrytheGroundBehaviorTree();
        this.aerialBehaviorTree = new SkrytheAerialBehaviorTree();
        this.registerBreakablePart("head_stagger", this.getStaggerPartBaseHealth());
        this.registerBreakablePart("head_break", this.m_21233_() * 0.4f);
        this.registerBreakablePart("tail", this.m_21233_() * 2.0f / 5.0f);
        this.registerBreakablePart("right_wing", this.m_21233_() * 3.0f / 10.0f);
        this.registerBreakablePart("left_wing", this.m_21233_() * 3.0f / 10.0f);
        this.registerRawHitzone("body", DamageTypes.WeaponType.SLASHING, 0.3f);
        this.registerRawHitzone("body", DamageTypes.WeaponType.BLUNT, 0.3f);
        this.registerRawHitzone("body", DamageTypes.WeaponType.PIERCING, 0.3f);
        this.registerElementalHitzone("body", DamageTypes.ElementType.ICE, 0.4f);
        this.registerRawHitzone("head_stagger", DamageTypes.WeaponType.BLUNT, 0.7f);
        this.registerRawHitzone("head_stagger", DamageTypes.WeaponType.SLASHING, 0.45f);
        this.registerRawHitzone("head_stagger", DamageTypes.WeaponType.PIERCING, 0.45f);
        this.registerRawHitzone("head_break", DamageTypes.WeaponType.BLUNT, 0.7f);
        this.registerRawHitzone("head_break", DamageTypes.WeaponType.SLASHING, 0.45f);
        this.registerRawHitzone("head_break", DamageTypes.WeaponType.PIERCING, 0.45f);
        this.registerRawHitzone("tail", DamageTypes.WeaponType.SLASHING, 0.6f);
        this.registerRawHitzone("tail", DamageTypes.WeaponType.BLUNT, 0.3f);
        this.registerRawHitzone("tail", DamageTypes.WeaponType.PIERCING, 0.3f);
        this.registerRawHitzone("right_wing", DamageTypes.WeaponType.PIERCING, 0.5f);
        this.registerRawHitzone("right_wing", DamageTypes.WeaponType.SLASHING, 0.4f);
        this.registerRawHitzone("right_wing", DamageTypes.WeaponType.BLUNT, 0.4f);
        this.registerRawHitzone("left_wing", DamageTypes.WeaponType.PIERCING, 0.5f);
        this.registerRawHitzone("left_wing", DamageTypes.WeaponType.SLASHING, 0.4f);
        this.registerRawHitzone("left_wing", DamageTypes.WeaponType.BLUNT, 0.4f);
        this.registerElementalHitzone("head_stagger", DamageTypes.ElementType.ICE, 0.5f);
        this.registerElementalHitzone("head_break", DamageTypes.ElementType.ICE, 0.5f);
        this.registerElementalHitzone("right_wing", DamageTypes.ElementType.ICE, 0.5f);
        this.registerElementalHitzone("left_wing", DamageTypes.ElementType.ICE, 0.5f);
        this.registerElementalHitzone("tail", DamageTypes.ElementType.ICE, 0.4f);
        this.m_21051_(Attributes.f_22276_).m_22100_(750.0 * (Double)ModConfig.SERVER.SKRYTHE.MAX_HEALTH.get() * (Double)ModConfig.SERVER.GENERAL.MAX_HEALTH.get());
        this.m_21051_(Attributes.f_22281_).m_22100_(12.0 * (Double)ModConfig.SERVER.SKRYTHE.ATTACK_DAMAGE.get() * (Double)ModConfig.SERVER.GENERAL.MAX_HEALTH.get());
    }

    public SkrytheAnimationState getAnimationState() {
        return this.animationState;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLAPPING, (Object)false);
        this.f_19804_.m_135372_(HEADSHAKE, (Object)false);
        this.f_19804_.m_135372_(HOVER_TRANSITION, (Object)false);
        this.f_19804_.m_135372_(FLY_TRANSITION, (Object)false);
        this.f_19804_.m_135372_(AERIAL, (Object)false);
        this.f_19804_.m_135372_(FLY, (Object)false);
        this.f_19804_.m_135372_(HOVER, (Object)false);
        this.f_19804_.m_135372_(TAIL_CUT, (Object)false);
        this.f_19804_.m_135372_(TURN_STATE, (Object)TurnState.NONE.ordinal());
        this.f_19804_.m_135372_(AIR_DASH_STATE, (Object)AirDashState.NONE.ordinal());
        this.f_19804_.m_135372_(ENRAGED_RUSH_STATE, (Object)EnragedRushState.NONE.ordinal());
        this.f_19804_.m_135372_(ENRAGED_FRONT_BITE_STATE, (Object)EnragedFrontBiteState.NONE.ordinal());
        this.f_19804_.m_135372_(LAND_STATE, (Object)LandState.NONE.ordinal());
        this.f_19804_.m_135372_(FLY_STATE, (Object)FlyState.NONE.ordinal());
        this.f_19804_.m_135372_(STOMP_STATE, (Object)StompState.NONE.ordinal());
        this.f_19804_.m_135372_(CHARGE_STATE, (Object)ChargeState.NONE.ordinal());
        this.f_19804_.m_135372_(AERIAL_ASSAULT_STATE, (Object)AerialAssaultState.NONE.ordinal());
        this.f_19804_.m_135372_(AIR_TOPPLE_STATE, (Object)AirToppleState.NONE.ordinal());
        this.f_19804_.m_135372_(AIR_TAIL_CUT_STATE, (Object)AirTailCutState.NONE.ordinal());
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new SkrytheEscapeWaterGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new SkrytheStaggerGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new SkrytheToppleGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new SkrytheTailCutGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new SkrytheWingBreakGoal(this));
        if (!this.m_21824_() || this.m_21824_() && this.getTamedBehavior() != AbstractLargeMonster.TamedBehavior.PASSIVE) {
            this.f_21345_.m_25352_(1, (Goal)new SkrytheTurnGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheOrbFlyGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheEnrageGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheLandGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheFlyGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheSeismicRoarGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheAerialAssaultGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheRushGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheAirOrbGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheGroundOrbGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheAirKickGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheAirBiteGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheAirTailSwipeGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheLegStompGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheStompGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheChargeGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheFrontBiteGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheTailSlamGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheWingSlapGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheAirRoarGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheTailSwipeGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheRoarGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheAirDashGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheAirClawGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheHaltGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new SkrytheAirTailSlamGoal(this));
        }
        if (this.m_21824_() && this.getTamedStance() == AbstractLargeMonster.TamedStance.FOLLOWING) {
            this.f_21345_.m_25352_(2, (Goal)new SkrytheFollowOwnerGoal(this, 1.0, 20.0f, 12.0f));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.decideIfEntityFlyingOrHovering();
        if (!this.m_9236_().f_46443_) {
            if (this.isTailCut()) {
                this.tail4.m_146870_();
                this.tail5.m_146870_();
                this.tail6.m_146870_();
                this.tail7.m_146870_();
            }
            this.updateServerWalk();
            this.updateAITimers();
            if (!(this.m_21824_() && (!this.m_21824_() || this.getTamedBehavior() != AbstractLargeMonster.TamedBehavior.AGGRESSIVE && this.getTamedBehavior() != AbstractLargeMonster.TamedBehavior.NEUTRAL) || this.m_20160_() || this.getTamedStance() == AbstractLargeMonster.TamedStance.SITTING || this.m_5448_() == null)) {
                if (!this.isAerial()) {
                    this.groundBehaviorTree.tick(this);
                } else {
                    this.aerialBehaviorTree.tick(this);
                }
            }
            --this.pathUpdateCooldown;
        }
    }

    private void updateAITimers() {
        this.ticksSpentFlying = this.isAerial() ? ++this.ticksSpentFlying : 0;
        this.ticksStuckClose = this.m_5448_() != null ? (this.m_20280_((Entity)this.m_5448_()) < 36.0 ? ++this.ticksStuckClose : 0) : 0;
        --this.flightCooldown;
        --this.landingCooldown;
    }

    private void decideIfEntityFlyingOrHovering() {
        if (this.isAerial() && !this.isAttacking()) {
            boolean isMoving;
            double motionSq = this.m_20184_().m_82556_();
            boolean bl = isMoving = motionSq > (double)0.17f;
            if (isMoving) {
                this.setHovering(false);
                this.setFlying(true);
            } else {
                this.setHovering(true);
                this.setFlying(false);
            }
        } else {
            this.setHovering(false);
            this.setFlying(false);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 750.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22280_, 1.0).m_22268_(Attributes.f_22278_, 0.95);
    }

    @Override
    public String getStaggerPartName() {
        return "head_stagger";
    }

    @Override
    public float getStaggerPartBaseHealth() {
        return this.m_21233_() * 2.0f / 15.0f;
    }

    @Override
    protected void onFlashed(DamageSource source) {
        if (this.isAerial()) {
            this.setToppleForFlashIfAerial();
        } else {
            this.setStaggerForFlash();
        }
        ++this.staggerCount;
        this.flashProgress = 0;
        this.flashThreshold = (int)Math.pow(2.0, this.staggerCount);
    }

    @Override
    @Nullable
    protected List<String> getLogicalPartNamesFor(LargeMonsterPartEntity<?> physicalPart) {
        if (physicalPart == this.head) {
            return List.of("head_stagger", "head_break");
        }
        if (this.isTailPart((SkrythePartEntity)physicalPart)) {
            return List.of("tail");
        }
        if (this.isRightWingPart((SkrythePartEntity)physicalPart)) {
            return List.of("right_wing");
        }
        if (this.isLeftWingPart((SkrythePartEntity)physicalPart)) {
            return List.of("left_wing");
        }
        return null;
    }

    @Override
    protected void onPartBroken(String partName, DamageSource source) {
        switch (partName) {
            case "head_stagger": {
                this.handleStagger(source);
                break;
            }
            case "head_break": {
                if (this.hasDroppedToppleLoot) break;
                if (this.getCurrentStaggerState() == StaggerState.STAGGER) {
                    this.setCurrentStaggerState(StaggerState.TOPPLE);
                } else {
                    this.setCurrentStaggerState(StaggerState.STAGGER);
                }
                this.hasDroppedToppleLoot = true;
                ItemStack item = this.m_217043_().m_188503_(3) == 0 ? new ItemStack((ItemLike)ModItems.SKRYTHE_FANG.get()) : new ItemStack((ItemLike)ModItems.SKRYTHE_ARMORPLATE.get());
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.head.m_20185_(), this.head.m_20186_(), this.head.m_20189_(), item);
                this.m_9236_().m_7967_((Entity)itemEntity);
                break;
            }
            case "tail": {
                if (this.isTailCut()) break;
                this.setTailCut(true);
                this.setCurrentStaggerState(StaggerState.TAIL_CUT);
                Vec3 directionToPart = this.tail.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                float tailYaw = this.m_146908_();
                SkrythePartEntity part = this.tail4;
                double flingSpeed = 0.1;
                double upwardSpeed = 0.8;
                SkrytheTailEntity tailEntity = new SkrytheTailEntity(this.m_9236_(), part.m_20185_(), part.m_20186_(), part.m_20189_(), tailYaw);
                tailEntity.m_20334_(directionToPart.f_82479_ * flingSpeed, upwardSpeed, directionToPart.f_82481_ * flingSpeed);
                this.m_9236_().m_7967_((Entity)tailEntity);
                break;
            }
            case "right_wing": {
                if (this.rightWingBroken) break;
                this.setCurrentStaggerState(StaggerState.RIGHT_WING_BREAK);
                this.rightWingBroken = true;
                ItemStack item = new ItemStack((ItemLike)ModItems.SKRYTHE_WING_MEMBRANE.get());
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.right_wing2.m_20185_(), this.right_wing2.m_20186_(), this.right_wing2.m_20189_(), item);
                this.m_9236_().m_7967_((Entity)itemEntity);
                break;
            }
            case "left_wing": {
                if (this.leftWingBroken) break;
                this.setCurrentStaggerState(StaggerState.LEFT_WING_BREAK);
                this.leftWingBroken = true;
                ItemStack item = new ItemStack((ItemLike)ModItems.SKRYTHE_WING_MEMBRANE.get());
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.left_wing2.m_20185_(), this.left_wing2.m_20186_(), this.left_wing2.m_20189_(), item);
                this.m_9236_().m_7967_((Entity)itemEntity);
            }
        }
    }

    private void handleStagger(DamageSource source) {
        if (this.getCurrentStaggerState() == StaggerState.TOPPLE) {
            this.setCurrentStaggerState(StaggerState.STAGGER);
        } else if (this.getCurrentStaggerState() == StaggerState.STAGGER) {
            this.setCurrentStaggerState(StaggerState.TOPPLE);
            ++this.toppleCount;
        } else if (this.getCurrentAbility() == Ability.AERIAL_ASSAULT || this.getCurrentAbility() == Ability.SEISMIC_ROAR) {
            this.setCurrentStaggerState(StaggerState.TOPPLE);
            ++this.toppleCount;
        } else if (this.staggerCount % 3 != 0 || this.staggerCount == 0) {
            this.setCurrentStaggerState(StaggerState.STAGGER);
        } else {
            this.setCurrentStaggerState(StaggerState.TOPPLE);
            ++this.toppleCount;
        }
        float newHealth = this.getStaggerPartBaseHealth() * (1.0f + 0.5f * (float)this.staggerCount);
        this.resetPartHealth(this.getStaggerPartName(), newHealth);
    }

    @Override
    public void setStaggerForFlash() {
        this.handleStagger(this.m_269291_().m_269425_());
    }

    @Override
    public void setToppleForFlashIfAerial() {
        this.setCurrentStaggerState(StaggerState.TOPPLE);
        ++this.toppleCount;
        float newHealth = this.getStaggerPartBaseHealth() * (1.0f + 0.5f * (float)this.staggerCount);
        this.resetPartHealth(this.getStaggerPartName(), newHealth);
    }

    public void fireDistortionOrb(Vec3 spawnPos, Vec3 moveVec) {
        if (!this.m_9236_().f_46443_) {
            DistortionOrbProjectile orb = new DistortionOrbProjectile(this.m_9236_(), (LivingEntity)this);
            orb.m_146884_(spawnPos);
            orb.m_20256_(moveVec);
            this.m_9236_().m_7967_((Entity)orb);
            this.m_9236_().m_7605_((Entity)orb, (byte)4);
        }
    }

    public void fireSoundSphere(Vec3 spawnPos, Vec3 moveVec) {
        if (!this.m_9236_().f_46443_) {
            SoundSphereProjectile sphere = new SoundSphereProjectile(this.m_9236_(), (LivingEntity)this);
            sphere.m_146884_(spawnPos);
            sphere.m_20256_(moveVec);
            this.m_9236_().m_7967_((Entity)sphere);
            this.m_9236_().m_7605_((Entity)sphere, (byte)4);
        }
    }

    public SkrythePartEntity[] getBodyParts() {
        return this.parts;
    }

    public SkrythePartEntity getHeadPart() {
        return this.head;
    }

    public double tryRoar() {
        double score;
        if (this.isAttacking() || this.f_19797_ - this.lastRoar < 750 || this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        AbstractLargeMonster.RelativePosition pos = this.getTargetRelativePosition(this.m_5448_());
        if (pos == AbstractLargeMonster.RelativePosition.FRONT) {
            score = 20.0;
        } else {
            if (pos == AbstractLargeMonster.RelativePosition.BACK || pos == AbstractLargeMonster.RelativePosition.BACK_LEFT || pos == AbstractLargeMonster.RelativePosition.BACK_RIGHT) {
                return 0.0;
            }
            score = 10.0;
        }
        double distanceSqr = this.m_20280_((Entity)this.m_5448_());
        score = distanceSqr > 400.0 ? (score *= 2.0) : (score -= 10.0);
        if (this.isTargetHealing()) {
            score *= 5.0;
        }
        return Math.max(0.0, score);
    }

    public double tryTailSwipe() {
        if (this.isAttacking() || this.f_19797_ - this.lastTailSwipe < 250 || this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_() || !this.m_5448_().m_20096_()) {
            return 0.0;
        }
        if (this.m_20280_((Entity)this.m_5448_()) > 225.0) {
            return 0.0;
        }
        double score = 15.0;
        AbstractLargeMonster.RelativePosition pos = this.getTargetRelativePosition(this.m_5448_());
        score = pos == AbstractLargeMonster.RelativePosition.LEFT ? (score *= 3.0) : (pos == AbstractLargeMonster.RelativePosition.BACK ? (score *= 1.0) : (pos == AbstractLargeMonster.RelativePosition.BACK_LEFT ? (score *= 2.0) : (pos == AbstractLargeMonster.RelativePosition.FRONT_LEFT ? (score *= 1.5) : (score *= 0.0))));
        return score;
    }

    public double tryAirRoar() {
        if (this.isAttacking() || this.f_19797_ - this.lastAirRoar < 750 || !this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        double score = 25.0;
        double distance = this.m_20270_((Entity)this.m_5448_());
        if (distance > 20.0) {
            return 0.0;
        }
        if (distance < 10.0) {
            score += 15.0;
        }
        return score;
    }

    public double tryWingSlap() {
        if (this.isAttacking() || this.f_19797_ - this.lastWingSlap < 100 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(5.0, 0.0, 2.0), 4.0, 6.0, 5.0);
        if (!targetInZone) {
            return 0.0;
        }
        double score = 30.0;
        if (this.isTargetHealing()) {
            score *= 3.0;
        }
        return score;
    }

    public double tryTailSlam() {
        boolean targetInZone;
        if (this.isAttacking() || this.f_19797_ - this.lastTailSlam < 200 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean bl = targetInZone = this.m_20280_((Entity)this.m_5448_()) < 100.0 && (this.getTargetRelativePosition(this.m_5448_()) == AbstractLargeMonster.RelativePosition.LEFT || this.getTargetRelativePosition(this.m_5448_()) == AbstractLargeMonster.RelativePosition.BACK_LEFT || this.getTargetRelativePosition(this.m_5448_()) == AbstractLargeMonster.RelativePosition.FRONT_LEFT);
        if (!targetInZone) {
            return 0.0;
        }
        double score = 30.0;
        if (this.isTargetHealing()) {
            score *= 3.0;
        }
        return score;
    }

    public double tryFrontBite() {
        if (this.isAttacking() || this.f_19797_ - this.lastFrontBite < 100 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 4.0), 6.0, 6.0, 6.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 45.0;
    }

    public double tryCharge() {
        if (this.isAttacking() || this.f_19797_ - this.lastCharge < 500 || this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_() || !this.m_5448_().m_20096_()) {
            return 0.0;
        }
        double distance = this.m_20270_((Entity)this.m_5448_());
        if (distance <= 30.0) {
            return 0.0;
        }
        double score = 30.0 + (distance - 30.0);
        if (this.isTargetHealing()) {
            score *= 3.0;
        }
        return score;
    }

    public double tryRush() {
        if (this.isAttacking() || this.f_19797_ - this.lastRush < 300 || this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 15.0), 6.0, 12.0, 15.0);
        if (!targetInZone) {
            return 0.0;
        }
        double score = 30.0;
        if (this.isTargetBlocking()) {
            score *= 1.5;
        }
        if (this.isTargetRunningAway()) {
            score *= 4.0;
        }
        return score;
    }

    public double tryAirTailSwipe() {
        if (this.isAttacking() || this.f_19797_ - this.lastAirTailSwipe < 200 || !this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), Vec3.f_82478_, 4.0, 20.0, 20.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 35.0;
    }

    public double tryAirBite() {
        if (this.isAttacking() || this.f_19797_ - this.lastAirBite < 100 || !this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, -2.0, 15.0), 4.0, 9.0, 10.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 40.0;
    }

    public double tryAirKick() {
        if (this.isAttacking() || this.f_19797_ - this.lastAirKick < 50 || !this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, -4.0, 0.0), 8.0, 8.0, 8.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 40.0;
    }

    public double tryAirOrb() {
        if (this.isAttacking() || this.f_19797_ - this.lastAirOrb < 150 || !this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 30.0), 2.0, 30.0, 30.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 30.0;
    }

    public double tryStomp() {
        if (!this.isEnraged() || this.isAttacking() || this.f_19797_ - this.lastStomp < 500 || this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_() || !this.m_5448_().m_20096_()) {
            return 0.0;
        }
        double distance = this.m_20270_((Entity)this.m_5448_());
        if (distance >= 7.0) {
            return 0.0;
        }
        double score = 60.0 - distance * 2.0;
        return Math.max(0.0, score);
    }

    public double tryLegStomp() {
        if (this.isAttacking() || this.f_19797_ - this.lastLegStomp < 200 || this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_() || !this.m_5448_().m_20096_()) {
            return 0.0;
        }
        double distance = this.m_20270_((Entity)this.m_5448_());
        if (distance >= 5.0) {
            return 0.0;
        }
        double score = 35.0 - distance * 2.0;
        return Math.max(0.0, score);
    }

    public double tryStuckAttack() {
        boolean onCooldown;
        if (this.m_5448_() == null || this.isAttacking() || !this.isStuck() || !this.m_142582_((Entity)this.m_5448_())) {
            return 0.0;
        }
        boolean bl = this.isAerial() ? this.f_19797_ - this.lastAirOrb < 70 : (onCooldown = this.f_19797_ - this.lastGroundOrb < 70);
        if (onCooldown) {
            return 0.0;
        }
        return 100.0;
    }

    public double tryAerialAssault() {
        if (!this.isEnraged() || this.isAttacking() || this.f_19797_ - this.lastAerialAssault < 1500 || !this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_() || this.m_20280_((Entity)this.m_5448_()) <= 1225.0) {
            return 0.0;
        }
        int RISE_HEIGHT = 40;
        BlockPos.MutableBlockPos checkPos = this.m_20183_().m_122032_();
        for (int i = 1; i <= 40; ++i) {
            if (this.m_9236_().m_8055_((BlockPos)checkPos.m_122173_(Direction.UP)).m_60795_()) continue;
            return 0.0;
        }
        double score = 80.0 + (double)(this.m_20270_((Entity)this.m_5448_()) - 35.0f);
        return score;
    }

    public double trySeismicRoar() {
        if (!this.isEnraged() || this.isAttacking() || this.f_19797_ - this.lastSeismicRoar < 2000 || this.m_5448_() == null || !this.m_5448_().m_6084_() || !this.m_5448_().m_20096_()) {
            return 0.0;
        }
        double distanceSq = this.m_20280_((Entity)this.m_5448_());
        if (distanceSq >= 400.0) {
            return 0.0;
        }
        double score = 75.0;
        return score;
    }

    public double tryAirClaw() {
        if (this.isAttacking() || this.f_19797_ - this.lastAirClaw < 200 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        double score = 0.0;
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 20.0), 10.0, 30.0, 20.0);
        if (targetInZone) {
            score = 50.0;
        }
        return score;
    }

    public double tryTurn() {
        if (this.isAttacking() || this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_() || this.f_19797_ - this.lastTurn < 50) {
            return 0.0;
        }
        Vec3 vecToTarget = this.m_5448_().m_20182_().m_82546_(this.m_20182_()).m_82541_();
        double dotProduct = vecToTarget.m_82526_(this.m_20154_());
        if (dotProduct > 0.25) {
            return 0.0;
        }
        double score = (1.0 - dotProduct) * 15.0;
        return score;
    }

    public double tryGlance() {
        if (this.isAttacking() || this.isAerial() || this.findNthHighestThreat(2) == null || !this.findNthHighestThreat(2).m_6084_() || this.f_19797_ - this.lastGlance < 200 || this.lastUsedAbility == Ability.TURN) {
            return 0.0;
        }
        LivingEntity target = this.findNthHighestThreat(2);
        Vec3 vecToTarget = target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
        double dotProduct = vecToTarget.m_82526_(this.m_20154_());
        if (dotProduct > 0.25) {
            return 0.0;
        }
        double score = 1.0;
        return score;
    }

    public double tryAirDash() {
        if (this.m_5448_() == null || !this.isAerial() || this.isAttacking() || this.f_19797_ - this.lastAirDash < 100 || !this.m_5448_().m_6084_() || this.lastUsedAbility == Ability.AIR_DASH) {
            return 0.0;
        }
        double score = 0.0;
        Vec3 vecToTarget = this.m_5448_().m_20182_().m_82546_(this.m_20182_()).m_82541_();
        double dotProduct = vecToTarget.m_82526_(this.m_20154_());
        if (dotProduct > 0.25) {
            return 0.0;
        }
        if (this.m_20238_(this.m_5448_().m_20182_()) > 1600.0) {
            return 0.0;
        }
        score = 5.0;
        return score;
    }

    public double tryAirTailSlam() {
        if (this.m_5448_() == null || !this.isAerial() || this.isAttacking() || this.f_19797_ - this.lastAirTailSlam < 250 || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        double score = 0.0;
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 5.0), 10.0, 10.0, 8.0);
        if (targetInZone) {
            score = 30.0;
        }
        return score;
    }

    public double tryHalt() {
        if (this.m_5448_() == null || this.isAttacking() || this.f_19797_ - this.lastHalt < 250 || !this.m_5448_().m_6084_() || this.lastUsedAbility == Ability.HALT || this.lastAbilityTick - this.f_19797_ > 100 || this.isEnraged()) {
            return 0.0;
        }
        double score = 30.0;
        return score;
    }

    public double tryFly() {
        if (this.m_5448_() == null || !this.m_20096_() || this.isAerial() || this.flightCooldown > 0 || this.isAttacking()) {
            return 0.0;
        }
        double score = 0.0;
        double horizontalDistanceSq = this.m_5448_().m_20275_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (horizontalDistanceSq > 1024.0) {
            score = 60.0 + (Math.sqrt(horizontalDistanceSq) - 32.0);
        }
        if (horizontalDistanceSq < 36.0 && this.ticksStuckClose > 80) {
            this.ticksStuckClose = 0;
            score = Math.max(score, 80.0);
        }
        return score;
    }

    public double tryOrbFly() {
        if (this.m_5448_() == null || !this.m_20096_() || this.isAerial() || this.isAttacking() || this.f_19797_ - this.lastOrbFly < 1000) {
            return 0.0;
        }
        double score = 0.0;
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 2.0), 6.0, 12.0, 6.0);
        if (targetInZone) {
            score = 30.0;
        }
        if (this.isTargetAttacking()) {
            score *= 2.0;
        }
        if (this.lastUsedAbility == Ability.AIR_TAIL_SLAM) {
            score *= 3.0;
        }
        return score;
    }

    public double tryLand() {
        double horizontalDistanceSq;
        boolean isUnderneath;
        if (this.m_5448_() == null || !this.isAerial() || this.landingCooldown > 0 || this.isAttacking()) {
            return 0.0;
        }
        if (this.ticksSpentFlying < 100 && !this.isEnraged()) {
            return 0.0;
        }
        double score = 0.0;
        if (this.ticksSpentFlying > 600) {
            score = 100.0;
        }
        boolean bl = isUnderneath = (horizontalDistanceSq = this.m_5448_().m_20275_(this.m_20185_(), this.m_20186_(), this.m_20189_())) < 16.0 && this.m_5448_().m_20186_() < this.m_20186_() - 4.0;
        if (isUnderneath) {
            score = Math.max(score, 70.0);
        }
        return score += (double)this.ticksSpentFlying / 20.0;
    }

    public BehaviorStatus startAerialAssault() {
        this.setCurrentAbility(Ability.AERIAL_ASSAULT);
        this.lastAerialAssault = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startTurn() {
        this.setCurrentAbility(Ability.TURN);
        this.lastTurn = this.f_19797_;
        this.turnTarget = this.m_5448_();
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startGlance() {
        this.setCurrentAbility(Ability.TURN);
        this.lastGlance = this.f_19797_;
        this.turnTarget = this.findNthHighestThreat(2);
        this.applyTemporaryThreat(this.findNthHighestThreat(2).m_20148_(), 1000.0f, 100);
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startAirDash() {
        this.setCurrentAbility(Ability.AIR_DASH);
        this.lastAirDash = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startAirTailSlam() {
        this.setCurrentAbility(Ability.AIR_TAIL_SLAM);
        this.lastAirTailSlam = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startHalt() {
        this.setCurrentAbility(Ability.HALT);
        this.lastHalt = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startOrbFly() {
        this.setCurrentAbility(Ability.ORB_FLY);
        this.lastOrbFly = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startSeismicRoar() {
        if (this.getCurrentAbility() == Ability.SEISMIC_ROAR) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.SEISMIC_ROAR);
        this.lastSeismicRoar = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startLand() {
        if (!this.isAerial()) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.LAND);
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startFly() {
        if (this.isAerial()) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.FLY);
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startAirOrb() {
        if (this.getCurrentAbility() == Ability.AIR_ORB) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.AIR_ORB);
        this.lastAirOrb = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startStuckAttack() {
        if (this.isStuckForLongerThan(10)) {
            if (!this.isEnraged()) {
                this.setWantsToEnrage(true);
            }
        } else if (this.isStuckForLongerThan(2)) {
            if (this.isAerial()) {
                this.setCurrentAbility(Ability.AIR_ORB);
                this.lastAirOrb = this.f_19797_;
                return BehaviorStatus.SUCCESS;
            }
            this.setCurrentAbility(Ability.GROUND_ORB);
            this.lastGroundOrb = this.f_19797_;
            return BehaviorStatus.SUCCESS;
        }
        return BehaviorStatus.FAILURE;
    }

    public BehaviorStatus startAirKick() {
        if (this.getCurrentAbility() == Ability.AIR_KICK) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.AIR_KICK);
        this.lastAirKick = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startAirClaw() {
        if (this.getCurrentAbility() == Ability.AIR_CLAW) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.AIR_CLAW);
        this.lastAirClaw = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startRush() {
        if (this.getCurrentAbility() == Ability.RUSH) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.RUSH);
        this.lastRush = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startAirBite() {
        if (this.getCurrentAbility() == Ability.AIR_BITE) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.AIR_BITE);
        this.lastAirBite = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startAirTailSwipe() {
        if (this.getCurrentAbility() == Ability.AIR_TAILSWIPE) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.AIR_TAILSWIPE);
        this.lastAirTailSwipe = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startLegStomp() {
        if (this.getCurrentAbility() == Ability.LEG_STOMP) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.LEG_STOMP);
        this.lastLegStomp = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startStomp() {
        this.setCurrentAbility(Ability.STOMP);
        this.lastStomp = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startCharge() {
        if (this.getChargeState() == ChargeState.SLAM.ordinal()) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.CHARGE);
        this.lastCharge = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startFrontBite() {
        if (this.getCurrentAbility() == Ability.FRONT_BITE) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.FRONT_BITE);
        this.lastFrontBite = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startTailSlam() {
        if (this.getCurrentAbility() == Ability.TAIL_SLAM) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.TAIL_SLAM);
        this.lastTailSlam = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startWingSlap() {
        if (this.getCurrentAbility() == Ability.WING_SLAP) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.WING_SLAP);
        this.lastWingSlap = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startRoar() {
        if (this.getCurrentAbility() == Ability.ROAR) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.ROAR);
        this.lastRoar = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startAirRoar() {
        if (this.getCurrentAbility() == Ability.AIR_ROAR) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.AIR_ROAR);
        this.lastAirRoar = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus startTailSwipe() {
        if (this.getCurrentAbility() == Ability.TAILSWIPE) {
            return BehaviorStatus.SUCCESS;
        }
        this.setCurrentAbility(Ability.TAILSWIPE);
        this.lastTailSwipe = this.f_19797_;
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus updateGroundMovement(LivingEntity target) {
        if (this.m_21824_() && this.getTamedStance() == AbstractLargeMonster.TamedStance.FOLLOWING) {
            return BehaviorStatus.FAILURE;
        }
        if (this.isAttacking()) {
            return BehaviorStatus.FAILURE;
        }
        if (target == null || !target.m_6084_()) {
            this.m_21573_().m_26573_();
            return BehaviorStatus.FAILURE;
        }
        if (this.m_20280_((Entity)target) <= 36.0) {
            this.m_21573_().m_26573_();
            return BehaviorStatus.SUCCESS;
        }
        if (this.pathUpdateCooldown <= 0) {
            this.pathUpdateCooldown = 25;
            Vec3 predictedPos = this.getPredictedTargetPosition(target, 10);
            BlockPos targetPos = BlockPos.m_274446_((Position)predictedPos);
            Path path = this.m_21573_().m_7864_(targetPos, 0);
            if (path != null && !path.m_77392_()) {
                this.m_21573_().m_26536_(path, 1.0);
            }
        }
        return this.m_21573_().m_26572_() ? BehaviorStatus.RUNNING : BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus updateGroundMovement() {
        return this.updateGroundMovement(this.m_5448_());
    }

    public BehaviorStatus updateAerialMovement(LivingEntity target) {
        double dynamicSpeed;
        double destinationZ;
        double destinationX;
        double dZ;
        if (this.m_21824_() && this.getTamedStance() == AbstractLargeMonster.TamedStance.FOLLOWING) {
            return BehaviorStatus.FAILURE;
        }
        double HOVER_ALTITUDE_ABOVE_TARGET = 2.0;
        double VERTICAL_TOLERANCE = 1.0;
        double MAX_ENGAGEMENT_DISTANCE_SQUARED = 64.0;
        boolean CHASE_DELAY_TICKS = false;
        int COAST_DURATION_TICKS = 15;
        double CHASE_SPEED = 1.2;
        double APPROACH_SPEED = 0.4;
        double HOVER_SPEED = 0.2;
        if (this.isAttacking()) {
            this.timeTargetOutOfRange = 0;
            this.timeInRange = 0;
            return BehaviorStatus.FAILURE;
        }
        if (target == null || !target.m_6084_()) {
            return BehaviorStatus.FAILURE;
        }
        Vec3 dragonPos = this.m_20182_();
        Vec3 targetPos = target.m_20182_();
        double dX = dragonPos.m_7096_() - targetPos.m_7096_();
        double horizontalDistanceSq = dX * dX + (dZ = dragonPos.m_7094_() - targetPos.m_7094_()) * dZ;
        if (horizontalDistanceSq > 64.0) {
            this.timeInRange = 0;
            ++this.timeTargetOutOfRange;
            if (this.timeTargetOutOfRange > 0) {
                destinationX = targetPos.m_7096_();
                destinationZ = targetPos.m_7094_();
                dynamicSpeed = 1.2;
            } else {
                destinationX = dragonPos.m_7096_();
                destinationZ = dragonPos.m_7094_();
                dynamicSpeed = 0.2;
            }
        } else {
            this.timeTargetOutOfRange = 0;
            ++this.timeInRange;
            float progress = (float)this.timeInRange / 15.0f;
            progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
            dynamicSpeed = Mth.m_14139_((double)progress, (double)0.4, (double)0.2);
            if (this.timeInRange < 15) {
                destinationX = targetPos.m_7096_();
                destinationZ = targetPos.m_7094_();
            } else {
                destinationX = dragonPos.m_7096_();
                destinationZ = dragonPos.m_7094_();
            }
        }
        double idealAltitude = targetPos.m_7098_() + 2.0;
        double destinationY = Math.abs(dragonPos.m_7098_() - idealAltitude) > 1.0 ? idealAltitude : dragonPos.m_7098_();
        Vec3 finalDestination = new Vec3(destinationX, destinationY, destinationZ);
        this.m_21566_().m_6849_(finalDestination.f_82479_, finalDestination.f_82480_, finalDestination.f_82481_, dynamicSpeed);
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus updateAerialMovement() {
        return this.updateAerialMovement(this.m_5448_());
    }

    @Override
    protected void registerServerAnimations() {
        this.animationPlayer.registerAnimation("walk", SkrytheServerAnimations.walk);
        this.animationPlayer.registerAnimation("front_bite", SkrytheServerAnimations.front_bite);
        this.animationPlayer.registerAnimation("start_flying", SkrytheServerAnimations.start_flying);
        this.animationPlayer.registerAnimation("stop_flying", SkrytheServerAnimations.stop_flying);
        this.animationPlayer.registerAnimation("hover_to_flying", SkrytheServerAnimations.hover_to_flying);
        this.animationPlayer.registerAnimation("flying_to_hover", SkrytheServerAnimations.flying_to_hover);
        this.animationPlayer.registerAnimation("tailswipe", SkrytheServerAnimations.tailswipe);
        this.animationPlayer.registerAnimation("roar", SkrytheServerAnimations.roar);
        this.animationPlayer.registerAnimation("air_tailswipe", SkrytheServerAnimations.air_tailswipe);
        this.animationPlayer.registerAnimation("air_bite", SkrytheServerAnimations.air_bite);
        this.animationPlayer.registerAnimation("air_roar", SkrytheServerAnimations.air_roar);
        this.animationPlayer.registerAnimation("rush", SkrytheServerAnimations.rush);
        this.animationPlayer.registerAnimation("enraged_rush_base", SkrytheServerAnimations.enraged_rush_base);
        this.animationPlayer.registerAnimation("tail_slam", SkrytheServerAnimations.tail_slam);
        this.animationPlayer.registerAnimation("charge", SkrytheServerAnimations.charge);
        this.animationPlayer.registerAnimation("charge_start", SkrytheServerAnimations.charge_start);
        this.animationPlayer.registerAnimation("charge_end", SkrytheServerAnimations.charge_end);
        this.animationPlayer.registerAnimation("stomp", SkrytheServerAnimations.stomp);
        this.animationPlayer.registerAnimation("stomp_start", SkrytheServerAnimations.stomp_start);
        this.animationPlayer.registerAnimation("stomp_end", SkrytheServerAnimations.stomp_end);
        this.animationPlayer.registerAnimation("air_enrage", SkrytheServerAnimations.air_enrage);
        this.animationPlayer.registerAnimation("ground_enrage", SkrytheServerAnimations.ground_enrage);
        this.animationPlayer.registerAnimation("leg_stomp", SkrytheServerAnimations.leg_stomp);
        this.animationPlayer.registerAnimation("wing_slap", SkrytheServerAnimations.wing_slap);
        this.animationPlayer.registerAnimation("enraged_front_bite_base", SkrytheServerAnimations.enraged_front_bite_base);
        this.animationPlayer.registerAnimation("enraged_front_bite_success", SkrytheServerAnimations.enraged_front_bite_success);
        this.animationPlayer.registerAnimation("enraged_front_bite_fail", SkrytheServerAnimations.enraged_front_bite_fail);
        this.animationPlayer.registerAnimation("enraged_rush_slide", SkrytheServerAnimations.enraged_rush_slide);
        this.animationPlayer.registerAnimation("enraged_rush_turn", SkrytheServerAnimations.enraged_rush_turn);
        this.animationPlayer.registerAnimation("enraged_rush_rerush", SkrytheServerAnimations.enraged_rush_rerush);
        this.animationPlayer.registerAnimation("enraged_rush_end", SkrytheServerAnimations.enraged_rush_end);
        this.animationPlayer.registerAnimation("air_kick", SkrytheServerAnimations.air_kick);
        this.animationPlayer.registerAnimation("air_orb", SkrytheServerAnimations.air_orb);
        this.animationPlayer.registerAnimation("enraged_air_orb", SkrytheServerAnimations.enraged_air_orb);
        this.animationPlayer.registerAnimation("ground_orb", SkrytheServerAnimations.ground_orb);
        this.animationPlayer.registerAnimation("aerial_assault_rise", SkrytheServerAnimations.aerial_assault_rise);
        this.animationPlayer.registerAnimation("aerial_assault_transition", SkrytheServerAnimations.aerial_assault_transition);
        this.animationPlayer.registerAnimation("aerial_assault_dive", SkrytheServerAnimations.aerial_assault_dive);
        this.animationPlayer.registerAnimation("aerial_assault_crash", SkrytheServerAnimations.aerial_assault_crash);
        this.animationPlayer.registerAnimation("seismic_roar", SkrytheServerAnimations.seismic_roar);
        this.animationPlayer.registerAnimation("ground_stagger", SkrytheServerAnimations.ground_stagger);
        this.animationPlayer.registerAnimation("ground_stagger", SkrytheServerAnimations.ground_stagger);
        this.animationPlayer.registerAnimation("air_stagger", SkrytheServerAnimations.air_stagger);
        this.animationPlayer.registerAnimation("ground_topple", SkrytheServerAnimations.ground_topple);
        this.animationPlayer.registerAnimation("air_topple_fall", SkrytheServerAnimations.air_topple_fall);
        this.animationPlayer.registerAnimation("air_topple_crash", SkrytheServerAnimations.air_topple_crash);
        this.animationPlayer.registerAnimation("air_topple_start", SkrytheServerAnimations.air_topple_start);
        this.animationPlayer.registerAnimation("turn_left", SkrytheServerAnimations.turn_left);
        this.animationPlayer.registerAnimation("turn_right", SkrytheServerAnimations.turn_right);
        this.animationPlayer.registerAnimation("sit", SkrytheServerAnimations.sit);
        this.animationPlayer.registerAnimation("start_sit", SkrytheServerAnimations.start_sit);
        this.animationPlayer.registerAnimation("end_sit", SkrytheServerAnimations.end_sit);
        this.animationPlayer.registerAnimation("flapping", SkrytheServerAnimations.flapping);
        this.animationPlayer.registerAnimation("fly", SkrytheServerAnimations.fly);
        this.animationPlayer.registerAnimation("hover", SkrytheServerAnimations.hover);
        this.animationPlayer.registerAnimation("ground_tail_cut", SkrytheServerAnimations.ground_tail_cut);
        this.animationPlayer.registerAnimation("air_tail_cut_start", SkrytheServerAnimations.air_tail_cut_start);
        this.animationPlayer.registerAnimation("air_tail_cut_fall", SkrytheServerAnimations.air_tail_cut_fall);
        this.animationPlayer.registerAnimation("air_tail_cut_crash", SkrytheServerAnimations.air_tail_cut_crash);
        this.animationPlayer.registerAnimation("ground_right_wing_break", SkrytheServerAnimations.ground_right_wing_break);
        this.animationPlayer.registerAnimation("ground_left_wing_break", SkrytheServerAnimations.ground_left_wing_break);
        this.animationPlayer.registerAnimation("air_right_wing_break", SkrytheServerAnimations.air_right_wing_break);
        this.animationPlayer.registerAnimation("air_left_wing_break", SkrytheServerAnimations.air_left_wing_break);
        this.animationPlayer.registerAnimation("orb_fly", SkrytheServerAnimations.orb_fly);
        this.animationPlayer.registerAnimation("air_dash_turn_right", SkrytheServerAnimations.air_dash_turn_right);
        this.animationPlayer.registerAnimation("air_dash_turn_left", SkrytheServerAnimations.air_dash_turn_left);
        this.animationPlayer.registerAnimation("air_dash_move", SkrytheServerAnimations.air_dash_move);
        this.animationPlayer.registerAnimation("air_dash_stop_right", SkrytheServerAnimations.air_dash_stop_right);
        this.animationPlayer.registerAnimation("air_dash_stop_left", SkrytheServerAnimations.air_dash_stop_left);
        this.animationPlayer.registerAnimation("air_claw", SkrytheServerAnimations.air_claw);
        this.animationPlayer.registerAnimation("air_halt", SkrytheServerAnimations.air_halt);
        this.animationPlayer.registerAnimation("ground_halt", SkrytheServerAnimations.ground_halt);
        this.animationPlayer.registerAnimation("air_tail_slam", SkrytheServerAnimations.air_tail_slam);
        this.animationPlayer.registerAnimation("start_fly_fail", SkrytheServerAnimations.start_fly_fail);
    }

    private void updateServerWalk() {
    }

    @Override
    protected String getBoneNameForPart(LargeMonsterPartEntity<?> part) {
        if (part == this.head) {
            return "head";
        }
        if (part == this.right_wing1) {
            return "right_wing_anchor";
        }
        if (part == this.right_wing2) {
            return "right_wing2";
        }
        if (part == this.left_wing1) {
            return "left_wing_anchor";
        }
        if (part == this.left_wing2) {
            return "left_wing2";
        }
        if (part == this.tail) {
            return "left_toes";
        }
        if (part == this.tail1) {
            return "tail1";
        }
        if (part == this.tail2) {
            return "tail2";
        }
        if (part == this.tail3) {
            return "tail3";
        }
        if (part == this.tail4) {
            return "tail4";
        }
        if (part == this.tail5) {
            return "tail5";
        }
        if (part == this.tail6) {
            return "tail6";
        }
        if (part == this.tail7) {
            return "tail7";
        }
        return null;
    }

    @Override
    protected Map<String, String> getBoneHierarchy() {
        return SKRYTHE_HIERARCHY;
    }

    @Override
    protected Map<String, Vec3> getDefaultOffsets() {
        return SKRYTHE_DEFAULT_OFFSETS;
    }

    @Override
    protected Map<String, Vec3> getDefaultRotations() {
        return SKRYTHE_DEFAULT_ROTATIONS;
    }

    private boolean isTailPart(SkrythePartEntity part) {
        return part == this.tail || part == this.tail1 || part == this.tail2 || part == this.tail3 || part == this.tail4 || part == this.tail5 || part == this.tail6 || part == this.tail7;
    }

    private boolean isRightWingPart(SkrythePartEntity part) {
        return part == this.right_wing1 || part == this.right_wing2;
    }

    private boolean isLeftWingPart(SkrythePartEntity part) {
        return part == this.left_wing1 || part == this.left_wing2;
    }

    @Override
    protected void setupAnimationStates() {
        this.idleAnimation();
        this.sitAnimation();
        this.startFlyingAnimation();
        this.stopFlyingAnimation();
        this.flappingAnimation();
        this.flyingAnimation();
        this.hoveringAnimation();
        this.roaringAnimation();
        this.tailswipeAnimation();
        this.airTailSwipeAnimation();
        this.airBiteAnimation();
        this.airRoarAnimation();
        this.airKickAnimation();
        this.biteAnimation();
        this.kickAnimation();
        this.chargeAnimation();
        this.stompAnimation();
        this.enrageAnimation();
        this.rushAnimation();
        this.orbAnimation();
        this.aerialAssaultAnimation();
        this.seismicRoarAnimation();
        this.staggerAnimation();
        this.toppleAnimation();
        this.turnAnimation();
        this.deathAnimation();
        this.tailCutAnimation();
        this.wingBreakAnimation();
        this.airDashAnimation();
        this.airClawAnimation();
        this.haltAnimation();
        this.airTailSlamAnimation();
    }

    private void idleAnimation() {
        if (!this.idleAnimation.m_216984_() && !this.isFlying()) {
            this.idleAnimation.m_216977_(this.f_19797_);
            this.animationPlayer.playAnimation("idle", 1.0f);
        } else {
            this.animationPlayer.stopAnimation("idle");
        }
    }

    private void airDashAnimation() {
        if (this.getCurrentAbility() == Ability.AIR_DASH && this.getAirDashState() == AirDashState.TURN_LEFT.ordinal()) {
            if (!this.airDashTurnLeftAnimation.m_216984_()) {
                this.airDashTurnLeftAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_dash_turn_left", 1.0f);
            }
        } else {
            this.airDashTurnLeftAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_dash_turn_left");
        }
        if (this.getCurrentAbility() == Ability.AIR_DASH && this.getAirDashState() == AirDashState.TURN_RIGHT.ordinal()) {
            if (!this.airDashTurnRightAnimation.m_216984_()) {
                this.airDashTurnRightAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_dash_turn_right", 1.0f);
            }
        } else {
            this.airDashTurnRightAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_dash_turn_right");
        }
        if (this.getCurrentAbility() == Ability.AIR_DASH && this.getAirDashState() == AirDashState.MOVE.ordinal()) {
            if (!this.airDashMoveAnimation.m_216984_()) {
                this.airDashMoveAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_dash_move", 1.0f);
            }
        } else {
            this.airDashMoveAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_dash_move");
        }
        if (this.getCurrentAbility() == Ability.AIR_DASH && this.getAirDashState() == AirDashState.STOP_LEFT.ordinal()) {
            if (!this.airDashStopLeftAnimation.m_216984_()) {
                this.airDashStopLeftAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_dash_stop_left", 1.0f);
            }
        } else {
            this.airDashStopLeftAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_dash_stop_left");
        }
        if (this.getCurrentAbility() == Ability.AIR_DASH && this.getAirDashState() == AirDashState.STOP_RIGHT.ordinal()) {
            if (!this.airDashStopRightAnimation.m_216984_()) {
                this.airDashStopRightAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_dash_stop_right", 1.0f);
            }
        } else {
            this.airDashStopRightAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_dash_stop_right");
        }
    }

    private void airClawAnimation() {
        if (this.getCurrentAbility() == Ability.AIR_CLAW) {
            if (!this.airClawAnimation.m_216984_()) {
                this.airClawAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_claw", 1.0f);
            }
        } else {
            this.airClawAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_claw");
        }
    }

    private void airTailSlamAnimation() {
        if (this.getCurrentAbility() == Ability.AIR_TAIL_SLAM) {
            if (!this.airTailSlamAnimation.m_216984_()) {
                this.airTailSlamAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_tail_slam", 0.8f);
            }
        } else {
            this.airTailSlamAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_tail_slam");
        }
    }

    private void haltAnimation() {
        if (this.getCurrentAbility() == Ability.HALT && !this.isAerial()) {
            if (!this.groundHaltAnimation.m_216984_()) {
                this.groundHaltAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("ground_halt", 1.2f);
            }
        } else {
            this.groundHaltAnimation.m_216973_();
            this.animationPlayer.stopAnimation("ground_halt");
        }
        if (this.getCurrentAbility() == Ability.HALT && this.isAerial()) {
            if (!this.airHaltAnimation.m_216984_()) {
                this.airHaltAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_halt", 1.0f);
            }
        } else {
            this.airHaltAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_halt");
        }
    }

    private void deathAnimation() {
        if (this.getCurrentAbility() == Ability.DEATH) {
            if (!this.deathAnimation.m_216984_()) {
                this.deathAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.deathAnimation.m_216973_();
        }
    }

    private void sitAnimation() {
        boolean canSit;
        boolean bl = canSit = this.getTamedStance() == AbstractLargeMonster.TamedStance.SITTING && !this.isAerial() && !this.isAttacking() && !this.m_20160_() && this.getCurrentAbility() != Ability.STAGGER;
        if (canSit) {
            if (!this.sitStartAnimation.m_216984_()) {
                this.sitStartAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("start_sit", 1.0f);
            } else if (!this.animationPlayer.isPlaying("start_sit")) {
                this.animationPlayer.playAnimation("sit", 1.0f);
            }
        } else if (this.isAerial() || this.isAttacking() || this.m_20160_()) {
            this.sitStartAnimation.m_216973_();
            this.sitEndAnimation.m_216973_();
            this.animationPlayer.stopAnimation("start_sit");
            this.animationPlayer.stopAnimation("end_sit");
            this.animationPlayer.stopAnimation("sit");
        } else if (this.sitStartAnimation.m_216984_() && this.getTamedStance() != AbstractLargeMonster.TamedStance.SITTING && !this.sitEndAnimation.m_216984_() && this.getCurrentAbility() != Ability.STAGGER) {
            this.sitStartAnimation.m_216973_();
            this.sitEndAnimation.m_216977_(this.f_19797_);
            this.animationPlayer.stopAnimation("start_sit");
            this.animationPlayer.playAnimation("end_sit", 1.0f);
            this.animationPlayer.stopAnimation("sit");
        } else if (this.sitEndAnimation.m_216981_() > 2000L) {
            this.sitStartAnimation.m_216973_();
            this.sitEndAnimation.m_216973_();
            this.animationPlayer.stopAnimation("start_sit");
            this.animationPlayer.stopAnimation("end_sit");
            this.animationPlayer.stopAnimation("sit");
        } else {
            this.sitStartAnimation.m_216973_();
            this.animationPlayer.stopAnimation("start_sit");
            this.animationPlayer.stopAnimation("sit");
        }
    }

    private void staggerAnimation() {
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.STAGGER && !this.isAerial()) {
            if (!this.groundStaggerAnimation.m_216984_()) {
                this.groundStaggerAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("ground_stagger", 0.8f);
            }
        } else {
            this.groundStaggerAnimation.m_216973_();
            this.animationPlayer.stopAnimation("ground_stagger");
        }
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.STAGGER && this.isAerial()) {
            if (!this.airStaggerAnimation.m_216984_()) {
                this.airStaggerAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_stagger", 0.8f);
            }
        } else {
            this.airStaggerAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_stagger");
        }
    }

    private void toppleAnimation() {
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.TOPPLE && !this.isAerial()) {
            if (!this.groundToppleAnimation.m_216984_()) {
                this.groundToppleAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("ground_topple", 0.8f);
            }
        } else {
            this.groundToppleAnimation.m_216973_();
            this.animationPlayer.stopAnimation("ground_topple");
        }
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.TOPPLE && this.isAerial() && this.getAirToppleState() == AirToppleState.START.ordinal()) {
            if (!this.airToppleStartAnimation.m_216984_()) {
                this.airToppleStartAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_topple_start", 1.0f);
            }
        } else {
            this.airToppleStartAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_topple_start");
        }
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.TOPPLE && this.isAerial() && this.getAirToppleState() == AirToppleState.FALL.ordinal()) {
            if (!this.airToppleFallAnimation.m_216984_()) {
                this.airToppleFallAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_topple_fall", 1.0f);
            }
        } else {
            this.airToppleFallAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_topple_fall");
        }
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.TOPPLE && this.isAerial() && this.getAirToppleState() == AirToppleState.CRASH.ordinal()) {
            if (!this.airToppleCrashAnimation.m_216984_()) {
                this.airToppleCrashAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_topple_crash", 0.8f);
            }
        } else {
            this.airToppleCrashAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_topple_crash");
        }
    }

    private void tailCutAnimation() {
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.TAIL_CUT && !this.isAerial()) {
            if (!this.groundTailCutAnimation.m_216984_()) {
                this.groundTailCutAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("ground_tail_cut", 1.0f);
            }
        } else {
            this.groundTailCutAnimation.m_216973_();
            this.animationPlayer.stopAnimation("ground_tail_cut");
        }
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.TAIL_CUT && this.isAerial() && this.getAirTailCutState() == AirTailCutState.START.ordinal()) {
            if (!this.airTailCutStartAnimation.m_216984_()) {
                this.airTailCutStartAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_tail_cut_start", 1.0f);
            }
        } else {
            this.airTailCutStartAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_tail_cut_start");
        }
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.TAIL_CUT && this.isAerial() && this.getAirTailCutState() == AirTailCutState.FALL.ordinal()) {
            if (!this.airTailCutFallAnimation.m_216984_()) {
                this.airTailCutFallAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_tail_cut_fall", 1.0f);
            }
        } else {
            this.airTailCutFallAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_tail_cut_fall");
        }
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.TAIL_CUT && this.isAerial() && this.getAirTailCutState() == AirTailCutState.CRASH.ordinal()) {
            if (!this.airTailCutCrashAnimation.m_216984_()) {
                this.airTailCutCrashAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_tail_cut_crash", 1.0f);
            }
        } else {
            this.airTailCutCrashAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_tail_cut_crash");
        }
    }

    private void wingBreakAnimation() {
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.RIGHT_WING_BREAK && !this.isAerial()) {
            if (!this.groundRightWingBreakAnimation.m_216984_()) {
                this.groundRightWingBreakAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("ground_right_wing_break", 0.8f);
            }
        } else {
            this.groundRightWingBreakAnimation.m_216973_();
            this.animationPlayer.stopAnimation("ground_right_wing_break");
        }
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.RIGHT_WING_BREAK && this.isAerial()) {
            if (!this.airRightWingBreakAnimation.m_216984_()) {
                this.airRightWingBreakAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_right_wing_break", 0.8f);
            }
        } else {
            this.airRightWingBreakAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_right_wing_break");
        }
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.LEFT_WING_BREAK && !this.isAerial()) {
            if (!this.groundLeftWingBreakAnimation.m_216984_()) {
                this.groundLeftWingBreakAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("ground_left_wing_break", 0.8f);
            }
        } else {
            this.groundLeftWingBreakAnimation.m_216973_();
            this.animationPlayer.stopAnimation("ground_left_wing_break");
        }
        if (this.getCurrentAbility() == Ability.STAGGER && this.getCurrentStaggerState() == StaggerState.LEFT_WING_BREAK && this.isAerial()) {
            if (!this.airLeftWingBreakAnimation.m_216984_()) {
                this.airLeftWingBreakAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_left_wing_break", 0.8f);
            }
        } else {
            this.airLeftWingBreakAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_left_wing_break");
        }
    }

    private void turnAnimation() {
        if (this.getCurrentAbility() == Ability.TURN && this.getTurnState() == TurnState.RIGHT.ordinal()) {
            if (!this.turnRightAnimation.m_216984_()) {
                this.turnRightAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("turn_right", 1.0f);
            }
        } else {
            this.turnRightAnimation.m_216973_();
            this.animationPlayer.stopAnimation("turn_right");
        }
        if (this.getCurrentAbility() == Ability.TURN && this.getTurnState() == TurnState.LEFT.ordinal()) {
            if (!this.turnLeftAnimation.m_216984_()) {
                this.turnLeftAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("turn_left", 1.0f);
            }
        } else {
            this.turnLeftAnimation.m_216973_();
            this.animationPlayer.stopAnimation("turn_left");
        }
    }

    private void biteAnimation() {
        if (this.getCurrentAbility() == Ability.WING_SLAP) {
            if (!this.wingSlapAnimation.m_216984_()) {
                this.wingSlapAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("wing_slap", 1.0f);
            }
        } else {
            this.wingSlapAnimation.m_216973_();
            this.animationPlayer.stopAnimation("wing_slap");
        }
        if (this.getCurrentAbility() == Ability.FRONT_BITE) {
            if (!this.frontBiteAnimation.m_216984_()) {
                this.frontBiteAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("front_bite", 1.0f);
            }
        } else {
            this.frontBiteAnimation.m_216973_();
            this.animationPlayer.stopAnimation("front_bite");
        }
        if (this.getCurrentAbility() == Ability.FRONT_BITE && this.isAbilityEnraged() && this.getEnragedFrontBiteState() == EnragedFrontBiteState.SUCCESS.ordinal()) {
            if (!this.enragedFrontBiteSuccessAnimation.m_216984_()) {
                this.enragedFrontBiteSuccessAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("enraged_front_bite_success", 1.0f);
            }
        } else {
            this.enragedFrontBiteSuccessAnimation.m_216973_();
            this.animationPlayer.stopAnimation("enraged_front_bite_success");
        }
        if (this.getCurrentAbility() == Ability.FRONT_BITE && this.isAbilityEnraged() && this.getEnragedFrontBiteState() == EnragedFrontBiteState.FAIL.ordinal()) {
            if (!this.enragedFrontBiteFailAnimation.m_216984_()) {
                this.enragedFrontBiteFailAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("enraged_front_bite_fail", 1.0f);
            }
        } else {
            this.enragedFrontBiteFailAnimation.m_216973_();
            this.animationPlayer.stopAnimation("enraged_front_bite_fail");
        }
        if (this.getCurrentAbility() == Ability.FRONT_BITE && this.isAbilityEnraged() && this.getEnragedFrontBiteState() == EnragedFrontBiteState.BASE.ordinal()) {
            if (!this.enragedFrontBiteBaseAnimation.m_216984_()) {
                this.enragedFrontBiteBaseAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("enraged_front_bite_base", 1.0f);
            }
        } else {
            this.enragedFrontBiteBaseAnimation.m_216973_();
            this.animationPlayer.stopAnimation("enraged_front_bite_base");
        }
    }

    private void startFlyingAnimation() {
        if (this.getCurrentAbility() == Ability.FLY && this.getFlyState() == FlyState.SUCCESS.ordinal()) {
            if (!this.startFlyingAnimation.m_216984_()) {
                this.startFlyingAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("start_flying", 1.0f);
            }
        } else {
            this.startFlyingAnimation.m_216973_();
            this.animationPlayer.stopAnimation("start_flying");
        }
        if (this.getCurrentAbility() == Ability.FLY && this.getFlyState() == FlyState.FAIL.ordinal()) {
            if (!this.startFlyFailAnimation.m_216984_()) {
                this.startFlyFailAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("start_fly_fail", 0.8f);
            }
        } else {
            this.startFlyFailAnimation.m_216973_();
            this.animationPlayer.stopAnimation("start_fly_fail");
        }
    }

    private void stopFlyingAnimation() {
        if (this.getLandState() == LandState.LAND.ordinal()) {
            if (!this.stopFlyingAnimation.m_216984_()) {
                this.stopFlyingAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("stop_flying", 1.0f);
            }
        } else {
            this.stopFlyingAnimation.m_216973_();
            this.animationPlayer.stopAnimation("stop_flying");
        }
    }

    private void flyingAnimation() {
        boolean shouldFly;
        boolean bl = shouldFly = this.isFlying() && !this.isHovering() && !this.isAttacking() && this.isAerial();
        if (shouldFly) {
            if (!this.flyAnimation.m_216984_()) {
                this.flyAnimation.m_216977_(this.f_19797_);
                if (this.wasHoveringLastTick) {
                    this.hoverToFlyingAnimation.m_216977_(this.f_19797_);
                    this.animationPlayer.playAnimation("hover_to_flying", 1.0f);
                }
            }
        } else {
            this.flyAnimation.m_216973_();
            this.animationPlayer.stopAnimation("hover_to_flying");
        }
        this.wasHoveringLastTick = this.isHovering();
    }

    private void hoveringAnimation() {
        boolean shouldHover;
        boolean bl = shouldHover = !this.isFlying() && this.isHovering() && !this.isAttacking() && this.isAerial() || this.getCurrentAbility() == Ability.AIR_DASH && this.getAirDashState() == AirDashState.NONE.ordinal();
        if (shouldHover) {
            if (!this.hoverAnimation.m_216984_()) {
                this.hoverAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("hover", 1.0f);
                if (this.wasFlyingLastTick) {
                    this.flyingToHoverAnimation.m_216977_(this.f_19797_);
                    this.animationPlayer.playAnimation("flying_to_hover", 1.0f);
                }
            }
        } else {
            this.hoverAnimation.m_216973_();
            this.animationPlayer.stopAnimation("hover");
            this.animationPlayer.stopAnimation("flying_to_hover");
        }
        this.wasFlyingLastTick = this.isFlying();
    }

    private void flappingAnimation() {
        if (this.isAerial() && (!this.isAttacking() || this.getCurrentAbility() == Ability.AIR_DASH && this.getAirDashState() == AirDashState.NONE.ordinal())) {
            if (!this.flappingAnimation.m_216984_()) {
                this.flappingAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("flapping", 1.5f);
            }
        } else {
            this.flappingAnimation.m_216973_();
            this.animationPlayer.stopAnimation("flapping");
        }
    }

    private void roaringAnimation() {
        if (this.getCurrentAbility() == Ability.ROAR) {
            if (!this.roarAnimation.m_216984_()) {
                this.roarAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("roar", 1.0f);
            }
        } else {
            this.roarAnimation.m_216973_();
            this.animationPlayer.stopAnimation("roar");
        }
    }

    private void tailswipeAnimation() {
        if (this.getCurrentAbility() == Ability.TAILSWIPE) {
            if (!this.tailswipeAnimation.m_216984_()) {
                this.tailswipeAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("tailswipe", 1.0f);
            }
        } else {
            this.tailswipeAnimation.m_216973_();
            this.animationPlayer.stopAnimation("tailswipe");
        }
    }

    private void airTailSwipeAnimation() {
        if (this.getCurrentAbility() == Ability.AIR_TAILSWIPE) {
            if (!this.airTailswipeAnimation.m_216984_()) {
                this.airTailswipeAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_tailswipe", 1.0f);
            }
        } else {
            this.airTailswipeAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_tailswipe");
        }
    }

    private void airRoarAnimation() {
        if (this.getCurrentAbility() == Ability.AIR_ROAR) {
            if (!this.airRoarAnimation.m_216984_()) {
                this.airRoarAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_roar", 1.0f);
            }
        } else {
            this.airRoarAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_roar");
        }
    }

    private void kickAnimation() {
        if (this.getCurrentAbility() == Ability.TAIL_SLAM) {
            if (!this.tailSlamAnimation.m_216984_()) {
                this.tailSlamAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("tail_slam", 1.0f);
            }
        } else {
            this.tailSlamAnimation.m_216973_();
            this.animationPlayer.stopAnimation("tail_slam");
        }
    }

    private void chargeAnimation() {
        if (this.getChargeState() == ChargeState.CHARGING.ordinal()) {
            if (!this.chargeAnimation.m_216984_()) {
                this.chargeAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("charge", 1.2f);
            }
        } else {
            this.chargeAnimation.m_216973_();
            this.animationPlayer.stopAnimation("charge");
        }
        if (this.getChargeState() == ChargeState.STARTUP.ordinal()) {
            if (!this.chargeStartAnimation.m_216984_()) {
                this.chargeStartAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("charge_start", 1.0f);
            }
        } else {
            this.chargeStartAnimation.m_216973_();
            this.animationPlayer.stopAnimation("charge_start");
        }
        if (this.getChargeState() == ChargeState.SLAM.ordinal()) {
            if (!this.chargeEndAnimation.m_216984_()) {
                this.chargeEndAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("charge_end", 1.0f);
            }
        } else {
            this.chargeEndAnimation.m_216973_();
            this.animationPlayer.stopAnimation("charge_end");
        }
    }

    private void stompAnimation() {
        if (this.getStompState() == StompState.AIRBORNE.ordinal()) {
            if (!this.stompAnimation.m_216984_()) {
                this.stompAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("stomp", 1.0f);
            }
        } else {
            this.stompAnimation.m_216973_();
            this.animationPlayer.stopAnimation("stomp");
        }
        if (this.getStompState() == StompState.STARTUP.ordinal()) {
            if (!this.stompStartAnimation.m_216984_()) {
                this.stompStartAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("stomp_start", 1.0f);
            }
        } else {
            this.stompStartAnimation.m_216973_();
            this.animationPlayer.stopAnimation("stomp_start");
        }
        if (this.getStompState() == StompState.SLAM.ordinal()) {
            if (!this.stompEndAnimation.m_216984_()) {
                this.stompEndAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("stomp_end", 1.0f);
            }
        } else {
            this.stompEndAnimation.m_216973_();
            this.animationPlayer.stopAnimation("stomp_end");
        }
        if (this.getCurrentAbility() == Ability.LEG_STOMP) {
            if (!this.legStompAnimation.m_216984_()) {
                this.legStompAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("leg_stomp", 1.3f);
            }
        } else {
            this.legStompAnimation.m_216973_();
            this.animationPlayer.stopAnimation("leg_stomp");
        }
    }

    private void airBiteAnimation() {
        if (this.getCurrentAbility() == Ability.AIR_BITE) {
            if (!this.airBiteAnimation.m_216984_()) {
                this.airBiteAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_bite", 1.0f);
            }
        } else {
            this.airBiteAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_bite");
        }
    }

    private void enrageAnimation() {
        if (this.getCurrentAbility() == Ability.ENRAGE && this.isAerial()) {
            if (!this.airEnrageAnimation.m_216984_()) {
                this.airEnrageAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_enrage", 0.8f);
            }
        } else {
            this.airEnrageAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_enrage");
        }
        if (this.getCurrentAbility() == Ability.ENRAGE && !this.isAerial()) {
            if (!this.groundEnrageAnimation.m_216984_()) {
                this.groundEnrageAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("ground_enrage", 0.8f);
            }
        } else {
            this.groundEnrageAnimation.m_216973_();
            this.animationPlayer.stopAnimation("ground_enrage");
        }
    }

    private void rushAnimation() {
        if (this.getCurrentAbility() == Ability.RUSH && !this.isAbilityEnraged()) {
            if (!this.rushAnimation.m_216984_()) {
                this.rushAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("rush", 0.8f);
            }
        } else {
            this.rushAnimation.m_216973_();
            this.animationPlayer.stopAnimation("rush");
        }
        if (this.getCurrentAbility() == Ability.RUSH && this.isAbilityEnraged() && this.getEnragedRushState() == EnragedRushState.BASE.ordinal()) {
            if (!this.enragedRushBaseAnimation.m_216984_()) {
                this.enragedRushBaseAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("enraged_rush_base", 0.8f);
            }
        } else {
            this.enragedRushBaseAnimation.m_216973_();
            this.animationPlayer.stopAnimation("enraged_rush_base");
        }
        if (this.getCurrentAbility() == Ability.RUSH && this.isAbilityEnraged() && this.getEnragedRushState() == EnragedRushState.SLIDE.ordinal()) {
            if (!this.enragedRushSlideAnimation.m_216984_()) {
                this.enragedRushSlideAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("enraged_rush_slide", 1.0f);
            }
        } else {
            this.enragedRushSlideAnimation.m_216973_();
            this.animationPlayer.stopAnimation("enraged_rush_slide");
        }
        if (this.getCurrentAbility() == Ability.RUSH && this.isAbilityEnraged() && this.getEnragedRushState() == EnragedRushState.TURN.ordinal()) {
            if (!this.enragedRushTurnAnimation.m_216984_()) {
                this.enragedRushTurnAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("enraged_rush_turn", 1.0f);
            }
        } else {
            this.enragedRushTurnAnimation.m_216973_();
            this.animationPlayer.stopAnimation("enraged_rush_turn");
        }
        if (this.getCurrentAbility() == Ability.RUSH && this.isAbilityEnraged() && this.getEnragedRushState() == EnragedRushState.RE_RUSH.ordinal()) {
            if (!this.enragedRushReRushAnimation.m_216984_()) {
                this.enragedRushReRushAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("enraged_rush_rerush", 1.0f);
            }
        } else {
            this.enragedRushReRushAnimation.m_216973_();
            this.animationPlayer.stopAnimation("enraged_rush_rerush");
        }
        if (this.getCurrentAbility() == Ability.RUSH && this.isAbilityEnraged() && this.getEnragedRushState() == EnragedRushState.END.ordinal()) {
            if (!this.enragedRushEndAnimation.m_216984_()) {
                this.enragedRushEndAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("enraged_rush_end", 1.0f);
            }
        } else {
            this.enragedRushEndAnimation.m_216973_();
            this.animationPlayer.stopAnimation("enraged_rush_end");
        }
    }

    private void airKickAnimation() {
        if (this.getCurrentAbility() == Ability.AIR_KICK) {
            if (!this.airKickAnimation.m_216984_()) {
                this.airKickAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_kick", 0.8f);
            }
        } else {
            this.airKickAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_kick");
        }
    }

    private void orbAnimation() {
        if (this.getCurrentAbility() == Ability.AIR_ORB && !this.isAbilityEnraged()) {
            if (!this.airOrbAnimation.m_216984_()) {
                this.airOrbAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_orb", 0.8f);
            }
        } else {
            this.airOrbAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_orb");
        }
        if (this.getCurrentAbility() == Ability.AIR_ORB && this.isAbilityEnraged()) {
            if (!this.enragedAirOrbAnimation.m_216984_()) {
                this.enragedAirOrbAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("enraged_air_orb", 0.8f);
            }
        } else {
            this.enragedAirOrbAnimation.m_216973_();
            this.animationPlayer.stopAnimation("enraged_air_orb");
        }
        if (this.getCurrentAbility() == Ability.GROUND_ORB) {
            if (!this.groundOrbAnimation.m_216984_()) {
                this.groundOrbAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("ground_orb", 0.8f);
            }
        } else {
            this.groundOrbAnimation.m_216973_();
            this.animationPlayer.stopAnimation("ground_orb");
        }
        if (this.getCurrentAbility() == Ability.ORB_FLY) {
            if (!this.orbFlyAnimation.m_216984_()) {
                this.orbFlyAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("orb_fly");
            }
        } else {
            this.orbFlyAnimation.m_216973_();
            this.animationPlayer.stopAnimation("orb_fly");
        }
    }

    private void aerialAssaultAnimation() {
        if (this.getCurrentAbility() == Ability.AERIAL_ASSAULT && this.getAerialAssaultState() == AerialAssaultState.RISE.ordinal()) {
            if (!this.aerialAssaultRiseAnimation.m_216984_()) {
                this.aerialAssaultRiseAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("aerial_assault_rise", 1.0f);
            }
        } else {
            this.aerialAssaultRiseAnimation.m_216973_();
            this.animationPlayer.stopAnimation("aerial_assault_rise");
        }
        if (this.getCurrentAbility() == Ability.AERIAL_ASSAULT && this.getAerialAssaultState() == AerialAssaultState.TRANSITION.ordinal()) {
            if (!this.aerialAssaultTransitionAnimation.m_216984_()) {
                this.aerialAssaultTransitionAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("aerial_assault_transition", 1.0f);
            }
        } else {
            this.aerialAssaultTransitionAnimation.m_216973_();
            this.animationPlayer.stopAnimation("aerial_assault_transition");
        }
        if (this.getCurrentAbility() == Ability.AERIAL_ASSAULT && this.getAerialAssaultState() == AerialAssaultState.DIVE.ordinal()) {
            if (!this.aerialAssaultDiveAnimation.m_216984_()) {
                this.aerialAssaultDiveAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("aerial_assault_dive", 1.0f);
            }
        } else {
            this.aerialAssaultDiveAnimation.m_216973_();
            this.animationPlayer.stopAnimation("aerial_assault_dive");
        }
        if (this.getCurrentAbility() == Ability.AERIAL_ASSAULT && this.getAerialAssaultState() == AerialAssaultState.CRASH.ordinal()) {
            if (!this.aerialAssaultCrashAnimation.m_216984_()) {
                this.aerialAssaultCrashAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("aerial_assault_crash", 1.0f);
            }
        } else {
            this.aerialAssaultCrashAnimation.m_216973_();
            this.animationPlayer.stopAnimation("aerial_assault_crash");
        }
    }

    private void seismicRoarAnimation() {
        if (this.getCurrentAbility() == Ability.SEISMIC_ROAR) {
            if (!this.seismicRoarAnimation.m_216984_()) {
                this.seismicRoarAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("seismic_roar", 1.0f);
            }
        } else {
            this.seismicRoarAnimation.m_216973_();
            this.animationPlayer.stopAnimation("seismic_roar");
        }
    }

    @Override
    public void enableFly() {
        this.f_19804_.m_135381_(AERIAL, (Object)true);
        this.changeNavigation(this.m_9236_(), true);
        this.m_20242_(true);
        this.changeMoveControl(0);
        this.landingCooldown = 1000;
    }

    @Override
    public void disableFly() {
        this.f_19804_.m_135381_(AERIAL, (Object)false);
        this.changeNavigation(this.m_9236_(), false);
        this.m_20242_(false);
        this.changeMoveControl(1);
        this.flightCooldown = 1000;
    }

    protected void changeNavigation(Level pLevel, boolean flying) {
        this.f_21344_ = flying ? new FlyingPathNavigation((Mob)this, this.m_9236_()) : new BigMobPathNavigate((Mob)this, this.m_9236_());
    }

    protected void changeMoveControl(int moveControl) {
        if (moveControl == 0) {
            this.f_21342_ = new BigMobFlyController((Mob)this);
        }
        if (moveControl == 1) {
            this.f_21342_ = new BigMobMoveControl((Mob)this);
        }
    }

    @Override
    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING && !this.isAerial() && !this.isAttacking() ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    @Override
    public boolean isAttacking() {
        return this.getCurrentAbility() != this.getNoneAbility();
    }

    @Override
    public Ability getNoneAbility() {
        return Ability.NONE;
    }

    @Override
    public StaggerState getNoneStagger() {
        return StaggerState.NONE;
    }

    public boolean isTailCut() {
        return (Boolean)this.f_19804_.m_135370_(TAIL_CUT);
    }

    public void setTailCut(boolean tailCut) {
        this.f_19804_.m_135381_(TAIL_CUT, (Object)tailCut);
        if (tailCut) {
            this.tail4.m_146870_();
            this.tail5.m_146870_();
            this.tail6.m_146870_();
            this.tail7.m_146870_();
        }
    }

    @Override
    public boolean isAttackAbility() {
        Ability ability = (Ability)this.getCurrentAbility();
        return ability != Ability.TURN && ability != Ability.AIR_DASH && ability != Ability.HALT && ability != Ability.STAGGER && ability != Ability.NONE;
    }

    @Override
    public boolean isAerial() {
        return (Boolean)this.f_19804_.m_135370_(AERIAL);
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLY);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLY, (Object)flying);
    }

    @Override
    public boolean isHovering() {
        return (Boolean)this.f_19804_.m_135370_(HOVER);
    }

    public void setHovering(boolean hovering) {
        this.f_19804_.m_135381_(HOVER, (Object)hovering);
    }

    public int getLandState() {
        return (Integer)this.f_19804_.m_135370_(LAND_STATE);
    }

    public int getFlyState() {
        return (Integer)this.f_19804_.m_135370_(FLY_STATE);
    }

    public int getStompState() {
        return (Integer)this.f_19804_.m_135370_(STOMP_STATE);
    }

    public int getChargeState() {
        return (Integer)this.f_19804_.m_135370_(CHARGE_STATE);
    }

    public int getEnragedFrontBiteState() {
        return (Integer)this.f_19804_.m_135370_(ENRAGED_FRONT_BITE_STATE);
    }

    public int getEnragedRushState() {
        return (Integer)this.f_19804_.m_135370_(ENRAGED_RUSH_STATE);
    }

    public int getAerialAssaultState() {
        return (Integer)this.f_19804_.m_135370_(AERIAL_ASSAULT_STATE);
    }

    public int getAirToppleState() {
        return (Integer)this.f_19804_.m_135370_(AIR_TOPPLE_STATE);
    }

    public int getAirTailCutState() {
        return (Integer)this.f_19804_.m_135370_(AIR_TAIL_CUT_STATE);
    }

    public int getTurnState() {
        return (Integer)this.f_19804_.m_135370_(TURN_STATE);
    }

    public int getAirDashState() {
        return (Integer)this.f_19804_.m_135370_(AIR_DASH_STATE);
    }

    public void setLandState(int state) {
        this.f_19804_.m_135381_(LAND_STATE, (Object)state);
    }

    public void setFlyState(int state) {
        this.f_19804_.m_135381_(FLY_STATE, (Object)state);
    }

    public void setChargeState(int state) {
        this.f_19804_.m_135381_(CHARGE_STATE, (Object)state);
    }

    public void setStompState(int state) {
        this.f_19804_.m_135381_(STOMP_STATE, (Object)state);
    }

    public void setEnragedFrontBiteState(int state) {
        this.f_19804_.m_135381_(ENRAGED_FRONT_BITE_STATE, (Object)state);
    }

    public void setEnragedRushState(int state) {
        this.f_19804_.m_135381_(ENRAGED_RUSH_STATE, (Object)state);
    }

    public void setAerialAssaultState(int state) {
        this.f_19804_.m_135381_(AERIAL_ASSAULT_STATE, (Object)state);
    }

    public void setAirToppleState(int state) {
        this.f_19804_.m_135381_(AIR_TOPPLE_STATE, (Object)state);
    }

    public void setAirTailCutState(int state) {
        this.f_19804_.m_135381_(AIR_TAIL_CUT_STATE, (Object)state);
    }

    public void setTurnState(int state) {
        this.f_19804_.m_135381_(TURN_STATE, (Object)state);
    }

    public void setAirDashState(int state) {
        this.f_19804_.m_135381_(AIR_DASH_STATE, (Object)state);
    }

    public void m_7023_(Vec3 pTravelVector) {
        LivingEntity livingEntity;
        if (!this.m_20160_() || !((livingEntity = this.m_6688_()) instanceof Player)) {
            super.m_7023_(pTravelVector);
            return;
        }
        Player passenger = (Player)livingEntity;
        float forward = passenger.f_20902_;
        float strafe = passenger.f_20900_ * 0.5f;
        if (forward <= 0.0f) {
            forward *= 0.25f;
        }
        double riderVerticalSpeed = this.m_20160_() && this.m_6688_() instanceof Player ? (this.isRiderAscending() ? 0.6 : (this.isRiderDescending() ? -0.6 : 0.0)) : 0.0;
        if (this.isAerial()) {
            this.m_7910_((float)this.m_21133_(Attributes.f_22280_));
        } else {
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
        }
        Vec3 finalTravelVector = new Vec3((double)strafe, riderVerticalSpeed, (double)forward);
        super.m_7023_(finalTravelVector);
    }

    public double m_6048_() {
        return super.m_6048_() * 1.25;
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("FlightCooldown", this.flightCooldown);
        pCompound.m_128405_("LandingCooldown", this.landingCooldown);
        pCompound.m_128379_("IsAerial", this.isAerial());
        pCompound.m_128379_("TailCut", this.isTailCut());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.flightCooldown = pCompound.m_128451_("FlightCooldown");
        this.landingCooldown = pCompound.m_128451_("LandingCooldown");
        this.f_19804_.m_135381_(AERIAL, (Object)pCompound.m_128471_("IsAerial"));
        this.f_19804_.m_135381_(TAIL_CUT, (Object)pCompound.m_128471_("TailCut"));
    }

    protected void m_6153_() {
        ++this.f_20919_;
        this.setCurrentAbility(Ability.DEATH);
        if (this.f_20919_ >= 100 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public boolean isFlashable() {
        return true;
    }

    public static enum Ability implements IMonsterAbilities<Ability>
    {
        NONE,
        ROAR,
        TAILSWIPE,
        AIR_ROAR,
        WING_SLAP,
        TAIL_SLAM,
        FRONT_BITE,
        CHARGE,
        STOMP,
        LEG_STOMP,
        AIR_TAILSWIPE,
        AIR_BITE,
        ENRAGE,
        RUSH,
        FLY,
        LAND,
        AIR_KICK,
        AIR_ORB,
        ORB_FLY,
        AIR_DASH,
        AERIAL_ASSAULT,
        SEISMIC_ROAR,
        STAGGER,
        GROUND_ORB,
        TURN,
        DEATH,
        AIR_CLAW,
        HALT,
        AIR_TAIL_SLAM;


        @Override
        public int getOrdinal() {
            return this.ordinal();
        }

        @Override
        public Ability getNone() {
            return NONE;
        }
    }

    public static enum StaggerState implements IMonsterStaggers<StaggerState>
    {
        NONE,
        STAGGER,
        TOPPLE,
        TAIL_CUT,
        RIGHT_WING_BREAK,
        LEFT_WING_BREAK;

    }

    public static enum TurnState {
        NONE,
        RIGHT,
        LEFT;

    }

    public static enum AirDashState {
        NONE,
        TURN_LEFT,
        TURN_RIGHT,
        MOVE,
        STOP_LEFT,
        STOP_RIGHT;

    }

    public static enum EnragedRushState {
        NONE,
        BASE,
        SLIDE,
        TURN,
        RE_RUSH,
        END;

    }

    public static enum EnragedFrontBiteState {
        NONE,
        BASE,
        SUCCESS,
        FAIL;

    }

    public static enum LandState {
        NONE,
        DESCEND,
        LAND;

    }

    public static enum FlyState {
        NONE,
        SUCCESS,
        FAIL;

    }

    public static enum StompState {
        NONE,
        STARTUP,
        AIRBORNE,
        SLAM;

    }

    public static enum ChargeState {
        NONE,
        STARTUP,
        CHARGING,
        SLAM;

    }

    public static enum AerialAssaultState {
        NONE,
        RISE,
        TRANSITION,
        DIVE,
        CRASH;

    }

    public static enum AirToppleState {
        NONE,
        START,
        FALL,
        CRASH;

    }

    public static enum AirTailCutState {
        NONE,
        START,
        FALL,
        CRASH;

    }
}

