/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.custom;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.config.ModConfig;
import net.saksolm.monsterexpansion.entity.ai.HealPunishGoal;
import net.saksolm.monsterexpansion.entity.ai.HighestThreatTargetGoal;
import net.saksolm.monsterexpansion.entity.ai.LargeMonsterFollowOwnerGoal;
import net.saksolm.monsterexpansion.entity.ai.SwitchTargetGoal;
import net.saksolm.monsterexpansion.entity.ai.behavior.BehaviorStatus;
import net.saksolm.monsterexpansion.entity.ai.behavior.custom.RhyzaGroundBehaviorTree;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaBackslashGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaDashGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaEnrageGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaFlashGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaFrenzyGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaInvisibilityGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaLeapGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaRightSlashGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaRushGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaSlamGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaSlashGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaStaggerGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaTailCutGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaTailswipeGoal;
import net.saksolm.monsterexpansion.entity.ai.rhyza.RhyzaToppleGoal;
import net.saksolm.monsterexpansion.entity.animations.RhyzaAnimationState;
import net.saksolm.monsterexpansion.entity.animations.RhyzaServerAnimations;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.IFlyingMonster;
import net.saksolm.monsterexpansion.entity.custom.IMonsterAbilities;
import net.saksolm.monsterexpansion.entity.custom.IMonsterStaggers;
import net.saksolm.monsterexpansion.entity.custom.LargeMonsterPartEntity;
import net.saksolm.monsterexpansion.entity.custom.RhyzaPartEntity;
import net.saksolm.monsterexpansion.entity.custom.RhyzaTailEntity;
import net.saksolm.monsterexpansion.entity.util.DamageTypes;
import net.saksolm.monsterexpansion.item.ModItems;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import org.jetbrains.annotations.Nullable;

public class RhyzaEntity
extends AbstractLargeMonster<Ability, StaggerState> {
    private final RhyzaAnimationState animationState;
    public static final double BASE_MAX_HEALTH = 500.0;
    public static final double BASE_ATTACK_DAMAGE = 10.0;
    private static final Map<String, String> RHYZA_HIERARCHY = ImmutableMap.builder().put((Object)"torso", (Object)"Rhyza").put((Object)"lower", (Object)"torso").put((Object)"upper", (Object)"torso").put((Object)"hip", (Object)"lower").put((Object)"left_leg", (Object)"hip").put((Object)"right_leg", (Object)"hip").put((Object)"tails", (Object)"hip").put((Object)"left_knee", (Object)"left_leg").put((Object)"right_knee", (Object)"right_leg").put((Object)"left_upper_foot", (Object)"left_knee").put((Object)"right_upper_foot", (Object)"right_knee").put((Object)"left_lower_foot", (Object)"left_upper_foot").put((Object)"right_lower_foot", (Object)"right_upper_foot").put((Object)"toe_1", (Object)"left_lower_foot").put((Object)"toe_2", (Object)"left_lower_foot").put((Object)"toe_3", (Object)"left_lower_foot").put((Object)"toe_4", (Object)"right_lower_foot").put((Object)"toe_5", (Object)"right_lower_foot").put((Object)"toe_6", (Object)"right_lower_foot").put((Object)"right_tail", (Object)"tails").put((Object)"left_tail", (Object)"tails").put((Object)"right_tail_1", (Object)"right_tail").put((Object)"left_tail_1", (Object)"left_tail").put((Object)"right_tail_2", (Object)"right_tail_1").put((Object)"left_tail_2", (Object)"left_tail_1").put((Object)"right_tail_3", (Object)"right_tail_2").put((Object)"left_tail_3", (Object)"left_tail_2").put((Object)"right_tail_4", (Object)"right_tail_3").put((Object)"left_tail_4", (Object)"left_tail_3").put((Object)"left_arm", (Object)"upper").put((Object)"right_arm", (Object)"upper").put((Object)"lower_neck", (Object)"upper").put((Object)"left_forearm", (Object)"left_arm").put((Object)"right_forearm", (Object)"right_arm").put((Object)"left_claw", (Object)"left_forearm").put((Object)"right_claw", (Object)"right_forearm").put((Object)"finger_1", (Object)"right_claw").put((Object)"finger_2", (Object)"right_claw").put((Object)"finger_3", (Object)"right_claw").put((Object)"right_thumb", (Object)"right_claw").put((Object)"finger_4", (Object)"left_claw").put((Object)"finger_5", (Object)"left_claw").put((Object)"finger_6", (Object)"left_claw").put((Object)"left_thumb", (Object)"left_claw").put((Object)"upper_neck", (Object)"lower_neck").put((Object)"head", (Object)"upper_neck").put((Object)"jaw", (Object)"head").put((Object)"antennas", (Object)"head").put((Object)"left_antenna", (Object)"antennas").put((Object)"right_antenna", (Object)"antennas").put((Object)"la_1", (Object)"left_antenna").put((Object)"ra_1", (Object)"right_antenna").put((Object)"la_2", (Object)"la_1").put((Object)"ra_2", (Object)"ra_1").put((Object)"la_3", (Object)"la_2").put((Object)"ra_3", (Object)"ra_2").put((Object)"la_4", (Object)"la_3").put((Object)"ra_4", (Object)"ra_3").put((Object)"la_5", (Object)"la_4").put((Object)"ra_5", (Object)"ra_4").put((Object)"ra_6", (Object)"la_2").put((Object)"ra_7", (Object)"ra_6").put((Object)"ra_8", (Object)"ra_7").build();
    private static final Map<String, Vec3> RHYZA_DEFAULT_OFFSETS = ImmutableMap.builder().put((Object)"Rhyza", (Object)new Vec3(0.0, 1.5625, -0.8125)).put((Object)"torso", (Object)new Vec3(0.0, -0.125, 0.6875)).put((Object)"lower", (Object)new Vec3(0.0, 0.5625, -0.6875)).put((Object)"hip", (Object)new Vec3(0.0, -0.3125, 1.25)).put((Object)"left_leg", (Object)new Vec3(-0.4375, -0.25, 0.1875)).put((Object)"left_knee", (Object)new Vec3(-0.0625, -1.0816062688827515, (double)0.3444125f)).put((Object)"left_upper_foot", (Object)new Vec3(0.0, 0.0, 0.75)).put((Object)"left_lower_foot", (Object)new Vec3(0.0, -0.8125, -0.4375)).put((Object)"toe_1", (Object)new Vec3(-0.1875, 0.0, -0.1875)).put((Object)"toe_2", (Object)new Vec3(0.0, 0.0, -0.1875)).put((Object)"toe_3", (Object)new Vec3(0.1875, 0.0, -0.1875)).put((Object)"tails", (Object)new Vec3(0.0, (double)0.2836375f, (double)0.3820625f)).put((Object)"right_tail", (Object)new Vec3(0.1875, 0.0903875008225441, (double)-0.0421625f)).put((Object)"right_tail_1", (Object)new Vec3(0.1875, 0.1596125066280365, 0.3546625077724457)).put((Object)"right_tail_2", (Object)new Vec3(0.0, 0.25, 0.5625)).put((Object)"right_tail_3", (Object)new Vec3(0.0, 0.375, 0.875)).put((Object)"right_tail_4", (Object)new Vec3(0.0, 0.3125, 0.8125)).put((Object)"left_tail", (Object)new Vec3(-0.1875, 0.0903875008225441, (double)-0.0421625f)).put((Object)"left_tail_1", (Object)new Vec3(-0.1875, 0.1596125066280365, 0.3546625077724457)).put((Object)"left_tail_2", (Object)new Vec3(0.0, 0.25, 0.5625)).put((Object)"left_tail_3", (Object)new Vec3(0.0, 0.375, 0.875)).put((Object)"left_tail_4", (Object)new Vec3(0.0, 0.3125, 0.8125)).put((Object)"right_leg", (Object)new Vec3(0.5, -0.25, 0.1875)).put((Object)"right_knee", (Object)new Vec3(0.0, -1.0816062688827515, (double)0.3444125f)).put((Object)"right_upper_foot", (Object)new Vec3(0.0, 0.0, 0.75)).put((Object)"right_lower_foot", (Object)new Vec3(0.0, -0.8125, -0.4375)).put((Object)"toe_4", (Object)new Vec3(-0.1875, 0.0, -0.1875)).put((Object)"toe_5", (Object)new Vec3(0.0, 0.0, -0.1875)).put((Object)"toe_6", (Object)new Vec3(0.1875, 0.0, -0.1875)).put((Object)"upper", (Object)new Vec3(0.0, 0.4375, -1.0)).put((Object)"left_arm", (Object)new Vec3(-0.4375, -0.25, -0.125)).put((Object)"left_forearm", (Object)new Vec3(-0.0625, -1.25, 0.8125)).put((Object)"left_claw", (Object)new Vec3(0.0, -0.8125, 0.3125)).put((Object)"finger_4", (Object)new Vec3(-0.1875, -0.375, 0.1875)).put((Object)"finger_5", (Object)new Vec3(0.0, -0.375, 0.1875)).put((Object)"finger_6", (Object)new Vec3(0.1875, -0.375, 0.1875)).put((Object)"left_thumb", (Object)new Vec3((double)0.230125f, (double)-0.0410875f, (double)0.0029875f)).put((Object)"right_arm", (Object)new Vec3(0.4375, -0.25, -0.125)).put((Object)"right_forearm", (Object)new Vec3(0.0625, -1.25, 0.8125)).put((Object)"right_claw", (Object)new Vec3(0.0, -0.8125, 0.3125)).put((Object)"finger_1", (Object)new Vec3(-0.1875, -0.375, 0.1875)).put((Object)"finger_2", (Object)new Vec3(0.0, -0.375, 0.1875)).put((Object)"finger_3", (Object)new Vec3(0.1875, -0.375, 0.1875)).put((Object)"right_thumb", (Object)new Vec3((double)-0.230125f, (double)-0.0410875f, (double)0.0029875f)).put((Object)"lower_neck", (Object)new Vec3(0.0, -0.1875, -0.3125)).put((Object)"upper_neck", (Object)new Vec3(0.0, 0.375, -0.5)).put((Object)"head", (Object)new Vec3(0.0, 0.375, -0.1875)).put((Object)"jaw", (Object)new Vec3(0.0, -0.375, -0.3125)).put((Object)"antennas", (Object)new Vec3(0.0, 0.125, -0.0625)).put((Object)"left_antenna", (Object)new Vec3(-0.4375, 0.0, 0.0)).put((Object)"ra_1", (Object)new Vec3((double)0.365975f, (double)0.504325f, 0.0)).put((Object)"ra_2", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"ra_3", (Object)new Vec3((double)0.2478625f, (double)0.03263125f, 0.0)).put((Object)"ra_4", (Object)new Vec3((double)0.1811125f, -0.04853124916553497, 0.0)).put((Object)"ra_5", (Object)new Vec3((double)0.0960125f, (double)-0.17275f, 0.0)).put((Object)"right_antenna", (Object)new Vec3(0.4375, 0.0, 0.0)).put((Object)"la_1", (Object)new Vec3((double)-0.365975f, (double)0.504325f, 0.0)).put((Object)"la_2", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"la_3", (Object)new Vec3(-0.428974986076355, (double)-0.0159f, 0.0)).put((Object)"la_4", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"la_5", (Object)new Vec3((double)-0.0960125f, (double)-0.17275f, 0.0)).put((Object)"ra_6", (Object)new Vec3((double)-0.2478625f, (double)0.03263125f, 0.0)).put((Object)"ra_7", (Object)new Vec3((double)-0.1811125f, -0.04853124916553497, 0.0)).put((Object)"ra_8", (Object)new Vec3((double)-0.0960125f, (double)-0.17275f, 0.0)).build();
    private static final Map<String, Vec3> RHYZA_DEFAULT_ROTATIONS = ImmutableMap.builder().put((Object)"Rhyza", (Object)new Vec3((double)-0.3491f, 0.0, 0.0)).put((Object)"hip", (Object)new Vec3((double)-0.1309f, 0.0, 0.0)).put((Object)"left_leg", (Object)new Vec3((double)0.7109f, (double)-0.0741f, (double)-0.3414f)).put((Object)"left_knee", (Object)new Vec3((double)0.4559f, (double)0.2036f, (double)0.1644f)).put((Object)"left_lower_foot", (Object)new Vec3((double)0.4363f, 0.0, 0.0)).put((Object)"toe_1", (Object)new Vec3((double)-1.0854f, (double)-0.0058f, (double)0.1266f)).put((Object)"toe_2", (Object)new Vec3((double)-1.0875f, (double)0.0347f, (double)0.0493f)).put((Object)"toe_3", (Object)new Vec3((double)-1.0927f, (double)0.075f, (double)-0.0283f)).put((Object)"tails", (Object)new Vec3((double)-0.1745f, 0.0, 0.0)).put((Object)"right_leg", (Object)new Vec3((double)0.7109f, (double)0.0741f, (double)0.3414f)).put((Object)"right_knee", (Object)new Vec3((double)0.4559f, (double)-0.2036f, (double)-0.1644f)).put((Object)"right_lower_foot", (Object)new Vec3((double)0.4363f, 0.0, 0.0)).put((Object)"toe_4", (Object)new Vec3((double)-1.0927f, (double)-0.075f, (double)0.0283f)).put((Object)"toe_5", (Object)new Vec3((double)-1.0875f, (double)-0.0347f, (double)-0.0493f)).put((Object)"toe_6", (Object)new Vec3((double)-1.0854f, (double)0.0058f, (double)-0.1266f)).put((Object)"upper", (Object)new Vec3((double)0.829f, 0.0, 0.0)).put((Object)"left_arm", (Object)new Vec3((double)-0.5865f, (double)-0.3093f, (double)-0.4295f)).put((Object)"left_forearm", (Object)new Vec3((double)-0.747f, (double)0.3424f, (double)0.4924f)).put((Object)"left_claw", (Object)new Vec3((double)0.0939f, (double)-0.3367f, (double)-0.2778f)).put((Object)"finger_4", (Object)new Vec3((double)-1.177f, (double)-0.0946f, (double)-0.0835f)).put((Object)"finger_5", (Object)new Vec3((double)-1.1773f, (double)-0.0101f, (double)0.0166f)).put((Object)"finger_6", (Object)new Vec3((double)-1.1692f, (double)0.0739f, (double)0.1169f)).put((Object)"left_thumb", (Object)new Vec3((double)-1.3684f, (double)0.8643f, (double)-0.5805f)).put((Object)"right_arm", (Object)new Vec3((double)-0.5865f, (double)0.3093f, (double)0.4295f)).put((Object)"right_forearm", (Object)new Vec3((double)-0.747f, (double)-0.3424f, (double)-0.4924f)).put((Object)"right_claw", (Object)new Vec3((double)0.0939f, (double)0.3367f, (double)0.2778f)).put((Object)"finger_1", (Object)new Vec3((double)-1.1692f, (double)-0.0739f, (double)-0.1169f)).put((Object)"finger_2", (Object)new Vec3((double)-1.1773f, (double)0.0101f, (double)-0.0166f)).put((Object)"finger_3", (Object)new Vec3((double)-1.177f, (double)0.0946f, (double)0.0835f)).put((Object)"right_thumb", (Object)new Vec3((double)-1.3684f, (double)-0.8643f, (double)0.5805f)).put((Object)"lower_neck", (Object)new Vec3((double)-0.2182f, 0.0, 0.0)).put((Object)"upper_neck", (Object)new Vec3((double)0.1309f, 0.0, 0.0)).put((Object)"head", (Object)new Vec3((double)-0.2182f, 0.0, 0.0)).put((Object)"left_antenna", (Object)new Vec3((double)0.1965f, (double)-0.5721f, (double)-0.2976f)).put((Object)"right_antenna", (Object)new Vec3((double)0.1965f, (double)0.5721f, (double)0.2976f)).build();
    private final int SLASH_COOLDOWN = 70;
    private final int BACKSLASH_COOLDOWN = 70;
    private final int TAILSWIPE_COOLDOWN = 200;
    private final int RUSH_COOLDOWN = 140;
    private final int SLAM_COOLDOWN = 70;
    private final int RIGHT_SLASH_COOLDOWN = 70;
    private final int DASH_COOLDOWN = 200;
    private final int INVISIBILITY_COOLDOWN = 700;
    private final int LEAP_COOLDOWN = 140;
    private final int FLASH_COOLDOWN = 700;
    private final int FRENZY_COOLDOWN = 300;
    private int lastSlash = -1000;
    private int lastBackslash = -1000;
    private int lastTailswipe = -1000;
    private int lastRush = -1000;
    private int lastSlam = -1000;
    private int lastRightSlash = -1000;
    private int lastDash = -1000;
    private int lastInvisibility = -1000;
    private int lastLeap = -1000;
    private int lastFlash = -1000;
    private int lastFrenzy = -1000;
    private static final EntityDataAccessor<Integer> FRENZY_STATE = SynchedEntityData.m_135353_(RhyzaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FADE_TICKS = SynchedEntityData.m_135353_(RhyzaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> INVISIBLE = SynchedEntityData.m_135353_(RhyzaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int invisibilityDurationTicks = -1;
    private final RhyzaGroundBehaviorTree groundBehaviorTree;
    private static final EntityDataAccessor<Boolean> RUNNING = SynchedEntityData.m_135353_(RhyzaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int pathUpdateCooldown = 0;
    private RhyzaPartEntity[] parts;
    private RhyzaPartEntity head;
    private RhyzaPartEntity right_tail;
    private RhyzaPartEntity right_tail_1;
    private RhyzaPartEntity right_tail_2;
    private RhyzaPartEntity right_tail_3;
    private RhyzaPartEntity right_tail_4;
    private RhyzaPartEntity left_tail;
    private RhyzaPartEntity left_tail_1;
    private RhyzaPartEntity left_tail_2;
    private RhyzaPartEntity left_tail_3;
    private RhyzaPartEntity left_tail_4;
    private static final EntityDataAccessor<Boolean> RIGHT_TAIL_CUT = SynchedEntityData.m_135353_(RhyzaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEFT_TAIL_CUT = SynchedEntityData.m_135353_(RhyzaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState test = new AnimationState();
    public final AnimationState sideWalkAnimation = new AnimationState();
    public final AnimationState idleAnimation = new AnimationState();
    public final AnimationState runAnimation = new AnimationState();
    public final AnimationState runStartAnimation = new AnimationState();
    public final AnimationState runEndAnimation = new AnimationState();
    public final AnimationState slashAnimation = new AnimationState();
    public final AnimationState backslashAnimation = new AnimationState();
    public final AnimationState tailswipeAnimation = new AnimationState();
    public final AnimationState rushAnimation = new AnimationState();
    public final AnimationState slamAnimation = new AnimationState();
    public final AnimationState rightSlashAnimation = new AnimationState();
    public final AnimationState dashAnimation = new AnimationState();
    public final AnimationState enrageAnimation = new AnimationState();
    public final AnimationState staggerAnimation = new AnimationState();
    public final AnimationState toppleAnimation = new AnimationState();
    public final AnimationState leapAnimation = new AnimationState();
    public final AnimationState flashAnimation = new AnimationState();
    public final AnimationState frenzyStartAnimation = new AnimationState();
    public final AnimationState frenzyLeftAnimation = new AnimationState();
    public final AnimationState frenzyLeftToRightAnimation = new AnimationState();
    public final AnimationState frenzyRightAnimation = new AnimationState();
    public final AnimationState frenzyRightToLeftAnimation = new AnimationState();
    public final AnimationState frenzyLeftFinishAnimation = new AnimationState();
    public final AnimationState frenzyRightFinishAnimation = new AnimationState();
    public final AnimationState tailCutAnimation = new AnimationState();

    public RhyzaEntity(EntityType<? extends AbstractLargeMonster<Ability, StaggerState>> pEntityType, Level pLevel) {
        super(pEntityType, pLevel, Ability.class, StaggerState.class);
        this.animationState = new RhyzaAnimationState();
        this.head = new RhyzaPartEntity(this, 1.0f, 1.0f);
        this.right_tail = new RhyzaPartEntity(this, 1.0f, 1.0f);
        this.right_tail_1 = new RhyzaPartEntity(this, 1.0f, 1.0f);
        this.right_tail_2 = new RhyzaPartEntity(this, 1.0f, 1.0f);
        this.right_tail_3 = new RhyzaPartEntity(this, 1.0f, 1.0f);
        this.right_tail_4 = new RhyzaPartEntity(this, 1.0f, 1.0f);
        this.left_tail = new RhyzaPartEntity(this, 1.0f, 1.0f);
        this.left_tail_1 = new RhyzaPartEntity(this, 1.0f, 1.0f);
        this.left_tail_2 = new RhyzaPartEntity(this, 1.0f, 1.0f);
        this.left_tail_3 = new RhyzaPartEntity(this, 1.0f, 1.0f);
        this.left_tail_4 = new RhyzaPartEntity(this, 1.0f, 1.0f);
        this.parts = new RhyzaPartEntity[]{this.head, this.right_tail, this.right_tail_1, this.right_tail_2, this.right_tail_3, this.right_tail_4, this.left_tail, this.left_tail_1, this.left_tail_2, this.left_tail_3, this.left_tail_4};
        this.groundBehaviorTree = new RhyzaGroundBehaviorTree();
        this.registerBreakablePart("head_break", this.getStaggerPartBaseHealth());
        this.registerBreakablePart("head_stagger", this.getStaggerPartBaseHealth());
        this.registerBreakablePart("right_tail", this.m_21233_() * 2.0f / 5.0f);
        this.registerBreakablePart("left_tail", this.m_21233_() * 2.0f / 5.0f);
        this.registerRawHitzone("head_stagger", DamageTypes.WeaponType.BLUNT, 0.7f);
        this.registerRawHitzone("head_stagger", DamageTypes.WeaponType.SLASHING, 0.45f);
        this.registerRawHitzone("head_stagger", DamageTypes.WeaponType.PIERCING, 0.45f);
        this.registerRawHitzone("head_break", DamageTypes.WeaponType.BLUNT, 0.7f);
        this.registerRawHitzone("head_break", DamageTypes.WeaponType.SLASHING, 0.45f);
        this.registerRawHitzone("head_break", DamageTypes.WeaponType.PIERCING, 0.45f);
        this.registerRawHitzone("right_tail", DamageTypes.WeaponType.SLASHING, 0.6f);
        this.registerRawHitzone("right_tail", DamageTypes.WeaponType.BLUNT, 0.3f);
        this.registerRawHitzone("right_tail", DamageTypes.WeaponType.PIERCING, 0.3f);
        this.registerRawHitzone("left_tail", DamageTypes.WeaponType.SLASHING, 0.6f);
        this.registerRawHitzone("left_tail", DamageTypes.WeaponType.BLUNT, 0.3f);
        this.registerRawHitzone("left_tail", DamageTypes.WeaponType.PIERCING, 0.3f);
        this.registerRawHitzone("body", DamageTypes.WeaponType.SLASHING, 0.3f);
        this.registerRawHitzone("body", DamageTypes.WeaponType.BLUNT, 0.3f);
        this.registerRawHitzone("body", DamageTypes.WeaponType.PIERCING, 0.3f);
        this.registerElementalHitzone("body", DamageTypes.ElementType.ICE, 0.3f);
        this.m_21051_(Attributes.f_22276_).m_22100_(500.0 * (Double)ModConfig.SERVER.RHYZA.MAX_HEALTH.get() * (Double)ModConfig.SERVER.GENERAL.MAX_HEALTH.get());
        this.m_21051_(Attributes.f_22281_).m_22100_(10.0 * (Double)ModConfig.SERVER.RHYZA.ATTACK_DAMAGE.get() * (Double)ModConfig.SERVER.GENERAL.MAX_HEALTH.get());
    }

    public RhyzaAnimationState getAnimationState() {
        return this.animationState;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RUNNING, (Object)false);
        this.f_19804_.m_135372_(INVISIBLE, (Object)false);
        this.f_19804_.m_135372_(RIGHT_TAIL_CUT, (Object)false);
        this.f_19804_.m_135372_(LEFT_TAIL_CUT, (Object)false);
        this.f_19804_.m_135372_(FADE_TICKS, (Object)0);
        this.f_19804_.m_135372_(FRENZY_STATE, (Object)FrenzyState.NONE.ordinal());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22280_, 1.0).m_22268_(Attributes.f_22278_, 0.95).m_22268_(Attributes.f_22288_, 0.85);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new RhyzaStaggerGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new RhyzaToppleGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new RhyzaTailCutGoal(this));
        if (!this.m_21824_()) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        }
        if (!this.m_21824_() || this.m_21824_() && this.getTamedBehavior() != AbstractLargeMonster.TamedBehavior.PASSIVE) {
            this.f_21345_.m_25352_(1, (Goal)new RhyzaEnrageGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new RhyzaSlashGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new RhyzaRightSlashGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new RhyzaBackslashGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new RhyzaTailswipeGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new RhyzaRushGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new RhyzaSlamGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new RhyzaDashGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new RhyzaInvisibilityGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new RhyzaLeapGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new RhyzaFlashGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new RhyzaFrenzyGoal(this));
            this.f_21346_.m_25352_(2, (Goal)new HealPunishGoal(this));
            this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
            this.f_21346_.m_25352_(4, (Goal)new HighestThreatTargetGoal(this));
            this.f_21346_.m_25352_(5, (Goal)new SwitchTargetGoal(this));
            this.f_21346_.m_25352_(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
            this.f_21346_.m_25352_(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        }
        if (this.m_21824_() && this.getTamedStance() == AbstractLargeMonster.TamedStance.FOLLOWING) {
            this.f_21345_.m_25352_(2, (Goal)new LargeMonsterFollowOwnerGoal(this, 1.0, 10.0f, 5.0f));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.isRightTailCut()) {
                this.right_tail_4.m_146870_();
                this.right_tail_3.m_146870_();
            }
            if (this.isLeftTailCut()) {
                this.left_tail_4.m_146870_();
                this.left_tail_3.m_146870_();
            }
            --this.pathUpdateCooldown;
            this.handleInvisibility();
            if (!(this.m_21824_() && (!this.m_21824_() || this.getTamedBehavior() != AbstractLargeMonster.TamedBehavior.AGGRESSIVE && this.getTamedBehavior() != AbstractLargeMonster.TamedBehavior.NEUTRAL) || this.m_20160_() || this.getTamedStance() == AbstractLargeMonster.TamedStance.SITTING || this.m_5448_() == null)) {
                this.groundBehaviorTree.tick(this);
            }
        }
    }

    private void handleInvisibility() {
        if (this.m_20145_()) {
            --this.invisibilityDurationTicks;
            if (this.invisibilityDurationTicks % 20 == 0 && this.m_20096_() && this.isAttacking()) {
                this.spawnGroundEffects(Vec3.f_82478_, 1.0f, 0, 5, 0);
            }
            if (this.invisibilityDurationTicks <= 0) {
                this.m_6842_(false);
                this.setFadeTicks(0);
            }
        } else if (this.getFadeTicks() > 0) {
            this.setFadeTicks(0);
        }
    }

    public BehaviorStatus updateGroundMovement(LivingEntity target) {
        if (this.m_21824_() && this.getTamedStance() == AbstractLargeMonster.TamedStance.FOLLOWING) {
            return BehaviorStatus.FAILURE;
        }
        if (this.isAttacking()) {
            this.setRunning(false);
            return BehaviorStatus.FAILURE;
        }
        if (target == null || !target.m_6084_()) {
            this.setRunning(false);
            this.m_21573_().m_26573_();
            return BehaviorStatus.FAILURE;
        }
        if (this.m_20280_((Entity)target) <= 25.0) {
            this.setRunning(false);
            this.m_21573_().m_26573_();
            return BehaviorStatus.SUCCESS;
        }
        if (this.pathUpdateCooldown <= 0) {
            this.pathUpdateCooldown = 1;
            Vec3 predictedPos = this.getPredictedTargetPosition(target, 10);
            BlockPos targetPos = BlockPos.m_274446_((Position)predictedPos);
            Path path = this.m_21573_().m_7864_(targetPos, 0);
            if (path != null && !path.m_77392_()) {
                Vec3 finalDestination = path.m_77406_().m_252807_();
                double distanceSq = this.m_20182_().m_82557_(finalDestination);
                double RUN_DISTANCE_THRESHOLD_SQ = 100.0;
                boolean shouldRun = distanceSq > 100.0;
                this.setRunning(shouldRun);
                float speed = shouldRun ? 1.5f : 1.0f;
                this.m_21573_().m_26536_(path, (double)speed);
            }
        }
        return this.m_21573_().m_26572_() ? BehaviorStatus.RUNNING : BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus updateGroundMovement() {
        return this.updateGroundMovement(this.m_5448_());
    }

    @Override
    public LargeMonsterPartEntity<?>[] getBodyParts() {
        return this.parts;
    }

    @Override
    protected void onFlashed(DamageSource source) {
    }

    @Override
    public String getStaggerPartName() {
        return "head_stagger";
    }

    @Override
    public float getStaggerPartBaseHealth() {
        return this.m_21233_() * 0.2f;
    }

    @Override
    protected void onPartBroken(String partName, DamageSource source) {
        switch (partName) {
            case "head_stagger": {
                this.handleStagger(source);
                break;
            }
            case "head_break": {
                if (this.hasDroppedToppleLoot) break;
                if (this.getCurrentStaggerState() == StaggerState.STAGGER) {
                    this.setCurrentStaggerState(StaggerState.TOPPLE);
                } else {
                    this.setCurrentStaggerState(StaggerState.STAGGER);
                }
                this.hasDroppedToppleLoot = true;
                ItemStack item = this.m_217043_().m_188503_(2) == 0 ? new ItemStack((ItemLike)ModItems.RHYZA_CARAPACE.get()) : new ItemStack((ItemLike)ModItems.RHYZA_FUR.get());
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.head.m_20185_(), this.head.m_20186_(), this.head.m_20189_(), item);
                this.m_9236_().m_7967_((Entity)itemEntity);
                break;
            }
            case "right_tail": {
                if (this.isRightTailCut()) break;
                this.setRightTailCut(true);
                this.setCurrentStaggerState(StaggerState.TAIL_CUT);
                Vec3 directionToPart = this.right_tail.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                float tailYaw = this.m_146908_();
                RhyzaPartEntity part = this.right_tail_3;
                double flingSpeed = 0.1;
                double upwardSpeed = 0.8;
                RhyzaTailEntity tailEntity = new RhyzaTailEntity(this.m_9236_(), part.m_20185_(), part.m_20186_(), part.m_20189_(), tailYaw);
                tailEntity.m_20334_(directionToPart.f_82479_ * flingSpeed, upwardSpeed, directionToPart.f_82481_ * flingSpeed);
                this.m_9236_().m_7967_((Entity)tailEntity);
                break;
            }
            case "left_tail": {
                if (this.isLeftTailCut()) break;
                this.setLeftTailCut(true);
                this.setCurrentStaggerState(StaggerState.TAIL_CUT);
                Vec3 directionToPart = this.left_tail.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                float tailYaw = this.m_146908_();
                RhyzaPartEntity part = this.left_tail_3;
                double flingSpeed = 0.1;
                double upwardSpeed = 0.8;
                RhyzaTailEntity tailEntity = new RhyzaTailEntity(this.m_9236_(), part.m_20185_(), part.m_20186_(), part.m_20189_(), tailYaw);
                tailEntity.m_20334_(directionToPart.f_82479_ * flingSpeed, upwardSpeed, directionToPart.f_82481_ * flingSpeed);
                this.m_9236_().m_7967_((Entity)tailEntity);
            }
        }
    }

    @Override
    protected List<String> getLogicalPartNamesFor(LargeMonsterPartEntity<?> physicalPart) {
        if (physicalPart == this.head) {
            return List.of("head_stagger", "head_break");
        }
        if (this.isRightTailPart((RhyzaPartEntity)physicalPart)) {
            return List.of("right_tail");
        }
        if (this.isLeftTailPart((RhyzaPartEntity)physicalPart)) {
            return List.of("left_tail");
        }
        return List.of();
    }

    private void handleStagger(DamageSource source) {
        if (this.getCurrentStaggerState() == StaggerState.TOPPLE) {
            this.setCurrentStaggerState(StaggerState.STAGGER);
        } else if (this.getCurrentStaggerState() == StaggerState.STAGGER) {
            this.setCurrentStaggerState(StaggerState.TOPPLE);
            ++this.toppleCount;
        } else if (this.staggerCount % 3 != 0 || this.staggerCount == 0) {
            this.setCurrentStaggerState(StaggerState.STAGGER);
        } else {
            this.setCurrentStaggerState(StaggerState.TOPPLE);
            ++this.toppleCount;
        }
        float newHealth = this.getStaggerPartBaseHealth() * (1.0f + 0.5f * (float)this.staggerCount);
        this.resetPartHealth(this.getStaggerPartName(), newHealth);
    }

    public RhyzaPartEntity getHeadPart() {
        return this.head;
    }

    @Override
    protected void registerServerAnimations() {
        this.animationPlayer.registerAnimation("walk", RhyzaServerAnimations.walk);
        this.animationPlayer.registerAnimation("run", RhyzaServerAnimations.run);
        this.animationPlayer.registerAnimation("run_start", RhyzaServerAnimations.run_start);
        this.animationPlayer.registerAnimation("run_end", RhyzaServerAnimations.run_end);
        this.animationPlayer.registerAnimation("side_walk", RhyzaServerAnimations.side_walk);
        this.animationPlayer.registerAnimation("slash", RhyzaServerAnimations.slash);
        this.animationPlayer.registerAnimation("backslash", RhyzaServerAnimations.backslash);
        this.animationPlayer.registerAnimation("tailswipe", RhyzaServerAnimations.tailswipe);
        this.animationPlayer.registerAnimation("rush", RhyzaServerAnimations.rush);
        this.animationPlayer.registerAnimation("right_slash", RhyzaServerAnimations.right_slash);
        this.animationPlayer.registerAnimation("slam", RhyzaServerAnimations.slam);
        this.animationPlayer.registerAnimation("dash", RhyzaServerAnimations.dash);
        this.animationPlayer.registerAnimation("enrage", RhyzaServerAnimations.enrage);
        this.animationPlayer.registerAnimation("stagger", RhyzaServerAnimations.stagger);
        this.animationPlayer.registerAnimation("topple", RhyzaServerAnimations.topple);
        this.animationPlayer.registerAnimation("leap", RhyzaServerAnimations.leap);
        this.animationPlayer.registerAnimation("flash", RhyzaServerAnimations.flash);
        this.animationPlayer.registerAnimation("frenzy_start", RhyzaServerAnimations.frenzy_start);
        this.animationPlayer.registerAnimation("frenzy_left", RhyzaServerAnimations.frenzy_left);
        this.animationPlayer.registerAnimation("frenzy_left_to_right", RhyzaServerAnimations.frenzy_left_to_right);
        this.animationPlayer.registerAnimation("frenzy_right", RhyzaServerAnimations.frenzy_right);
        this.animationPlayer.registerAnimation("frenzy_right_to_left", RhyzaServerAnimations.frenzy_right_to_left);
        this.animationPlayer.registerAnimation("frenzy_left_finish", RhyzaServerAnimations.frenzy_left_finish);
        this.animationPlayer.registerAnimation("frenzy_right_finish", RhyzaServerAnimations.frenzy_right_finish);
        this.animationPlayer.registerAnimation("tail_cut", RhyzaServerAnimations.tail_cut);
        this.animationPlayer.registerAnimation("test", RhyzaServerAnimations.test);
    }

    @Override
    protected String getBoneNameForPart(LargeMonsterPartEntity<?> part) {
        if (part == this.head) {
            return "head";
        }
        if (part == this.right_tail) {
            return "right_tail";
        }
        if (part == this.right_tail_1) {
            return "right_tail_1";
        }
        if (part == this.right_tail_2) {
            return "right_tail_2";
        }
        if (part == this.right_tail_3) {
            return "right_tail_3";
        }
        if (part == this.right_tail_4) {
            return "right_tail_4";
        }
        if (part == this.left_tail) {
            return "left_tail";
        }
        if (part == this.left_tail_1) {
            return "left_tail_1";
        }
        if (part == this.left_tail_2) {
            return "left_tail_2";
        }
        if (part == this.left_tail_3) {
            return "left_tail_3";
        }
        if (part == this.left_tail_4) {
            return "left_tail_4";
        }
        return null;
    }

    @Override
    protected Map<String, String> getBoneHierarchy() {
        return RHYZA_HIERARCHY;
    }

    @Override
    protected Map<String, Vec3> getDefaultOffsets() {
        return RHYZA_DEFAULT_OFFSETS;
    }

    @Override
    protected Map<String, Vec3> getDefaultRotations() {
        return RHYZA_DEFAULT_ROTATIONS;
    }

    @Override
    protected void setupAnimationStates() {
        this.idleAnimation();
        this.runAnimation();
        this.slashAnimation();
        this.backslashAnimation();
        this.tailswipeAnimation();
        this.rushAnimation();
        this.slamAnimation();
        this.rightSlashAnimation();
        this.dashAnimation();
        this.enrageAnimation();
        this.invisibilityAnimation();
        this.staggerAnimation();
        this.toppleAnimation();
        this.leapAnimation();
        this.flashAnimation();
        this.frenzyAnimation();
        this.tailCutAnimation();
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING && !this.isAttacking() && this.m_20096_() ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    private void idleAnimation() {
    }

    private void runAnimation() {
    }

    private void slashAnimation() {
        if (this.getCurrentAbility() == Ability.SLASH) {
            if (!this.slashAnimation.m_216984_()) {
                this.slashAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("slash", 1.0f);
            }
        } else {
            this.slashAnimation.m_216973_();
            this.animationPlayer.stopAnimation("slash");
        }
    }

    private void backslashAnimation() {
        if (this.getCurrentAbility() == Ability.BACKSLASH) {
            if (!this.backslashAnimation.m_216984_()) {
                this.backslashAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("backslash", 1.0f);
            }
        } else {
            this.backslashAnimation.m_216973_();
            this.animationPlayer.stopAnimation("backslash");
        }
    }

    private void tailswipeAnimation() {
        if (this.getCurrentAbility() == Ability.TAILSWIPE) {
            if (!this.tailswipeAnimation.m_216984_()) {
                this.tailswipeAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("tailswipe", 1.0f);
            }
        } else {
            this.tailswipeAnimation.m_216973_();
            this.animationPlayer.stopAnimation("tailswipe");
        }
    }

    private void rushAnimation() {
        if (this.getCurrentAbility() == Ability.RUSH) {
            if (!this.rushAnimation.m_216984_()) {
                this.rushAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("rush", 1.0f);
            }
        } else {
            this.rushAnimation.m_216973_();
            this.animationPlayer.stopAnimation("rush");
        }
    }

    private void slamAnimation() {
        if (this.getCurrentAbility() == Ability.SLAM) {
            if (!this.slamAnimation.m_216984_()) {
                this.slamAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("slam", 1.0f);
            }
        } else {
            this.slamAnimation.m_216973_();
            this.animationPlayer.stopAnimation("slam");
        }
    }

    private void rightSlashAnimation() {
        if (this.getCurrentAbility() == Ability.RIGHT_SLASH) {
            if (!this.rightSlashAnimation.m_216984_()) {
                this.rightSlashAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("right_slash", 1.0f);
            }
        } else {
            this.rightSlashAnimation.m_216973_();
            this.animationPlayer.stopAnimation("right_slash");
        }
    }

    private void dashAnimation() {
        if (this.getCurrentAbility() == Ability.DASH) {
            if (!this.dashAnimation.m_216984_()) {
                this.dashAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("dash", 0.8f);
            }
        } else {
            this.dashAnimation.m_216973_();
            this.animationPlayer.stopAnimation("dash");
        }
    }

    private void enrageAnimation() {
        if (this.getCurrentAbility() == Ability.ENRAGE) {
            if (!this.enrageAnimation.m_216984_()) {
                this.enrageAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("enrage", 1.0f);
            }
        } else {
            this.enrageAnimation.m_216973_();
            this.animationPlayer.stopAnimation("enrage");
        }
    }

    private void invisibilityAnimation() {
        if (this.getCurrentAbility() == Ability.INVISIBILITY) {
            if (!this.sideWalkAnimation.m_216984_()) {
                this.sideWalkAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("side_walk", 1.0f);
            }
        } else {
            this.sideWalkAnimation.m_216973_();
            this.animationPlayer.stopAnimation("side_walk");
        }
    }

    private void staggerAnimation() {
        if (this.getCurrentStaggerState() == StaggerState.STAGGER) {
            if (!this.staggerAnimation.m_216984_()) {
                this.staggerAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("stagger", 0.8f);
            }
        } else {
            this.staggerAnimation.m_216973_();
            this.animationPlayer.stopAnimation("stagger");
        }
    }

    private void toppleAnimation() {
        if (this.getCurrentStaggerState() == StaggerState.TOPPLE) {
            if (!this.toppleAnimation.m_216984_()) {
                this.toppleAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("topple", 0.8f);
            }
        } else {
            this.toppleAnimation.m_216973_();
            this.animationPlayer.stopAnimation("topple");
        }
    }

    private void leapAnimation() {
        if (this.getCurrentAbility() == Ability.LEAP) {
            if (!this.leapAnimation.m_216984_()) {
                this.leapAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("leap", 1.0f);
            }
        } else {
            this.leapAnimation.m_216973_();
            this.animationPlayer.stopAnimation("leap");
        }
    }

    private void flashAnimation() {
        if (this.getCurrentAbility() == Ability.FLASH) {
            if (!this.flashAnimation.m_216984_()) {
                this.flashAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("flash", 1.0f);
            }
        } else {
            this.flashAnimation.m_216973_();
            this.animationPlayer.stopAnimation("flash");
        }
    }

    private void frenzyAnimation() {
        if (this.getCurrentAbility() == Ability.FRENZY && this.getFrenzyState() == FrenzyState.START.ordinal()) {
            if (!this.frenzyStartAnimation.m_216984_()) {
                this.frenzyStartAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("frenzy_start", 1.0f);
            }
        } else {
            this.frenzyStartAnimation.m_216973_();
            this.animationPlayer.stopAnimation("frenzy_start");
        }
        if (this.getCurrentAbility() == Ability.FRENZY && this.getFrenzyState() == FrenzyState.LEFT.ordinal()) {
            if (!this.frenzyLeftAnimation.m_216984_()) {
                this.frenzyLeftAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("frenzy_left", 1.0f);
            }
        } else {
            this.frenzyLeftAnimation.m_216973_();
            this.animationPlayer.stopAnimation("frenzy_left");
        }
        if (this.getCurrentAbility() == Ability.FRENZY && this.getFrenzyState() == FrenzyState.LEFT_TO_RIGHT.ordinal()) {
            if (!this.frenzyLeftToRightAnimation.m_216984_()) {
                this.frenzyLeftToRightAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("frenzy_left_to_right", 1.0f);
            }
        } else {
            this.frenzyLeftToRightAnimation.m_216973_();
            this.animationPlayer.stopAnimation("frenzy_left_to_right");
        }
        if (this.getCurrentAbility() == Ability.FRENZY && this.getFrenzyState() == FrenzyState.RIGHT.ordinal()) {
            if (!this.frenzyRightAnimation.m_216984_()) {
                this.frenzyRightAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("frenzy_right", 1.0f);
            }
        } else {
            this.frenzyRightAnimation.m_216973_();
            this.animationPlayer.stopAnimation("frenzy_right");
        }
        if (this.getCurrentAbility() == Ability.FRENZY && this.getFrenzyState() == FrenzyState.RIGHT_TO_LEFT.ordinal()) {
            if (!this.frenzyRightToLeftAnimation.m_216984_()) {
                this.frenzyRightToLeftAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("frenzy_right_to_left", 1.0f);
            }
        } else {
            this.frenzyRightToLeftAnimation.m_216973_();
            this.animationPlayer.stopAnimation("frenzy_right_to_left");
        }
        if (this.getCurrentAbility() == Ability.FRENZY && this.getFrenzyState() == FrenzyState.LEFT_FINISH.ordinal()) {
            if (!this.frenzyLeftFinishAnimation.m_216984_()) {
                this.frenzyLeftFinishAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("frenzy_left_finish", 1.0f);
            }
        } else {
            this.frenzyLeftFinishAnimation.m_216973_();
            this.animationPlayer.stopAnimation("frenzy_left_finish");
        }
        if (this.getCurrentAbility() == Ability.FRENZY && this.getFrenzyState() == FrenzyState.RIGHT_FINISH.ordinal()) {
            if (!this.frenzyRightFinishAnimation.m_216984_()) {
                this.frenzyRightFinishAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("frenzy_right_finish", 1.0f);
            }
        } else {
            this.frenzyRightFinishAnimation.m_216973_();
            this.animationPlayer.stopAnimation("frenzy_right_finish");
        }
    }

    private void tailCutAnimation() {
        if (this.getCurrentStaggerState() == StaggerState.TAIL_CUT) {
            if (!this.tailCutAnimation.m_216984_()) {
                this.tailCutAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("tail_cut", 0.8f);
            }
        } else {
            this.tailCutAnimation.m_216973_();
            this.animationPlayer.stopAnimation("tail_cut");
        }
    }

    @Override
    public Ability getNoneAbility() {
        return Ability.NONE;
    }

    @Override
    public StaggerState getNoneStagger() {
        return StaggerState.NONE;
    }

    @Override
    public void setStaggerForFlash() {
        this.setCurrentStaggerState(StaggerState.STAGGER);
    }

    @Override
    public void setToppleForFlashIfAerial() {
    }

    protected void m_6135_() {
        double jumpStrength = this.m_21133_(Attributes.f_22288_);
        Vec3 motion = this.m_20184_();
        this.m_20334_(motion.f_82479_, jumpStrength * (double)this.m_20098_(), motion.f_82481_);
        this.f_19812_ = true;
    }

    @Override
    protected SoundEvent getMusic() {
        return (SoundEvent)ModSounds.RHYZA_THEME.get();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public boolean isRunning() {
        return (Boolean)this.f_19804_.m_135370_(RUNNING);
    }

    public void setRunning(boolean pRunning) {
        this.f_19804_.m_135381_(RUNNING, (Object)pRunning);
    }

    public boolean trySlash() {
        if (this.m_5448_() == null) {
            return false;
        }
        boolean isTargetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 2.0), 8.0, 9.0, 6.0);
        return isTargetInZone && !this.isAttacking() && this.f_19797_ - this.lastSlash >= 70;
    }

    public BehaviorStatus startSlash() {
        this.lastSlash = this.f_19797_;
        this.setCurrentAbility(Ability.SLASH);
        return BehaviorStatus.SUCCESS;
    }

    public boolean tryBackslash() {
        if (this.m_5448_() == null) {
            return false;
        }
        boolean zone1 = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, -6.0), 8.0, 10.0, 4.0);
        boolean zone2 = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 2.0), 10.0, 10.0, 4.0);
        boolean isTargetInZone = zone1 || zone2;
        return isTargetInZone && !this.isAttacking() && this.f_19797_ - this.lastBackslash >= 70;
    }

    public BehaviorStatus startBackslash() {
        this.lastBackslash = this.f_19797_;
        this.setCurrentAbility(Ability.BACKSLASH);
        return BehaviorStatus.SUCCESS;
    }

    public boolean tryTailswipe() {
        if (this.m_5448_() == null) {
            return false;
        }
        boolean isTargetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 3.0), 4.0, 6.0, 4.0);
        return isTargetInZone && !this.isAttacking() && this.f_19797_ - this.lastTailswipe >= 200;
    }

    public BehaviorStatus startTailswipe() {
        this.lastTailswipe = this.f_19797_;
        this.setCurrentAbility(Ability.TAILSWIPE);
        return BehaviorStatus.SUCCESS;
    }

    public boolean tryRush() {
        if (this.m_5448_() == null) {
            return false;
        }
        boolean isTargetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 10.0), 4.0, 6.0, 4.0);
        return isTargetInZone && !this.isAttacking() && this.f_19797_ - this.lastRush >= 140;
    }

    public BehaviorStatus startRush() {
        this.lastRush = this.f_19797_;
        this.setCurrentAbility(Ability.RUSH);
        return BehaviorStatus.SUCCESS;
    }

    public boolean trySlam() {
        if (this.m_5448_() == null) {
            return false;
        }
        boolean isTargetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 8.0), 4.0, 6.0, 4.0);
        return isTargetInZone && !this.isAttacking() && this.f_19797_ - this.lastSlam >= 70;
    }

    public BehaviorStatus startSlam() {
        this.lastSlam = this.f_19797_;
        this.setCurrentAbility(Ability.SLAM);
        return BehaviorStatus.SUCCESS;
    }

    public boolean tryRightSlash() {
        if (this.m_5448_() == null) {
            return false;
        }
        boolean isTargetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, -3.0), 8.0, 6.0, 4.0);
        return isTargetInZone && !this.isAttacking() && this.f_19797_ - this.lastRightSlash >= 70;
    }

    public BehaviorStatus startRightSlash() {
        this.lastRightSlash = this.f_19797_;
        this.setCurrentAbility(Ability.RIGHT_SLASH);
        return BehaviorStatus.SUCCESS;
    }

    public boolean tryDash() {
        if (this.m_5448_() == null || this.isStuckForLongerThan(6)) {
            return false;
        }
        return this.m_20280_((Entity)this.m_5448_()) < 225.0 && !this.isAttacking() && this.f_19797_ - this.lastDash >= 200;
    }

    public BehaviorStatus startDash() {
        this.lastDash = this.f_19797_;
        this.setCurrentAbility(Ability.DASH);
        return BehaviorStatus.SUCCESS;
    }

    public boolean tryInvisibility() {
        if (this.m_5448_() == null) {
            return false;
        }
        return this.isEnraged() && this.m_20280_((Entity)this.m_5448_()) < 400.0 && !this.isAttacking() && this.f_19797_ - this.lastInvisibility >= 700;
    }

    public BehaviorStatus startInvisibility() {
        this.lastInvisibility = this.f_19797_;
        this.setCurrentAbility(Ability.INVISIBILITY);
        return BehaviorStatus.SUCCESS;
    }

    public boolean tryLeap() {
        if (this.m_5448_() == null || !this.isEnraged()) {
            return false;
        }
        boolean isTargetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 15.0), 8.0, 8.0, 8.0);
        return isTargetInZone && !this.isAttacking() && this.f_19797_ - this.lastLeap >= 140;
    }

    public BehaviorStatus startLeap() {
        this.lastLeap = this.f_19797_;
        this.setCurrentAbility(Ability.LEAP);
        return BehaviorStatus.SUCCESS;
    }

    public boolean tryFlash() {
        if (this.m_5448_() == null || !this.isEnraged()) {
            return false;
        }
        return this.m_20280_((Entity)this.m_5448_()) < 625.0 && !this.isAttacking() && this.f_19797_ - this.lastFlash >= 700;
    }

    public BehaviorStatus startFlash() {
        this.lastFlash = this.f_19797_;
        this.setCurrentAbility(Ability.FLASH);
        return BehaviorStatus.SUCCESS;
    }

    public boolean tryFrenzy() {
        if (this.m_5448_() == null) {
            return false;
        }
        boolean isTargetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 3.0), 8.0, 6.0, 6.0);
        return isTargetInZone && !this.isAttacking() && this.f_19797_ - this.lastFrenzy >= 300;
    }

    public BehaviorStatus startFrenzy() {
        this.lastFrenzy = this.f_19797_;
        this.setCurrentAbility(Ability.FRENZY);
        return BehaviorStatus.SUCCESS;
    }

    public int getFadeTicks() {
        return (Integer)this.f_19804_.m_135370_(FADE_TICKS);
    }

    public void setFadeTicks(int ticks) {
        this.f_19804_.m_135381_(FADE_TICKS, (Object)ticks);
    }

    public boolean m_20145_() {
        return (Boolean)this.f_19804_.m_135370_(INVISIBLE);
    }

    public void m_6842_(boolean invisible) {
        this.f_19804_.m_135381_(INVISIBLE, (Object)invisible);
        if (invisible) {
            this.invisibilityDurationTicks = 150;
        }
    }

    public int getFrenzyState() {
        return (Integer)this.f_19804_.m_135370_(FRENZY_STATE);
    }

    public void setFrenzyState(int state) {
        this.f_19804_.m_135381_(FRENZY_STATE, (Object)state);
    }

    @Override
    public boolean isFlashable() {
        return false;
    }

    public void m_7023_(Vec3 pTravelVector) {
        IFlyingMonster flyer;
        RhyzaEntity rhyzaEntity;
        LivingEntity livingEntity;
        if (!this.m_20160_() || !((livingEntity = this.m_6688_()) instanceof Player)) {
            super.m_7023_(pTravelVector);
            return;
        }
        Player passenger = (Player)livingEntity;
        float forward = passenger.f_20902_;
        float strafe = passenger.f_20900_ * 0.5f;
        if (forward <= 0.0f) {
            forward *= 0.25f;
        }
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            if (this.m_6109_() && Minecraft.m_91087_().f_91066_.f_92089_.m_90857_()) {
                this.m_6862_(true);
            } else {
                this.m_6862_(false);
            }
        }
        if ((rhyzaEntity = this) instanceof IFlyingMonster && (flyer = (IFlyingMonster)((Object)rhyzaEntity)).isAerial()) {
            this.m_7910_((float)this.m_21133_(Attributes.f_22280_));
        } else if (this.m_6109_() && Minecraft.m_91087_().f_91066_.f_92091_.m_90857_()) {
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * 2.0f);
            this.setRunning(true);
        } else {
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * 0.75f);
            this.setRunning(false);
        }
        Vec3 finalTravelVector = new Vec3((double)strafe, pTravelVector.f_82480_, (double)forward);
        super.m_7023_(finalTravelVector);
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return this.m_217043_().m_188500_() >= 0.5;
    }

    public boolean isRightTailPart(RhyzaPartEntity part) {
        return part == this.right_tail || part == this.right_tail_1 || part == this.right_tail_2 || part == this.right_tail_3 || part == this.right_tail_4;
    }

    public boolean isLeftTailPart(RhyzaPartEntity part) {
        return part == this.left_tail || part == this.left_tail_1 || part == this.left_tail_2 || part == this.left_tail_3 || part == this.left_tail_4;
    }

    public boolean isRightTailCut() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT_TAIL_CUT);
    }

    public void setRightTailCut(boolean rightTailCut) {
        this.f_19804_.m_135381_(RIGHT_TAIL_CUT, (Object)rightTailCut);
    }

    public boolean isLeftTailCut() {
        return (Boolean)this.f_19804_.m_135370_(LEFT_TAIL_CUT);
    }

    public void setLeftTailCut(boolean leftTailCut) {
        this.f_19804_.m_135381_(LEFT_TAIL_CUT, (Object)leftTailCut);
    }

    @Override
    public boolean isAttackAbility() {
        Ability ability = (Ability)this.getCurrentAbility();
        return ability != Ability.DASH && ability != Ability.STAGGER && ability != Ability.INVISIBILITY && ability != Ability.ENRAGE && ability != Ability.NONE;
    }

    public static enum Ability implements IMonsterAbilities<Ability>
    {
        NONE,
        SLASH,
        BACKSLASH,
        TAILSWIPE,
        RUSH,
        SLAM,
        RIGHT_SLASH,
        DASH,
        ENRAGE,
        INVISIBILITY,
        STAGGER,
        LEAP,
        FLASH,
        FRENZY;


        @Override
        public int getOrdinal() {
            return this.ordinal();
        }

        @Override
        public Ability getNone() {
            return NONE;
        }
    }

    public static enum StaggerState implements IMonsterStaggers<StaggerState>
    {
        NONE,
        STAGGER,
        TOPPLE,
        TAIL_CUT;

    }

    public static enum FrenzyState {
        NONE,
        START,
        LEFT,
        RIGHT,
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT,
        RIGHT_FINISH,
        LEFT_FINISH;

    }
}

