/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.custom;

import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import org.jetbrains.annotations.NotNull;

public abstract class LargeMonsterPartEntity<T extends AbstractLargeMonster>
extends LivingEntity {
    public T parent;
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.m_135353_(LargeMonsterPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> DATA_WIDTH = SynchedEntityData.m_135353_(LargeMonsterPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_HEIGHT = SynchedEntityData.m_135353_(LargeMonsterPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public LargeMonsterPartEntity(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.parent = null;
    }

    public LargeMonsterPartEntity(EntityType<? extends LivingEntity> type, T parent, float width, float height) {
        super(type, parent.m_9236_());
        this.parent = parent;
        this.f_19804_.m_135381_(DATA_WIDTH, (Object)Float.valueOf(width));
        this.f_19804_.m_135381_(DATA_HEIGHT, (Object)Float.valueOf(height));
        this.f_19804_.m_135381_(PARENT_UUID, Optional.of(parent.m_20148_()));
        this.m_6210_();
        this.m_20242_(true);
        this.f_19794_ = true;
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        return this.parent != null && !this.m_6673_(pSource) && ((AbstractLargeMonster)this.parent).onPartAttacked(this, pSource, pAmount);
    }

    public boolean m_6673_(DamageSource pSource) {
        return pSource == this.m_269291_().m_269318_() || pSource == this.m_269291_().m_269354_() || super.m_6673_(pSource);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_WIDTH, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_HEIGHT, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(PARENT_UUID, Optional.empty());
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_WIDTH.equals(pKey) || DATA_HEIGHT.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 10) {
            if (this.parent == null) {
                ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).ifPresent(uuid -> {
                    Player parentEntity = this.m_9236_().m_46003_(uuid);
                    if (parentEntity instanceof AbstractLargeMonster) {
                        this.parent = (AbstractLargeMonster)parentEntity;
                    }
                });
            }
            if (!(this.parent != null && this.parent.m_6084_() || this.m_9236_().f_46443_)) {
                this.m_146870_();
            }
        }
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        return EntityDimensions.m_20395_((float)((Float)this.f_19804_.m_135370_(DATA_WIDTH)).floatValue(), (float)((Float)this.f_19804_.m_135370_(DATA_HEIGHT)).floatValue());
    }

    public void m_8107_() {
        if (this.f_20903_ > 0) {
            double d0 = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
            double d2 = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
            double d4 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
            double d6 = Mth.m_14175_((double)(this.f_20907_ - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d6 / (float)this.f_20903_);
            this.m_146926_(this.m_146909_() + (float)(this.f_20908_ - (double)this.m_146909_()) / (float)this.f_20903_);
            --this.f_20903_;
            this.m_6034_(d0, d2, d4);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        if (this.f_20934_ > 0) {
            this.f_20885_ += (float)Mth.m_14175_((double)(this.f_20933_ - (double)this.f_20885_)) / (float)this.f_20934_;
            --this.f_20934_;
        }
    }

    protected void m_7324_(Entity pEntity) {
        if (pEntity == this) {
            return;
        }
        if (pEntity == this.parent) {
            return;
        }
        if (!pEntity.m_6094_()) {
            return;
        }
        double dx = pEntity.m_20185_() - this.m_20185_();
        double dz = pEntity.m_20189_() - this.m_20189_();
        double distSqr = dx * dx + dz * dz;
        double collisionRadius = (double)this.m_20205_() / 2.0 + (double)pEntity.m_20205_() / 2.0 + 0.4;
        if (distSqr > 0.01 && distSqr < collisionRadius * collisionRadius) {
            double dist = Mth.m_14116_((float)((float)distSqr));
            double strength = 0.4;
            Vec3 bossVel = this.m_20184_();
            pEntity.m_20334_(bossVel.f_82479_ * 0.2 + (dx /= dist) * strength, 0.2, bossVel.f_82481_ * 0.2 + (dz /= dist) * strength);
            pEntity.f_19812_ = true;
        }
    }

    public boolean m_6094_() {
        return false;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_7306_(@NotNull Entity pEntity) {
        return this == pEntity || this.parent == pEntity;
    }

    public boolean m_142391_() {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        return false;
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean m_6040_() {
        return true;
    }
}

