/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.custom;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkHooks;
import net.saksolm.monsterexpansion.capabilities.ModCapabilities;
import net.saksolm.monsterexpansion.compat.EpicFightCompat;
import net.saksolm.monsterexpansion.effect.ModEffects;
import net.saksolm.monsterexpansion.entity.ai.HealPunishGoal;
import net.saksolm.monsterexpansion.entity.ai.HighestThreatTargetGoal;
import net.saksolm.monsterexpansion.entity.ai.LargeMonsterNearestAttackableTargetGoal;
import net.saksolm.monsterexpansion.entity.ai.LargeMonsterWanderGoal;
import net.saksolm.monsterexpansion.entity.ai.SwitchTargetGoal;
import net.saksolm.monsterexpansion.entity.ai.control.BigMobMoveControl;
import net.saksolm.monsterexpansion.entity.ai.control.BigMobPathNavigate;
import net.saksolm.monsterexpansion.entity.animations.hitbox.AnimationPlayer;
import net.saksolm.monsterexpansion.entity.custom.DamageInfo;
import net.saksolm.monsterexpansion.entity.custom.IBehavioralEntity;
import net.saksolm.monsterexpansion.entity.custom.IFlyingMonster;
import net.saksolm.monsterexpansion.entity.custom.KobekoEntity;
import net.saksolm.monsterexpansion.entity.custom.LargeMonsterPartEntity;
import net.saksolm.monsterexpansion.entity.custom.effect.HeavingGroundEffectEntity;
import net.saksolm.monsterexpansion.entity.custom.effect.ShockwaveEntity;
import net.saksolm.monsterexpansion.entity.custom.effect.SmashedGroundEffectEntity;
import net.saksolm.monsterexpansion.entity.util.DamageTypes;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.SoundPacket;
import net.saksolm.monsterexpansion.particles.options.BigDustParticleOptions;
import net.saksolm.monsterexpansion.particles.options.DebrisParticleOptions;
import net.saksolm.monsterexpansion.particles.options.DustParticleOptions;
import net.saksolm.monsterexpansion.screen.MonsterMenu;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLargeMonster<T extends Enum<T>, S extends Enum<S>>
extends TamableAnimal
implements PlayerRideable,
MenuProvider,
IBehavioralEntity<T> {
    protected final Map<UUID, Float> threatMap = Maps.newHashMap();
    protected final Map<UUID, ThreatModifier> temporaryThreats = new HashMap<UUID, ThreatModifier>();
    private static final float THREAT_DECAY_FACTOR = 0.98f;
    private static final float THREAT_DECAY_FACTOR_NO_LOS = 0.95f;
    private static final double THREAT_DECAY_RANGE_SQUARED = 1600.0;
    protected int ignoreHighestThreatTimer = 0;
    protected boolean isProcessingPartDamage = false;
    private final Set<UUID> playersWithMusic = new HashSet<UUID>();
    protected final String BODY_PART_NAME = "body";
    protected static final EntityDataAccessor<Float> TARGET_YAW = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> TARGET_PITCH = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> TURN_DURATION = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> TURN_DIRECTION = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Boolean> MANUAL_ROTAION = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> SMOOTH_ROTATION = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Float> ROTATION_START_YAW = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> ROTATION_START_YAW_BODY = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> ROTATION_TICK_COUNT = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> TRACKING_MODE = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Integer> TRACKING_TARGET_ID = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> TRACKING_DURATION = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vec3 trackingPositionTarget;
    private float maxTurnSpeed;
    protected final Queue<DamageInfo> damageQueue = new ConcurrentLinkedQueue<DamageInfo>();
    protected boolean isApplyingQueuedDamage = false;
    protected int lastHurtTick = 0;
    protected int stuckTimer = 0;
    protected Vec3 lastStuckCheckPosition;
    protected static final EntityDataAccessor<Boolean> IS_RIDER_ASCENDING = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_RIDER_DESCENDING = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Byte> TAMED_BEHAVIOR = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> TAMED_STANCE = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected final Map<LargeMonsterPartEntity<?>, Vec3> additivePartOffsets = new HashMap();
    protected final Set<LargeMonsterPartEntity<?>> activeDamageParts = new HashSet();
    protected final List<LivingEntity> hitEntitiesThisAttack = new ArrayList<LivingEntity>();
    protected boolean wantsToEnrage = false;
    protected float damageUntilEnrage;
    protected int enrageDurationTicks = 0;
    protected static final EntityDataAccessor<Boolean> ENRAGED = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> ENRAGED_ABILITY = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected final Map<String, Float> partHealths = new HashMap<String, Float>();
    protected final Map<String, Float> partMaxHealths = new HashMap<String, Float>();
    protected final Set<String> brokenParts = new HashSet<String>();
    protected int staggerCount = 0;
    protected int toppleCount = 0;
    protected boolean hasDroppedToppleLoot = false;
    protected final Map<String, Map<DamageTypes.WeaponType, Float>> partRawHitzones = new HashMap<String, Map<DamageTypes.WeaponType, Float>>();
    protected final Map<String, Map<DamageTypes.ElementType, Float>> partElementalHitzones = new HashMap<String, Map<DamageTypes.ElementType, Float>>();
    protected int flashProgress = 0;
    protected int flashThreshold = 1;
    Vec3 lastTargetPosition = Vec3.f_82478_;
    Vec3 targetVelocity = Vec3.f_82478_;
    LivingEntity lastTrackedTarget = null;
    protected T lastUsedAbility = null;
    protected int lastAbilityTick = 0;
    protected final Class<T> abilityClass;
    protected final Class<S> staggerClass;
    protected static final EntityDataAccessor<Integer> ABILITY_STATE = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> STAGGER_STATE = SynchedEntityData.m_135353_(AbstractLargeMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationPlayer animationPlayer;

    protected AbstractLargeMonster(EntityType<? extends AbstractLargeMonster> entityType, Level world, Class<T> abilityClass, Class<S> staggerClass) {
        super(entityType, world);
        this.abilityClass = abilityClass;
        this.staggerClass = staggerClass;
        this.lastStuckCheckPosition = Vec3.f_82478_;
        this.damageUntilEnrage = this.m_21233_() * 0.25f;
        this.f_21344_ = new BigMobPathNavigate((Mob)this, world);
        this.f_21342_ = new BigMobMoveControl((Mob)this);
        this.m_274367_(3.0f);
        this.animationPlayer = new AnimationPlayer(this.getBoneHierarchy(), this.getDefaultOffsets(), this.getDefaultRotations());
        if (!this.m_9236_().m_5776_()) {
            this.registerServerAnimations();
        }
    }

    protected void m_8099_() {
        if (!this.m_21824_() || this.m_21824_() && this.getTamedStance() == TamedStance.WANDERING) {
            this.f_21345_.m_25352_(0, (Goal)new LargeMonsterWanderGoal((PathfinderMob)this, 1.0));
        }
        if (!this.m_21824_() || this.m_21824_() && this.getTamedBehavior() != TamedBehavior.PASSIVE) {
            this.f_21346_.m_25352_(2, (Goal)new HealPunishGoal(this));
            this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
            this.f_21346_.m_25352_(4, (Goal)new HighestThreatTargetGoal(this));
            this.f_21346_.m_25352_(5, (Goal)new SwitchTargetGoal(this));
            this.f_21346_.m_25352_(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
            this.f_21346_.m_25352_(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        }
        if (this.m_21824_() && this.getTamedBehavior() == TamedBehavior.AGGRESSIVE) {
            this.f_21346_.m_25352_(3, new LargeMonsterNearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, true));
        }
        if (this.m_21824_() && this.getTamedStance() == TamedStance.SITTING) {
            this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        }
    }

    protected abstract Map<String, String> getBoneHierarchy();

    protected abstract Map<String, Vec3> getDefaultOffsets();

    protected abstract Map<String, Vec3> getDefaultRotations();

    protected abstract String getBoneNameForPart(LargeMonsterPartEntity<?> var1);

    public abstract LargeMonsterPartEntity<?>[] getBodyParts();

    protected abstract void onPartBroken(String var1, DamageSource var2);

    protected abstract List<String> getLogicalPartNamesFor(LargeMonsterPartEntity<?> var1);

    protected abstract void onFlashed(DamageSource var1);

    public abstract String getStaggerPartName();

    public abstract float getStaggerPartBaseHealth();

    public abstract boolean isAttackAbility();

    protected abstract void setupAnimationStates();

    @Override
    public abstract T getNoneAbility();

    public abstract S getNoneStagger();

    public abstract void setStaggerForFlash();

    public abstract void setToppleForFlashIfAerial();

    public abstract boolean isFlashable();

    protected abstract void registerServerAnimations();

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new MonsterMenu(pContainerId, pPlayerInventory, this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TURN_DURATION, (Object)0);
        this.f_19804_.m_135372_(TURN_DIRECTION, (Object)((byte)TurnDirection.SHORTEST.ordinal()));
        this.f_19804_.m_135372_(MANUAL_ROTAION, (Object)false);
        this.f_19804_.m_135372_(SMOOTH_ROTATION, (Object)false);
        this.f_19804_.m_135372_(ROTATION_TICK_COUNT, (Object)0);
        this.f_19804_.m_135372_(ROTATION_START_YAW_BODY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_START_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TRACKING_MODE, (Object)((byte)TrackingMode.NONE.ordinal()));
        this.f_19804_.m_135372_(TRACKING_TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(TRACKING_DURATION, (Object)0);
        this.f_19804_.m_135372_(TAMED_BEHAVIOR, (Object)((byte)TamedBehavior.PASSIVE.ordinal()));
        this.f_19804_.m_135372_(TAMED_STANCE, (Object)((byte)TamedStance.WANDERING.ordinal()));
        this.f_19804_.m_135372_(IS_RIDER_ASCENDING, (Object)false);
        this.f_19804_.m_135372_(IS_RIDER_DESCENDING, (Object)false);
        this.f_19804_.m_135372_(ENRAGED_ABILITY, (Object)false);
        this.f_19804_.m_135372_(ENRAGED, (Object)false);
        this.f_19804_.m_135372_(ABILITY_STATE, (Object)0);
        this.f_19804_.m_135372_(STAGGER_STATE, (Object)0);
    }

    public void refreshGoals() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        List<Goal> goalsToRemove = this.f_21345_.m_148105_().stream().map(WrappedGoal::m_26015_).collect(Collectors.toList());
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)this.f_21345_).m_25363_(arg_0));
        List<Goal> targetersToRemove = this.f_21346_.m_148105_().stream().map(WrappedGoal::m_26015_).collect(Collectors.toList());
        targetersToRemove.forEach(arg_0 -> ((GoalSelector)this.f_21346_).m_25363_(arg_0));
        this.m_8099_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.setupAnimationStates();
        if (this.m_20160_()) {
            Player passenger = (Player)this.m_6688_();
            this.m_146922_(passenger.m_146908_());
            this.m_146926_(passenger.m_146909_() * 0.2f);
            this.f_19859_ = this.m_146908_();
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = this.m_146908_();
            this.f_20885_ = this.m_146908_();
        }
        if (this.isRotationManual()) {
            if (this.getTrackingMode() != TrackingMode.NONE) {
                this.handleTracking();
            } else {
                this.handleRotation();
            }
        }
        if (!this.m_9236_().f_46443_) {
            AbstractLargeMonster abstractLargeMonster;
            if (this.m_20160_() && (abstractLargeMonster = this) instanceof IFlyingMonster) {
                IFlyingMonster flyer = (IFlyingMonster)((Object)abstractLargeMonster);
                if (flyer.isAerial()) {
                    if (this.isRiderDescending() && this.m_20096_()) {
                        flyer.disableFly();
                    }
                } else if (this.isRiderAscending() && this.m_20096_()) {
                    flyer.enableFly();
                }
            }
            if (this.f_19797_ % 20 == 0) {
                this.handleThreatGeneration();
                this.handleThreatDecay();
            }
            this.handlePartBasedDamage();
            this.animationPlayer.tick();
            this.updatePartPositions();
            this.applyQueuedDamage();
            this.updateStuckDetection();
            this.trackTargetVelocity();
            this.handleMusic();
            this.handleEnrage();
            this.updateTemporaryThreats();
        }
    }

    public boolean onPartAttacked(LargeMonsterPartEntity<?> pPart, DamageSource pSource, float pAmount) {
        ItemStack weaponStack;
        List<String> logicalPartNames;
        OwnableEntity ownable;
        if (this.m_6673_(pSource)) {
            return false;
        }
        Entity entity = pSource.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            this.isProcessingPartDamage = true;
            boolean hurtSuccess = this.m_6469_(pSource, pAmount);
            this.isProcessingPartDamage = false;
            return hurtSuccess;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (attacker == this || attacker == this.m_269323_() || this.m_21824_() && attacker instanceof OwnableEntity && (ownable = (OwnableEntity)attacker).m_269323_() == this.m_269323_()) {
            return false;
        }
        float amount = pAmount;
        if (!(attacker instanceof Player) && !(attacker instanceof KobekoEntity)) {
            amount *= 0.2f;
        }
        if ((logicalPartNames = this.getLogicalPartNamesFor(pPart)) == null || logicalPartNames.isEmpty()) {
            this.isProcessingPartDamage = true;
            boolean hurtSuccess = this.m_6469_(pSource, amount);
            this.isProcessingPartDamage = false;
            return hurtSuccess;
        }
        if (attacker instanceof KobekoEntity) {
            KobekoEntity kobeko = (KobekoEntity)attacker;
            weaponStack = kobeko.getWeaponStack();
        } else {
            weaponStack = attacker.m_21205_();
        }
        LazyOptional weaponCap = weaponStack.getCapability(ModCapabilities.WEAPON_DATA);
        DamageTypes.WeaponType weaponType = weaponCap.map(c -> c.getWeaponType(weaponStack)).orElse(DamageTypes.WeaponType.SLASHING);
        DamageTypes.ElementType elementType = weaponCap.map(c -> c.getElementType(weaponStack)).orElse(DamageTypes.ElementType.NONE);
        float weaponElementDamage = weaponCap.map(c -> Float.valueOf(c.getElementalDamage(weaponStack))).orElse(Float.valueOf(0.0f)).floatValue();
        HashMap<String, Float> damageToApplyToParts = new HashMap<String, Float>();
        float totalRawDamageForMainHP = 0.0f;
        float totalElementDamageForMainHP = 0.0f;
        float highestCombinedMultiplier = -1.0f;
        for (String partName : logicalPartNames) {
            float rawMultiplier = this.getRawHitzone(partName, weaponType);
            float elementMultiplier = this.getElementalHitzone(partName, elementType);
            float rawDamageToPart = amount * rawMultiplier;
            float elementDamageToPart = weaponElementDamage * elementMultiplier;
            float totalDamageToPart = rawDamageToPart + elementDamageToPart;
            damageToApplyToParts.put(partName, Float.valueOf(totalDamageToPart));
            float currentCombinedMultiplier = rawMultiplier + elementMultiplier;
            if (!(currentCombinedMultiplier > highestCombinedMultiplier)) continue;
            highestCombinedMultiplier = currentCombinedMultiplier;
            totalRawDamageForMainHP = rawDamageToPart;
            totalElementDamageForMainHP = elementDamageToPart;
        }
        float finalTotalDamageToMainHP = totalRawDamageForMainHP + totalElementDamageForMainHP;
        this.isProcessingPartDamage = true;
        boolean hurtSuccess = this.m_6469_(pSource, finalTotalDamageToMainHP);
        this.isProcessingPartDamage = false;
        if (hurtSuccess) {
            for (Map.Entry entry : damageToApplyToParts.entrySet()) {
                this.applyDamageToPart((String)entry.getKey(), ((Float)entry.getValue()).floatValue(), pSource);
            }
        }
        return hurtSuccess;
    }

    protected void registerRawHitzone(String partName, DamageTypes.WeaponType type, float multiplier) {
        this.partRawHitzones.computeIfAbsent(partName, k -> new EnumMap(DamageTypes.WeaponType.class)).put(type, Float.valueOf(multiplier));
    }

    protected float getRawHitzone(String partName, DamageTypes.WeaponType type) {
        return this.partRawHitzones.getOrDefault(partName, Collections.emptyMap()).getOrDefault((Object)type, Float.valueOf(0.4f)).floatValue();
    }

    protected void registerElementalHitzone(String partName, DamageTypes.ElementType type, float multiplier) {
        this.partElementalHitzones.computeIfAbsent(partName, k -> new EnumMap(DamageTypes.ElementType.class)).put(type, Float.valueOf(multiplier));
    }

    protected float getElementalHitzone(String partName, DamageTypes.ElementType type) {
        return this.partElementalHitzones.getOrDefault(partName, Collections.emptyMap()).getOrDefault((Object)type, Float.valueOf(0.15f)).floatValue();
    }

    private void handlePartBasedDamage() {
        if (this.activeDamageParts.isEmpty()) {
            return;
        }
        for (LargeMonsterPartEntity<?> part : this.activeDamageParts) {
            List targets = this.m_9236_().m_45976_(LivingEntity.class, part.m_20191_());
            for (LivingEntity target : targets) {
                OwnableEntity ownable;
                if (target == this || target == this.m_269323_() || this.hitEntitiesThisAttack.contains(target) || this.m_21824_() && target instanceof OwnableEntity && (ownable = (OwnableEntity)target).m_269323_() == this.m_269323_() || !this.hurtByPart(target)) continue;
                this.hitEntitiesThisAttack.add(target);
            }
        }
    }

    protected boolean hurtByPart(LivingEntity target) {
        return this.applyDamageToTarget(target, 1.0f, KnockbackType.NONE, 1.0, true, false, 0);
    }

    protected void handleThreatGeneration() {
        AABB proximityBox = this.m_20191_().m_82400_(8.0);
        List nearbyPlayers = this.m_9236_().m_6443_(Player.class, proximityBox, player -> !player.m_7500_() && !player.m_5833_() && this.m_142582_((Entity)player));
        for (Player player2 : nearbyPlayers) {
            this.addThreat(player2.m_20148_(), 1.0f);
        }
    }

    protected void handleThreatDecay() {
        if (this.threatMap.isEmpty()) {
            return;
        }
        if (this.ignoreHighestThreatTimer > 0) {
            --this.ignoreHighestThreatTimer;
        }
        this.threatMap.entrySet().removeIf(entry -> {
            float newThreat;
            UUID uuid = (UUID)entry.getKey();
            float currentThreat = ((Float)entry.getValue()).floatValue();
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(uuid);
            if (entity == null || !entity.m_6084_()) {
                return true;
            }
            float decayFactor = 1.0f;
            if (this.m_20280_(entity) > 1600.0) {
                decayFactor = 0.98f;
            }
            if (!this.m_142582_(entity)) {
                decayFactor = Math.min(decayFactor, 0.95f);
            }
            if ((newThreat = currentThreat * decayFactor) < currentThreat) {
                if (newThreat <= 0.1f) {
                    return true;
                }
                entry.setValue(Float.valueOf(newThreat));
            }
            return false;
        });
    }

    protected void updatePartPositions() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        for (LargeMonsterPartEntity<?> part : this.getBodyParts()) {
            String boneName = this.getBoneNameForPart(part);
            if (boneName == null) continue;
            Vec3 finalOffset = this.animationPlayer.getAbsolutePartPosition(boneName);
            this.positionPart(part, finalOffset);
        }
    }

    protected void handleMusic() {
        ServerPlayer player;
        HashSet<UUID> playersWhoShouldHaveMusic = new HashSet<UUID>();
        for (UUID playerUUID : this.threatMap.keySet()) {
            player = (ServerPlayer)this.m_9236_().m_46003_(playerUUID);
            if (player == null || !(this.m_20280_((Entity)player) <= 3600.0) || !player.m_6084_()) continue;
            playersWhoShouldHaveMusic.add(playerUUID);
        }
        for (UUID playerUUID : playersWhoShouldHaveMusic) {
            if (this.playersWithMusic.contains(playerUUID) || (player = (ServerPlayer)this.m_9236_().m_46003_(playerUUID)) == null) continue;
            ModNetwork.sendToPlayer(new SoundPacket(this.getMusic().m_11660_(), true, SoundPacket.SoundType.LOOPING_MUSIC), player);
            this.playersWithMusic.add(playerUUID);
        }
        Iterator<UUID> iterator = this.playersWithMusic.iterator();
        while (iterator.hasNext()) {
            UUID playerUUID;
            playerUUID = iterator.next();
            player = (ServerPlayer)this.m_9236_().m_46003_(playerUUID);
            if (playersWhoShouldHaveMusic.contains(playerUUID)) continue;
            if (player != null) {
                ModNetwork.sendToPlayer(new SoundPacket(this.getMusic().m_11660_(), false), player);
            }
            iterator.remove();
        }
    }

    protected SoundEvent getMusic() {
        return (SoundEvent)ModSounds.SKRYTHE_THEME.get();
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.m_9236_().m_5776_()) {
            for (UUID playerUUID : this.playersWithMusic) {
                ServerPlayer player = (ServerPlayer)this.m_9236_().m_46003_(playerUUID);
                if (player == null) continue;
                ModNetwork.sendToPlayer(new SoundPacket(this.getMusic().m_11660_(), false), player);
            }
            this.threatMap.clear();
            this.playersWithMusic.clear();
        }
    }

    protected void updateStuckDetection() {
        if (!(this.m_21824_() && this.getTamedStance() == TamedStance.FOLLOWING || this.f_19797_ % 20 != 0)) {
            if (this.m_20096_() && this.m_5448_() != null && !this.isAttacking()) {
                this.stuckTimer = this.m_20280_((Entity)this.m_5448_()) <= this.m_20191_().f_82291_ + 1.0 * this.m_20191_().f_82291_ + 1.0 ? 0 : (this.m_20182_().m_82557_(this.lastStuckCheckPosition) < 1.0 ? ++this.stuckTimer : 0);
                this.lastStuckCheckPosition = this.m_20182_();
            } else if (!this.isAttacking() && this.m_5448_() != null) {
                if (this.m_20280_((Entity)this.m_5448_()) >= 64.0) {
                    this.stuckTimer = 0;
                }
            } else {
                this.stuckTimer = 0;
            }
        }
    }

    protected void positionPart(LargeMonsterPartEntity<?> part, Vec3 offset) {
        Vec3 correctedOffset = new Vec3(-offset.f_82479_, offset.f_82480_, -offset.f_82481_);
        Vec3 rotatedOffset = correctedOffset.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        Vec3 finalPos = this.m_20182_().m_82549_(rotatedOffset);
        part.m_6034_(finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_);
    }

    protected void handleRotation() {
        int duration;
        int tickCount = (Integer)this.f_19804_.m_135370_(ROTATION_TICK_COUNT);
        if (tickCount < (duration = ((Integer)this.f_19804_.m_135370_(TURN_DURATION)).intValue())) {
            this.f_19804_.m_135381_(ROTATION_TICK_COUNT, (Object)(tickCount + 1));
            float targetYaw = this.getTargetYaw();
            float targetPitch = this.getTargetPitch();
            TurnDirection turnDirection = TurnDirection.values()[(Byte)this.f_19804_.m_135370_(TURN_DIRECTION)];
            boolean useSmoothing = (Boolean)this.f_19804_.m_135370_(SMOOTH_ROTATION);
            float progress = (float)tickCount / (float)duration;
            float finalProgress = useSmoothing ? (float)Mth.m_14197_((double)progress) : progress;
            float totalYawDifference = Mth.m_14177_((float)(targetYaw - ((Float)this.f_19804_.m_135370_(ROTATION_START_YAW)).floatValue()));
            switch (turnDirection) {
                case RIGHT: {
                    if (!(totalYawDifference < 0.0f)) break;
                    totalYawDifference += 360.0f;
                    break;
                }
                case LEFT: {
                    if (!(totalYawDifference > 0.0f)) break;
                    totalYawDifference -= 360.0f;
                }
            }
            float newHeadYaw = ((Float)this.f_19804_.m_135370_(ROTATION_START_YAW)).floatValue() + totalYawDifference * finalProgress;
            float newBodyYaw = ((Float)this.f_19804_.m_135370_(ROTATION_START_YAW_BODY)).floatValue() + totalYawDifference * finalProgress;
            float newPitch = Mth.m_14179_((float)finalProgress, (float)this.m_146909_(), (float)targetPitch);
            this.m_5616_(newHeadYaw);
            this.m_146926_(newPitch);
            this.f_20883_ = newBodyYaw;
            this.m_146922_(newHeadYaw);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleTracking() {
        Vec3 targetPos;
        block6: {
            int duration = (Integer)this.f_19804_.m_135370_(TRACKING_DURATION);
            if (duration <= 0) {
                this.stopTracking();
                return;
            }
            this.f_19804_.m_135381_(TRACKING_DURATION, (Object)(duration - 1));
            targetPos = null;
            TrackingMode mode = this.getTrackingMode();
            if (mode == TrackingMode.ENTITY) {
                Entity target = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(TRACKING_TARGET_ID)).intValue());
                if (target != null && target.m_6084_()) {
                    targetPos = target.m_146892_();
                    break block6;
                } else {
                    this.stopTracking();
                    return;
                }
            }
            if (mode == TrackingMode.POSITION) {
                targetPos = this.trackingPositionTarget;
            }
        }
        if (targetPos == null) {
            return;
        }
        Vec3 directionToTarget = targetPos.m_82546_(this.m_146892_()).m_82541_();
        float targetYaw = (float)Mth.m_14175_((double)(Math.toDegrees(Mth.m_14136_((double)directionToTarget.f_82481_, (double)directionToTarget.f_82479_)) - 90.0));
        float targetPitch = (float)Mth.m_14175_((double)(-Math.toDegrees(Mth.m_14136_((double)directionToTarget.f_82480_, (double)directionToTarget.m_165924_()))));
        float currentYaw = Mth.m_14177_((float)this.m_6080_());
        float currentPitch = Mth.m_14177_((float)this.m_146909_());
        float yawDifference = Mth.m_14177_((float)(targetYaw - currentYaw));
        float pitchDifference = Mth.m_14177_((float)(targetPitch - currentPitch));
        float yawChange = Mth.m_14036_((float)yawDifference, (float)(-this.maxTurnSpeed), (float)this.maxTurnSpeed);
        float pitchChange = Mth.m_14036_((float)pitchDifference, (float)(-this.maxTurnSpeed), (float)this.maxTurnSpeed);
        float newYaw = currentYaw + yawChange;
        float newPitch = currentPitch + pitchChange;
        this.m_5616_(newYaw);
        this.m_146926_(newPitch);
        this.f_20883_ = newYaw;
        this.m_146922_(newYaw);
    }

    protected void handleEnrage() {
        if (this.enrageDurationTicks > 0) {
            --this.enrageDurationTicks;
            if (this.enrageDurationTicks == 0) {
                this.setEnraged(false);
            }
        }
    }

    protected void trackTargetVelocity() {
        LivingEntity currentTarget = this.m_5448_();
        if (currentTarget != null) {
            if (this.lastTrackedTarget != currentTarget) {
                this.lastTrackedTarget = currentTarget;
                this.lastTargetPosition = currentTarget.m_20182_();
                this.targetVelocity = Vec3.f_82478_;
            } else {
                this.targetVelocity = currentTarget.m_20182_().m_82546_(this.lastTargetPosition);
                this.lastTargetPosition = currentTarget.m_20182_();
            }
        } else {
            this.lastTrackedTarget = null;
            this.targetVelocity = Vec3.f_82478_;
        }
    }

    public void setTargetRotation(float yaw, float pitch, int turnTicks, TurnDirection direction, boolean useSmoothing) {
        this.f_19804_.m_135381_(TARGET_YAW, (Object)Float.valueOf(Mth.m_14177_((float)yaw)));
        this.f_19804_.m_135381_(TARGET_PITCH, (Object)Float.valueOf(Mth.m_14036_((float)pitch, (float)-90.0f, (float)90.0f)));
        this.f_19804_.m_135381_(TURN_DIRECTION, (Object)((byte)direction.ordinal()));
        this.f_19804_.m_135381_(TURN_DURATION, (Object)turnTicks);
        this.f_19804_.m_135381_(ROTATION_TICK_COUNT, (Object)0);
        this.f_19804_.m_135381_(ROTATION_START_YAW, (Object)Float.valueOf(this.m_6080_()));
        this.f_19804_.m_135381_(ROTATION_START_YAW_BODY, (Object)Float.valueOf(this.f_20883_));
        this.f_19804_.m_135381_(SMOOTH_ROTATION, (Object)useSmoothing);
    }

    public void setTargetRotation(float yaw, float pitch, int turnTicks) {
        this.setTargetRotation(yaw, pitch, turnTicks, TurnDirection.SHORTEST, false);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public float getYawFromDirection(Vec3 pDirection) {
        double dX = pDirection.m_7096_();
        double dZ = pDirection.m_7094_();
        return (float)(Mth.m_14136_((double)dZ, (double)dX) * 57.2957763671875) - 90.0f;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity;
        float damageToApply = pAmount;
        if (!this.isProcessingPartDamage) {
            if (this.m_6673_(pSource)) {
                return false;
            }
            Entity entity2 = pSource.m_7639_();
            if (entity2 instanceof LivingEntity) {
                OwnableEntity ownable;
                LivingEntity attacker = (LivingEntity)entity2;
                if (attacker == this || attacker == this.m_269323_() || this.m_21824_() && attacker instanceof OwnableEntity && (ownable = (OwnableEntity)attacker).m_269323_() == this.m_269323_()) {
                    return false;
                }
                float amount = pAmount;
                if (!(attacker instanceof Player) && !(attacker instanceof KobekoEntity)) {
                    amount *= 0.2f;
                }
                ItemStack weaponStack = attacker.m_21205_();
                LazyOptional weaponCap = weaponStack.getCapability(ModCapabilities.WEAPON_DATA);
                DamageTypes.WeaponType weaponType = weaponCap.map(c -> c.getWeaponType(weaponStack)).orElse(DamageTypes.WeaponType.SLASHING);
                DamageTypes.ElementType elementType = weaponCap.map(c -> c.getElementType(weaponStack)).orElse(DamageTypes.ElementType.NONE);
                float weaponElementDamage = weaponCap.map(c -> Float.valueOf(c.getElementalDamage(weaponStack))).orElse(Float.valueOf(0.0f)).floatValue();
                String bodyPartName = "body";
                float rawMultiplier = this.getRawHitzone(bodyPartName, weaponType);
                float elementMultiplier = this.getElementalHitzone(bodyPartName, elementType);
                float totalRawDamageForMainHP = amount * rawMultiplier;
                float totalElementDamageForMainHP = weaponElementDamage * elementMultiplier;
                damageToApply = totalRawDamageForMainHP + totalElementDamageForMainHP;
            } else {
                damageToApply = pAmount;
            }
        }
        boolean result = super.m_6469_(pSource, damageToApply);
        if (this.m_21824_() && pSource.m_7639_() == this.m_269323_()) {
            this.m_6703_(null);
            return result;
        }
        if (result && (entity = pSource.m_7639_()) instanceof LivingEntity) {
            LivingEntity enemy = (LivingEntity)entity;
            if (this.getTamedBehavior() != TamedBehavior.PASSIVE || !this.m_21824_()) {
                this.threatMap.put(enemy.m_20148_(), Float.valueOf(this.threatMap.getOrDefault(enemy.m_20148_(), Float.valueOf(0.0f)).floatValue() + damageToApply));
            }
        }
        if (!(!result || this.isEnraged() || this.getTamedBehavior() == TamedBehavior.PASSIVE && this.m_21824_())) {
            float oldEnrage = this.damageUntilEnrage;
            this.damageUntilEnrage -= damageToApply;
            if (this.damageUntilEnrage <= 0.0f) {
                this.setWantsToEnrage(true);
            }
        }
        return result;
    }

    protected void registerBreakablePart(String partName, float initialHealth) {
        this.partHealths.put(partName, Float.valueOf(initialHealth));
        this.partMaxHealths.put(partName, Float.valueOf(initialHealth));
    }

    protected boolean applyDamageToPart(String partName, float amount, DamageSource source) {
        if (!this.partHealths.containsKey(partName)) {
            return false;
        }
        if (this.brokenParts.contains(partName)) {
            return false;
        }
        float currentHealth = this.partHealths.get(partName).floatValue();
        float newHealth = currentHealth - amount;
        this.partHealths.put(partName, Float.valueOf(newHealth));
        if (newHealth <= 0.0f) {
            this.brokenParts.add(partName);
            this.onPartBroken(partName, source);
            return true;
        }
        return false;
    }

    protected void resetPartHealth(String partName) {
        if (this.partMaxHealths.containsKey(partName)) {
            float maxHealth = this.partMaxHealths.get(partName).floatValue();
            this.partHealths.put(partName, Float.valueOf(maxHealth));
            this.brokenParts.remove(partName);
        }
    }

    protected void resetPartHealth(String partName, float newMaxHealth) {
        this.partHealths.put(partName, Float.valueOf(newMaxHealth));
        this.partMaxHealths.put(partName, Float.valueOf(newMaxHealth));
        this.brokenParts.remove(partName);
    }

    public float getPartHealth(String partName) {
        return this.partHealths.getOrDefault(partName, Float.valueOf(0.0f)).floatValue();
    }

    public boolean isPartBroken(String partName) {
        return this.brokenParts.contains(partName);
    }

    public boolean m_6673_(DamageSource pSource) {
        if (this.isStuckForLongerThan(6) && pSource.m_269533_(DamageTypeTags.f_268524_)) {
            return true;
        }
        if (pSource.m_269533_(DamageTypeTags.f_268524_) && this.m_217043_().m_188503_(3) == 3) {
            return true;
        }
        return super.m_6673_(pSource);
    }

    protected void applyQueuedDamage() {
        this.isApplyingQueuedDamage = true;
        while (!this.damageQueue.isEmpty()) {
            DamageInfo info = this.damageQueue.poll();
            if (info == null || this.f_19797_ - this.lastHurtTick < 2) continue;
            this.m_6475_(info.source(), info.amount());
            this.m_9236_().m_7605_((Entity)this, (byte)2);
            this.lastHurtTick = this.f_19797_;
            if (!(this.m_21223_() <= 0.0f)) continue;
            this.m_6667_(info.source());
            break;
        }
        this.isApplyingQueuedDamage = false;
    }

    public void handleParticleImpact(Vec3 impactPos) {
    }

    public void queueDamage(DamageSource pSource, float pAmount) {
        this.damageQueue.add(new DamageInfo(pSource, pAmount));
    }

    public void flash() {
        if (!this.isFlashable()) {
            return;
        }
        ++this.flashProgress;
        if (this.flashProgress >= this.flashThreshold) {
            this.onFlashed(this.m_269291_().m_269425_());
        }
    }

    public Vec3 getPredictedTargetPosition(LivingEntity target, int ticksInFuture) {
        if (target == null) {
            return this.m_20182_();
        }
        Vec3 predictedPosition = target.m_20182_().m_82549_(this.targetVelocity.m_82490_((double)ticksInFuture));
        return predictedPosition;
    }

    protected List<LivingEntity> getTargetsInOrientedBox(Vec3 anchor, Vec3 offset, double length, double height, double depth) {
        ArrayList<LivingEntity> hitTargets = new ArrayList<LivingEntity>();
        Vec3 forward = this.m_20154_().m_82541_();
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 horizontalForward = new Vec3(forward.f_82479_, 0.0, forward.f_82481_).m_82541_();
        Vec3 right = horizontalForward.m_82537_(up).m_82541_();
        double searchRadius = offset.m_82553_() + Math.max(Math.max(length, height), depth) / 2.0 + 2.0;
        AABB searchArea = new AABB(anchor.m_7096_() - searchRadius, anchor.m_7098_() - searchRadius, anchor.m_7094_() - searchRadius, anchor.m_7096_() + searchRadius, anchor.m_7098_() + searchRadius, anchor.m_7094_() + searchRadius);
        List potentialTargets = this.m_9236_().m_45976_(LivingEntity.class, searchArea);
        for (LivingEntity target : potentialTargets) {
            if (target == this) continue;
            Vec3 vecToTarget = target.m_20182_().m_82546_(anchor);
            double distanceForward = vecToTarget.m_82526_(forward);
            double distanceUp = vecToTarget.m_82526_(up);
            double distanceRight = vecToTarget.m_82526_(right);
            double halfLength = length / 2.0;
            double halfHeight = height / 2.0;
            double halfDepth = depth / 2.0;
            double minX = offset.f_82479_ - halfLength;
            double maxX = offset.f_82479_ + halfLength;
            double minY = offset.f_82480_ - halfHeight;
            double maxY = offset.f_82480_ + halfHeight;
            double minZ = offset.f_82481_ - halfDepth;
            double maxZ = offset.f_82481_ + halfDepth;
            if (!(distanceRight >= minX) || !(distanceRight <= maxX) || !(distanceUp >= minY) || !(distanceUp <= maxY) || !(distanceForward >= minZ) || !(distanceForward <= maxZ)) continue;
            hitTargets.add(target);
        }
        return hitTargets;
    }

    public boolean isTargetInOrientedBox(LivingEntity target, Vec3 offset, double length, double height, double depth) {
        if (target == null) {
            return false;
        }
        return this.getTargetsInOrientedBox(this.m_20182_(), offset, length, height, depth).contains(target);
    }

    public void applyVeinEffect(LivingEntity target) {
        int DURATION = 800;
        int MAX_AMPLIFIER = 2;
        if (target == null || !target.m_6084_()) {
            return;
        }
        if (target == this) {
            return;
        }
        if (this.m_269323_() == target) {
            return;
        }
        if (this.m_217043_().m_188503_(1) == 0) {
            if (target.m_21023_((MobEffect)ModEffects.FROSTVEIN.get())) {
                int currentAmplifier = target.m_21124_((MobEffect)ModEffects.FROSTVEIN.get()).m_19564_();
                int newAmplifier = Math.min(currentAmplifier + 1, 2);
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROSTVEIN.get(), 800, newAmplifier, true, true));
            } else {
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROSTVEIN.get(), 800, 0, true, true));
            }
        }
    }

    public boolean applyDamageToTarget(LivingEntity target, float damageMultiplier, KnockbackType knockbackType, double knockbackStrength, boolean shieldIgnore, boolean shieldBreak, int shieldDownDuration) {
        OwnableEntity ownableEntity;
        if (target == this.m_269323_()) {
            return false;
        }
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (this.m_21824_() && target instanceof OwnableEntity && (ownableEntity = (OwnableEntity)target).m_269323_() == this.m_269323_()) {
            return false;
        }
        for (OwnableEntity part : this.getBodyParts()) {
            if (part != target) continue;
            return false;
        }
        DamageSource damageSource = this.m_269291_().m_269333_((LivingEntity)this);
        if (ModList.get().isLoaded("epicfight")) {
            damageSource = EpicFightCompat.createGuardBreakDamageSource((LivingEntity)this);
        }
        if (shieldIgnore) {
            if (ModList.get().isLoaded("epicfight")) {
                damageSource = EpicFightCompat.addGuardPuncture(damageSource);
            }
            target.m_5810_();
        }
        if (ModList.get().isLoaded("epicfight")) {
            damageSource = EpicFightCompat.addDodgeBypass(damageSource);
        }
        if (target.m_6469_(damageSource, (float)(this.m_21133_(Attributes.f_22281_) * (double)damageMultiplier))) {
            this.applyKnockback(target, knockbackType, knockbackStrength);
            if (shieldBreak && shieldDownDuration > 0) {
                ItemStack shield = ItemStack.f_41583_;
                if (target instanceof Player) {
                    Player player = (Player)target;
                    shield = player.m_21211_();
                }
                target.m_5810_();
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (!shield.m_41619_()) {
                        player.m_36335_().m_41524_(shield.m_41720_(), shieldDownDuration);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected void dealDamageToTargets(List<LivingEntity> targets, float damageMultiplier, KnockbackType knockbackType, double knockbackStrength, boolean shieldIgnore, boolean shieldBreak, int shieldDownDuration) {
        for (LivingEntity target : targets) {
            this.applyDamageToTarget(target, damageMultiplier, knockbackType, knockbackStrength, shieldIgnore, shieldBreak, shieldDownDuration);
        }
    }

    public void dealDamageInOrientedBox(Vec3 anchor, Vec3 offset, double length, double height, double depth, float damageMultiplier, KnockbackType knockbackType, double knockbackStrength, boolean shieldIgnore, boolean shieldBreak, int shieldDownDuration) {
        List<LivingEntity> targetsToHit = this.getTargetsInOrientedBox(anchor, offset, length, height, depth);
        this.dealDamageToTargets(targetsToHit, damageMultiplier, knockbackType, knockbackStrength, shieldIgnore, shieldBreak, shieldDownDuration);
    }

    private void applyKnockback(LivingEntity target, KnockbackType knockbackType, double knockbackStrength) {
        if (knockbackType == KnockbackType.NONE) {
            return;
        }
        Vec3 knockbackDirection = Vec3.f_82478_;
        switch (knockbackType) {
            case STANDARD: {
                Vec3 awayDir = target.m_20182_().m_82546_(this.m_20182_());
                knockbackDirection = new Vec3(awayDir.m_7096_(), 0.0, awayDir.m_7094_()).m_82541_();
                break;
            }
            case UPWARD: {
                Vec3 awayFromDragon = target.m_20182_().m_82546_(this.m_20182_());
                Vec3 horizontalPush = new Vec3(awayFromDragon.m_7096_(), 0.0, awayFromDragon.m_7094_()).m_82541_().m_82490_(0.2);
                knockbackDirection = new Vec3(horizontalPush.f_82479_, 1.0, horizontalPush.f_82481_).m_82541_();
                break;
            }
            case LATERAL: {
                Vec3 forward = this.m_20154_();
                knockbackDirection = new Vec3(-forward.f_82481_, 0.0, forward.f_82479_).m_82541_();
                break;
            }
            case FORWARD: {
                Vec3 lookDir = this.m_20154_();
                knockbackDirection = new Vec3(lookDir.m_7096_(), 0.0, lookDir.m_7094_()).m_82541_();
            }
        }
        if (knockbackDirection.m_82556_() > 0.0) {
            target.m_20256_(target.m_20184_().m_82549_(knockbackDirection.m_82490_(knockbackStrength)));
        }
    }

    public void dealDamageInOrientedBox(Vec3 anchor, Vec3 offset, double length, double height, double depth, float damageMultiplier, KnockbackType knockbackType, double knockbackStrength) {
        this.dealDamageInOrientedBox(anchor, offset, length, height, depth, damageMultiplier, knockbackType, knockbackStrength, false, false, 0);
    }

    public RelativePosition getTargetRelativePosition(@Nullable LivingEntity target) {
        if (target == null) {
            return RelativePosition.FRONT;
        }
        Vec3 forward = this.m_20154_();
        Vec3 forwardHorizontal = new Vec3(forward.f_82479_, 0.0, forward.f_82481_).m_82541_();
        Vec3 toTarget = target.m_20182_().m_82546_(this.m_20182_());
        if (toTarget.f_82479_ * toTarget.f_82479_ + toTarget.f_82481_ * toTarget.f_82481_ < 1.0E-5) {
            return RelativePosition.FRONT;
        }
        Vec3 toTargetHorizontal = new Vec3(toTarget.f_82479_, 0.0, toTarget.f_82481_).m_82541_();
        double angleToTarget = Math.atan2(toTargetHorizontal.f_82481_, toTargetHorizontal.f_82479_);
        double angleForward = Math.atan2(forwardHorizontal.f_82481_, forwardHorizontal.f_82479_);
        double relativeAngleDegrees = Math.toDegrees(angleForward - angleToTarget);
        double wrappedAngle = Mth.m_14175_((double)relativeAngleDegrees);
        if (wrappedAngle >= -22.5 && wrappedAngle <= 22.5) {
            return RelativePosition.FRONT;
        }
        if (wrappedAngle > 22.5 && wrappedAngle <= 67.5) {
            return RelativePosition.FRONT_LEFT;
        }
        if (wrappedAngle > 67.5 && wrappedAngle <= 112.5) {
            return RelativePosition.LEFT;
        }
        if (wrappedAngle > 112.5 && wrappedAngle <= 157.5) {
            return RelativePosition.BACK_LEFT;
        }
        if (wrappedAngle < -22.5 && wrappedAngle >= -67.5) {
            return RelativePosition.FRONT_RIGHT;
        }
        if (wrappedAngle < -67.5 && wrappedAngle >= -112.5) {
            return RelativePosition.RIGHT;
        }
        if (wrappedAngle < -112.5 && wrappedAngle >= -157.5) {
            return RelativePosition.BACK_RIGHT;
        }
        return RelativePosition.BACK;
    }

    public boolean isTargetAttacking() {
        LivingEntity target = this.m_5448_();
        return target != null && target.f_20921_ > 0.0f;
    }

    public boolean isTargetHealing() {
        Player player;
        LivingEntity target = this.m_5448_();
        if (target instanceof Player && (player = (Player)target).m_6117_()) {
            ItemStack itemInUse = player.m_21211_();
            return itemInUse.m_41780_() == UseAnim.EAT || itemInUse.m_41780_() == UseAnim.DRINK;
        }
        return false;
    }

    public boolean isTargetBlocking() {
        LivingEntity target = this.m_5448_();
        return target != null && target.m_21254_();
    }

    public boolean isTargetLowOnHealth() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return false;
        }
        return target.m_21223_() / target.m_21233_() <= 0.4f;
    }

    public boolean isTargetIncapacitated() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return false;
        }
        return target.m_21023_(MobEffects.f_19597_) && target.m_21124_(MobEffects.f_19597_).m_19564_() > 2;
    }

    public boolean isTargetRunningAway() {
        LivingEntity target = this.m_5448_();
        if (target == null || this.targetVelocity.m_82556_() < 0.01) {
            return false;
        }
        Vec3 directionToTarget = target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
        Vec3 targetMovementDirection = this.targetVelocity.m_82541_();
        return targetMovementDirection.m_82526_(directionToTarget) > 0.5;
    }

    public boolean hasClearLineOfSight() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return false;
        }
        return this.m_9236_().m_45547_(new ClipContext(this.m_146892_(), target.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public Vec3 getPredictedDirection(Vec3 anchor, int ticksInFuture, LivingEntity target) {
        if (target != null) {
            Vec3 predictedPos = this.getPredictedTargetPosition(target, ticksInFuture);
            Vec3 directionVec = predictedPos.m_82546_(anchor);
            return directionVec.m_82541_();
        }
        return this.m_20154_();
    }

    public Vec3 getPredictedDirection(Vec3 anchor, int ticksInFuture) {
        return this.getPredictedDirection(anchor, ticksInFuture, this.m_5448_());
    }

    public Vec3 getPredictedHorizontalDirection(int tickInFuture, LivingEntity target) {
        if (target != null) {
            Vec3 predictedPos = this.getPredictedTargetPosition(target, tickInFuture);
            Vec3 directionVec = predictedPos.m_82546_(this.m_20182_());
            return new Vec3(directionVec.m_7096_(), 0.0, directionVec.m_7094_()).m_82541_();
        }
        Vec3 lookAngle = this.m_20154_();
        return new Vec3(lookAngle.m_7096_(), 0.0, lookAngle.m_7094_()).m_82541_();
    }

    public Vec3 getPredictedHorizontalDirection(int tickInFuture) {
        return this.getPredictedHorizontalDirection(tickInFuture, this.m_5448_());
    }

    public float getPredictedAngle(int tickInFuture, LivingEntity target) {
        Vec3 directionToTarget = this.getPredictedHorizontalDirection(tickInFuture, target);
        return this.getYawFromDirection(directionToTarget);
    }

    public float getPredictedAngle(int tickInFuture) {
        return this.getPredictedAngle(tickInFuture, this.m_5448_());
    }

    public boolean isTargetOnLeft(LivingEntity target) {
        if (target == null) {
            return false;
        }
        Vec3 forward = this.m_20154_();
        Vec3 forwardHorizontal = new Vec3(forward.f_82479_, 0.0, forward.f_82481_).m_82541_();
        Vec3 toTarget = target.m_20182_().m_82546_(this.m_20182_());
        Vec3 toTargetHorizontal = new Vec3(toTarget.f_82479_, 0.0, toTarget.f_82481_).m_82541_();
        double crossProductY = forwardHorizontal.f_82479_ * toTargetHorizontal.f_82481_ - forwardHorizontal.f_82481_ * toTargetHorizontal.f_82479_;
        return !(crossProductY > 0.0);
    }

    public boolean isPositionOnLeft(Vec3 position) {
        Vec3 forward = this.m_20154_();
        Vec3 forwardHorizontal = new Vec3(forward.f_82479_, 0.0, forward.f_82481_).m_82541_();
        Vec3 toTarget = position.m_82546_(this.m_20182_());
        Vec3 toTargetHorizontal = new Vec3(toTarget.f_82479_, 0.0, toTarget.f_82481_).m_82541_();
        double crossProductY = forwardHorizontal.f_82479_ * toTargetHorizontal.f_82481_ - forwardHorizontal.f_82481_ * toTargetHorizontal.f_82479_;
        return !(crossProductY > 0.0);
    }

    public void addPartOffset(LargeMonsterPartEntity<?> part, Vec3 offset) {
        if (this.additivePartOffsets.containsKey(part)) {
            this.additivePartOffsets.put(part, this.additivePartOffsets.get(part).m_82549_(offset));
        }
    }

    public Vec3 getPartOffset(LargeMonsterPartEntity<?> part) {
        return this.additivePartOffsets.get(part);
    }

    public void setPartOffset(LargeMonsterPartEntity<?> part, Vec3 offset) {
        this.additivePartOffsets.put(part, offset);
    }

    public void resetPartOffsets() {
        for (LargeMonsterPartEntity<?> part : this.getBodyParts()) {
            this.additivePartOffsets.put(part, Vec3.f_82478_);
        }
    }

    public void spawnShockwave(Vec3 spawnPos, float yaw, float pitch, float maxRadius, float damage, int lifetime) {
        if (!this.m_9236_().f_46443_) {
            ShockwaveEntity shockwave = new ShockwaveEntity(this.m_9236_(), spawnPos, (LivingEntity)this, maxRadius, damage, lifetime);
            shockwave.m_146922_(yaw);
            shockwave.m_146926_(pitch);
            this.m_9236_().m_7967_((Entity)shockwave);
        }
    }

    public void spawnHeavingGroundEffect(float radius, int duration) {
        if (!this.m_9236_().f_46443_) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            ArrayList<BlockState> states = new ArrayList<BlockState>();
            BlockPos center = this.m_20183_();
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_((int)(-radius), -2, (int)(-radius)), (BlockPos)center.m_7918_((int)radius, 2, (int)radius))) {
                if (!(pos.m_123331_((Vec3i)center) <= (double)(radius * radius))) continue;
                BlockPos.MutableBlockPos groundPos = pos.m_122032_();
                while (this.m_9236_().m_8055_((BlockPos)groundPos).m_60795_() && groundPos.m_123342_() > this.m_9236_().m_141937_()) {
                    groundPos.m_122173_(Direction.DOWN);
                }
                BlockState groundState = this.m_9236_().m_8055_((BlockPos)groundPos);
                if (!groundState.m_280296_()) continue;
                blocks.add(groundPos.m_7949_());
                states.add(groundState);
            }
            HeavingGroundEffectEntity effect = new HeavingGroundEffectEntity(this.m_9236_(), blocks, states, duration, radius);
            effect.m_146884_(this.m_20182_());
            this.m_9236_().m_7967_((Entity)effect);
        }
    }

    public void spawnSmashedGroundEffect(Vec3 offset, float radius, int duration) {
        if (!this.m_9236_().f_46443_) {
            Vec3 rotatedOffset = offset.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            Vec3 centerPos = this.m_20182_().m_82549_(rotatedOffset);
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            ArrayList<BlockState> states = new ArrayList<BlockState>();
            BlockPos center = BlockPos.m_274446_((Position)centerPos);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_((int)(-radius), -3, (int)(-radius)), (BlockPos)center.m_7918_((int)radius, 3, (int)radius))) {
                if (!(pos.m_123331_((Vec3i)center) <= (double)(radius * radius))) continue;
                BlockPos.MutableBlockPos groundPos = pos.m_122032_();
                while (this.m_9236_().m_8055_((BlockPos)groundPos).m_60795_() && groundPos.m_123342_() > this.m_9236_().m_141937_()) {
                    groundPos.m_122173_(Direction.DOWN);
                }
                BlockState groundState = this.m_9236_().m_8055_((BlockPos)groundPos);
                if (!groundState.m_280296_() || blocks.contains(groundPos)) continue;
                blocks.add(groundPos.m_7949_());
                states.add(groundState);
            }
            if (!blocks.isEmpty()) {
                SmashedGroundEffectEntity effect = new SmashedGroundEffectEntity(this.m_9236_(), blocks, states, duration, radius);
                effect.m_146884_(centerPos);
                this.m_9236_().m_7967_((Entity)effect);
            }
        }
    }

    public void spawnGroundEffects(Vec3 offset, float spawnRadius, int debrisCount, int dustCount, int bigDustCount) {
        if (!this.m_9236_().f_46443_) {
            double velZ;
            double velY;
            double velX;
            Object options;
            BlockState groundState;
            BlockPos groundPos;
            Vec3 particleSpawnPos;
            double offsetZ;
            double offsetX;
            double distance;
            double angle;
            int i;
            Vec3 rotatedOffset = offset.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            Vec3 centerPos = this.m_20182_().m_82549_(rotatedOffset);
            for (i = 0; i < debrisCount; ++i) {
                angle = this.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = this.m_217043_().m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                offsetZ = Math.sin(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = this.m_9236_().m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new DebrisParticleOptions(groundState);
                velX = (this.m_217043_().m_188500_() - 0.5) * 0.8;
                velY = this.m_217043_().m_188500_() * 0.8;
                velZ = (this.m_217043_().m_188500_() - 0.5) * 0.8;
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, new Vec3(velX, velY, velZ), true), (Entity)this);
            }
            for (i = 0; i < dustCount; ++i) {
                angle = this.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = this.m_217043_().m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                offsetZ = Math.sin(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = this.m_9236_().m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new DustParticleOptions(groundState);
                velX = (this.m_217043_().m_188500_() - 0.5) * 0.15;
                velY = this.m_217043_().m_188500_() * 0.15;
                velZ = (this.m_217043_().m_188500_() - 0.5) * 0.15;
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, new Vec3(velX, velY, velZ), true), (Entity)this);
            }
            for (i = 0; i < bigDustCount; ++i) {
                angle = this.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = this.m_217043_().m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                offsetZ = Math.sin(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = this.m_9236_().m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new BigDustParticleOptions(groundState);
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, Vec3.f_82478_, true), (Entity)this);
            }
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (item == Items.f_42686_ && !this.m_21824_()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_21828_(pPlayer);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)pPlayer)) {
            if (pPlayer.m_36341_()) {
                if (pPlayer instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this, buf -> buf.writeInt(this.m_19879_()));
                    pPlayer.m_213846_((Component)Component.m_237113_((String)"Menu Opened!"));
                }
            } else if (!this.m_9236_().f_46443_) {
                pPlayer.m_20329_((Entity)this);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Nullable
    public LivingEntity m_6688_() {
        return (LivingEntity)this.m_146895_();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsEnraged", this.isEnraged());
        pCompound.m_128405_("EnrageTicks", this.enrageDurationTicks);
        pCompound.m_128405_("StaggerCount", this.staggerCount);
        pCompound.m_128405_("ToppleCount", this.toppleCount);
        pCompound.m_128379_("HasDroppedToppleLoot", this.hasDroppedToppleLoot);
        pCompound.m_128405_("FlashProgress", this.flashProgress);
        pCompound.m_128405_("FlashThreshold", this.flashThreshold);
        CompoundTag partHealthsTag = new CompoundTag();
        for (Map.Entry<String, Float> entry : this.partHealths.entrySet()) {
            partHealthsTag.m_128350_(entry.getKey(), entry.getValue().floatValue());
        }
        pCompound.m_128365_("PartHealths", (Tag)partHealthsTag);
        CompoundTag partMaxHealthsTag = new CompoundTag();
        for (Map.Entry<String, Float> entry : this.partMaxHealths.entrySet()) {
            partMaxHealthsTag.m_128350_(entry.getKey(), entry.getValue().floatValue());
        }
        pCompound.m_128365_("PartMaxHealths", (Tag)partMaxHealthsTag);
        ListTag listTag = new ListTag();
        for (String partName : this.brokenParts) {
            listTag.add((Object)StringTag.m_129297_((String)partName));
        }
        pCompound.m_128365_("BrokenParts", (Tag)listTag);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setEnraged(pCompound.m_128471_("IsEnraged"));
        this.enrageDurationTicks = pCompound.m_128451_("EnrageTicks");
        this.staggerCount = pCompound.m_128451_("StaggerCount");
        this.toppleCount = pCompound.m_128451_("ToppleCount");
        this.hasDroppedToppleLoot = pCompound.m_128471_("HasDroppedToppleLoot");
        this.flashProgress = pCompound.m_128451_("FlashProgress");
        this.flashThreshold = pCompound.m_128451_("FlashThreshold");
        if (pCompound.m_128425_("PartHealths", 10)) {
            CompoundTag partHealthsTag = pCompound.m_128469_("PartHealths");
            this.partHealths.clear();
            for (String key : partHealthsTag.m_128431_()) {
                this.partHealths.put(key, Float.valueOf(partHealthsTag.m_128457_(key)));
            }
        }
        if (pCompound.m_128425_("PartMaxHealths", 10)) {
            CompoundTag partMaxHealthsTag = pCompound.m_128469_("PartMaxHealths");
            this.partMaxHealths.clear();
            for (String key : partMaxHealthsTag.m_128431_()) {
                this.partMaxHealths.put(key, Float.valueOf(partMaxHealthsTag.m_128457_(key)));
            }
        }
        if (pCompound.m_128425_("BrokenParts", 9)) {
            ListTag brokenPartsTag = pCompound.m_128437_("BrokenParts", 8);
            this.brokenParts.clear();
            for (int i = 0; i < brokenPartsTag.size(); ++i) {
                this.brokenParts.add(brokenPartsTag.m_128778_(i));
            }
        }
    }

    public void m_20234_(int pId) {
        super.m_20234_(pId);
        for (int i = 0; i < this.getBodyParts().length; ++i) {
            this.getBodyParts()[i].m_20234_(pId + i + 1);
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_9236_().f_46443_) {
            for (LargeMonsterPartEntity<?> part : this.getBodyParts()) {
                this.m_9236_().m_7967_(part);
            }
        }
    }

    public void m_7618_(EntityAnchorArgument.Anchor pAnchor, Vec3 pTarget) {
    }

    @NotNull
    public AABB m_6921_() {
        return super.m_6921_().m_82400_(10.0);
    }

    public void m_6710_(@Nullable LivingEntity pTarget) {
        Player player;
        OwnableEntity ownableEntity;
        if (this.m_21824_() && pTarget instanceof OwnableEntity && (ownableEntity = (OwnableEntity)pTarget).m_269323_() == this.m_269323_()) {
            return;
        }
        if (pTarget instanceof Player && ((player = (Player)pTarget).m_7500_() || player.m_5833_())) {
            return;
        }
        for (LargeMonsterPartEntity<?> part : this.getBodyParts()) {
            if (pTarget != part) continue;
            return;
        }
        super.m_6710_(pTarget);
    }

    public void addActiveDamagePart(LargeMonsterPartEntity<?> part) {
        this.activeDamageParts.add(part);
    }

    public void removeActiveDamagePart(LargeMonsterPartEntity<?> part) {
        this.activeDamageParts.remove(part);
    }

    public void clearActiveDamageParts() {
        this.activeDamageParts.clear();
    }

    public void clearHitEntities() {
        this.hitEntitiesThisAttack.clear();
    }

    public void applyTemporaryThreat(UUID source, float amount, int durationTicks) {
        ServerLevel serverLevel;
        Entity taunter;
        this.temporaryThreats.put(source, new ThreatModifier(amount, durationTicks));
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && (taunter = (serverLevel = (ServerLevel)level).m_8791_(source)) instanceof LivingEntity) {
            LivingEntity livingTaunter = (LivingEntity)taunter;
            this.m_6710_(livingTaunter);
        }
    }

    protected void updateTemporaryThreats() {
        if (this.temporaryThreats.isEmpty()) {
            return;
        }
        this.temporaryThreats.entrySet().removeIf(entry -> {
            ThreatModifier mod = (ThreatModifier)entry.getValue();
            --mod.durationTicks;
            return mod.durationTicks <= 0;
        });
    }

    public LivingEntity findNthHighestThreat(int n) {
        LivingEntity livingTarget;
        Level level;
        if (n <= 0 || !((level = this.m_9236_()) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        List sortedThreats = this.threatMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).toList();
        if (n > sortedThreats.size()) {
            return null;
        }
        UUID targetUUID = (UUID)sortedThreats.get(n - 1).getKey();
        Entity targetEntity = serverLevel.m_8791_(targetUUID);
        if (targetEntity instanceof LivingEntity && (livingTarget = (LivingEntity)targetEntity).m_6084_()) {
            return livingTarget;
        }
        return null;
    }

    @Override
    public final T getCurrentAbility() {
        int ordinal = (Integer)this.f_19804_.m_135370_(ABILITY_STATE);
        if (ordinal < 0 || ordinal >= ((Enum[])this.abilityClass.getEnumConstants()).length) {
            return (T)((Enum[])this.abilityClass.getEnumConstants())[0];
        }
        return (T)((Enum[])this.abilityClass.getEnumConstants())[ordinal];
    }

    @Override
    public final void setCurrentAbility(T ability) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        T previousAbility = this.getCurrentAbility();
        this.f_19804_.m_135381_(ABILITY_STATE, (Object)((Enum)ability).ordinal());
        if (previousAbility != this.getNoneAbility()) {
            this.lastUsedAbility = previousAbility;
            this.lastAbilityTick = this.f_19797_;
        }
        if (ability != this.getNoneAbility()) {
            this.setEnragedAbility(this.isEnraged());
        }
    }

    @Override
    public boolean isAttacking() {
        return this.getCurrentAbility() != this.getNoneAbility();
    }

    public boolean isAbilityEnraged() {
        return (Boolean)this.f_19804_.m_135370_(ENRAGED_ABILITY);
    }

    public void setEnragedAbility(boolean isEnraged) {
        this.f_19804_.m_135381_(ENRAGED_ABILITY, (Object)isEnraged);
    }

    public boolean isEnraged() {
        return (Boolean)this.f_19804_.m_135370_(ENRAGED);
    }

    public void setEnraged(boolean enraged) {
        this.f_19804_.m_135381_(ENRAGED, (Object)enraged);
        if (enraged) {
            this.enrageDurationTicks = 1000;
        } else {
            this.damageUntilEnrage = this.m_21233_() * 0.3f;
        }
    }

    public Map<UUID, ThreatModifier> getTemporaryThreats() {
        return this.temporaryThreats;
    }

    public void addThreat(UUID source, float amount) {
        if (this.m_21824_() && this.m_269323_() != null && source.equals(this.m_269323_().m_20148_())) {
            return;
        }
        this.threatMap.put(source, Float.valueOf(this.threatMap.getOrDefault(source, Float.valueOf(0.0f)).floatValue() + amount));
    }

    public boolean isRotationManual() {
        return (Boolean)this.f_19804_.m_135370_(MANUAL_ROTAION);
    }

    public void setRotationManual(boolean manual) {
        if (manual) {
            this.setTargetRotation(this.f_20883_, 0.0f, 0);
        }
        this.m_5616_(this.f_20883_);
        this.f_19804_.m_135381_(MANUAL_ROTAION, (Object)manual);
    }

    public void startTrackingEntity(LivingEntity target, int durationTicks, float maxTurnSpeed) {
        if (this.m_9236_().f_46443_ || target == null) {
            return;
        }
        this.f_19804_.m_135381_(TRACKING_MODE, (Object)((byte)TrackingMode.ENTITY.ordinal()));
        this.f_19804_.m_135381_(TRACKING_TARGET_ID, (Object)target.m_19879_());
        this.f_19804_.m_135381_(TRACKING_DURATION, (Object)durationTicks);
        this.maxTurnSpeed = maxTurnSpeed;
        this.setRotationManual(true);
    }

    public void startTrackingPosition(Vec3 position, int durationTicks, float maxTurnSpeed) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.f_19804_.m_135381_(TRACKING_MODE, (Object)((byte)TrackingMode.POSITION.ordinal()));
        this.trackingPositionTarget = position;
        this.f_19804_.m_135381_(TRACKING_DURATION, (Object)durationTicks);
        this.maxTurnSpeed = maxTurnSpeed;
    }

    public void stopTracking() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.f_19804_.m_135381_(TRACKING_MODE, (Object)((byte)TrackingMode.NONE.ordinal()));
        this.f_19804_.m_135381_(TRACKING_TARGET_ID, (Object)-1);
        this.f_19804_.m_135381_(TRACKING_DURATION, (Object)0);
    }

    public TrackingMode getTrackingMode() {
        return TrackingMode.values()[(Byte)this.f_19804_.m_135370_(TRACKING_MODE)];
    }

    public TamedBehavior getTamedBehavior() {
        return TamedBehavior.values()[(Byte)this.f_19804_.m_135370_(TAMED_BEHAVIOR)];
    }

    public void setTamedBehavior(TamedBehavior behavior) {
        this.f_19804_.m_135381_(TAMED_BEHAVIOR, (Object)((byte)behavior.ordinal()));
        this.refreshGoals();
    }

    public TamedStance getTamedStance() {
        return TamedStance.values()[(Byte)this.f_19804_.m_135370_(TAMED_STANCE)];
    }

    public void setTamedStance(TamedStance stance) {
        this.f_19804_.m_135381_(TAMED_STANCE, (Object)((byte)stance.ordinal()));
        this.m_21839_(stance == TamedStance.SITTING);
        this.refreshGoals();
        if (stance == TamedStance.SITTING) {
            this.staggerCount = 0;
            this.toppleCount = 0;
            this.flashProgress = 0;
            this.flashThreshold = 1;
        }
    }

    public final S getCurrentStaggerState() {
        int ordinal = (Integer)this.f_19804_.m_135370_(STAGGER_STATE);
        Enum[] constants = (Enum[])this.staggerClass.getEnumConstants();
        if (ordinal < 0 || ordinal >= constants.length) {
            return this.getNoneStagger();
        }
        return (S)constants[ordinal];
    }

    public final void setCurrentStaggerState(S state) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.f_19804_.m_135381_(STAGGER_STATE, (Object)((Enum)state).ordinal());
    }

    public float getTargetYaw() {
        return ((Float)this.f_19804_.m_135370_(TARGET_YAW)).floatValue();
    }

    public float getTargetPitch() {
        return ((Float)this.f_19804_.m_135370_(TARGET_PITCH)).floatValue();
    }

    public boolean isRiderAscending() {
        return (Boolean)this.f_19804_.m_135370_(IS_RIDER_ASCENDING);
    }

    public void setRiderAscending(boolean ascending) {
        this.f_19804_.m_135381_(IS_RIDER_ASCENDING, (Object)ascending);
    }

    public boolean isRiderDescending() {
        return (Boolean)this.f_19804_.m_135370_(IS_RIDER_DESCENDING);
    }

    public void setRiderDescending(boolean descending) {
        this.f_19804_.m_135381_(IS_RIDER_DESCENDING, (Object)descending);
    }

    public boolean isApplyingQueuedDamage() {
        return this.isApplyingQueuedDamage;
    }

    public boolean isStuck() {
        return this.stuckTimer > 2;
    }

    public boolean isStuckForLongerThan(int seconds) {
        return this.stuckTimer >= seconds;
    }

    public Map<UUID, Float> getThreatMap() {
        return this.threatMap;
    }

    public boolean wantsToEnrage() {
        return this.wantsToEnrage;
    }

    public void setWantsToEnrage(boolean wantsToEnrage) {
        this.wantsToEnrage = wantsToEnrage;
    }

    protected void m_7324_(Entity pEntity) {
        if (pEntity == this) {
            return;
        }
        for (LargeMonsterPartEntity<?> part : this.getBodyParts()) {
            if (pEntity != part) continue;
            return;
        }
        if (!pEntity.m_6094_()) {
            return;
        }
        double dx = pEntity.m_20185_() - this.m_20185_();
        double dz = pEntity.m_20189_() - this.m_20189_();
        double distSqr = dx * dx + dz * dz;
        double collisionRadius = (double)this.m_20205_() / 2.0 + (double)pEntity.m_20205_() / 2.0 + 0.4;
        if (distSqr > 0.01 && distSqr < collisionRadius * collisionRadius) {
            double dist = Mth.m_14116_((float)((float)distSqr));
            double strength = 0.4;
            Vec3 bossVel = this.m_20184_();
            pEntity.m_20334_(bossVel.f_82479_ * 0.2 + (dx /= dist) * strength, 0.0, bossVel.f_82481_ * 0.2 + (dz /= dist) * strength);
            pEntity.f_19812_ = true;
        }
    }

    public boolean isIgnoringHighestThreat() {
        return this.ignoreHighestThreatTimer > 0;
    }

    public void setIgnoreHighestThreat(int ticks) {
        this.ignoreHighestThreatTimer = ticks;
    }

    public boolean m_5801_() {
        return false;
    }

    public static enum TamedStance {
        FOLLOWING,
        SITTING,
        WANDERING;

    }

    public static enum TamedBehavior {
        AGGRESSIVE,
        PASSIVE,
        NEUTRAL;

    }

    public static enum TurnDirection {
        SHORTEST,
        RIGHT,
        LEFT;

    }

    public static enum TrackingMode {
        NONE,
        ENTITY,
        POSITION;

    }

    public static enum KnockbackType {
        NONE,
        STANDARD,
        UPWARD,
        LATERAL,
        FORWARD;

    }

    public static enum RelativePosition {
        FRONT,
        FRONT_RIGHT,
        RIGHT,
        BACK_RIGHT,
        BACK,
        BACK_LEFT,
        LEFT,
        FRONT_LEFT;

    }

    public static class ThreatModifier {
        public float amount;
        public int durationTicks;

        public ThreatModifier(float amount, int durationTicks) {
            this.amount = amount;
            this.durationTicks = durationTicks;
        }
    }
}

