/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.effect.SmashedGroundEffectEntity;

public class SmashedGroundRenderer
extends EntityRenderer<SmashedGroundEffectEntity> {
    public SmashedGroundRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(SmashedGroundEffectEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        float ageInTicks = (float)pEntity.f_19797_ + pPartialTick;
        float lifetime = pEntity.getAnimationDuration();
        float maxRadius = pEntity.getMaxRadius();
        Vec3 centerPos = pEntity.m_20182_();
        float MAX_TILT_DEGREES = 30.0f;
        float transitionTime = 0.01f;
        for (int i = 0; i < pEntity.blocksToAnimate.size(); ++i) {
            float animationIntensity;
            float progress;
            BlockPos pos = pEntity.blocksToAnimate.get(i);
            BlockState state = pEntity.blockStates.get(i);
            if (state.m_60795_() || (progress = ageInTicks / lifetime) > 1.0f) continue;
            if (progress < 0.01f) {
                animationIntensity = progress / 0.01f;
            } else if (progress > 0.99f) {
                float outProgress = (progress - 0.99f) / 0.01f;
                animationIntensity = 1.0f - outProgress;
            } else {
                animationIntensity = 1.0f;
            }
            animationIntensity = Mth.m_14036_((float)animationIntensity, (float)0.0f, (float)1.0f);
            pPoseStack.m_85836_();
            pPoseStack.m_85837_((double)pos.m_123341_() - centerPos.f_82479_, (double)pos.m_123342_() - centerPos.f_82480_ + (double)0.01f, (double)pos.m_123343_() - centerPos.f_82481_);
            RandomSource seededRandom = RandomSource.m_216335_((long)pos.m_121878_());
            float maxRandomXRot = (seededRandom.m_188501_() - 0.5f) * 30.0f;
            float maxRandomZRot = (seededRandom.m_188501_() - 0.5f) * 30.0f;
            pPoseStack.m_252781_(Axis.f_252529_.m_252977_(maxRandomXRot * animationIntensity));
            pPoseStack.m_252781_(Axis.f_252403_.m_252977_(maxRandomZRot * animationIntensity));
            RenderType renderType = ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)false);
            VertexConsumer vertexConsumer = pBuffer.m_6299_(renderType);
            blockRenderer.m_234355_(state, pos.m_7494_(), (BlockAndTintGetter)pEntity.m_9236_(), pPoseStack, vertexConsumer, false, pEntity.m_9236_().m_213780_());
            pPoseStack.m_85849_();
        }
    }

    public ResourceLocation getTextureLocation(SmashedGroundEffectEntity smashedGroundEffectEntity) {
        return null;
    }
}

