/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.saksolm.monsterexpansion.entity.custom.effect.ShockwaveEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ShockwaveRenderer
extends EntityRenderer<ShockwaveEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("monsterexpansion", "textures/effect/shockwave.png");

    public ShockwaveRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(ShockwaveEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        float radius = pEntity.getRadius();
        float maxRadius = pEntity.getMaxRadius();
        float lifetime = pEntity.getLifetime();
        if (lifetime == 0.0f) {
            return;
        }
        float alpha = 1.0f - ((float)pEntity.f_19797_ + pPartialTick) / lifetime;
        if (alpha <= 0.0f) {
            return;
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.0, 0.05, 0.0);
        float yaw = Mth.m_14179_((float)pPartialTick, (float)pEntity.f_19859_, (float)pEntity.m_146908_());
        float pitch = Mth.m_14179_((float)pPartialTick, (float)pEntity.f_19860_, (float)pEntity.m_146909_());
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        VertexConsumer vertexConsumer = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
        Matrix4f matrix = pPoseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = pPoseStack.m_85850_().m_252943_();
        vertexConsumer.m_252986_(matrix, -radius, -radius, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_252939_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -radius, radius, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_252939_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, radius, radius, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_252939_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, radius, -radius, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_252939_(normalMatrix, 0.0f, 0.0f, 1.0f).m_5752_();
        pPoseStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(ShockwaveEntity pEntity) {
        return TEXTURE;
    }
}

