/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.saksolm.monsterexpansion.entity.client.RhyzaModel;
import net.saksolm.monsterexpansion.entity.custom.RhyzaEntity;
import net.saksolm.monsterexpansion.entity.layers.MonsterModelLayers;
import org.jetbrains.annotations.Nullable;

public class RhyzaRenderer
extends MobRenderer<RhyzaEntity, RhyzaModel<RhyzaEntity>> {
    private static final ResourceLocation BASE_TEXTURE = new ResourceLocation("monsterexpansion", "textures/entity/rhyza.png");
    private static final ResourceLocation ENRAGED_TEXTURE = new ResourceLocation("monsterexpansion", "textures/entity/rhyza_enraged.png");

    public RhyzaRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new RhyzaModel(pContext.m_174023_(MonsterModelLayers.RHYZA_LAYER)), 2.0f);
    }

    @Nullable
    protected RenderType getRenderType(RhyzaEntity pLivingEntity, boolean pBodyVisible, boolean pTranslucent, boolean pGlowing) {
        if (pLivingEntity.isEnraged()) {
            return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(pLivingEntity));
        }
        return super.m_7225_((LivingEntity)pLivingEntity, pBodyVisible, pTranslucent, pGlowing);
    }

    public ResourceLocation getTextureLocation(RhyzaEntity rhyzaEntity) {
        return rhyzaEntity.isEnraged() ? ENRAGED_TEXTURE : BASE_TEXTURE;
    }

    public void render(RhyzaEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        int fadeDuration;
        int fadeTicks = pEntity.getFadeTicks();
        float alpha = 1.0f - Mth.m_14036_((float)((float)fadeTicks / (float)(fadeDuration = 30)), (float)0.0f, (float)1.0f);
        if (alpha <= 0.01f) {
            return;
        }
        pPoseStack.m_85836_();
        float bodyYaw = Mth.m_14189_((float)pPartialTick, (float)pEntity.f_20884_, (float)pEntity.f_20883_);
        float headYaw = Mth.m_14189_((float)pPartialTick, (float)pEntity.f_20886_, (float)pEntity.f_20885_);
        float headPitch = Mth.m_14179_((float)pPartialTick, (float)pEntity.f_19860_, (float)pEntity.m_146909_());
        float netHeadYaw = headYaw - bodyYaw;
        float ageInTicks = this.m_6930_((LivingEntity)pEntity, pPartialTick);
        this.setupRotations(pEntity, pPoseStack, ageInTicks, bodyYaw, pPartialTick);
        pPoseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.m_7546_((LivingEntity)pEntity, pPoseStack, pPartialTick);
        pPoseStack.m_252880_(0.0f, -1.501f, 0.0f);
        float limbSwingAmount = pEntity.f_267362_.m_267711_(pPartialTick);
        float limbSwing = pEntity.f_267362_.m_267590_(pPartialTick);
        if (pEntity.m_6162_()) {
            limbSwing *= 3.0f;
        }
        ((RhyzaModel)this.f_115290_).m_6839_((Entity)pEntity, limbSwing, limbSwingAmount, pPartialTick);
        ((RhyzaModel)this.f_115290_).setupAnim(pEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        RenderType renderType = RenderType.m_110473_((ResourceLocation)this.getTextureLocation(pEntity));
        VertexConsumer vertexConsumer = pBuffer.m_6299_(renderType);
        int packedOverlay = LivingEntityRenderer.m_115338_((LivingEntity)pEntity, (float)0.0f);
        ((RhyzaModel)this.f_115290_).m_7695_(pPoseStack, vertexConsumer, pPackedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        pPoseStack.m_85849_();
    }

    protected void setupRotations(RhyzaEntity pEntityLiving, PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        if (this.m_5936_((LivingEntity)pEntityLiving)) {
            pRotationYaw += (float)(Math.cos((double)pEntityLiving.f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if (!pEntityLiving.m_217003_(Pose.SLEEPING)) {
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - pRotationYaw));
        }
        if (pEntityLiving.m_21209_()) {
            pPoseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f - pEntityLiving.m_146909_()));
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(((float)pEntityLiving.f_19797_ + pPartialTicks) * -75.0f));
        } else if (pEntityLiving.m_217003_(Pose.SLEEPING)) {
            Direction direction = pEntityLiving.m_21259_();
            float f1 = direction != null ? RhyzaRenderer.m_115328_(direction) : pRotationYaw;
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(f1));
            pPoseStack.m_252781_(Axis.f_252403_.m_252977_(this.m_6441_((LivingEntity)pEntityLiving)));
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        } else if (RhyzaRenderer.m_194453_((LivingEntity)pEntityLiving)) {
            pPoseStack.m_252880_(0.0f, pEntityLiving.m_20206_() + 0.1f, 0.0f);
            pPoseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }

    private static float m_115328_(Direction pDirection) {
        return switch (pDirection) {
            case Direction.SOUTH -> 90.0f;
            case Direction.WEST -> 0.0f;
            case Direction.NORTH -> 270.0f;
            case Direction.EAST -> 180.0f;
            default -> 0.0f;
        };
    }
}

