/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.saksolm.monsterexpansion.entity.client.KobekoModel;
import net.saksolm.monsterexpansion.entity.custom.KobekoEntity;
import net.saksolm.monsterexpansion.item.ModItems;
import net.saksolm.monsterexpansion.item.armor.client.LeivekilthKobekoChestplateModel;
import net.saksolm.monsterexpansion.item.armor.client.LeivekilthKobekoHelmetModel;
import net.saksolm.monsterexpansion.item.armor.client.OreKobekoChestplateModel;
import net.saksolm.monsterexpansion.item.armor.client.OreKobekoHelmetModel;
import net.saksolm.monsterexpansion.item.armor.client.RhyzaKobekoChestplateModel;
import net.saksolm.monsterexpansion.item.armor.client.RhyzaKobekoHelmetModel;
import net.saksolm.monsterexpansion.item.armor.client.SkrytheKobekoChestplateModel;
import net.saksolm.monsterexpansion.item.armor.client.SkrytheKobekoHelmetModel;

public class KobekoArmorLayer
extends RenderLayer<KobekoEntity, KobekoModel<KobekoEntity>> {
    private final Map<Item, ArmorModelInfo> armorModels = new HashMap<Item, ArmorModelInfo>();

    public KobekoArmorLayer(RenderLayerParent<KobekoEntity, KobekoModel<KobekoEntity>> pRenderer, EntityRendererProvider.Context context) {
        super(pRenderer);
        this.loadArmorModels(context);
    }

    private void loadArmorModels(EntityRendererProvider.Context context) {
        this.armorModels.put((Item)ModItems.IRON_KOBEKO_HELMET.get(), new ArmorModelInfo(new OreKobekoHelmetModel<KobekoEntity>(context.m_174023_(OreKobekoHelmetModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/iron_kobeko_armor.png")));
        this.armorModels.put((Item)ModItems.IRON_KOBEKO_CHESTPLATE.get(), new ArmorModelInfo(new OreKobekoChestplateModel<KobekoEntity>(context.m_174023_(OreKobekoChestplateModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/iron_kobeko_armor.png")));
        this.armorModels.put((Item)ModItems.GOLD_KOBEKO_HELMET.get(), new ArmorModelInfo(new OreKobekoHelmetModel<KobekoEntity>(context.m_174023_(OreKobekoHelmetModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/gold_kobeko_armor.png")));
        this.armorModels.put((Item)ModItems.GOLD_KOBEKO_CHESTPLATE.get(), new ArmorModelInfo(new OreKobekoChestplateModel<KobekoEntity>(context.m_174023_(OreKobekoChestplateModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/gold_kobeko_armor.png")));
        this.armorModels.put((Item)ModItems.DIAMOND_KOBEKO_HELMET.get(), new ArmorModelInfo(new OreKobekoHelmetModel<KobekoEntity>(context.m_174023_(OreKobekoHelmetModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/diamond_kobeko_armor.png")));
        this.armorModels.put((Item)ModItems.DIAMOND_KOBEKO_CHESTPLATE.get(), new ArmorModelInfo(new OreKobekoChestplateModel<KobekoEntity>(context.m_174023_(OreKobekoChestplateModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/diamond_kobeko_armor.png")));
        this.armorModels.put((Item)ModItems.NETHERITE_KOBEKO_HELMET.get(), new ArmorModelInfo(new OreKobekoHelmetModel<KobekoEntity>(context.m_174023_(OreKobekoHelmetModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/netherite_kobeko_armor.png")));
        this.armorModels.put((Item)ModItems.NETHERITE_KOBEKO_CHESTPLATE.get(), new ArmorModelInfo(new OreKobekoChestplateModel<KobekoEntity>(context.m_174023_(OreKobekoChestplateModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/netherite_kobeko_armor.png")));
        this.armorModels.put((Item)ModItems.RHYZA_KOBEKO_HELMET.get(), new ArmorModelInfo(new RhyzaKobekoHelmetModel<KobekoEntity>(context.m_174023_(RhyzaKobekoHelmetModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/rhyza_kobeko_armor.png")));
        this.armorModels.put((Item)ModItems.RHYZA_KOBEKO_CHESTPLATE.get(), new ArmorModelInfo(new RhyzaKobekoChestplateModel<KobekoEntity>(context.m_174023_(RhyzaKobekoChestplateModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/rhyza_kobeko_armor.png")));
        this.armorModels.put((Item)ModItems.SKRYTHE_KOBEKO_HELMET.get(), new ArmorModelInfo(new SkrytheKobekoChestplateModel<KobekoEntity>(context.m_174023_(SkrytheKobekoHelmetModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/skrythe_kobeko_armor.png")));
        this.armorModels.put((Item)ModItems.SKRYTHE_KOBEKO_CHESTPLATE.get(), new ArmorModelInfo(new SkrytheKobekoHelmetModel<KobekoEntity>(context.m_174023_(SkrytheKobekoChestplateModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/skrythe_kobeko_armor.png")));
        this.armorModels.put((Item)ModItems.LEIVEKILTH_KOBEKO_CHESTPLATE.get(), new ArmorModelInfo(new LeivekilthKobekoChestplateModel<KobekoEntity>(context.m_174023_(LeivekilthKobekoChestplateModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/leivekilth_kobeko_armor.png")));
        this.armorModels.put((Item)ModItems.LEIVEKILTH_KOBEKO_HELMET.get(), new ArmorModelInfo(new LeivekilthKobekoHelmetModel<KobekoEntity>(context.m_174023_(LeivekilthKobekoHelmetModel.LAYER_LOCATION)), new ResourceLocation("monsterexpansion", "textures/entity/armor/leivekilth_kobeko_armor.png")));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, KobekoEntity entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderArmorPiece(poseStack, buffer, packedLight, entity, entity.getHelmetStack());
        this.renderArmorPiece(poseStack, buffer, packedLight, entity, entity.getChestplateStack());
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource buffer, int packedLight, KobekoEntity entity, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        ArmorModelInfo info = this.armorModels.get(stack.m_41720_());
        if (info != null) {
            KobekoModel<KobekoEntity> armorModel = info.model();
            KobekoModel parentModel = (KobekoModel)this.m_117386_();
            this.copyBoneAnimations(parentModel, armorModel);
            KobekoArmorLayer.m_117376_(armorModel, (ResourceLocation)info.texture(), (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void copyBoneAnimations(KobekoModel<KobekoEntity> from, KobekoModel<KobekoEntity> to) {
        to.torso.m_104315_(from.torso);
        to.upper.m_104315_(from.upper);
        to.lower.m_104315_(from.lower);
        to.head.m_104315_(from.head);
        to.jaw.m_104315_(from.jaw);
        to.right_arm.m_104315_(from.right_arm);
        to.left_arm.m_104315_(from.left_arm);
        to.right_leg.m_104315_(from.right_leg);
        to.left_leg.m_104315_(from.left_leg);
        to.tail.m_104315_(from.tail);
    }

    private record ArmorModelInfo(KobekoModel<KobekoEntity> model, ResourceLocation texture) {
    }
}

