/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.effect.HeavingGroundEffectEntity;

public class HeavingGroundRenderer
extends EntityRenderer<HeavingGroundEffectEntity> {
    public HeavingGroundRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(HeavingGroundEffectEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        float ageInTicks = (float)pEntity.f_19797_ + pPartialTick;
        float singleBlockAnimationDuration = pEntity.animation_duration;
        Vec3 centerPos = pEntity.m_20182_();
        float MAX_HEAVE_HEIGHT = 1.0f;
        float RIPPLE_SPEED = 3.0f;
        for (int i = 0; i < pEntity.blocksToHeave.size(); ++i) {
            double distanceFromCenter;
            float delay;
            float effectiveAge;
            BlockPos pos = pEntity.blocksToHeave.get(i);
            BlockState state = pEntity.blockStates.get(i);
            if (state.m_60795_() || (effectiveAge = ageInTicks - (delay = (float)(distanceFromCenter = Math.sqrt(pos.m_123331_((Vec3i)BlockPos.m_274446_((Position)centerPos)))) * 3.0f)) < 0.0f || effectiveAge > singleBlockAnimationDuration) continue;
            float progress = effectiveAge / singleBlockAnimationDuration;
            float heaveHeight = Mth.m_14031_((float)(progress * (float)Math.PI)) * 1.0f;
            pPoseStack.m_85836_();
            pPoseStack.m_85837_((double)pos.m_123341_() - centerPos.f_82479_, (double)pos.m_123342_() - centerPos.f_82480_ + (double)heaveHeight + (double)0.01f, (double)pos.m_123343_() - centerPos.f_82481_);
            int correctPackedLight = LevelRenderer.m_109541_((BlockAndTintGetter)pEntity.m_9236_(), (BlockPos)pos.m_6630_((int)Math.ceil(heaveHeight)));
            BakedModel bakedModel = blockRenderer.m_110910_(state);
            RenderType renderType = ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)false);
            VertexConsumer vertexConsumer = pBuffer.m_6299_(renderType);
            int biomeColor = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)pEntity.m_9236_(), pos, 0);
            float r = (float)(biomeColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(biomeColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(biomeColor & 0xFF) / 255.0f;
            blockRenderer.m_110937_().m_111067_(pPoseStack.m_85850_(), vertexConsumer, state, bakedModel, r, g, b, correctPackedLight, OverlayTexture.f_118083_);
            pPoseStack.m_85849_();
        }
    }

    public ResourceLocation getTextureLocation(HeavingGroundEffectEntity pEntity) {
        return null;
    }
}

