/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.animations.hitbox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.saksolm.monsterexpansion.entity.animations.hitbox.AnimationChannel;

public record AnimationDefinition(float lengthInSeconds, boolean looping, Map<String, List<AnimationChannel>> boneAnimations) {

    public static class Builder {
        private final float length;
        private final Map<String, List<AnimationChannel>> boneAnimations = new HashMap<String, List<AnimationChannel>>();
        private boolean looping;

        private Builder(float lengthInSeconds) {
            this.length = lengthInSeconds;
        }

        public static Builder withLength(float lengthInSeconds) {
            return new Builder(lengthInSeconds);
        }

        public Builder looping() {
            this.looping = true;
            return this;
        }

        public Builder addAnimation(String boneName, AnimationChannel channel) {
            this.boneAnimations.computeIfAbsent(boneName, k -> new ArrayList()).add(channel);
            return this;
        }

        public AnimationDefinition build() {
            return new AnimationDefinition(this.length, this.looping, this.boneAnimations);
        }
    }
}

