/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.skrythe;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class SkrytheTailCutGoal
extends Goal {
    private SkrytheEntity skrythe;
    private int tickCount;
    private Vec3 retreatVector;
    private boolean isExecuting = false;
    private AirPhase currentPhase;

    public SkrytheTailCutGoal(SkrytheEntity skrythe) {
        this.skrythe = skrythe;
    }

    public boolean m_8036_() {
        return this.skrythe.getCurrentStaggerState() == SkrytheEntity.StaggerState.TAIL_CUT;
    }

    public boolean m_8045_() {
        return this.skrythe.getCurrentStaggerState() == SkrytheEntity.StaggerState.TAIL_CUT && this.isExecuting;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.skrythe.setCurrentAbility(SkrytheEntity.Ability.STAGGER);
        this.skrythe.m_21573_().m_26573_();
        this.skrythe.m_20256_(Vec3.f_82478_);
        this.skrythe.setRotationManual(true);
        if (this.skrythe.isAerial()) {
            this.currentPhase = AirPhase.START;
            this.skrythe.setAirTailCutState(SkrytheEntity.AirTailCutState.START.ordinal());
        }
        this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_TAIL_CUT.get(), this.skrythe.m_5720_(), 2.0f, 1.0f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        if (this.skrythe.getCurrentStaggerState() == SkrytheEntity.StaggerState.TAIL_CUT) {
            this.skrythe.setRotationManual(false);
            this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
        }
        if (this.skrythe.getCurrentStaggerState() == SkrytheEntity.StaggerState.TAIL_CUT) {
            this.skrythe.setCurrentStaggerState(SkrytheEntity.StaggerState.NONE);
        }
        this.skrythe.setAirTailCutState(SkrytheEntity.AirTailCutState.NONE.ordinal());
        this.currentPhase = null;
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.currentPhase == null) {
            if (this.tickCount == 1) {
                this.retreatVector = this.skrythe.m_20154_().m_82490_((double)0.7f);
            }
            if (this.tickCount < 10) {
                this.skrythe.m_20334_(this.retreatVector.f_82479_, this.skrythe.m_20184_().f_82480_, this.retreatVector.f_82481_);
            }
            if (this.tickCount >= 10 && this.tickCount < 20) {
                double FRICTION = 0.95;
                this.skrythe.m_20256_(this.retreatVector);
                this.retreatVector = this.retreatVector.m_82490_(0.95);
            }
            if (this.tickCount == 10) {
                this.skrythe.setTargetRotation(this.skrythe.f_20883_ - 90.0f, 0.0f, 30, AbstractLargeMonster.TurnDirection.SHORTEST, true);
            }
            if (this.tickCount == 17) {
                this.skrythe.spawnGroundEffects(Vec3.f_82478_, 5.0f, 20, 20, 5);
                this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.skrythe.m_5720_(), 2.0f, 1.0f);
            }
            if (this.tickCount == 25) {
                this.skrythe.setTargetRotation(this.skrythe.f_20883_ - 45.0f, 0.0f, 20, AbstractLargeMonster.TurnDirection.SHORTEST, true);
            }
            if (this.tickCount == 35) {
                this.skrythe.setTargetRotation(this.skrythe.f_20883_ - 45.0f, 0.0f, 20, AbstractLargeMonster.TurnDirection.SHORTEST, true);
            }
            if (this.tickCount == 37) {
                this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_TAIL_CUT_RECOVER.get(), this.skrythe.m_5720_(), 2.0f, 1.0f);
            }
            if (this.tickCount > 45) {
                this.isExecuting = false;
            }
        } else {
            switch (this.currentPhase) {
                case START: {
                    if (this.tickCount > 7) {
                        this.skrythe.m_20256_(this.skrythe.m_20184_().m_82549_(new Vec3(0.0, -0.1, 0.0)));
                    }
                    if (this.tickCount <= 10) break;
                    this.currentPhase = AirPhase.FALL;
                    this.skrythe.setAirTailCutState(SkrytheEntity.AirTailCutState.FALL.ordinal());
                    this.tickCount = 0;
                    break;
                }
                case FALL: {
                    this.skrythe.m_20256_(this.skrythe.m_20184_().m_82549_(new Vec3(0.0, -0.2, 0.0)));
                    this.skrythe.m_20256_(new Vec3(0.0, -2.0, 0.0));
                    BlockPos posBelow = this.skrythe.m_20183_().m_6625_(1);
                    if (this.skrythe.m_9236_().m_8055_(posBelow).m_60795_()) break;
                    this.currentPhase = AirPhase.CRASH;
                    this.skrythe.setAirTailCutState(SkrytheEntity.AirTailCutState.CRASH.ordinal());
                    this.tickCount = 0;
                    break;
                }
                case CRASH: {
                    if (this.tickCount == 1) {
                        this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.skrythe.m_5720_(), 2.0f, 1.0f);
                    }
                    if (this.tickCount < 10) {
                        this.retreatVector = this.skrythe.m_20154_().m_82537_(new Vec3(0.0, -1.0, 0.0).m_82490_(0.5));
                        this.skrythe.m_20334_(this.retreatVector.f_82479_, this.skrythe.m_20184_().f_82480_, this.retreatVector.f_82481_);
                        this.skrythe.spawnGroundEffects(Vec3.f_82478_, 5.0f, 5, 5, 1);
                    }
                    if (this.tickCount == 10) {
                        this.skrythe.setTargetRotation(this.skrythe.f_20883_ - 90.0f, 0.0f, 20, AbstractLargeMonster.TurnDirection.SHORTEST, true);
                    }
                    if (this.tickCount == 20) {
                        this.skrythe.setTargetRotation(this.skrythe.f_20883_ - 45.0f, 0.0f, 15, AbstractLargeMonster.TurnDirection.SHORTEST, true);
                    }
                    if (this.tickCount == 30) {
                        this.skrythe.setTargetRotation(this.skrythe.f_20883_ - 45.0f, 0.0f, 15, AbstractLargeMonster.TurnDirection.SHORTEST, true);
                    }
                    if (this.tickCount == 33) {
                        this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_TAIL_CUT_RECOVER.get(), this.skrythe.m_5720_(), 2.0f, 1.0f);
                    }
                    if (this.tickCount <= 40) break;
                    this.isExecuting = false;
                    this.skrythe.disableFly();
                }
            }
        }
    }

    private static enum AirPhase {
        NONE,
        START,
        FALL,
        CRASH;

    }
}

