/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.skrythe;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class SkrytheRoarGoal
extends Goal {
    private final SkrytheEntity skrythe;
    private int tickCount = 0;
    private boolean isAbilityEnraged = false;
    private float targetYaw;
    private boolean isExecuting = false;

    public SkrytheRoarGoal(SkrytheEntity skrythe) {
        this.skrythe = skrythe;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.ROAR && this.skrythe.m_5448_() != null;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.ROAR;
    }

    public void m_8041_() {
        this.isExecuting = false;
        if (this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.ROAR) {
            this.skrythe.setRotationManual(false);
            this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
        }
        this.skrythe.resetPartOffsets();
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.isAbilityEnraged = this.skrythe.isAbilityEnraged();
        this.skrythe.m_21573_().m_26573_();
        this.skrythe.setRotationManual(true);
        this.targetYaw = this.skrythe.getPredictedAngle(1);
        this.skrythe.setTargetRotation(this.targetYaw, 0.0f, 20, AbstractLargeMonster.TurnDirection.SHORTEST, true);
        this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_ROAR.get(), this.skrythe.m_5720_(), 5.0f, 1.0f);
        this.skrythe.resetPartOffsets();
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount >= 1 && this.tickCount <= 10) {
            this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 0.15, 0.0));
        }
        if (this.tickCount == 10) {
            this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, -3.5, 0.0));
            this.skrythe.spawnShockwave(this.skrythe.m_146892_().m_82549_(this.skrythe.m_20154_().m_82490_(5.0)), this.skrythe.m_146908_(), this.skrythe.m_146909_(), 25.0f, 0.0f, 40);
        }
        if (this.tickCount <= 25 && this.tickCount >= 10 && this.skrythe.m_5448_() != null) {
            int PARTICLE_COUNT_PER_TICK = 10;
            double PARTICLE_SPEED = 4.0;
            double PARTICLE_SPREAD = 0.3;
            SimpleParticleType particleOptions = ParticleTypes.f_123759_;
            Vec3 lookVec = this.skrythe.m_20154_();
            Vec3 mouthPos = this.skrythe.m_146892_().m_82549_(lookVec.m_82490_(5.0)).m_82549_(new Vec3(0.0, -2.0, 0.0));
            if (!this.isAbilityEnraged) {
                double PROJECTILE_SPREAD = 0.1;
                for (int i = 0; i < 10; ++i) {
                    double spreadX = this.skrythe.m_217043_().m_188583_() * 0.1;
                    double spreadY = this.skrythe.m_217043_().m_188583_() * 0.1;
                    double spreadZ = this.skrythe.m_217043_().m_188583_() * 0.1;
                    Vec3 particleVelocity = lookVec.m_82520_(spreadX, spreadY, spreadZ).m_82541_().m_82490_(4.0);
                    ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)particleOptions, mouthPos, particleVelocity, false), (Entity)this.skrythe);
                }
            } else {
                boolean PROJECTILE_COUNT_PER_TICK = true;
                double PROJECTILE_SPEED = 2.0;
                for (int i = 0; i < 1; ++i) {
                    double spreadX = this.skrythe.m_217043_().m_188583_() * 0.3;
                    double spreadY = this.skrythe.m_217043_().m_188583_() * 0.3;
                    double spreadZ = this.skrythe.m_217043_().m_188583_() * 0.3;
                    Vec3 fireVelocity = lookVec.m_82520_(spreadX, spreadY, spreadZ).m_82541_().m_82490_(2.0);
                    this.skrythe.fireSoundSphere(mouthPos, fireVelocity);
                }
            }
            double range = 50.0;
            double coneAngle = Math.toRadians(60.0);
            AABB area = this.skrythe.m_20191_().m_82400_(range);
            Vec3 origin = this.skrythe.m_20182_();
            List entities = this.skrythe.m_9236_().m_6443_(LivingEntity.class, area, e -> e != this.skrythe && e.m_6084_());
            for (LivingEntity entity : entities) {
                Vec3 toTarget = entity.m_20182_().m_82546_(origin).m_82541_();
                double angleToEntity = Math.acos(lookVec.m_82526_(toTarget));
                if (!(angleToEntity <= coneAngle / 2.0)) continue;
                Vec3 push = toTarget.m_82490_(0.5);
                entity.m_5997_(push.f_82479_, 0.2, push.f_82481_);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 1));
                entity.m_6469_(this.skrythe.m_269291_().m_269333_((LivingEntity)this.skrythe), 10.0f);
            }
        }
        if (this.tickCount == 30) {
            this.skrythe.resetPartOffsets();
        }
        if (this.tickCount > 40) {
            this.isExecuting = false;
        }
    }
}

