/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.skrythe;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.ScreenShakePacket;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class SkrytheChargeGoal
extends Goal {
    private final SkrytheEntity skrythe;
    private int tickCount = 0;
    private Phase currentPhase;
    private Vec3 chargeDestination;
    private final AbstractLargeMonster.KnockbackType KNOCKBACK_TYPE = AbstractLargeMonster.KnockbackType.UPWARD;
    private final int STRENGTH = 3;
    private boolean isExecuting = false;

    public SkrytheChargeGoal(SkrytheEntity skrythe) {
        this.skrythe = skrythe;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.skrythe.m_5448_() != null && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.CHARGE;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.CHARGE;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.skrythe.setChargeState(SkrytheEntity.ChargeState.STARTUP.ordinal());
        this.currentPhase = Phase.STARTUP;
        this.isExecuting = true;
        this.skrythe.m_21573_().m_26573_();
        this.skrythe.resetPartOffsets();
    }

    public void m_8041_() {
        this.currentPhase = null;
        this.isExecuting = false;
        this.skrythe.setChargeState(SkrytheEntity.ChargeState.NONE.ordinal());
        if (this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.CHARGE) {
            this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
        }
        this.skrythe.m_21573_().m_26573_();
        this.skrythe.resetPartOffsets();
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case STARTUP: {
                this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 0.3, 0.0));
                if (this.tickCount < 7) break;
                this.chargeDestination = this.skrythe.getPredictedTargetPosition(this.skrythe.m_5448_(), 30);
                Path path = this.skrythe.m_21573_().m_7864_(BlockPos.m_274446_((Position)this.chargeDestination), 0);
                if (path != null && !path.m_77392_()) {
                    this.skrythe.m_21573_().m_26536_(path, 1.5);
                    this.currentPhase = Phase.CHARGING;
                    this.skrythe.setChargeState(SkrytheEntity.ChargeState.CHARGING.ordinal());
                    this.tickCount = 0;
                    break;
                }
                this.isExecuting = false;
                break;
            }
            case CHARGING: {
                if (!this.skrythe.m_21573_().m_26571_() && this.tickCount <= 100) break;
                this.currentPhase = Phase.SLAM;
                this.skrythe.setChargeState(SkrytheEntity.ChargeState.SLAM.ordinal());
                this.tickCount = 0;
                break;
            }
            case SLAM: {
                if (this.tickCount == 5) {
                    this.skrythe.resetPartOffsets();
                    this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.skrythe.m_5720_(), 2.0f, 1.0f);
                    ModNetwork.sendToClientsTracking(new ScreenShakePacket(20, 5), (Entity)this.skrythe);
                    this.skrythe.spawnGroundEffects(new Vec3(3.0, 0.0, 6.0), 5.0f, 40, 30, 5);
                    this.skrythe.spawnGroundEffects(new Vec3(-3.0, 0.0, 6.0), 5.0f, 40, 30, 5);
                    this.skrythe.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 6.0), 3.0f, 240);
                    this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), new Vec3(0.0, 0.0, 6.0), 12.0, 8.0, 12.0, 2.0f, this.KNOCKBACK_TYPE, 3.0, false, false, 80);
                }
                if (this.tickCount < 15) break;
                this.currentPhase = null;
                this.isExecuting = false;
            }
        }
    }

    private static enum Phase {
        STARTUP,
        CHARGING,
        SLAM;

    }
}

