/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.skrythe;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class SkrytheAirOrbGoal
extends Goal {
    private SkrytheEntity skrythe;
    private int tickCount = 0;
    private boolean isAbilityEnraged = false;
    private boolean isExecuting = false;

    public SkrytheAirOrbGoal(SkrytheEntity skrythe) {
        this.skrythe = skrythe;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.skrythe.m_5448_() != null && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.AIR_ORB;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.AIR_ORB;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.isAbilityEnraged = this.skrythe.isAbilityEnraged();
        if (!this.isAbilityEnraged) {
            this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_AIR_ORB.get(), this.skrythe.m_5720_(), 3.0f, 1.0f);
        } else {
            this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_ENRAGED_AIR_ORB.get(), this.skrythe.m_5720_(), 3.0f, 1.0f);
        }
        this.skrythe.setRotationManual(true);
        this.skrythe.resetPartOffsets();
    }

    public void m_8041_() {
        this.isExecuting = false;
        if (this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.AIR_ORB) {
            this.skrythe.setRotationManual(false);
            this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
        }
        this.skrythe.resetPartOffsets();
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount >= 1 && this.tickCount <= 15) {
            this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 0.2, -0.1));
        }
        if (this.skrythe.m_5448_() != null) {
            float targetYaw = this.skrythe.getPredictedAngle(20);
            this.skrythe.setTargetRotation(targetYaw, 0.0f, 20);
        }
        if (!this.isAbilityEnraged) {
            if (this.tickCount == 15) {
                this.skrythe.resetPartOffsets();
                Vec3 spawnPos = this.skrythe.m_146892_().m_82549_(this.skrythe.m_20154_().m_82490_(7.0));
                Vec3 direction = this.skrythe.getPredictedDirection(spawnPos, 20);
                Vec3 movementVector = direction.m_82490_(1.2);
                float targetYaw = this.skrythe.getYawFromDirection(direction);
                this.skrythe.setTargetRotation(targetYaw, 0.0f, 20);
                this.skrythe.fireDistortionOrb(spawnPos, movementVector);
            }
            if (this.tickCount == 20) {
                this.isExecuting = false;
            }
        } else {
            float targetYaw;
            Vec3 movementVector;
            Vec3 direction;
            if (this.tickCount == 15) {
                this.skrythe.resetPartOffsets();
                Vec3 spawnPos = this.skrythe.m_146892_().m_82549_(this.skrythe.m_20154_().m_82490_(7.0));
                direction = this.skrythe.getPredictedDirection(spawnPos, 20);
                movementVector = direction.m_82490_(1.2);
                targetYaw = this.skrythe.getYawFromDirection(direction);
                this.skrythe.setTargetRotation(targetYaw, 0.0f, 20);
                this.skrythe.fireDistortionOrb(spawnPos, movementVector);
            }
            if (this.tickCount == 20) {
                Vec3 spawnPos = this.skrythe.m_146892_().m_82549_(this.skrythe.m_20154_().m_82490_(7.0));
                direction = this.skrythe.getPredictedDirection(spawnPos, 20);
                movementVector = direction.m_82490_(1.2);
                targetYaw = this.skrythe.getYawFromDirection(direction);
                this.skrythe.setTargetRotation(targetYaw, 0.0f, 20);
                this.skrythe.fireDistortionOrb(spawnPos, movementVector);
            }
            if (this.tickCount == 23) {
                Vec3 spawnPos = this.skrythe.m_146892_().m_82549_(this.skrythe.m_20154_().m_82490_(7.0));
                direction = this.skrythe.getPredictedDirection(spawnPos, 20);
                movementVector = direction.m_82490_(1.2);
                targetYaw = this.skrythe.getYawFromDirection(direction);
                this.skrythe.setTargetRotation(targetYaw, 0.0f, 20);
                this.skrythe.fireDistortionOrb(spawnPos, movementVector);
            }
            if (this.tickCount == 28) {
                Vec3 spawnPos = this.skrythe.m_146892_().m_82549_(this.skrythe.m_20154_().m_82490_(7.0));
                direction = this.skrythe.getPredictedDirection(spawnPos, 20);
                movementVector = direction.m_82490_(1.2);
                targetYaw = this.skrythe.getYawFromDirection(direction);
                this.skrythe.setTargetRotation(targetYaw, 0.0f, 20);
                this.skrythe.fireDistortionOrb(spawnPos, movementVector);
            }
            if (this.tickCount == 38) {
                this.isExecuting = false;
            }
        }
    }
}

