/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.skrythe;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;

public class SkrytheAirDashGoal
extends Goal {
    private SkrytheEntity skrythe;
    private int tickCount = 0;
    private boolean isExecuting = false;
    private Vec3 direction;
    Vec3 targetPosition;
    private boolean justTurn = false;
    private Phase currentPhase;

    public SkrytheAirDashGoal(SkrytheEntity skrythe) {
        this.skrythe = skrythe;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        return this.skrythe.m_5448_() != null && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.AIR_DASH;
    }

    public boolean m_8045_() {
        return this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.AIR_DASH && this.isExecuting;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.skrythe.m_20256_(Vec3.f_82478_);
        if (this.skrythe.m_5448_() == null || !this.skrythe.m_5448_().m_6084_()) {
            this.m_8041_();
            return;
        }
        if (this.skrythe.m_217043_().m_188503_(2) == 0) {
            this.targetPosition = this.skrythe.m_5448_().m_20182_();
            this.justTurn = true;
        } else {
            this.targetPosition = this.getRandomPositionAroundTarget();
            this.justTurn = false;
        }
        if (this.targetPosition == null) {
            this.m_8041_();
            return;
        }
        Vec3 vecToTarget = this.targetPosition.m_82546_(this.skrythe.m_20182_()).m_82541_();
        double dotProduct = vecToTarget.m_82526_(this.skrythe.m_20154_());
        if (dotProduct > 0.25) {
            this.currentPhase = Phase.MOVE;
            this.skrythe.setAirDashState(SkrytheEntity.AirDashState.MOVE.ordinal());
            this.skrythe.setTargetRotation(this.skrythe.getYawFromDirection(this.targetPosition.m_82546_(this.skrythe.m_20182_())), 0.0f, 10, AbstractLargeMonster.TurnDirection.SHORTEST, true);
        } else if (this.skrythe.isPositionOnLeft(this.targetPosition)) {
            this.currentPhase = Phase.TURN_LEFT;
            this.skrythe.setAirDashState(SkrytheEntity.AirDashState.TURN_LEFT.ordinal());
        } else {
            this.currentPhase = Phase.TURN_RIGHT;
            this.skrythe.setAirDashState(SkrytheEntity.AirDashState.TURN_RIGHT.ordinal());
        }
        this.skrythe.setRotationManual(true);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.skrythe.m_20256_(Vec3.f_82478_);
        this.currentPhase = null;
        if (this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.AIR_DASH) {
            this.skrythe.setRotationManual(false);
            this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
        }
        this.skrythe.setAirDashState(SkrytheEntity.AirDashState.NONE.ordinal());
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case TURN_LEFT: {
                if (this.tickCount == 1) {
                    this.skrythe.setTargetRotation(this.skrythe.getYawFromDirection(this.targetPosition.m_82546_(this.skrythe.m_20182_())), 0.0f, 20, AbstractLargeMonster.TurnDirection.LEFT, true);
                    this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), SoundEvents.f_12230_, this.skrythe.m_5720_(), 2.0f, 1.5f);
                }
                if (!this.justTurn && this.tickCount > 12) {
                    this.currentPhase = Phase.MOVE;
                    this.skrythe.setAirDashState(SkrytheEntity.AirDashState.MOVE.ordinal());
                    this.tickCount = 0;
                    break;
                }
                if (!this.justTurn || this.tickCount <= 12) break;
                this.currentPhase = null;
                this.isExecuting = false;
                break;
            }
            case TURN_RIGHT: {
                if (this.tickCount == 1) {
                    this.skrythe.setTargetRotation(this.skrythe.getYawFromDirection(this.targetPosition.m_82546_(this.skrythe.m_20182_())), 0.0f, 20, AbstractLargeMonster.TurnDirection.RIGHT, true);
                    this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), SoundEvents.f_12230_, this.skrythe.m_5720_(), 2.0f, 1.5f);
                }
                if (!this.justTurn && this.tickCount > 12) {
                    this.currentPhase = Phase.MOVE;
                    this.skrythe.setAirDashState(SkrytheEntity.AirDashState.MOVE.ordinal());
                    this.tickCount = 0;
                    break;
                }
                if (!this.justTurn || this.tickCount <= 12) break;
                this.currentPhase = null;
                this.isExecuting = false;
                break;
            }
            case MOVE: {
                if (this.tickCount == 1) {
                    this.direction = this.targetPosition.m_82546_(this.skrythe.m_20182_()).m_82541_().m_82490_(1.0);
                }
                if (this.tickCount > 5) {
                    this.skrythe.m_20334_(this.direction.f_82479_, 0.0, this.direction.f_82481_);
                }
                if (this.tickCount <= 35 && (this.tickCount <= 10 || !(this.skrythe.m_20275_(this.targetPosition.f_82479_, this.skrythe.m_20182_().f_82480_, this.targetPosition.f_82481_) <= 4.0))) break;
                if (this.skrythe.isTargetOnLeft(this.skrythe.m_5448_())) {
                    this.currentPhase = Phase.STOP_LEFT;
                    this.skrythe.setAirDashState(SkrytheEntity.AirDashState.STOP_LEFT.ordinal());
                    this.tickCount = 0;
                    break;
                }
                this.currentPhase = Phase.STOP_RIGHT;
                this.skrythe.setAirDashState(SkrytheEntity.AirDashState.STOP_RIGHT.ordinal());
                this.tickCount = 0;
                break;
            }
            case STOP_LEFT: {
                if (this.tickCount == 1) {
                    this.skrythe.setTargetRotation(this.skrythe.getPredictedAngle(10), 0.0f, 20, AbstractLargeMonster.TurnDirection.LEFT, true);
                }
                if (this.tickCount == 5) {
                    this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), SoundEvents.f_11893_, this.skrythe.m_5720_(), 2.0f, 0.8f);
                }
                if (this.tickCount <= 12) break;
                this.isExecuting = false;
                break;
            }
            case STOP_RIGHT: {
                if (this.tickCount == 1) {
                    this.skrythe.setTargetRotation(this.skrythe.getPredictedAngle(10), 0.0f, 20, AbstractLargeMonster.TurnDirection.RIGHT, true);
                }
                if (this.tickCount == 5) {
                    this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), SoundEvents.f_11893_, this.skrythe.m_5720_(), 2.0f, 0.8f);
                }
                if (this.tickCount <= 12) break;
                this.isExecuting = false;
            }
        }
    }

    private Vec3 getRandomPositionAroundTarget() {
        LivingEntity target = this.skrythe.m_5448_();
        if (target == null) {
            return null;
        }
        double minRadius = 10.0;
        double maxRadius = 12.0;
        double randomRadius = minRadius + this.skrythe.m_217043_().m_188500_() * (maxRadius - minRadius);
        Vec3 toTargetVec = this.skrythe.m_20182_().m_82505_(target.m_20182_());
        double angleToTarget = Mth.m_14136_((double)toTargetVec.f_82481_, (double)toTargetVec.f_82479_);
        boolean isTargetOnLeft = this.skrythe.isPositionOnLeft(target.m_20182_());
        double sideOffsetAngle = isTargetOnLeft ? 1.5707963267948966 : -1.5707963267948966;
        double randomAngleSpread = (this.skrythe.m_217043_().m_188500_() - 0.5) * 2.0943951023931953;
        double finalAngle = angleToTarget + sideOffsetAngle + randomAngleSpread;
        double offsetX = Math.cos(finalAngle) * randomRadius;
        double offsetZ = Math.sin(finalAngle) * randomRadius;
        return target.m_20182_().m_82520_(offsetX, 0.0, offsetZ);
    }

    private static enum Phase {
        TURN_LEFT,
        TURN_RIGHT,
        MOVE,
        STOP_LEFT,
        STOP_RIGHT;

    }
}

