/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.skrythe;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class SkrytheAerialAssaultGoal
extends Goal {
    private SkrytheEntity skrythe;
    private int tickCount = 0;
    private float targetYaw = 0.0f;
    private Vec3 diveDirection = Vec3.f_82478_;
    private Vec3 roarDirection = Vec3.f_82478_;
    private Vec3 slideDirection = Vec3.f_82478_;
    private final AbstractLargeMonster.KnockbackType KNOCKBACK_TYPE = AbstractLargeMonster.KnockbackType.FORWARD;
    private final float STRENGTH = 5.0f;
    private Phase currentPhase;
    private boolean isExecuting = false;

    public SkrytheAerialAssaultGoal(SkrytheEntity skrythe) {
        this.skrythe = skrythe;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.skrythe.m_5448_() != null && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.AERIAL_ASSAULT;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.AERIAL_ASSAULT;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.skrythe.m_21573_().m_26573_();
        this.skrythe.setRotationManual(true);
        this.skrythe.m_20256_(Vec3.f_82478_);
        this.skrythe.setAerialAssaultState(SkrytheEntity.AerialAssaultState.RISE.ordinal());
        this.currentPhase = Phase.RISE;
        this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_AERIAL_ASSAULT_RISE.get(), this.skrythe.m_5720_(), 3.0f, 1.0f);
        this.skrythe.resetPartOffsets();
    }

    public void m_8041_() {
        this.isExecuting = false;
        if (this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.AERIAL_ASSAULT) {
            this.skrythe.setRotationManual(false);
            this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
        }
        this.skrythe.setAerialAssaultState(SkrytheEntity.AerialAssaultState.NONE.ordinal());
        this.currentPhase = null;
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case RISE: {
                if (this.tickCount >= 1 && this.tickCount < 5) {
                    this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, -0.3, 0.0));
                }
                if (this.tickCount == 1) {
                    this.targetYaw = this.skrythe.getPredictedAngle(1);
                    this.skrythe.setTargetRotation(this.targetYaw, 0.0f, 25);
                }
                if (this.tickCount == 20) {
                    this.skrythe.setPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 3.0, -3.0));
                }
                if (this.tickCount >= 20 && this.tickCount < 35) {
                    this.skrythe.m_20256_(this.skrythe.m_20184_().m_82520_(0.0, 0.15, 0.0));
                }
                if (this.tickCount == 35) {
                    this.skrythe.m_20256_(new Vec3(0.0, 0.02, 0.0));
                    this.roarDirection = this.skrythe.getPredictedDirection(this.skrythe.m_146892_(), 20);
                    this.targetYaw = this.skrythe.getYawFromDirection(this.roarDirection);
                    this.skrythe.setTargetRotation(this.targetYaw, 0.0f, 40);
                    this.skrythe.setPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 0.0, 0.0));
                }
                if (this.tickCount == 55) {
                    this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_ROAR_ENRAGE.get(), this.skrythe.m_5720_(), 5.0f, 1.0f);
                    this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, -0.5, 0.0));
                    this.skrythe.spawnShockwave(this.skrythe.m_146892_().m_82549_(this.skrythe.m_20154_().m_82490_(5.0).m_82549_(new Vec3(0.0, 1.0, 0.0))), this.skrythe.m_146908_(), this.skrythe.m_146909_(), 25.0f, 0.0f, 40);
                }
                if (this.tickCount >= 55 && this.tickCount < 87) {
                    LivingEntity target = this.skrythe.m_5448_();
                    if (target == null) {
                        return;
                    }
                    this.roarDirection = this.skrythe.getPredictedHorizontalDirection(20);
                    this.targetYaw = this.skrythe.getYawFromDirection(this.roarDirection);
                    this.skrythe.setTargetRotation(this.targetYaw, 0.0f, 5);
                    int PROJECTILES_TO_FIRE = 3;
                    double SPREAD = 0.2;
                    double SPEED = 1.8;
                    Vec3 mouthPos = this.skrythe.m_146892_().m_82549_(this.skrythe.m_20154_().m_82490_(5.0).m_82549_(new Vec3(0.0, 1.0, 0.0)));
                    Vec3 directionToTarget = target.m_20182_().m_82546_(mouthPos).m_82541_();
                    for (int i = 0; i < 3; ++i) {
                        double spreadX = this.skrythe.m_217043_().m_188583_() * 0.2;
                        double spreadY = this.skrythe.m_217043_().m_188583_() * 0.2;
                        double spreadZ = this.skrythe.m_217043_().m_188583_() * 0.2;
                        Vec3 fireVelocity = directionToTarget.m_82520_(spreadX, spreadY, spreadZ).m_82541_().m_82490_(1.8);
                        this.skrythe.fireSoundSphere(mouthPos, fireVelocity);
                    }
                }
                if (this.tickCount < 87) break;
                this.currentPhase = Phase.TRANSITION;
                this.skrythe.setAerialAssaultState(SkrytheEntity.AerialAssaultState.TRANSITION.ordinal());
                this.tickCount = 0;
                break;
            }
            case TRANSITION: {
                if (this.tickCount < 5) break;
                this.currentPhase = Phase.DIVE;
                this.skrythe.setAerialAssaultState(SkrytheEntity.AerialAssaultState.DIVE.ordinal());
                this.tickCount = 0;
                break;
            }
            case DIVE: {
                this.skrythe.setPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, -5.0, 0.0));
                this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), Vec3.f_82478_, 10.0, 10.0, 10.0, 2.0f, this.KNOCKBACK_TYPE, 5.0);
                if (this.tickCount == 1) {
                    Vec3 horizontalDirection = this.skrythe.getPredictedHorizontalDirection(1);
                    float diveAnglePitch = -45.0f;
                    this.diveDirection = new Vec3(horizontalDirection.f_82479_, Math.tan(diveAnglePitch * ((float)Math.PI / 180)), horizontalDirection.f_82481_).m_82541_();
                    this.targetYaw = this.skrythe.getYawFromDirection(this.diveDirection);
                    double initialDiveSpeed = 2.0;
                    this.skrythe.m_20256_(this.diveDirection.m_82490_(initialDiveSpeed));
                }
                if (this.tickCount > 1) {
                    this.skrythe.setTargetRotation(this.targetYaw, 0.0f, 5);
                    this.skrythe.m_20256_(this.diveDirection.m_82490_(2.0));
                }
                BlockPos posBelow = this.skrythe.m_20183_().m_6625_(2);
                if (this.tickCount <= 10 || this.skrythe.m_9236_().m_8055_(posBelow).m_60795_() && !this.skrythe.m_20096_()) break;
                Vec3 currentVelocity = this.skrythe.m_20184_();
                this.slideDirection = new Vec3(currentVelocity.f_82479_, 0.0, currentVelocity.f_82481_);
                this.currentPhase = Phase.CRASH;
                this.skrythe.setAerialAssaultState(SkrytheEntity.AerialAssaultState.CRASH.ordinal());
                this.tickCount = 0;
                this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_AERIAL_ASSAULT_CRASH.get(), this.skrythe.m_5720_(), 2.0f, 1.0f);
                this.skrythe.disableFly();
                break;
            }
            case CRASH: {
                if (this.tickCount >= 1 && this.tickCount <= 10) {
                    this.skrythe.setPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, -2.0, 0.0));
                    this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), Vec3.f_82478_, 20.0, 10.0, 15.0, 2.0f, this.KNOCKBACK_TYPE, 5.0, false, false, 20);
                } else {
                    this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), Vec3.f_82478_, 10.0, 10.0, 10.0, 2.0f, this.KNOCKBACK_TYPE, 5.0);
                }
                double FRICTION = 0.95;
                this.skrythe.m_20256_(this.slideDirection);
                this.slideDirection = this.slideDirection.m_82490_(0.95);
                this.skrythe.spawnGroundEffects(Vec3.f_82478_, 5.0f, 5, 0, 0);
                if (this.tickCount > 20) {
                    this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 0.5, 0.0));
                }
                if (this.tickCount <= 25) break;
                this.isExecuting = false;
                this.skrythe.disableFly();
            }
        }
    }

    private static enum Phase {
        RISE,
        TRANSITION,
        DIVE,
        CRASH;

    }
}

