/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rhyza;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RhyzaEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class RhyzaSlashGoal
extends Goal {
    private RhyzaEntity rhyza;
    private int tickCount = 0;
    private boolean isExecuting = false;

    public RhyzaSlashGoal(RhyzaEntity rhyza) {
        this.rhyza = rhyza;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rhyza.m_5448_() != null && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.SLASH;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.SLASH;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rhyza.m_21573_().m_26573_();
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setRotationManual(true);
        this.rhyza.resetPartOffsets();
        this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_SLASH.get(), this.rhyza.m_5720_(), 1.0f, 1.0f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setCurrentAbility(RhyzaEntity.Ability.NONE);
        this.rhyza.setRotationManual(false);
        this.rhyza.resetPartOffsets();
    }

    public void m_8037_() {
        Vec3 retreatVector;
        ++this.tickCount;
        if (this.tickCount > 1 && this.tickCount <= 6) {
            this.rhyza.setTargetRotation(this.rhyza.getPredictedAngle(5), 0.0f, 5);
            retreatVector = this.rhyza.m_20154_().m_82490_(-0.35);
            this.rhyza.m_20256_(retreatVector);
            this.rhyza.addPartOffset(this.rhyza.getHeadPart(), new Vec3(-0.4, -0.1, -0.2));
        }
        if (this.tickCount >= 6 && this.tickCount <= 10) {
            this.rhyza.m_20256_(this.rhyza.getPredictedHorizontalDirection(5));
        }
        if (this.tickCount == 8) {
            this.rhyza.setPartOffset(this.rhyza.getHeadPart(), new Vec3(1.4, -0.5, -1.0));
        }
        if (this.tickCount >= 10 && this.tickCount <= 12) {
            this.rhyza.m_20256_(Vec3.f_82478_);
        }
        if (this.tickCount == 10) {
            this.rhyza.dealDamageInOrientedBox(this.rhyza.m_20182_(), new Vec3(0.0, 0.0, 2.0), 8.0, 10.0, 6.0, 1.5f, AbstractLargeMonster.KnockbackType.FORWARD, 1.0, false, true, 60);
        }
        if (this.tickCount == 14) {
            this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_CLAW_UNSTUCK.get(), this.rhyza.m_5720_(), 1.0f, 1.0f);
        }
        if (this.tickCount >= 12 && this.tickCount <= 15) {
            this.rhyza.addPartOffset(this.rhyza.getHeadPart(), new Vec3(-0.5, 0.05, 0.2));
            retreatVector = this.rhyza.m_20154_().m_82490_(-0.2);
            this.rhyza.m_20256_(retreatVector);
        }
        if (this.tickCount >= 15 && this.tickCount <= 22) {
            this.rhyza.addPartOffset(this.rhyza.getHeadPart(), new Vec3(0.1, 0.05, 0.0));
        }
        if (this.tickCount == 22) {
            this.isExecuting = false;
        }
    }
}

