/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rhyza;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RhyzaEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class RhyzaRightSlashGoal
extends Goal {
    private RhyzaEntity rhyza;
    private int tickCount = 0;
    private boolean isExecuting = false;
    private Vec3 direction;

    public RhyzaRightSlashGoal(RhyzaEntity rhyza) {
        this.rhyza = rhyza;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rhyza.m_5448_() != null && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.RIGHT_SLASH;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.RIGHT_SLASH;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rhyza.m_21573_().m_26573_();
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setRotationManual(true);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setCurrentAbility(RhyzaEntity.Ability.NONE);
        this.rhyza.setRotationManual(false);
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount > 1 && this.tickCount < 9) {
            this.rhyza.dealDamageInOrientedBox(this.rhyza.m_20182_(), new Vec3(0.0, 0.0, 3.0), 2.0, 6.0, 6.0, 1.5f, AbstractLargeMonster.KnockbackType.STANDARD, 2.0);
        }
        if (this.tickCount == 4) {
            this.rhyza.setTargetRotation(this.rhyza.getPredictedAngle(5), 0.0f, 6, AbstractLargeMonster.TurnDirection.RIGHT, true);
        }
        if (this.tickCount == 8) {
            // empty if block
        }
        if (this.tickCount == 9) {
            this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_DASH.get(), this.rhyza.m_5720_(), 1.0f, 1.0f);
            this.rhyza.m_20256_(this.rhyza.m_20154_().m_82490_(-3.0).m_82549_(new Vec3(0.0, 0.35, 0.0)));
        }
        if (this.tickCount > 16) {
            this.isExecuting = false;
        }
    }
}

