/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rhyza;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RhyzaEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class RhyzaLeapGoal
extends Goal {
    private RhyzaEntity rhyza;
    private int tickCount = 0;
    private boolean isExecuting = false;
    private Vec3 direction = Vec3.f_82478_;

    public RhyzaLeapGoal(RhyzaEntity rhyza) {
        this.rhyza = rhyza;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rhyza.m_5448_() != null && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.LEAP;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.LEAP;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rhyza.m_21573_().m_26573_();
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setRotationManual(true);
        this.rhyza.resetPartOffsets();
        this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_LEAP.get(), this.rhyza.m_5720_(), 2.0f, 1.0f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setCurrentAbility(RhyzaEntity.Ability.NONE);
        this.rhyza.setRotationManual(false);
        this.rhyza.resetPartOffsets();
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount > 1 && this.tickCount <= 6) {
            this.rhyza.setTargetRotation(this.rhyza.getPredictedAngle(5), 0.0f, 5);
            Vec3 retreatVector = this.rhyza.m_20154_().m_82490_(-0.35);
            this.rhyza.m_20256_(retreatVector);
            this.rhyza.addPartOffset(this.rhyza.getHeadPart(), new Vec3(-0.4, -0.1, -0.2));
        }
        if (this.tickCount == 6) {
            this.direction = this.rhyza.getPredictedHorizontalDirection(5);
        }
        if (this.tickCount >= 7 && this.tickCount <= 10) {
            this.rhyza.m_20256_(this.direction.m_82490_(2.0));
            this.rhyza.resetPartOffsets();
        }
        if (this.tickCount == 10) {
            this.rhyza.setTargetRotation(this.rhyza.f_20883_ + 180.0f, 0.0f, 20, AbstractLargeMonster.TurnDirection.LEFT, true);
        }
        if (this.tickCount > 10 && this.tickCount <= 25) {
            double slideSpeed = Mth.m_14139_((double)((float)(this.tickCount - 10) / 14.0f), (double)2.0, (double)0.0);
            this.rhyza.m_20256_(this.direction.m_82490_(slideSpeed));
        }
        if (this.tickCount == 14) {
            this.rhyza.dealDamageInOrientedBox(this.rhyza.m_20182_(), Vec3.f_82478_, 8.0, 8.0, 8.0, 3.0f, AbstractLargeMonster.KnockbackType.NONE, 1.0, true, false, 0);
            this.rhyza.spawnSmashedGroundEffect(Vec3.f_82478_, 2.0f, 240);
            this.rhyza.spawnGroundEffects(Vec3.f_82478_, 4.0f, 10, 20, 5);
            this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_LEG_STOMP.get(), this.rhyza.m_5720_(), 2.0f, 1.0f);
            this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_DRAG.get(), this.rhyza.m_5720_(), 1.0f, 1.0f);
        }
        if (this.tickCount == 30) {
            this.isExecuting = false;
        }
    }
}

