/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rhyza;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RhyzaEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class RhyzaFrenzyGoal
extends Goal {
    private RhyzaEntity rhyza;
    private int tickCount = 0;
    private boolean isExecuting = false;
    private boolean firstSlash = false;
    private Phase currentPhase;
    private float againChance = 0.9f;

    public RhyzaFrenzyGoal(RhyzaEntity rhyza) {
        this.rhyza = rhyza;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rhyza.m_5448_() != null && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.FRENZY;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.FRENZY;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rhyza.m_21573_().m_26573_();
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setRotationManual(true);
        this.rhyza.resetPartOffsets();
        this.againChance = 0.9f;
        this.currentPhase = Phase.START;
        this.rhyza.setFrenzyState(RhyzaEntity.FrenzyState.START.ordinal());
        this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_SLASH.get(), this.rhyza.m_5720_(), 1.0f, 1.0f);
        this.firstSlash = true;
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setCurrentAbility(RhyzaEntity.Ability.NONE);
        this.rhyza.setRotationManual(false);
        this.rhyza.resetPartOffsets();
        this.rhyza.setFrenzyState(RhyzaEntity.FrenzyState.NONE.ordinal());
        this.currentPhase = null;
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case START: {
                if (this.tickCount > 1 && this.tickCount <= 6) {
                    this.rhyza.setTargetRotation(this.rhyza.getPredictedAngle(5), 0.0f, 5);
                    Vec3 retreatVector = this.rhyza.m_20154_().m_82490_(-0.35);
                    this.rhyza.m_20256_(retreatVector);
                    this.rhyza.addPartOffset(this.rhyza.getHeadPart(), new Vec3(0.4, -0.1, -0.2));
                }
                if (this.tickCount > 5) {
                    this.rhyza.m_20256_(this.rhyza.getPredictedHorizontalDirection(5));
                }
                if (this.tickCount <= 6) break;
                this.tickCount = 0;
                this.rhyza.setFrenzyState(RhyzaEntity.FrenzyState.LEFT.ordinal());
                this.currentPhase = Phase.LEFT;
                break;
            }
            case LEFT: {
                if (this.tickCount <= 2) {
                    this.rhyza.m_20256_(this.rhyza.getPredictedHorizontalDirection(5).m_82490_(1.5));
                }
                if (this.tickCount == 2 && !this.firstSlash) {
                    this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_CLAW.get(), this.rhyza.m_5720_(), 1.0f, 1.0f);
                }
                if (this.tickCount == 2) {
                    this.rhyza.m_20256_(Vec3.f_82478_);
                    this.rhyza.setPartOffset(this.rhyza.getHeadPart(), new Vec3(-1.4, -0.5, -1.0));
                }
                if (this.tickCount == 3) {
                    this.rhyza.dealDamageInOrientedBox(this.rhyza.m_20182_(), new Vec3(0.0, 0.0, 2.0), 8.0, 8.0, 6.0, 1.5f, AbstractLargeMonster.KnockbackType.FORWARD, 1.0, false, true, 60);
                }
                if (this.tickCount <= 5) break;
                if (this.rhyza.m_217043_().m_188500_() < (double)this.againChance) {
                    this.againChance -= 0.1f;
                    this.currentPhase = Phase.LEFT_TO_RIGHT;
                    this.rhyza.setFrenzyState(RhyzaEntity.FrenzyState.LEFT_TO_RIGHT.ordinal());
                } else {
                    this.currentPhase = Phase.LEFT_FINISH;
                    this.rhyza.setFrenzyState(RhyzaEntity.FrenzyState.LEFT_FINISH.ordinal());
                }
                this.tickCount = 0;
                this.firstSlash = false;
                break;
            }
            case LEFT_TO_RIGHT: {
                if (this.tickCount < 4) {
                    this.rhyza.setTargetRotation(this.rhyza.getPredictedAngle(5), 0.0f, 5);
                    Vec3 retreatVector = this.rhyza.m_20154_().m_82490_(-0.2);
                    this.rhyza.m_20256_(retreatVector);
                } else {
                    this.rhyza.m_20256_(this.rhyza.getPredictedHorizontalDirection(5));
                }
                if (this.tickCount <= 4) break;
                this.currentPhase = Phase.RIGHT;
                this.tickCount = 0;
                this.rhyza.setFrenzyState(RhyzaEntity.FrenzyState.RIGHT.ordinal());
                break;
            }
            case RIGHT: {
                if (this.tickCount <= 2) {
                    this.rhyza.m_20256_(this.rhyza.getPredictedHorizontalDirection(5).m_82490_(1.5));
                }
                if (this.tickCount == 2) {
                    this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_CLAW.get(), this.rhyza.m_5720_(), 1.0f, 1.0f);
                }
                if (this.tickCount == 2) {
                    this.rhyza.m_20256_(Vec3.f_82478_);
                    this.rhyza.setPartOffset(this.rhyza.getHeadPart(), new Vec3(1.4, -0.5, -1.0));
                }
                if (this.tickCount == 3) {
                    this.rhyza.dealDamageInOrientedBox(this.rhyza.m_20182_(), new Vec3(0.0, 0.0, 2.0), 8.0, 8.0, 6.0, 1.5f, AbstractLargeMonster.KnockbackType.FORWARD, 1.0, false, true, 60);
                }
                if (this.tickCount <= 5) break;
                if (this.rhyza.m_217043_().m_188500_() < (double)this.againChance) {
                    this.againChance -= 0.1f;
                    this.currentPhase = Phase.RIGHT_TO_LEFT;
                    this.rhyza.setFrenzyState(RhyzaEntity.FrenzyState.RIGHT_TO_LEFT.ordinal());
                } else {
                    this.currentPhase = Phase.RIGHT_FINISH;
                    this.rhyza.setFrenzyState(RhyzaEntity.FrenzyState.RIGHT_FINISH.ordinal());
                }
                this.tickCount = 0;
                break;
            }
            case RIGHT_TO_LEFT: {
                if (this.tickCount < 4) {
                    this.rhyza.setTargetRotation(this.rhyza.getPredictedAngle(5), 0.0f, 5);
                    Vec3 retreatVector = this.rhyza.m_20154_().m_82490_(-0.2);
                    this.rhyza.m_20256_(retreatVector);
                } else {
                    this.rhyza.m_20256_(this.rhyza.getPredictedHorizontalDirection(5));
                }
                if (this.tickCount <= 4) break;
                this.currentPhase = Phase.LEFT;
                this.tickCount = 0;
                this.rhyza.setFrenzyState(RhyzaEntity.FrenzyState.LEFT.ordinal());
                break;
            }
            case LEFT_FINISH: {
                if (this.tickCount == 1) {
                    this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_CLAW_UNSTUCK.get(), this.rhyza.m_5720_(), 1.0f, 1.0f);
                }
                if (this.tickCount == 2) {
                    this.rhyza.resetPartOffsets();
                }
                if (this.tickCount < 3) {
                    Vec3 retreatVector = this.rhyza.m_20154_().m_82490_(-0.2);
                    this.rhyza.m_20256_(retreatVector);
                }
                if (this.tickCount <= 10) break;
                this.currentPhase = null;
                this.isExecuting = false;
                break;
            }
            case RIGHT_FINISH: {
                if (this.tickCount == 1) {
                    this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_CLAW_UNSTUCK.get(), this.rhyza.m_5720_(), 1.0f, 1.0f);
                }
                if (this.tickCount == 2) {
                    this.rhyza.resetPartOffsets();
                }
                if (this.tickCount < 3) {
                    Vec3 retreatVector = this.rhyza.m_20154_().m_82490_(-0.2);
                    this.rhyza.m_20256_(retreatVector);
                }
                if (this.tickCount <= 10) break;
                this.currentPhase = null;
                this.isExecuting = false;
            }
        }
    }

    private static enum Phase {
        START,
        LEFT,
        LEFT_TO_RIGHT,
        RIGHT,
        RIGHT_TO_LEFT,
        LEFT_FINISH,
        RIGHT_FINISH;

    }
}

