/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.kobeko;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.KobekoEntity;
import net.saksolm.monsterexpansion.item.ModItems;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.particles.ModParticles;
import net.saksolm.monsterexpansion.particles.options.ColorParticleOptions;

public class KobekoStaggerGoal
extends Goal {
    private KobekoEntity kobeko;
    private int tickCount = 0;
    private Vec3 direction;
    private boolean isExecuting = false;

    public KobekoStaggerGoal(KobekoEntity kobeko) {
        this.kobeko = kobeko;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.kobeko.getCurrentAbility() == KobekoEntity.Ability.STAGGER;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.m_8036_();
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.kobeko.m_21573_().m_26573_();
        this.kobeko.setRotationManual(true);
        this.direction = this.kobeko.m_271686_() != null ? this.kobeko.m_20182_().m_82546_(this.kobeko.m_271686_().m_20182_()).m_82541_() : Vec3.f_82478_;
        if (this.kobeko.getHelmetStack().m_41720_() == ModItems.LEIVEKILTH_KOBEKO_HELMET.get() && this.kobeko.getChestplateStack().m_41720_() == ModItems.LEIVEKILTH_KOBEKO_CHESTPLATE.get()) {
            int particleCount = 30;
            for (int i = 0; i < 30; ++i) {
                double motionX = (this.kobeko.m_217043_().m_188500_() - 0.5) * 0.3;
                double motionY = this.kobeko.m_217043_().m_188500_() * 0.5;
                double motionZ = (this.kobeko.m_217043_().m_188500_() - 0.5) * 0.3;
                ColorParticleOptions options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.ICE_SHARD.get()), 1.0f, 1.0f, 1.0f, 0.3f, -1);
                Vec3 velocity = new Vec3(motionX, motionY, motionZ);
                ModNetwork.sendToClientsTracking(new GenericParticlePacket(options, this.kobeko.m_20182_().m_82549_(new Vec3(0.0, 0.5, 0.0)), velocity, true), (Entity)this.kobeko);
            }
            this.kobeko.m_9236_().m_6263_(null, this.kobeko.m_20185_(), this.kobeko.m_20186_(), this.kobeko.m_20189_(), SoundEvents.f_11983_, this.kobeko.m_5720_(), 1.0f, 1.0f);
            Vec3 center = this.kobeko.m_20182_();
            AABB damageArea = new AABB(center.m_82492_(2.0, 0.0, 2.0), center.m_82520_(2.0, 2.5, 2.0));
            List targets = this.kobeko.m_9236_().m_45976_(LivingEntity.class, damageArea);
            DamageSource damageSource = this.kobeko.m_269291_().m_269333_((LivingEntity)this.kobeko);
            for (LivingEntity target : targets) {
                if (target == this.kobeko || target == this.kobeko.m_269323_()) continue;
                target.m_6469_(damageSource, 30.0f);
            }
        }
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.kobeko.m_21573_().m_26573_();
        this.kobeko.setRotationManual(false);
        if (this.kobeko.getCurrentAbility() == KobekoEntity.Ability.STAGGER) {
            this.kobeko.setCurrentAbility(KobekoEntity.Ability.NONE);
        }
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount == 1) {
            this.kobeko.setTargetRotation(this.kobeko.getYawFromDirection(this.direction) + 180.0f, 0.0f, 5, KobekoEntity.TurnDirection.SHORTEST, true);
        }
        if (this.tickCount < 7) {
            this.kobeko.m_20256_(this.direction.m_82490_(1.0));
        }
        if (this.tickCount > 15) {
            this.isExecuting = false;
        }
    }
}

