/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.kobeko;

import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.KobekoEntity;

public class KobekoGuardGoal
extends Goal {
    private KobekoEntity kobeko;
    private int tickCount = 0;
    private Phase currentPhase;
    private Vec3 retreatVector = Vec3.f_82478_;
    private Vec3 pos;
    private boolean isExecuting = false;

    public KobekoGuardGoal(KobekoEntity kobeko) {
        this.kobeko = kobeko;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.kobeko.m_5448_() != null && this.kobeko.getCurrentAbility() == KobekoEntity.Ability.GUARD;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.kobeko.getCurrentAbility() == KobekoEntity.Ability.GUARD;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.kobeko.m_21573_().m_26573_();
        this.currentPhase = Phase.HOLD;
        this.kobeko.setGuardState(KobekoEntity.GuardState.HOLD.ordinal());
        this.pos = this.kobeko.m_5448_() != null ? this.kobeko.m_5448_().m_20182_() : this.kobeko.m_20182_();
        this.kobeko.setRotationManual(true);
        this.kobeko.setHoldingWeapon(true);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.kobeko.m_21573_().m_26573_();
        if (this.kobeko.getCurrentAbility() == KobekoEntity.Ability.GUARD) {
            this.kobeko.setCurrentAbility(KobekoEntity.Ability.NONE);
        }
        this.kobeko.setGuardState(KobekoEntity.GuardState.NONE.ordinal());
        this.kobeko.setRotationManual(false);
        this.kobeko.tookDamageThisTick = false;
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case HOLD: {
                if (this.tickCount == 1) {
                    this.kobeko.setTargetRotation(this.kobeko.getYawFromDirection(this.kobeko.m_20182_().m_82546_(this.pos).m_82541_()) + 180.0f, 0.0f, 5, KobekoEntity.TurnDirection.SHORTEST, true);
                }
                if (this.tickCount > 20) {
                    this.isExecuting = false;
                }
                if (!this.kobeko.tookDamageThisTick) break;
                this.currentPhase = Phase.HIT;
                this.kobeko.setGuardState(KobekoEntity.GuardState.HIT.ordinal());
                this.kobeko.tookDamageThisTick = false;
                this.tickCount = 0;
                break;
            }
            case HIT: {
                if (this.tickCount == 1) {
                    this.retreatVector = this.kobeko.m_20182_().m_82546_(this.pos).m_82541_().m_82490_(0.5);
                }
                if (this.tickCount < 7) {
                    this.kobeko.m_20334_(this.retreatVector.f_82479_, 0.0, this.retreatVector.f_82481_);
                }
                if (this.tickCount <= 7) break;
                this.isExecuting = false;
            }
        }
    }

    private static enum Phase {
        HOLD,
        HIT;

    }
}

