/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.kobeko;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.saksolm.monsterexpansion.entity.custom.KobekoEntity;

public class KobekoAttackGoal
extends Goal {
    private KobekoEntity kobeko;
    private int tickCount = 0;
    private boolean isExecuting = false;
    private Phase currentPhase;

    public KobekoAttackGoal(KobekoEntity kobeko) {
        this.kobeko = kobeko;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.kobeko.m_5448_() != null && this.kobeko.getCurrentAbility() == KobekoEntity.Ability.ATTACK;
    }

    public boolean m_8045_() {
        if (this.currentPhase == Phase.CHASE) {
            return this.isExecuting && this.m_8036_();
        }
        return this.isExecuting && this.kobeko.getCurrentAbility() == KobekoEntity.Ability.ATTACK;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.kobeko.m_21573_().m_26573_();
        this.currentPhase = Phase.CHASE;
        this.kobeko.setAttackState(KobekoEntity.AttackState.CHARGE.ordinal());
        this.kobeko.setHoldingWeapon(true);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.currentPhase = null;
        this.kobeko.setAttackState(KobekoEntity.AttackState.NONE.ordinal());
        if (this.kobeko.getCurrentAbility() == KobekoEntity.Ability.ATTACK) {
            this.kobeko.setCurrentAbility(KobekoEntity.Ability.NONE);
        }
        this.kobeko.m_21573_().m_26573_();
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case CHASE: {
                if (this.kobeko.m_5448_() == null) {
                    this.isExecuting = false;
                } else {
                    this.kobeko.m_21573_().m_26519_(this.kobeko.m_5448_().m_20185_(), this.kobeko.m_5448_().m_20186_(), this.kobeko.m_5448_().m_20189_(), 1.0);
                }
                if (this.tickCount > 50 || this.kobeko.m_5448_() != null && this.kobeko.m_20280_((Entity)this.kobeko.m_5448_()) < 49.0) {
                    double attackSpeedModifier = 0.0;
                    ItemStack weapon = this.kobeko.getWeaponStack();
                    if (!this.kobeko.getWeaponStack().m_41619_()) {
                        attackSpeedModifier = weapon.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_).stream().mapToDouble(AttributeModifier::m_22218_).findFirst().orElse(0.0);
                    }
                    if (attackSpeedModifier >= -2.6 && this.kobeko.m_5448_() != null && this.kobeko.m_20280_((Entity)this.kobeko.m_5448_()) < 16.0) {
                        this.kobeko.setAttackState(KobekoEntity.AttackState.FAST.ordinal());
                        this.currentPhase = Phase.FAST;
                        this.tickCount = 0;
                        break;
                    }
                    if (attackSpeedModifier < -2.6 && this.kobeko.m_5448_() != null && this.kobeko.m_20280_((Entity)this.kobeko.m_5448_()) < 36.0) {
                        this.kobeko.setAttackState(KobekoEntity.AttackState.SLOW.ordinal());
                        this.currentPhase = Phase.SLOW;
                        this.tickCount = 0;
                        break;
                    }
                    this.isExecuting = false;
                    break;
                }
                if (this.kobeko.m_5448_() != null) break;
                this.isExecuting = false;
                break;
            }
            case FAST: {
                if (this.kobeko.m_5448_() != null) {
                    if (this.tickCount == 7) {
                        this.kobeko.m_7327_((Entity)this.kobeko.m_5448_());
                    }
                    this.kobeko.m_21573_().m_26519_(this.kobeko.m_5448_().m_20185_(), this.kobeko.m_5448_().m_20186_(), this.kobeko.m_5448_().m_20189_(), 1.0);
                }
                if (this.tickCount <= 10) break;
                this.isExecuting = false;
                break;
            }
            case SLOW: {
                if (this.kobeko.m_5448_() != null) {
                    if (this.tickCount == 10) {
                        this.kobeko.m_7327_((Entity)this.kobeko.m_5448_());
                    }
                    this.kobeko.m_21573_().m_26519_(this.kobeko.m_5448_().m_20185_(), this.kobeko.m_5448_().m_20186_(), this.kobeko.m_5448_().m_20189_(), 1.0);
                }
                if (this.tickCount <= 15) break;
                this.isExecuting = false;
            }
        }
    }

    private static enum Phase {
        CHASE,
        FAST,
        SLOW;

    }
}

