/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.behavior;

import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import net.minecraft.world.entity.LivingEntity;
import net.saksolm.monsterexpansion.entity.ai.behavior.BehaviorNode;
import net.saksolm.monsterexpansion.entity.ai.behavior.BehaviorStatus;
import net.saksolm.monsterexpansion.entity.ai.behavior.ScoredAction;

public class WeightedSelectorNode<E extends LivingEntity>
implements BehaviorNode<E> {
    private final List<ScoredAction<E>> scoredActions;

    @SafeVarargs
    public WeightedSelectorNode(ScoredAction<E> ... actions) {
        this.scoredActions = Arrays.asList(actions);
    }

    @Override
    public BehaviorStatus tick(E entity) {
        List<ActionScore> allScoredActions = this.scoredActions.stream().map(action -> new ActionScore(action, action.scorer.apply(entity))).filter(actionScore -> actionScore.score > 0.0).toList();
        if (allScoredActions.isEmpty()) {
            return BehaviorStatus.FAILURE;
        }
        OptionalDouble maxScoreOpt = allScoredActions.stream().mapToDouble(as -> as.score).max();
        if (maxScoreOpt.isEmpty()) {
            return BehaviorStatus.FAILURE;
        }
        double maxScore = maxScoreOpt.getAsDouble();
        List<ActionScore> bestActions = allScoredActions.stream().filter(as -> as.score == maxScore).toList();
        if (bestActions.size() == 1) {
            return bestActions.get((int)0).scoredAction.action.apply(entity);
        }
        int randomIndex = entity.m_217043_().m_188503_(bestActions.size());
        return bestActions.get((int)randomIndex).scoredAction.action.apply(entity);
    }

    private static class ActionScore<E extends LivingEntity> {
        final ScoredAction<E> scoredAction;
        final double score;

        ActionScore(ScoredAction<E> scoredAction, double score) {
            this.scoredAction = scoredAction;
            this.score = score;
        }
    }
}

