/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;

public class SwitchTargetGoal
extends Goal {
    private final AbstractLargeMonster<?, ?> largeMonster;
    private final int switchInterval;
    private int timer;
    private int switchDuration = 200;

    public SwitchTargetGoal(AbstractLargeMonster<?, ?> largeMonster) {
        this.largeMonster = largeMonster;
        this.switchInterval = 20 * (15 + largeMonster.m_217043_().m_188503_(10));
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        if (this.timer-- > 0) {
            return false;
        }
        return this.getPotentialTargets().size() > 1;
    }

    public void m_8056_() {
        this.timer = this.switchInterval;
        List<LivingEntity> potentialPlayers = this.getPotentialTargets();
        this.switchDuration = 100 + this.largeMonster.m_217043_().m_188503_(100);
        if (!potentialPlayers.isEmpty()) {
            LivingEntity newTarget = potentialPlayers.get(this.largeMonster.m_217043_().m_188503_(potentialPlayers.size()));
            this.largeMonster.m_6710_(newTarget);
            this.largeMonster.setIgnoreHighestThreat(this.switchDuration);
        }
    }

    private List<LivingEntity> getPotentialTargets() {
        Map<UUID, Float> threatMap = this.largeMonster.getThreatMap();
        if (threatMap.isEmpty()) {
            return List.of();
        }
        List entitiesInRange = this.largeMonster.m_9236_().m_45976_(LivingEntity.class, this.largeMonster.m_20191_().m_82400_(64.0));
        LivingEntity currentTarget = this.largeMonster.m_5448_();
        return entitiesInRange.stream().filter(entities -> threatMap.containsKey(entities.m_20148_()) && entities != currentTarget).collect(Collectors.toList());
    }
}

