/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai;

import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.LargeMonsterPartEntity;
import org.jetbrains.annotations.Nullable;

public class LargeMonsterNearestAttackableTargetGoal<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    public LargeMonsterNearestAttackableTargetGoal(Mob pMob, Class<T> pTargetType, boolean pMustSee, @Nullable Predicate<LivingEntity> pExternalPredicate) {
        super(pMob, pTargetType, 10, pMustSee, false, potentialTarget -> {
            Player player;
            if (pExternalPredicate != null && !pExternalPredicate.test((LivingEntity)potentialTarget)) {
                return false;
            }
            if (pMob instanceof AbstractLargeMonster) {
                AbstractLargeMonster largeMonster = (AbstractLargeMonster)pMob;
                for (LargeMonsterPartEntity<?> part : largeMonster.getBodyParts()) {
                    if (!potentialTarget.m_7306_(part)) continue;
                    return false;
                }
                if (largeMonster.m_21824_() && potentialTarget instanceof OwnableEntity) {
                    OwnableEntity ownableEntity = (OwnableEntity)potentialTarget;
                    if (largeMonster.m_269323_() == ownableEntity.m_269323_()) {
                        return false;
                    }
                }
                if (potentialTarget instanceof LargeMonsterPartEntity) {
                    LargeMonsterPartEntity part = (LargeMonsterPartEntity)((Object)potentialTarget);
                    if (part.parent.m_269323_() == largeMonster.m_269323_()) {
                        return false;
                    }
                }
            }
            return !(potentialTarget instanceof Player) || !(player = (Player)potentialTarget).m_7500_() && !player.m_5833_();
        });
    }

    public LargeMonsterNearestAttackableTargetGoal(Mob pMob, Class<T> pTargetType, boolean pMustSee) {
        this(pMob, pTargetType, pMustSee, null);
    }
}

