/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai;

import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;

public class HighestThreatTargetGoal
extends Goal {
    private final AbstractLargeMonster<?, ?> largeMonster;
    private int checkTimer = 0;
    private LivingEntity potentialTarget;

    public HighestThreatTargetGoal(AbstractLargeMonster<?, ?> largeMonster) {
        this.largeMonster = largeMonster;
    }

    public boolean m_8036_() {
        if (this.checkTimer-- > 0) {
            return false;
        }
        if (this.largeMonster.isIgnoringHighestThreat()) {
            return false;
        }
        this.checkTimer = 40;
        this.potentialTarget = this.findHighestThreat();
        return this.potentialTarget != null && this.potentialTarget != this.largeMonster.m_5448_();
    }

    public void m_8056_() {
        this.largeMonster.m_6710_(this.potentialTarget);
        super.m_8056_();
    }

    public void m_8041_() {
        this.potentialTarget = null;
    }

    private LivingEntity findHighestThreat() {
        Entity finalTarget;
        Level level = this.largeMonster.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Map<UUID, Float> permanentThreats = this.largeMonster.getThreatMap();
        Map<UUID, AbstractLargeMonster.ThreatModifier> temporaryThreats = this.largeMonster.getTemporaryThreats();
        UUID highestThreatUUID = null;
        float maxThreat = -1.0f;
        HashSet<UUID> allThreatSources = new HashSet<UUID>(permanentThreats.keySet());
        allThreatSources.addAll(temporaryThreats.keySet());
        for (UUID uuid : allThreatSources) {
            Player player;
            LivingEntity livingTarget;
            Entity potentialTarget;
            float temporaryThreat;
            float permanentThreat = permanentThreats.getOrDefault(uuid, Float.valueOf(0.0f)).floatValue();
            float totalThreat = permanentThreat + (temporaryThreat = temporaryThreats.containsKey(uuid) ? temporaryThreats.get((Object)uuid).amount : 0.0f);
            if (!(totalThreat > maxThreat) || !((potentialTarget = serverLevel.m_8791_(uuid)) instanceof LivingEntity) || !(livingTarget = (LivingEntity)potentialTarget).m_6084_() || !(this.largeMonster.m_20280_((Entity)livingTarget) < 4096.0) || livingTarget == this.largeMonster.m_269323_() || livingTarget instanceof Player && ((player = (Player)livingTarget).m_7500_() || player.m_5833_())) continue;
            maxThreat = totalThreat;
            highestThreatUUID = uuid;
        }
        if (highestThreatUUID != null && (finalTarget = serverLevel.m_8791_(highestThreatUUID)) instanceof LivingEntity) {
            return (LivingEntity)finalTarget;
        }
        return null;
    }
}

