/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ModConfig {
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Server SERVER;

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        SERVER = new Server(builder);
        SERVER_SPEC = builder.build();
    }

    public static class Server {
        public final GeneralConfig GENERAL;
        public final SkrytheConfig SKRYTHE;
        public final RhyzaConfig RHYZA;
        public final LeivekilthConfig LEIVEKILTH;

        Server(ForgeConfigSpec.Builder builder) {
            builder.push("general_stats");
            this.GENERAL = new GeneralConfig(builder);
            builder.pop();
            builder.push("skrythe_stats");
            this.SKRYTHE = new SkrytheConfig(builder);
            builder.pop();
            builder.push("rhyza_stats");
            this.RHYZA = new RhyzaConfig(builder);
            builder.pop();
            builder.push("leivekilth_stats");
            this.LEIVEKILTH = new LeivekilthConfig(builder);
            builder.pop();
        }
    }

    public static class LeivekilthConfig {
        public final ForgeConfigSpec.DoubleValue MAX_HEALTH;
        public final ForgeConfigSpec.DoubleValue ATTACK_DAMAGE;

        LeivekilthConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for the Leivekilth.").push("general");
            this.MAX_HEALTH = builder.comment("Maximum health multiplier for the Leivekilth. (eg. 2 to double it, 0.5 to halve it)").defineInRange("maxHealthMultiplier", 1.0, 0.0, 1000.0);
            this.ATTACK_DAMAGE = builder.comment("Attack damage multiplier for the Leivekilth. (eg. 2 to double it, 0.5 to halve it)").defineInRange("attackDamageMultiplier", 1.0, 0.0, 1000.0);
            builder.pop();
        }
    }

    public static class RhyzaConfig {
        public final ForgeConfigSpec.DoubleValue MAX_HEALTH;
        public final ForgeConfigSpec.DoubleValue ATTACK_DAMAGE;

        RhyzaConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for the Rhyza.").push("general");
            this.MAX_HEALTH = builder.comment("Maximum health multiplier for the Rhyza. (eg. 2 to double it, 0.5 to halve it)").defineInRange("maxHealthMultiplier", 1.0, 0.0, 1000.0);
            this.ATTACK_DAMAGE = builder.comment("Attack damage multiplier for the Rhyza. (eg. 2 to double it, 0.5 to halve it)").defineInRange("attackDamageMultiplier", 1.0, 0.0, 1000.0);
            builder.pop();
        }
    }

    public static class SkrytheConfig {
        public final ForgeConfigSpec.DoubleValue MAX_HEALTH;
        public final ForgeConfigSpec.DoubleValue ATTACK_DAMAGE;

        SkrytheConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for the Skrythe.").push("general");
            this.MAX_HEALTH = builder.comment("Maximum health multiplier for the Skrythe. (eg. 2 to double it, 0.5 to halve it)").defineInRange("maxHealthMultiplier", 1.0, 0.0, 1000.0);
            this.ATTACK_DAMAGE = builder.comment("Attack damage multiplier for the Skrythe. (eg. 2 to double it, 0.5 to halve it)").defineInRange("attackDamageMultiplier", 1.0, 0.0, 1000.0);
            builder.pop();
        }
    }

    public static class GeneralConfig {
        public final ForgeConfigSpec.DoubleValue MAX_HEALTH;
        public final ForgeConfigSpec.DoubleValue ATTACK_DAMAGE;

        GeneralConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for all the monsters. Changes done here affect all the monsters. These also stack with individual multipliers so keep that in mind.").push("general");
            this.MAX_HEALTH = builder.comment("Maximum health multiplier. (eg. 2 to double it, 0.5 to halve it)").defineInRange("maxHealthMultiplier", 1.0, 0.0, 1000.0);
            this.ATTACK_DAMAGE = builder.comment("Attack damage multiplier. (eg. 2 to double it, 0.5 to halve it)").defineInRange("attackDamageMultiplier", 1.0, 0.0, 1000.0);
            builder.pop();
        }
    }
}

