/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.compat;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;

public class EpicFightCompat {
    private static final MobEffect STUN_IMMUNITY = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("epicfight", "stun_immunity"));

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        SkrytheEntity skrythe;
        if (STUN_IMMUNITY == null) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof SkrytheEntity && !(skrythe = (SkrytheEntity)livingEntity).m_21023_(STUN_IMMUNITY)) {
            skrythe.m_7292_(new MobEffectInstance(STUN_IMMUNITY, 40, 0, false, false, false));
        }
    }

    public static DamageSource addGuardPuncture(DamageSource source) {
        EpicFightDamageSource efSource;
        EpicFightDamageSource epicFightSource = source instanceof EpicFightDamageSource ? (efSource = (EpicFightDamageSource)source) : new EpicFightDamageSource(source);
        epicFightSource.addRuntimeTag(EpicFightDamageTypeTags.GUARD_PUNCTURE);
        return epicFightSource;
    }

    public static DamageSource addDodgeBypass(DamageSource source) {
        EpicFightDamageSource efSource;
        EpicFightDamageSource epicFightSource = source instanceof EpicFightDamageSource ? (efSource = (EpicFightDamageSource)source) : new EpicFightDamageSource(source);
        epicFightSource.addRuntimeTag(EpicFightDamageTypeTags.BYPASS_DODGE);
        return epicFightSource;
    }

    public static DamageSource createGuardBreakDamageSource(LivingEntity attacker) {
        DamageSource vanillaSource = attacker.m_269291_().m_269333_(attacker);
        EpicFightDamageSource epicFightSource = new EpicFightDamageSource(vanillaSource);
        float impact = 100.0f;
        epicFightSource.setBaseImpact(impact);
        return epicFightSource;
    }
}

