/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.block;

import java.util.function.Supplier;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.saksolm.monsterexpansion.block.FoundryBlock;
import net.saksolm.monsterexpansion.block.FoundryPlaceholderBlock;
import net.saksolm.monsterexpansion.recipe.FoundryRecipe;
import net.saksolm.monsterexpansion.screen.FoundryMenu;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"monsterexpansion");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"monsterexpansion");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"monsterexpansion");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"monsterexpansion");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"monsterexpansion");
    public static final RegistryObject<Block> FOUNDRY = ModBlocks.registerBlockWithItem("foundry", () -> new FoundryBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60913_(3.5f, 6.0f).m_60918_(SoundType.f_56743_).m_60955_().m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<Block> FOUNDRY_PLACEHOLDER = BLOCKS.register("foundry_placeholder", () -> new FoundryPlaceholderBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283818_).m_60978_(-1.0f).m_60955_().m_278166_(PushReaction.DESTROY)));
    public static final RegistryObject<MenuType<FoundryMenu>> FOUNDRY_MENU = MENU_TYPES.register("foundry_menu", () -> IForgeMenuType.create((containerId, inventory, buffer) -> new FoundryMenu(containerId, inventory, buffer)));
    public static final RegistryObject<RecipeType<FoundryRecipe>> FOUNDRY_RECIPE_TYPE = RECIPE_TYPES.register("foundry", () -> new RecipeType<FoundryRecipe>(){});
    public static final RegistryObject<RecipeSerializer<FoundryRecipe>> FOUNDRY_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("foundry", () -> FoundryRecipe.Serializer.INSTANCE);

    private static <T extends Block> RegistryObject<T> registerBlockWithItem(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        MENU_TYPES.register(eventBus);
        RECIPE_TYPES.register(eventBus);
        RECIPE_SERIALIZERS.register(eventBus);
    }
}

