/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.epicfightbow.skills;

import com.p1nero.epicfightbow.gameassets.EFBowAnimations;
import com.p1nero.epicfightbow.mob_effect.EFBowEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.skill.BasicAttack;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.ComboCounterHandleEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class MortisBowInnateSkill
extends WeaponInnateSkill {
    protected int consumeSpeed;
    protected int effectDuration;
    protected static final UUID EVENT_UUID = UUID.fromString("d1d259cc-f25f-25ed-a05b-0242ac114514");

    public MortisBowInnateSkill(SkillBuilder<? extends WeaponInnateSkill> builder) {
        super(builder);
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.maxStackSize = 1;
        this.consumeSpeed = parameters.m_128451_("consume_speed");
        this.effectDuration = parameters.m_128451_("effect_duration");
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            float value;
            if (!event.getDamageSource().m_269014_()) {
                if (event.getDamageSource().getAnimation() == EFBowAnimations.ELBOW_2) {
                    event.getTarget().m_20256_(event.getTarget().m_20184_().m_82520_(0.0, 0.5 * (double)event.getDamageSource().getBaseImpact(), 0.0));
                }
                if (event.getDamageSource().getAnimation() == EFBowAnimations.ELBOW_3) {
                    Vec3 dir = event.getTarget().m_20182_().m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    event.getTarget().m_20256_(event.getTarget().m_20184_().m_82549_(dir));
                }
                return;
            }
            PlayerPatch playerPatch = event.getPlayerPatch();
            ItemStack mainHandItem = ((Player)playerPatch.getOriginal()).m_21205_();
            CapabilityItem capabilityItem = EpicFightCapabilities.getItemStackCapability((ItemStack)mainHandItem);
            if (capabilityItem == null || !(capabilityItem.getInnateSkill(playerPatch, mainHandItem) instanceof MortisBowInnateSkill)) {
                return;
            }
            if (!container.isFull() && (value = container.getResource() + event.getAttackDamage()) > 0.0f) {
                this.setConsumptionSynchronize(container, value * 2.0f);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        PlayerPatch playerPatch = container.getExecutor();
        if (container.isFull()) {
            if (!playerPatch.isLogicalClient()) {
                ((Player)playerPatch.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EFBowEffects.DOUBLE_ARROW.get(), this.effectDuration, 0, false, false, true));
                this.setConsumptionSynchronize(container, 0.0f);
            }
        } else if (!playerPatch.isLogicalClient()) {
            this.setConsumptionSynchronize(container, container.getResource() - (float)this.consumeSpeed);
        }
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        SkillContainer basicAttackContainer = container.getExecutor().getSkill((SkillSlot)SkillSlots.BASIC_ATTACK);
        SkillDataManager manager = basicAttackContainer.getDataManager();
        int comboCounter = (Integer)manager.getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get());
        if (comboCounter == 1) {
            this.playAnim(basicAttackContainer, EFBowAnimations.ELBOW_2);
        }
        if (comboCounter == 2) {
            this.playAnim(basicAttackContainer, EFBowAnimations.ELBOW_3);
        }
    }

    private void playAnim(SkillContainer basicAttackContainer, AnimationManager.AnimationAccessor<? extends StaticAnimation> accessor) {
        basicAttackContainer.getExecutor().playAnimationSynchronized(accessor, 0.15f);
        BasicAttack.setComboCounterWithEvent((ComboCounterHandleEvent.Causal)ComboCounterHandleEvent.Causal.ANOTHER_ACTION_ANIMATION, (ServerPlayerPatch)basicAttackContainer.getServerExecutor(), (SkillContainer)basicAttackContainer, accessor, (int)0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"item.p1nero_bow.mortis_innate.tooltip0").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)String.format("[%.0f]", Float.valueOf(this.consumption / 2.0f))).m_130940_(ChatFormatting.AQUA)));
        list.add((Component)Component.m_237110_((String)"item.p1nero_bow.mortis_innate.tooltip1", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92087_.m_90863_().m_6881_().m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.DARK_GRAY));
        list.add((Component)Component.m_237110_((String)"item.p1nero_bow.mortis_innate.tooltip2", (Object[])new Object[]{EpicFightKeyMappings.WEAPON_INNATE_SKILL.m_90863_().m_6881_().m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.DARK_GRAY));
        list.add((Component)Component.m_237115_((String)"item.p1nero_bow.mortis_innate.tooltip3").m_130940_(ChatFormatting.DARK_GRAY));
        return list;
    }

    public ResourceLocation getSkillTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"p1nero_bow", (String)"textures/mob_effect/double_arrow.png");
    }

    protected void generateTooltipforPhase(List<Component> list, ItemStack itemstack, CapabilityItem itemcap, PlayerPatch<?> playerpatch, Map<AnimationProperty.AttackPhaseProperty<?>, Object> propertyMap, String title) {
    }
}

