/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.epicfightbow.gameassets;

import com.p1nero.epicfightbow.animations.ScanAttackAnimation;
import com.p1nero.epicfightbow.gameassets.EFBowColliders;
import com.p1nero.epicfightbow.mob_effect.EFBowEffects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.MovementAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.StunType;

@Mod.EventBusSubscriber(modid="p1nero_bow", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EFBowAnimations {
    public static AnimationManager.AnimationAccessor<MovementAnimation> BOW_RUN;
    public static AnimationManager.AnimationAccessor<ScanAttackAnimation> BOW_AUTO1;
    public static AnimationManager.AnimationAccessor<ScanAttackAnimation> BOW_AUTO2;
    public static AnimationManager.AnimationAccessor<ScanAttackAnimation> BOW_AUTO3;
    public static AnimationManager.AnimationAccessor<AttackAnimation> BOW_DASH_ATTACK;
    public static AnimationManager.AnimationAccessor<ScanAttackAnimation> BOW_JUMP_ATTACK;
    public static AnimationManager.AnimationAccessor<AttackAnimation> ELBOW_2;
    public static AnimationManager.AnimationAccessor<AttackAnimation> ELBOW_3;

    @SubscribeEvent
    public static void efb$registerAnimations(AnimationManager.AnimationRegistryEvent event) {
        event.newBuilder("p1nero_bow", EFBowAnimations::buildBowAnimations);
    }

    private static void buildBowAnimations(AnimationManager.AnimationBuilder builder) {
        BOW_RUN = builder.nextAccessor("biped/bow_run", accessor -> (MovementAnimation)new MovementAnimation(true, accessor, (AssetAccessor)Armatures.BIPED).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> ((MovementAnimation)BOW_RUN.get()).getPlaySpeed(livingEntityPatch, dynamicAnimation) * 2.0f));
        BOW_AUTO1 = builder.nextAccessor("biped/bow_auto1", accessor -> (ScanAttackAnimation)new ScanAttackAnimation(0.15f, 0.0f, 0.15f, 1.0833334f, 1.0833334f, InteractionHand.MAIN_HAND, EFBowColliders.BOW_SCAN, ((HumanoidArmature)Armatures.BIPED.get()).rootJoint, (AnimationManager.AnimationAccessor<? extends AttackAnimation>)accessor, (AssetAccessor<? extends Armature>)Armatures.BIPED).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, true).addEvents(new AnimationEvent[]{EFBowAnimations.setFullBowUseTime(0.33333334f), EFBowAnimations.shootIn(0.5f), EFBowAnimations.setFullBowUseTime(0.8333333f), EFBowAnimations.shootIn(1.0f)}));
        BOW_AUTO2 = builder.nextAccessor("biped/bow_auto2", accessor -> (ScanAttackAnimation)new ScanAttackAnimation(0.15f, 0.0f, 0.15f, 1.0833334f, 1.0833334f, InteractionHand.MAIN_HAND, EFBowColliders.BOW_SCAN, ((HumanoidArmature)Armatures.BIPED.get()).rootJoint, (AnimationManager.AnimationAccessor<? extends AttackAnimation>)accessor, (AssetAccessor<? extends Armature>)Armatures.BIPED).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, true).addEvents(new AnimationEvent[]{EFBowAnimations.setFullBowUseTime(0.33333334f), EFBowAnimations.shootIn(0.5f), EFBowAnimations.setFullBowUseTime(0.8333333f), EFBowAnimations.shootIn(1.0f)}));
        BOW_AUTO3 = builder.nextAccessor("biped/bow_auto3", accessor -> (ScanAttackAnimation)new ScanAttackAnimation(0.15f, 0.0f, 0.15f, 1.6666666f, 2.0f, InteractionHand.MAIN_HAND, EFBowColliders.BOW_SCAN, ((HumanoidArmature)Armatures.BIPED.get()).rootJoint, (AnimationManager.AnimationAccessor<? extends AttackAnimation>)accessor, (AssetAccessor<? extends Armature>)Armatures.BIPED).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, true).addEvents(new AnimationEvent[]{EFBowAnimations.setFullBowUseTime(0.8333333f), EFBowAnimations.shootIn(1.3333334f), EFBowAnimations.setFullBowUseTime(1.4166666f), EFBowAnimations.shootIn(1.5f), EFBowAnimations.setFullBowUseTime(1.5833334f), EFBowAnimations.shootIn(1.6666666f)}));
        BOW_DASH_ATTACK = builder.nextAccessor("biped/bow_dash_attack", accessor -> (AttackAnimation)new AttackAnimation(0.15f, 0.0f, 0.0f, 0.6666667f, 1.0f, EFBowColliders.BOW_DASH, ((HumanoidArmature)Armatures.BIPED.get()).rootJoint, accessor, (AssetAccessor)Armatures.BIPED).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.KNOCKDOWN).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)2.0f)).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, (Object)true));
        BOW_JUMP_ATTACK = builder.nextAccessor("biped/bow_jump_attack", accessor -> (ScanAttackAnimation)new ScanAttackAnimation(0.15f, 0.0f, 0.15f, 0.33333334f, 1.3333334f, InteractionHand.MAIN_HAND, EFBowColliders.BOW_SCAN, ((HumanoidArmature)Armatures.BIPED.get()).rootJoint, (AnimationManager.AnimationAccessor<? extends AttackAnimation>)accessor, (AssetAccessor<? extends Armature>)Armatures.BIPED).addEvents(new AnimationEvent[]{EFBowAnimations.setFullBowUseTime(0.16666667f), EFBowAnimations.shootIn(0.25f), EFBowAnimations.setFullBowUseTime(0.26666668f), EFBowAnimations.shootIn(0.33333334f)}));
        ELBOW_2 = builder.nextAccessor("biped/elbow_2", accessor -> (AttackAnimation)new AttackAnimation(0.15f, 0.33333334f, 0.33333334f, 0.6666667f, 0.8333333f, EFBowColliders.BOW_ELBOW, ((HumanoidArmature)Armatures.BIPED.get()).rootJoint, accessor, (AssetAccessor)Armatures.BIPED).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.FALL).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)2.2f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)8.0f)).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, (Object)true));
        ELBOW_3 = builder.nextAccessor("biped/elbow_3", accessor -> new AttackAnimation(0.15f, 0.33333334f, 0.33333334f, 0.6666667f, 0.8333333f, EFBowColliders.BOW_ELBOW, ((HumanoidArmature)Armatures.BIPED.get()).handR, accessor, (AssetAccessor)Armatures.BIPED).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.KNOCKDOWN).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)2.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)8.0f)));
    }

    public static AnimationEvent.InTimeEvent<?> setFullBowUseTime(float time) {
        return AnimationEvent.InTimeEvent.create((float)time, (livingEntityPatch, assetAccessor, animationParameters) -> ((LivingEntity)livingEntityPatch.getOriginal()).m_21205_().m_41784_().m_128379_("is_full", true), (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent<?> shootIn(float time) {
        return AnimationEvent.InTimeEvent.create((float)time, (livingEntityPatch, assetAccessor, animationParameters) -> {
            int loopTime = ((LivingEntity)livingEntityPatch.getOriginal()).m_21023_((MobEffect)EFBowEffects.DOUBLE_ARROW.get()) ? 2 : 1;
            for (int i = 0; i < loopTime; ++i) {
                EFBowAnimations.shootOnce(livingEntityPatch, 3.0f + (float)i * 0.3f);
            }
            ((LivingEntity)livingEntityPatch.getOriginal()).m_5810_();
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    private static void shootOnce(LivingEntityPatch<?> livingEntityPatch) {
        EFBowAnimations.shootOnce(livingEntityPatch, 3.0f);
    }

    private static void shootOnce(LivingEntityPatch<?> livingEntityPatch, float speed) {
        LivingEntity living = (LivingEntity)livingEntityPatch.getOriginal();
        ItemStack itemStack = living.m_21205_();
        itemStack.m_41784_().m_128379_("is_full", false);
        Item item = itemStack.m_41720_();
        Level level = living.m_9236_();
        int leftTime = 0;
        Entity entity = livingEntityPatch.getOriginal();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (item instanceof BowItem) {
                BowItem bowItem = (BowItem)item;
                boolean flag = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)itemStack) > 0;
                ItemStack itemstack = player.m_6298_(itemStack);
                int i = item.m_8105_(itemStack) - leftTime;
                if ((i = ForgeEventFactory.onArrowLoose((ItemStack)itemStack, (Level)level, (Player)player, (int)i, (!itemstack.m_41619_() || flag ? 1 : 0) != 0)) < 0) {
                    return;
                }
                if (!itemstack.m_41619_() || flag) {
                    boolean flag1;
                    if (itemstack.m_41619_()) {
                        itemstack = new ItemStack((ItemLike)Items.f_42412_);
                    }
                    float f = 1.0f;
                    boolean bl = flag1 = player.m_150110_().f_35937_ || itemstack.m_41720_() instanceof ArrowItem && ((ArrowItem)itemstack.m_41720_()).isInfinite(itemstack, itemStack, (Player)player);
                    if (!level.f_46443_) {
                        int k;
                        int j;
                        ArrowItem arrowitem = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
                        AbstractArrow abstractarrow = arrowitem.m_6394_(level, itemstack, (LivingEntity)player);
                        abstractarrow = bowItem.customArrow(abstractarrow);
                        abstractarrow.m_146884_(EFBowAnimations.getJointWorldPos(livingEntityPatch, ((HumanoidArmature)Armatures.BIPED.get()).handL));
                        LivingEntity target = ScanAttackAnimation.getTarget(livingEntityPatch);
                        if (target == null) {
                            abstractarrow.m_37251_((Entity)player, living.m_146909_(), livingEntityPatch.getYRot(), 0.0f, f * 3.0f, 1.0f);
                        } else {
                            Vec3 targetPos = target.m_146892_();
                            Vec3 vec3 = targetPos.m_82546_(abstractarrow.m_20182_()).m_82541_().m_82490_((double)(speed * f));
                            abstractarrow.m_20256_(vec3);
                            double d0 = vec3.m_165924_();
                            abstractarrow.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
                            abstractarrow.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
                            abstractarrow.f_19859_ = abstractarrow.m_146908_();
                            abstractarrow.f_19860_ = abstractarrow.m_146909_();
                        }
                        if (f == 1.0f) {
                            abstractarrow.m_36762_(true);
                        }
                        if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)itemStack)) > 0) {
                            abstractarrow.m_36781_(abstractarrow.m_36789_() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)itemStack)) > 0) {
                            abstractarrow.m_36735_(k);
                        }
                        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)itemStack) > 0) {
                            abstractarrow.m_20254_(100);
                        }
                        itemStack.m_41622_(1, (LivingEntity)player, p_289501_ -> p_289501_.m_21190_(player.m_7655_()));
                        if (flag1 || player.m_150110_().f_35937_ && (itemstack.m_150930_(Items.f_42737_) || itemstack.m_150930_(Items.f_42738_))) {
                            abstractarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.m_7967_((Entity)abstractarrow);
                    }
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            player.m_150109_().m_36057_(itemstack);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)bowItem));
                }
            }
        }
    }

    public static Vec3 getJointWorldPos(LivingEntityPatch<?> entityPatch, Joint joint) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        OpenMatrix4f transformMatrix = entityPatch.getArmature().getBoundTransformFor(entityPatch.getAnimator().getPose(0.1f), joint);
        OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(entity.f_20884_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f.mul((OpenMatrix4f)rotation, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
        return new Vec3((double)(transformMatrix.m30 + (float)entity.m_20185_()), (double)(transformMatrix.m31 + (float)entity.m_20186_()), (double)(transformMatrix.m32 + (float)entity.m_20189_()));
    }
}

