/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.utils;

import com.mojang.datafixers.util.Pair;
import com.p1nero.tcrcore.worldgen.TCRDimensions;
import com.yungnickyoung.minecraft.yungsapi.criteria.SafeStructureLocationPredicate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.utils.math.Vec2i;

public class WorldUtil {
    public static final Vec3i AINE_IRIS_POS = new Vec3i(80, 74, -133);
    public static final Vec3i GIRL_POS = new Vec3i(80, 74, -133);
    public static final Vec3i GIRL_PORTAL_POS = new Vec3i(80, 73, -138);
    public static final Vec3i START_POS = new Vec3i(-3, 75, -190);
    public static final Vec3i GODNESS_STATUE_POS = new Vec3i(-169, 79, -118);
    public static final Vec3 GOLEM_CENTER_POS_VEC3 = new Vec3(78.0, 75.0, -190.0);
    public static final Vec3i GOLEM_CENTER_POS_VEC3I = new Vec3i(78, 75, -190);
    public static final Vec3 CENTER_POS = new Vec3(-19.0, 75.0, -79.0);
    public static final Vec3 GUIDER_POS = new Vec3(-186.0, 85.0, -191.0);
    public static final Vec3i GUIDER_BLOCK_POS = new Vec3i(-186, 85, -191);
    public static final String COVES = "ribbits:ribbit_village";
    public static final String SKY_ISLAND = "trek:overworld/very_rare/floating_farm_large";
    public static final String SAND = "dodosmobs:jungle_prison";
    public static final String CURSED = "aquamirae:ship";
    public static final String FIRE = "tcrcore:underworld_arena";
    public static final String SKY_GOLEM = "lost_aether_content:platinum_dungeon";
    public static final String OCEAN_GOLEM = "ba_bt:ocean_tower";
    public static final String LAND_GOLEM = "ba_bt:land_tower";
    public static final String CURSED_GOLEM = "callfromthedepth_:marbleforge";
    public static Vec2i storm;
    public static Vec2i flame;
    public static Vec2i abyss;
    public static Vec2i cursed;
    public static Vec2i desert;
    public static List<MapColor> surfaceMaterials;
    private static final Pattern LOCATE_PATTERN;

    public static boolean inMainLand(Entity entity) {
        return entity.m_9236_().m_46472_() == TCRDimensions.SANCTUM_LEVEL_KEY && entity.m_20182_().m_82546_(CENTER_POS).m_165924_() < 250.0;
    }

    public static boolean inMainLandRange(Entity entity) {
        return entity.m_20182_().m_82546_(CENTER_POS).m_165924_() < 250.0;
    }

    public static boolean isInStructure(LivingEntity entity, String structure) {
        if (entity.m_9236_().f_46443_) {
            return false;
        }
        return new SafeStructureLocationPredicate(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)ResourceLocation.parse((String)structure))).matches((ServerLevel)entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
    }

    public static boolean isInStructure(ServerLevel serverLevel, Vec3 pos, String structure) {
        return new SafeStructureLocationPredicate(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)ResourceLocation.parse((String)structure))).matches(serverLevel, pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
    }

    @Nullable
    public static BlockPos getNearbyStructurePos(ServerPlayer serverPlayer, String structureId, int y) {
        BlockPos playerPos;
        ServerLevel serverLevel = serverPlayer.m_284548_();
        ResourceLocation structureResourceLocation = ResourceLocation.m_135820_((String)structureId);
        if (structureResourceLocation == null) {
            return null;
        }
        ResourceKey structureKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)structureResourceLocation);
        Registry structureRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256944_);
        Optional structureHolderOpt = structureRegistry.m_203636_(structureKey);
        if (structureHolderOpt.isEmpty()) {
            return null;
        }
        HolderSet.Direct structureSet = HolderSet.m_205809_((Holder[])new Holder[]{(Holder)structureHolderOpt.get()});
        ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
        Pair result = chunkGenerator.m_223037_(serverLevel, (HolderSet)structureSet, playerPos = serverPlayer.m_20183_(), 20000, false);
        if (result != null) {
            BlockPos structurePos = (BlockPos)result.getFirst();
            return new BlockPos(structurePos.m_123341_(), y, structurePos.m_123343_());
        }
        return null;
    }

    @Nullable
    public static BlockPos getNearbyStructurePos(ServerLevel serverLevel, BlockPos playerPos, String structureId, int y) {
        ResourceLocation structureResourceLocation = ResourceLocation.m_135820_((String)structureId);
        if (structureResourceLocation == null) {
            return null;
        }
        ResourceKey structureKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)structureResourceLocation);
        Registry structureRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256944_);
        Optional structureHolderOpt = structureRegistry.m_203636_(structureKey);
        if (structureHolderOpt.isEmpty()) {
            return null;
        }
        HolderSet.Direct structureSet = HolderSet.m_205809_((Holder[])new Holder[]{(Holder)structureHolderOpt.get()});
        ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
        Pair result = chunkGenerator.m_223037_(serverLevel, (HolderSet)structureSet, playerPos, 20000, false);
        if (result != null) {
            BlockPos structurePos = (BlockPos)result.getFirst();
            return new BlockPos(structurePos.m_123341_(), y, structurePos.m_123343_());
        }
        return null;
    }

    @Nullable
    public static Vec2i getNearbyStructurePos(ServerLevel serverLevel, Vec3 position, String structureId) {
        String output = WorldUtil.getCommandOutput(serverLevel, position, "/locate structure " + structureId);
        Matcher matcher = LOCATE_PATTERN.matcher(output);
        if (matcher.find()) {
            try {
                String xStr = matcher.group(1).trim();
                String zStr = matcher.group(2).trim();
                return new Vec2i(Integer.parseInt(xStr), Integer.parseInt(zStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getCommandOutput(final ServerLevel serverLevel, final @Nullable Vec3 vec, String command) {
        BaseCommandBlock baseCommandBlock = new BaseCommandBlock(){

            @NotNull
            public ServerLevel m_5991_() {
                return serverLevel;
            }

            public void m_7368_() {
            }

            @NotNull
            public Vec3 m_6607_() {
                return Objects.requireNonNullElseGet(vec, () -> new Vec3(0.0, 0.0, 0.0));
            }

            @NotNull
            public CommandSourceStack m_6712_() {
                return new CommandSourceStack((CommandSource)this, this.m_6607_(), Vec2.f_82462_, serverLevel, 2, "dev", (Component)Component.m_237113_((String)"dev"), serverLevel.m_7654_(), null);
            }

            public boolean m_288209_() {
                return true;
            }

            public boolean m_45414_(Level pLevel) {
                if (!pLevel.f_46443_) {
                    this.m_45410_(0);
                    MinecraftServer server = this.m_5991_().m_7654_();
                    try {
                        this.m_45433_(null);
                        CommandSourceStack commandSourceStack = this.m_6712_().m_81334_((context, success, i) -> {
                            if (success) {
                                this.m_45410_(this.m_45436_() + 1);
                            }
                        });
                        server.m_129892_().m_230957_(commandSourceStack, this.m_45438_());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return true;
            }
        };
        baseCommandBlock.m_6590_(command);
        baseCommandBlock.m_45428_(true);
        baseCommandBlock.m_45414_((Level)serverLevel);
        return baseCommandBlock.m_45437_().getString();
    }

    public static BlockPos getSurfaceBlockPos(ServerLevel serverLevel, int x, int z) {
        int height = serverLevel.m_141928_();
        int minY = serverLevel.m_141937_();
        BlockPos pos = new BlockPos(x, height, z);
        for (int y = height; y > minY; --y) {
            BlockState blockState = serverLevel.m_8055_(pos);
            MapColor mapColor = blockState.m_284242_((BlockGetter)serverLevel, pos);
            if (blockState.m_60739_((BlockGetter)serverLevel, pos) >= 15 || surfaceMaterials.contains(mapColor)) {
                return pos.m_7494_().m_7949_();
            }
            pos = pos.m_7495_();
        }
        return new BlockPos(x, height - 1, z);
    }

    static {
        surfaceMaterials = Arrays.asList(MapColor.f_283864_, MapColor.f_283828_);
        LOCATE_PATTERN = Pattern.compile(".*?\\[\\s*(-?\\d+)\\s*,\\s*~\\s*,\\s*(-?\\d+)\\s*\\].*");
    }
}

