/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.utils;

import com.p1nero.fast_tpa.network.PacketRelay;
import com.p1nero.tcrcore.network.TCRPacketHandler;
import com.p1nero.tcrcore.network.packet.clientbound.AddWaypointPacket;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.Nullable;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointVisibilityType;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.hud.minimap.waypoint.WaypointPurpose;
import xaero.minimap.XaeroMinimap;

public class WaypointUtil {
    public static void sendWaypoint(ServerPlayer player, String key, BlockPos pos, WaypointColor color) {
        PacketRelay.sendToPlayer((SimpleChannel)TCRPacketHandler.INSTANCE, (Object)new AddWaypointPacket(key, pos, color), (ServerPlayer)player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addWayPoint(BlockPos pos, String name, @Nullable WaypointColor color) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null) {
            ArrayList<Waypoint> waypoints = WaypointUtil.getWaypoints(Minecraft.m_91087_().f_91074_);
            if (waypoints.stream().anyMatch(waypoint -> WaypointUtil.isEqualWaypoint(waypoint, name, pos))) {
                return;
            }
            Waypoint instant = new Waypoint(pos.m_123341_(), pos.m_123342_() + 2, pos.m_123343_(), name, name.substring(0, 1), color == null ? WaypointColor.getRandom() : color, WaypointPurpose.NORMAL, false);
            instant.setVisibility(WaypointVisibilityType.LOCAL);
            waypoints.add(instant);
            WaypointUtil.save(Minecraft.m_91087_().f_91074_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void removeWayPoint(BlockPos pos, String name) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null) {
            WaypointUtil.getWaypoints(Minecraft.m_91087_().f_91074_).removeIf(waypoint -> WaypointUtil.isEqualWaypoint(waypoint, name, pos));
            WaypointUtil.save(Minecraft.m_91087_().f_91074_);
        }
    }

    public static boolean isEqualWaypoint(Waypoint waypoint, String name, BlockPos pos) {
        return waypoint.getName().equals(name) && waypoint.getX() == pos.m_123341_() && waypoint.getY() == pos.m_123342_() + 2 && waypoint.getZ() == pos.m_123343_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ArrayList<Waypoint> getWaypoints(LocalPlayer localPlayer) {
        IXaeroMinimapClientPlayNetHandler clientLevel = (IXaeroMinimapClientPlayNetHandler)localPlayer.f_108617_;
        XaeroMinimapSession session = clientLevel.getXaero_minimapSession();
        WaypointsManager waypointsManager = session.getWaypointsManager();
        return waypointsManager.getWaypoints().getList();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static WaypointsManager getWaypointManager(LocalPlayer localPlayer) {
        IXaeroMinimapClientPlayNetHandler clientLevel = (IXaeroMinimapClientPlayNetHandler)localPlayer.f_108617_;
        XaeroMinimapSession session = clientLevel.getXaero_minimapSession();
        return session.getWaypointsManager();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void save(LocalPlayer localPlayer) {
        try {
            XaeroMinimap.instance.getSettings().saveWaypoints(WaypointUtil.getWaypointManager(localPlayer).getCurrentWorld());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

