/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.utils;

import com.google.common.collect.ImmutableList;
import com.p1nero.tcrcore.TCRCoreMod;
import com.p1nero.tcrcore.entity.custom.CustomColorItemEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemUtil {
    public static List<NonNullList<ItemStack>> getCompartments(Player player) {
        return ImmutableList.of((Object)player.m_150109_().f_35974_, (Object)player.m_150109_().f_35975_, (Object)player.m_150109_().f_35976_);
    }

    public static boolean isFullSets(Entity entity, ObjectArrayList<?> objects) {
        return ItemUtil.isFullSets(entity, objects, 4);
    }

    public static boolean isFullSets(Entity entity, ObjectArrayList<?> objects, int need) {
        int cnt = 0;
        for (ItemStack stack : entity.m_6168_()) {
            if (stack.m_41619_() || !objects.contains((Object)stack.m_41720_())) continue;
            ++cnt;
        }
        return cnt >= need;
    }

    public static void addItem(Player player, Item item, int count) {
        ItemUtil.addItem(player, item, count, false);
    }

    public static void addItem(Player player, ItemStack item) {
        ItemUtil.addItem(player, item, false);
    }

    public static void addItem(Player player, ItemStack itemStack, boolean showTip) {
        if (!player.m_9236_().f_46443_ && showTip) {
            player.m_5661_((Component)TCRCoreMod.getInfo("add_item_tip", itemStack.m_41611_(), itemStack.m_41613_()), false);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, player.m_5720_(), 1.0f, 1.0f);
        }
        if (!player.m_36356_(itemStack)) {
            ItemUtil.addItemEntity((Entity)player, itemStack);
        }
    }

    public static void addItem(Player player, Item item, int count, boolean showTip) {
        if (!player.m_9236_().f_46443_ && showTip) {
            player.m_5661_((Component)TCRCoreMod.getInfo("add_item_tip", item.m_7968_().m_41611_(), count), false);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, player.m_5720_(), 1.0f, 1.0f);
        }
        int maxStackSize = item.m_7968_().m_41741_();
        if (!player.m_36356_(item.m_7968_().m_255036_(count))) {
            if (maxStackSize < count) {
                for (int i = 0; i < count / maxStackSize; ++i) {
                    ItemUtil.addItemEntity((Entity)player, item, maxStackSize);
                }
                ItemUtil.addItemEntity((Entity)player, item, count % maxStackSize);
            } else {
                ItemUtil.addItemEntity((Entity)player, item, count);
            }
        }
    }

    public static CustomColorItemEntity addItemEntity(Entity spawnOn, Item item, int count, int color) {
        CustomColorItemEntity itemEntity = ItemUtil.addItemEntity(spawnOn, item, count);
        itemEntity.setTeamColor(color);
        return itemEntity;
    }

    public static CustomColorItemEntity addItemEntity(Entity spawnOn, ItemStack item, int count, int color) {
        CustomColorItemEntity itemEntity = ItemUtil.addItemEntity(spawnOn, item, count);
        itemEntity.setTeamColor(color);
        return itemEntity;
    }

    public static CustomColorItemEntity addItemEntity(Entity spawnOn, Item item, int count) {
        CustomColorItemEntity itemEntity = new CustomColorItemEntity(spawnOn.m_9236_(), spawnOn.m_20185_(), spawnOn.m_20186_(), spawnOn.m_20189_(), item.m_7968_().m_255036_(count));
        itemEntity.m_32010_(40);
        spawnOn.m_9236_().m_7967_((Entity)itemEntity);
        return itemEntity;
    }

    public static CustomColorItemEntity addItemEntity(Entity spawnOn, ItemStack item, int count) {
        CustomColorItemEntity itemEntity = new CustomColorItemEntity(spawnOn.m_9236_(), spawnOn.m_20185_(), spawnOn.m_20186_(), spawnOn.m_20189_(), item.m_255036_(count));
        itemEntity.m_32010_(40);
        spawnOn.m_9236_().m_7967_((Entity)itemEntity);
        return itemEntity;
    }

    public static CustomColorItemEntity addItemEntity(Entity spawnOn, ItemStack item) {
        CustomColorItemEntity itemEntity = new CustomColorItemEntity(spawnOn.m_9236_(), spawnOn.m_20185_(), spawnOn.m_20186_(), spawnOn.m_20189_(), item);
        itemEntity.m_32010_(40);
        spawnOn.m_9236_().m_7967_((Entity)itemEntity);
        return itemEntity;
    }

    public static CustomColorItemEntity addItemEntity(ServerLevel level, BlockPos pos, ItemStack item) {
        CustomColorItemEntity itemEntity = new CustomColorItemEntity((Level)level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), item);
        itemEntity.m_32010_(40);
        level.m_7967_((Entity)itemEntity);
        return itemEntity;
    }

    public static CustomColorItemEntity addItemEntity(ServerLevel level, double x, double y, double z, ItemStack item) {
        CustomColorItemEntity itemEntity = new CustomColorItemEntity((Level)level, x, y, z, item);
        itemEntity.m_32010_(40);
        level.m_7967_((Entity)itemEntity);
        return itemEntity;
    }

    public static int searchAndConsumeItem(Player player, Item item, int need) {
        int total = 0;
        ItemStack stack = ItemStack.f_41583_;
        if (item == player.m_21205_().m_41720_()) {
            stack = player.m_21205_();
        } else if (item == player.m_21206_().m_41720_()) {
            stack = player.m_21206_();
        } else {
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack teststack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (teststack.m_41720_() != item) continue;
                stack = teststack;
                break;
            }
        }
        if (stack != ItemStack.f_41583_) {
            if (stack.m_41613_() >= need) {
                stack.m_41774_(need);
                return need;
            }
            int cnt = stack.m_41613_();
            stack.m_41774_(cnt);
            total += cnt;
            return total += ItemUtil.searchAndConsumeItem(player, item, need - cnt);
        }
        return 0;
    }

    public static int searchAndConsumeItem(Player player, Predicate<Item> itemPredicate, int need) {
        int total = 0;
        ItemStack stack = ItemStack.f_41583_;
        if (itemPredicate.test(player.m_21205_().m_41720_())) {
            stack = player.m_21205_();
        } else if (itemPredicate.test(player.m_21206_().m_41720_())) {
            stack = player.m_21206_();
        } else {
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack teststack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (!itemPredicate.test(teststack.m_41720_())) continue;
                stack = teststack;
                break;
            }
        }
        if (stack != ItemStack.f_41583_) {
            if (stack.m_41613_() >= need) {
                stack.m_41774_(need);
                return need;
            }
            int cnt = stack.m_41613_();
            stack.m_41774_(cnt);
            total += cnt;
            return total += ItemUtil.searchAndConsumeItem(player, itemPredicate, need - cnt);
        }
        return 0;
    }

    public static ItemStack searchItemStack(Player player, Item item) {
        ItemStack stack = ItemStack.f_41583_;
        if (item == player.m_21205_().m_41720_()) {
            stack = player.m_21205_();
        } else if (item == player.m_21206_().m_41720_()) {
            stack = player.m_21206_();
        } else {
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack teststack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (teststack.m_41720_() != item) continue;
                stack = teststack;
                break;
            }
        }
        return stack;
    }

    public static ItemStack searchItemStack(Player player, Predicate<Item> itemPredicate) {
        ItemStack stack = ItemStack.f_41583_;
        if (itemPredicate.test(player.m_21205_().m_41720_())) {
            stack = player.m_21205_();
        } else if (itemPredicate.test(player.m_21206_().m_41720_())) {
            stack = player.m_21206_();
        } else {
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack teststack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (!itemPredicate.test(teststack.m_41720_())) continue;
                stack = teststack;
                break;
            }
        }
        return stack;
    }

    public static void clearItem(Player player, Item item) {
        ItemStack stack;
        while ((stack = ItemUtil.searchItemStack(player, item)) != ItemStack.f_41583_) {
            stack.m_41764_(0);
        }
    }
}

