/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.utils;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class EntityUtil {
    public static double getDegree(Entity target, Entity self) {
        return EntityUtil.getDegree(target.m_20182_(), self);
    }

    public static double getDegree(Vec3 target, Entity self) {
        Vec3 targetToBoss = target.m_82546_(self.m_20182_());
        Vec2 targetToBossV2 = new Vec2((float)targetToBoss.f_82479_, (float)targetToBoss.f_82481_);
        Vec3 view = self.m_20252_(1.0f);
        Vec2 viewV2 = new Vec2((float)view.f_82479_, (float)view.f_82481_);
        double angleRadians = Math.acos(targetToBossV2.m_165905_(viewV2) / (targetToBossV2.m_165907_() * viewV2.m_165907_()));
        return Math.toDegrees(angleRadians);
    }

    public static double getViewDegree(Entity target, Entity self) {
        Vec3 targetView = target.m_20252_(1.0f);
        Vec2 targetViewV2 = new Vec2((float)targetView.f_82479_, (float)targetView.f_82481_);
        Vec3 view = self.m_20252_(1.0f);
        Vec2 viewV2 = new Vec2((float)view.f_82479_, (float)view.f_82481_);
        double angleRadians = Math.acos(targetViewV2.m_165905_(viewV2) / (targetViewV2.m_165907_() * viewV2.m_165907_()));
        return Math.toDegrees(angleRadians);
    }

    public static AABB getPlayerAABB(BlockPos pos, int offset) {
        return new AABB(pos.m_7918_(offset, offset, offset), pos.m_7918_(-offset, -offset, -offset));
    }

    public static boolean isInFront(Entity target, Entity self, double degree) {
        return Math.abs(EntityUtil.getDegree(target, self)) <= degree;
    }

    public static List<Entity> getNearByEntities(Entity self, int offset) {
        return self.m_9236_().m_6249_(self, EntityUtil.getPlayerAABB(self.m_20097_(), offset), entity -> entity.m_20270_(self) < (float)offset);
    }

    public static <T extends Entity> List<T> getNearByEntities(Level level, Vec3 center, int radius, Class<T> entityClass) {
        return level.m_45976_(entityClass, new AABB(center, center).m_82400_((double)radius));
    }

    public static List<Player> getNearByPlayers(LivingEntity self, int offset) {
        return self.m_9236_().m_45955_(TargetingConditions.m_148353_(), self, EntityUtil.getPlayerAABB(self.m_20097_(), offset));
    }

    public static <T extends LivingEntity> List<T> getNearByEntities(Class<T> aClass, LivingEntity self, int offset) {
        return self.m_9236_().m_45971_(aClass, TargetingConditions.m_148353_(), self, EntityUtil.getPlayerAABB(self.m_20097_(), offset));
    }

    public static void nearPlayerDo(LivingEntity self, int radius, Consumer<Player> consumer) {
        Vec3 center = self.m_20182_();
        self.m_9236_().m_45976_(Player.class, new AABB(center, center).m_82400_((double)radius)).forEach(consumer);
    }

    public static void nearPlayerDo(Level level, Vec3 center, int radius, Consumer<Player> consumer) {
        level.m_45976_(Player.class, new AABB(center, center).m_82400_((double)radius)).forEach(consumer);
    }
}

