/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.save_data;

import com.p1nero.tcrcore.TCRCoreMod;
import com.p1nero.tcrcore.worldgen.TCRDimensions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class TCRMainLevelSaveData
extends SavedData {
    private BlockPos villagePos = BlockPos.f_121853_;
    private BlockPos abyssPos = BlockPos.f_121853_;
    private BlockPos desertPos = BlockPos.f_121853_;
    private BlockPos stormPos = BlockPos.f_121853_;
    private BlockPos cursedPos = BlockPos.f_121853_;
    private BlockPos flamePos = BlockPos.f_121853_;
    private boolean girlPlaced;
    private boolean stormFinish;
    private boolean desertFinish;
    private boolean cursedFinish;
    private boolean flameFinish;
    private boolean abyssFinish;
    private int progressCount;
    public static final String NAME = "tcr_level_save_data";
    private Level level;

    public void setLevel(Level level) {
        this.level = level;
    }

    public boolean isAllFinish() {
        return this.isAbyssFinish() && this.isStormFinish() && this.isCursedFinish() && this.isDesertFinish() && this.isFlameFinish();
    }

    public int getProgressCount() {
        return this.progressCount;
    }

    private void updateProgressCount() {
        Level level;
        this.progressCount = 0;
        if (this.stormFinish) {
            ++this.progressCount;
        }
        if (this.desertFinish) {
            ++this.progressCount;
        }
        if (this.cursedFinish) {
            ++this.progressCount;
        }
        if (this.flameFinish) {
            ++this.progressCount;
        }
        if (this.abyssFinish) {
            ++this.progressCount;
        }
        if (this.isAllFinish() && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6846_().m_11314_().forEach(player -> {
                player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11860_), SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, (long)player.m_217043_().m_188502_()));
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)TCRCoreMod.getInfo("finish_all_eye")));
            });
        }
    }

    private static TCRMainLevelSaveData create() {
        return new TCRMainLevelSaveData();
    }

    public void setVillagePos(BlockPos villagePos) {
        this.villagePos = villagePos;
    }

    public BlockPos getVillagePos() {
        return this.villagePos;
    }

    public void setAbyssPos(BlockPos abyssPos) {
        this.abyssPos = abyssPos;
    }

    public void setDesertPos(BlockPos desertPos) {
        this.desertPos = desertPos;
        this.m_77762_();
    }

    public BlockPos getDesertPos() {
        return this.desertPos;
    }

    public void setStormPos(BlockPos stormPos) {
        this.stormPos = stormPos;
        this.m_77762_();
    }

    public BlockPos getStormPos() {
        return this.stormPos;
    }

    public void setCursedPos(BlockPos cursedPos) {
        this.cursedPos = cursedPos;
        this.m_77762_();
    }

    public BlockPos getCursedPos() {
        return this.cursedPos;
    }

    public void setFlamePos(BlockPos flamePos) {
        this.flamePos = flamePos;
        this.m_77762_();
    }

    public BlockPos getFlamePos() {
        return this.flamePos;
    }

    public BlockPos getAbyssPos() {
        return this.abyssPos;
    }

    public boolean isGirlPlaced() {
        return this.girlPlaced;
    }

    public void setGirlPlaced(boolean girlPlaced) {
        this.girlPlaced = girlPlaced;
        this.m_77762_();
    }

    public boolean isStormFinish() {
        return this.stormFinish;
    }

    public boolean isAbyssFinish() {
        return this.abyssFinish;
    }

    public boolean isCursedFinish() {
        return this.cursedFinish;
    }

    public boolean isDesertFinish() {
        return this.desertFinish;
    }

    public boolean isFlameFinish() {
        return this.flameFinish;
    }

    public void setAbyssFinish(boolean abyssFinish) {
        this.abyssFinish = abyssFinish;
        this.updateProgressCount();
        this.m_77762_();
    }

    public void setCursedFinish(boolean cursedFinish) {
        this.cursedFinish = cursedFinish;
        this.updateProgressCount();
        this.m_77762_();
    }

    public void setDesertFinish(boolean desertFinish) {
        this.desertFinish = desertFinish;
        this.updateProgressCount();
        this.m_77762_();
    }

    public void setFlameFinish(boolean flameFinish) {
        this.flameFinish = flameFinish;
        this.updateProgressCount();
        this.m_77762_();
    }

    public void setStormFinish(boolean stormFinish) {
        this.stormFinish = stormFinish;
        this.updateProgressCount();
        this.m_77762_();
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag pCompoundTag) {
        pCompoundTag.m_128405_("covesPosX", this.abyssPos.m_123341_());
        pCompoundTag.m_128405_("covesPosY", this.abyssPos.m_123342_());
        pCompoundTag.m_128405_("covesPosZ", this.abyssPos.m_123343_());
        pCompoundTag.m_128405_("villagePosX", this.villagePos.m_123341_());
        pCompoundTag.m_128405_("villagePosY", this.villagePos.m_123342_());
        pCompoundTag.m_128405_("villagePosZ", this.villagePos.m_123343_());
        pCompoundTag.m_128405_("desertPosX", this.desertPos.m_123341_());
        pCompoundTag.m_128405_("desertPosY", this.desertPos.m_123342_());
        pCompoundTag.m_128405_("desertPosZ", this.desertPos.m_123343_());
        pCompoundTag.m_128405_("stormPosX", this.stormPos.m_123341_());
        pCompoundTag.m_128405_("stormPosY", this.stormPos.m_123342_());
        pCompoundTag.m_128405_("stormPosZ", this.stormPos.m_123343_());
        pCompoundTag.m_128405_("cursedPosX", this.cursedPos.m_123341_());
        pCompoundTag.m_128405_("cursedPosY", this.cursedPos.m_123342_());
        pCompoundTag.m_128405_("cursedPosZ", this.cursedPos.m_123343_());
        pCompoundTag.m_128405_("flamePosX", this.flamePos.m_123341_());
        pCompoundTag.m_128405_("flamePosY", this.flamePos.m_123342_());
        pCompoundTag.m_128405_("flamePosZ", this.flamePos.m_123343_());
        pCompoundTag.m_128379_("girlPlaced", this.girlPlaced);
        pCompoundTag.m_128379_("stormFinish", this.stormFinish);
        pCompoundTag.m_128379_("desertFinish", this.desertFinish);
        pCompoundTag.m_128379_("cursedFinish", this.cursedFinish);
        pCompoundTag.m_128379_("flameFinish", this.flameFinish);
        pCompoundTag.m_128379_("abyssFinish", this.abyssFinish);
        pCompoundTag.m_128405_("progressCount", this.progressCount);
        return pCompoundTag;
    }

    public void load(CompoundTag nbt) {
        this.villagePos = new BlockPos(nbt.m_128451_("villagePosX"), nbt.m_128451_("villagePosY"), nbt.m_128451_("vZ"));
        this.abyssPos = new BlockPos(nbt.m_128451_("covesPosX"), nbt.m_128451_("covesPosY"), nbt.m_128451_("covesPosZ"));
        this.desertPos = new BlockPos(nbt.m_128451_("desertPosX"), nbt.m_128451_("desertPosY"), nbt.m_128451_("desertPosZ"));
        this.stormPos = new BlockPos(nbt.m_128451_("stormPosX"), nbt.m_128451_("stormPosY"), nbt.m_128451_("stormPosZ"));
        this.cursedPos = new BlockPos(nbt.m_128451_("cursedPosX"), nbt.m_128451_("cursedPosY"), nbt.m_128451_("cursedPosZ"));
        this.flamePos = new BlockPos(nbt.m_128451_("flamePosX"), nbt.m_128451_("flamePosY"), nbt.m_128451_("flamePosZ"));
        this.girlPlaced = nbt.m_128471_("girlPlaced");
        this.stormFinish = nbt.m_128471_("stormFinish");
        this.desertFinish = nbt.m_128471_("desertFinish");
        this.cursedFinish = nbt.m_128471_("cursedFinish");
        this.flameFinish = nbt.m_128471_("flameFinish");
        this.abyssFinish = nbt.m_128471_("abyssFinish");
        this.progressCount = nbt.m_128451_("progressCount");
    }

    public static TCRMainLevelSaveData decode(CompoundTag tag) {
        TCRMainLevelSaveData saveData = TCRMainLevelSaveData.create();
        saveData.load(tag);
        return saveData;
    }

    public static TCRMainLevelSaveData get(ServerLevel worldIn) {
        ServerLevel world = worldIn.m_7654_().m_129880_(TCRDimensions.SANCTUM_LEVEL_KEY);
        DimensionDataStorage dataStorage = world.m_8895_();
        TCRMainLevelSaveData levelSaveData = (TCRMainLevelSaveData)dataStorage.m_164861_(TCRMainLevelSaveData::decode, TCRMainLevelSaveData::create, NAME);
        levelSaveData.setLevel((Level)world);
        return levelSaveData;
    }
}

