/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.network.packet.clientbound;

import com.p1nero.dialog_lib.network.packet.BasePacket;
import com.p1nero.tcrcore.capability.PlayerDataManager;
import com.p1nero.tcrcore.network.packet.clientbound.helper.DistHelper;
import com.p1nero.tcrcore.network.packet.clientbound.helper.TCRClientHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public record PersistentBoolDataSyncPacket(String key, boolean isLocked, boolean value) implements BasePacket
{
    public void encode(FriendlyByteBuf buf) {
        buf.m_130083_((Component)Component.m_237113_((String)this.key));
        buf.writeBoolean(this.isLocked);
        buf.writeBoolean(this.value);
    }

    public static PersistentBoolDataSyncPacket decode(FriendlyByteBuf buf) {
        String key = buf.m_130238_().getString();
        boolean isLocked = buf.readBoolean();
        boolean value = buf.readBoolean();
        return new PersistentBoolDataSyncPacket(key, isLocked, value);
    }

    public void execute(Player player) {
        if (player != null) {
            if (this.isLocked) {
                PlayerDataManager.putData(player, this.key + "isLocked", true);
                return;
            }
            PlayerDataManager.putData(player, this.key, this.value);
            PlayerDataManager.putData(player, this.key + "isLocked", false);
        }
        DistHelper.runClient(() -> () -> TCRClientHandler.syncBoolData(this.key, this.isLocked, this.value));
    }
}

