/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.mixin;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.naturescompass.NaturesCompass;
import com.p1nero.dialog_lib.api.entity.custom.IEntityNpc;
import com.p1nero.dialog_lib.client.screen.DialogueScreen;
import com.p1nero.dialog_lib.client.screen.builder.StreamDialogueScreenBuilder;
import com.p1nero.tcrcore.TCRCoreMod;
import com.p1nero.tcrcore.capability.PlayerDataManager;
import com.p1nero.tcrcore.utils.ItemUtil;
import com.p1nero.tudigong.entity.TudiGongEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TudiGongEntity.class})
public abstract class TuDiGongMixin
implements IEntityNpc {
    @Shadow(remap=false)
    public abstract boolean canInteract();

    @Shadow(remap=false)
    public abstract void setMarkRemoved();

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void tcr$mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (this.canInteract() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CompoundTag data = new CompoundTag();
            data.m_128379_("giftGet", PlayerDataManager.tudigongGiftGet.get(player).booleanValue());
            this.sendDialogTo(serverPlayer, data);
        }
        cir.setReturnValue((Object)InteractionResult.CONSUME);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"getDialogueScreen"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void tcr$getDialogueScreen(CompoundTag compoundTag, CallbackInfoReturnable<DialogueScreen> cir) {
        if (!compoundTag.m_128471_("giftGet")) {
            StreamDialogueScreenBuilder builder = new StreamDialogueScreenBuilder((Entity)((TudiGongEntity)this), "tudigong");
            builder.start(1).addFinalOption((Component)TCRCoreMod.getInfo("tudigong_gift"), 111);
            cir.setReturnValue((Object)builder.build());
        }
    }

    @Inject(method={"handleNpcInteraction"}, at={@At(value="HEAD")}, remap=false)
    private void tcr$handle(ServerPlayer serverPlayer, int i, CallbackInfo ci) {
        if (i == 111 && !PlayerDataManager.tudigongGiftGet.get((Player)serverPlayer).booleanValue()) {
            ItemUtil.addItemEntity((Entity)serverPlayer, new ItemStack((ItemLike)ExplorersCompass.explorersCompass));
            ItemUtil.addItemEntity((Entity)serverPlayer, new ItemStack((ItemLike)NaturesCompass.naturesCompass));
            serverPlayer.m_5661_((Component)TCRCoreMod.getInfo("tudigong_gift_get"), false);
            PlayerDataManager.tudigongGiftGet.put((Player)serverPlayer, true);
            this.setMarkRemoved();
        }
    }
}

