/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.tcrcore.events;

import com.p1nero.tcrcore.TCRCoreMod;
import com.p1nero.tcrcore.entity.TCREntities;
import com.p1nero.tcrcore.save_data.TCRMainLevelSaveData;
import com.p1nero.tcrcore.utils.DimensionResourceCopier;
import com.p1nero.tcrcore.utils.WorldUtil;
import com.p1nero.tcrcore.worldgen.TCRDimensions;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.stream.Stream;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="tcrcore")
public class ServerEvents {
    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.CreateSpawnPosition e) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = e.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_() == TCRDimensions.SANCTUM_LEVEL_KEY) {
            serverLevel.m_8733_(new BlockPos(WorldUtil.START_POS), 1.0f);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        TCRMainLevelSaveData tcrMainLevelSaveData;
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_() == TCRDimensions.SANCTUM_LEVEL_KEY && !(tcrMainLevelSaveData = TCRMainLevelSaveData.get(serverLevel)).isGirlPlaced()) {
            ((EntityType)TCREntities.GIRL.get()).m_262496_(serverLevel, new BlockPos(WorldUtil.GIRL_POS), MobSpawnType.SPAWNER);
            serverLevel.m_7731_(new BlockPos(WorldUtil.GIRL_PORTAL_POS), ModBlocks.waystone.m_49966_(), 3);
            serverLevel.m_7731_(new BlockPos(WorldUtil.GIRL_PORTAL_POS).m_7494_(), (BlockState)ModBlocks.waystone.m_49966_().m_61124_((Property)WaystoneBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
            ServerEvents.tryHandleLight(serverLevel);
            tcrMainLevelSaveData.setGirlPlaced(true);
        }
    }

    private static void tryHandleLight(ServerLevel level) {
        int minX = -204;
        int maxX = -40;
        int minZ = -208;
        int maxZ = -174;
        Random random = new Random();
        random.setSeed(level.m_7328_());
        for (int y = 79; y < 82; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    if (!state.m_60713_(Blocks.f_152480_) || !((double)random.nextFloat() < 0.99)) continue;
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        DimensionResourceCopier.copyDimensionToSaves(event.getServer());
    }

    public static void copyDuelDirectory(MinecraftServer server) {
        Path gameDir = FMLPaths.GAMEDIR.get();
        Path sourceDir = gameDir.resolve("mainland");
        Path savesDir = gameDir.resolve("saves");
        if (!Files.isDirectory(sourceDir, new LinkOption[0])) {
            System.err.println("\u6e90\u76ee\u5f55\u4e0d\u5b58\u5728: " + String.valueOf(sourceDir));
            return;
        }
        if (server.m_6982_()) {
            ServerEvents.copyToDimensions(gameDir.resolve(server.m_129910_().m_5462_()), sourceDir);
        } else {
            try (Stream<Path> saveFolders = Files.list(savesDir);){
                saveFolders.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(saveFolder -> ServerEvents.copyToDimensions(saveFolder, sourceDir));
            }
            catch (IOException e) {
                TCRCoreMod.LOGGER.error("TCR: Failed to copy dimension!", (Throwable)e);
            }
        }
    }

    private static void copyToDimensions(Path saveFolder, Path sourceDir) {
        Path markDir = saveFolder.resolve("mark");
        if (Files.exists(markDir, new LinkOption[0])) {
            return;
        }
        try {
            ServerEvents.copyDirectoryRecursive(sourceDir, saveFolder);
            Files.createDirectories(markDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            TCRCoreMod.LOGGER.error("TCR: Failed to copy dimension! \u590d\u5236\u5230 {} \u5931\u8d25\uff01", (Object)markDir, (Object)e);
        }
    }

    private static void copyDirectoryRecursive(final Path source, final Path target) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path relativePath = source.relativize(dir);
                Path destPath = target.resolve(relativePath);
                Files.createDirectories(destPath, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path destFile = target.resolve(source.relativize(file));
                Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

